# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2archive_affiliation import V2archiveAffiliation
from typing import Optional, Set
from typing_extensions import Self

class V2archiveName(BaseModel):
    """
    V2archiveName
    """ # noqa: E501
    first: Optional[StrictStr] = None
    middle: Optional[StrictStr] = None
    last: Optional[StrictStr] = None
    full: Optional[StrictStr] = None
    initials: Optional[StrictStr] = None
    suffix: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    affiliation: Optional[V2archiveAffiliation] = None
    __properties: ClassVar[List[str]] = ["first", "middle", "last", "full", "initials", "suffix", "title", "affiliation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2archiveName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of affiliation
        if self.affiliation:
            _dict['affiliation'] = self.affiliation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2archiveName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first": obj.get("first"),
            "middle": obj.get("middle"),
            "last": obj.get("last"),
            "full": obj.get("full"),
            "initials": obj.get("initials"),
            "suffix": obj.get("suffix"),
            "title": obj.get("title"),
            "affiliation": V2archiveAffiliation.from_dict(obj["affiliation"]) if obj.get("affiliation") is not None else None
        })
        return _obj


