# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2archive_affiliation import V2archiveAffiliation
from ncbi.datasets.openapi.models.v2archive_name import V2archiveName
from typing import Optional, Set
from typing_extensions import Self

class V2archiveSubmitter(BaseModel):
    """
    V2archiveSubmitter
    """ # noqa: E501
    name: Optional[List[V2archiveName]] = None
    role: Optional[StrictStr] = None
    affiliation: Optional[V2archiveAffiliation] = None
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    __properties: ClassVar[List[str]] = ["name", "role", "affiliation", "date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2archiveSubmitter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in name (list)
        _items = []
        if self.name:
            for _item_name in self.name:
                if _item_name:
                    _items.append(_item_name.to_dict())
            _dict['name'] = _items
        # override the default output from pydantic by calling `to_dict()` of affiliation
        if self.affiliation:
            _dict['affiliation'] = self.affiliation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2archiveSubmitter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": [V2archiveName.from_dict(_item) for _item in obj["name"]] if obj.get("name") is not None else None,
            "role": obj.get("role"),
            "affiliation": V2archiveAffiliation.from_dict(obj["affiliation"]) if obj.get("affiliation") is not None else None,
            "date": obj.get("date")
        })
        return _obj


