# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_assembly_level import V2reportsAssemblyLevel
from typing import Optional, Set
from typing_extensions import Self

class V2reportsAssemblyRevision(BaseModel):
    """
    V2reportsAssemblyRevision
    """ # noqa: E501
    genbank_accession: Optional[StrictStr] = None
    refseq_accession: Optional[StrictStr] = None
    assembly_name: Optional[StrictStr] = None
    assembly_level: Optional[V2reportsAssemblyLevel] = V2reportsAssemblyLevel.CHROMOSOME
    release_date: Optional[StrictStr] = None
    submission_date: Optional[StrictStr] = None
    sequencing_technology: Optional[StrictStr] = None
    identical: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["genbank_accession", "refseq_accession", "assembly_name", "assembly_level", "release_date", "submission_date", "sequencing_technology", "identical"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsAssemblyRevision from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsAssemblyRevision from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "genbank_accession": obj.get("genbank_accession"),
            "refseq_accession": obj.get("refseq_accession"),
            "assembly_name": obj.get("assembly_name"),
            "assembly_level": obj.get("assembly_level") if obj.get("assembly_level") is not None else V2reportsAssemblyLevel.CHROMOSOME,
            "release_date": obj.get("release_date"),
            "submission_date": obj.get("submission_date"),
            "sequencing_technology": obj.get("sequencing_technology"),
            "identical": obj.get("identical")
        })
        return _obj


