# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class V2reportsAssemblyStats(BaseModel):
    """
    V2reportsAssemblyStats
    """ # noqa: E501
    total_number_of_chromosomes: Optional[StrictInt] = None
    total_sequence_length: Optional[StrictStr] = None
    total_ungapped_length: Optional[StrictStr] = None
    number_of_contigs: Optional[StrictInt] = None
    contig_n50: Optional[StrictInt] = None
    contig_l50: Optional[StrictInt] = None
    number_of_scaffolds: Optional[StrictInt] = None
    scaffold_n50: Optional[StrictInt] = None
    scaffold_l50: Optional[StrictInt] = None
    gaps_between_scaffolds_count: Optional[StrictInt] = None
    number_of_component_sequences: Optional[StrictInt] = None
    atgc_count: Optional[StrictStr] = None
    gc_count: Optional[StrictStr] = None
    gc_percent: Optional[Union[StrictFloat, StrictInt]] = None
    genome_coverage: Optional[StrictStr] = None
    number_of_organelles: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["total_number_of_chromosomes", "total_sequence_length", "total_ungapped_length", "number_of_contigs", "contig_n50", "contig_l50", "number_of_scaffolds", "scaffold_n50", "scaffold_l50", "gaps_between_scaffolds_count", "number_of_component_sequences", "atgc_count", "gc_count", "gc_percent", "genome_coverage", "number_of_organelles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsAssemblyStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsAssemblyStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_number_of_chromosomes": obj.get("total_number_of_chromosomes"),
            "total_sequence_length": obj.get("total_sequence_length"),
            "total_ungapped_length": obj.get("total_ungapped_length"),
            "number_of_contigs": obj.get("number_of_contigs"),
            "contig_n50": obj.get("contig_n50"),
            "contig_l50": obj.get("contig_l50"),
            "number_of_scaffolds": obj.get("number_of_scaffolds"),
            "scaffold_n50": obj.get("scaffold_n50"),
            "scaffold_l50": obj.get("scaffold_l50"),
            "gaps_between_scaffolds_count": obj.get("gaps_between_scaffolds_count"),
            "number_of_component_sequences": obj.get("number_of_component_sequences"),
            "atgc_count": obj.get("atgc_count"),
            "gc_count": obj.get("gc_count"),
            "gc_percent": obj.get("gc_percent"),
            "genome_coverage": obj.get("genome_coverage"),
            "number_of_organelles": obj.get("number_of_organelles")
        })
        return _obj


