# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_ani_match import V2reportsANIMatch
from ncbi.datasets.openapi.models.v2reports_ani_type_category import V2reportsANITypeCategory
from ncbi.datasets.openapi.models.v2reports_average_nucleotide_identity_match_status import V2reportsAverageNucleotideIdentityMatchStatus
from ncbi.datasets.openapi.models.v2reports_average_nucleotide_identity_taxonomy_check_status import V2reportsAverageNucleotideIdentityTaxonomyCheckStatus
from typing import Optional, Set
from typing_extensions import Self

class V2reportsAverageNucleotideIdentity(BaseModel):
    """
    V2reportsAverageNucleotideIdentity
    """ # noqa: E501
    taxonomy_check_status: Optional[V2reportsAverageNucleotideIdentityTaxonomyCheckStatus] = V2reportsAverageNucleotideIdentityTaxonomyCheckStatus.TAXONOMY_CHECK_STATUS_UNKNOWN
    match_status: Optional[V2reportsAverageNucleotideIdentityMatchStatus] = V2reportsAverageNucleotideIdentityMatchStatus.BEST_MATCH_STATUS_UNKNOWN
    submitted_organism: Optional[StrictStr] = None
    submitted_species: Optional[StrictStr] = None
    category: Optional[V2reportsANITypeCategory] = V2reportsANITypeCategory.ANI_CATEGORY_UNKNOWN
    submitted_ani_match: Optional[V2reportsANIMatch] = None
    best_ani_match: Optional[V2reportsANIMatch] = None
    comment: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["taxonomy_check_status", "match_status", "submitted_organism", "submitted_species", "category", "submitted_ani_match", "best_ani_match", "comment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsAverageNucleotideIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of submitted_ani_match
        if self.submitted_ani_match:
            _dict['submitted_ani_match'] = self.submitted_ani_match.to_dict()
        # override the default output from pydantic by calling `to_dict()` of best_ani_match
        if self.best_ani_match:
            _dict['best_ani_match'] = self.best_ani_match.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsAverageNucleotideIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxonomy_check_status": obj.get("taxonomy_check_status") if obj.get("taxonomy_check_status") is not None else V2reportsAverageNucleotideIdentityTaxonomyCheckStatus.TAXONOMY_CHECK_STATUS_UNKNOWN,
            "match_status": obj.get("match_status") if obj.get("match_status") is not None else V2reportsAverageNucleotideIdentityMatchStatus.BEST_MATCH_STATUS_UNKNOWN,
            "submitted_organism": obj.get("submitted_organism"),
            "submitted_species": obj.get("submitted_species"),
            "category": obj.get("category") if obj.get("category") is not None else V2reportsANITypeCategory.ANI_CATEGORY_UNKNOWN,
            "submitted_ani_match": V2reportsANIMatch.from_dict(obj["submitted_ani_match"]) if obj.get("submitted_ani_match") is not None else None,
            "best_ani_match": V2reportsANIMatch.from_dict(obj["best_ani_match"]) if obj.get("best_ani_match") is not None else None,
            "comment": obj.get("comment")
        })
        return _obj


