# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class V2reportsCheckM(BaseModel):
    """
    V2reportsCheckM
    """ # noqa: E501
    checkm_marker_set: Optional[StrictStr] = None
    checkm_species_tax_id: Optional[StrictInt] = None
    checkm_marker_set_rank: Optional[StrictStr] = None
    checkm_version: Optional[StrictStr] = None
    completeness: Optional[Union[StrictFloat, StrictInt]] = None
    contamination: Optional[Union[StrictFloat, StrictInt]] = None
    completeness_percentile: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["checkm_marker_set", "checkm_species_tax_id", "checkm_marker_set_rank", "checkm_version", "completeness", "contamination", "completeness_percentile"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsCheckM from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsCheckM from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checkm_marker_set": obj.get("checkm_marker_set"),
            "checkm_species_tax_id": obj.get("checkm_species_tax_id"),
            "checkm_marker_set_rank": obj.get("checkm_marker_set_rank"),
            "checkm_version": obj.get("checkm_version"),
            "completeness": obj.get("completeness"),
            "contamination": obj.get("contamination"),
            "completeness_percentile": obj.get("completeness_percentile")
        })
        return _obj


