# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_tax_data import V2reportsTaxData
from typing import Optional, Set
from typing_extensions import Self

class V2reportsClassification(BaseModel):
    """
    V2reportsClassification
    """ # noqa: E501
    superkingdom: Optional[V2reportsTaxData] = None
    kingdom: Optional[V2reportsTaxData] = None
    phylum: Optional[V2reportsTaxData] = None
    var_class: Optional[V2reportsTaxData] = Field(default=None, alias="class")
    order: Optional[V2reportsTaxData] = None
    family: Optional[V2reportsTaxData] = None
    genus: Optional[V2reportsTaxData] = None
    species: Optional[V2reportsTaxData] = None
    domain: Optional[V2reportsTaxData] = None
    realm: Optional[V2reportsTaxData] = None
    acellular_root: Optional[V2reportsTaxData] = None
    __properties: ClassVar[List[str]] = ["superkingdom", "kingdom", "phylum", "class", "order", "family", "genus", "species", "domain", "realm", "acellular_root"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsClassification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of superkingdom
        if self.superkingdom:
            _dict['superkingdom'] = self.superkingdom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of kingdom
        if self.kingdom:
            _dict['kingdom'] = self.kingdom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of phylum
        if self.phylum:
            _dict['phylum'] = self.phylum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_class
        if self.var_class:
            _dict['class'] = self.var_class.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of family
        if self.family:
            _dict['family'] = self.family.to_dict()
        # override the default output from pydantic by calling `to_dict()` of genus
        if self.genus:
            _dict['genus'] = self.genus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of species
        if self.species:
            _dict['species'] = self.species.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realm
        if self.realm:
            _dict['realm'] = self.realm.to_dict()
        # override the default output from pydantic by calling `to_dict()` of acellular_root
        if self.acellular_root:
            _dict['acellular_root'] = self.acellular_root.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsClassification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "superkingdom": V2reportsTaxData.from_dict(obj["superkingdom"]) if obj.get("superkingdom") is not None else None,
            "kingdom": V2reportsTaxData.from_dict(obj["kingdom"]) if obj.get("kingdom") is not None else None,
            "phylum": V2reportsTaxData.from_dict(obj["phylum"]) if obj.get("phylum") is not None else None,
            "class": V2reportsTaxData.from_dict(obj["class"]) if obj.get("class") is not None else None,
            "order": V2reportsTaxData.from_dict(obj["order"]) if obj.get("order") is not None else None,
            "family": V2reportsTaxData.from_dict(obj["family"]) if obj.get("family") is not None else None,
            "genus": V2reportsTaxData.from_dict(obj["genus"]) if obj.get("genus") is not None else None,
            "species": V2reportsTaxData.from_dict(obj["species"]) if obj.get("species") is not None else None,
            "domain": V2reportsTaxData.from_dict(obj["domain"]) if obj.get("domain") is not None else None,
            "realm": V2reportsTaxData.from_dict(obj["realm"]) if obj.get("realm") is not None else None,
            "acellular_root": V2reportsTaxData.from_dict(obj["acellular_root"]) if obj.get("acellular_root") is not None else None
        })
        return _obj


