# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_error_assembly_error_code import V2reportsErrorAssemblyErrorCode
from ncbi.datasets.openapi.models.v2reports_error_gene_error_code import V2reportsErrorGeneErrorCode
from ncbi.datasets.openapi.models.v2reports_error_organelle_error_code import V2reportsErrorOrganelleErrorCode
from ncbi.datasets.openapi.models.v2reports_error_taxonomy_error_code import V2reportsErrorTaxonomyErrorCode
from ncbi.datasets.openapi.models.v2reports_error_virus_error_code import V2reportsErrorVirusErrorCode
from typing import Optional, Set
from typing_extensions import Self

class V2reportsError(BaseModel):
    """
    V2reportsError
    """ # noqa: E501
    assembly_error_code: Optional[V2reportsErrorAssemblyErrorCode] = V2reportsErrorAssemblyErrorCode.UNKNOWN_ASSEMBLY_ERROR_CODE
    gene_error_code: Optional[V2reportsErrorGeneErrorCode] = V2reportsErrorGeneErrorCode.UNKNOWN_GENE_ERROR_CODE
    organelle_error_code: Optional[V2reportsErrorOrganelleErrorCode] = V2reportsErrorOrganelleErrorCode.UNKNOWN_ORGANELLE_ERROR_CODE
    virus_error_code: Optional[V2reportsErrorVirusErrorCode] = V2reportsErrorVirusErrorCode.UNKNOWN_VIRUS_ERROR_CODE
    taxonomy_error_code: Optional[V2reportsErrorTaxonomyErrorCode] = V2reportsErrorTaxonomyErrorCode.UNKNOWN_TAXONOMY_ERROR_CODE
    reason: Optional[StrictStr] = None
    message: Optional[StrictStr] = None
    invalid_identifiers: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["assembly_error_code", "gene_error_code", "organelle_error_code", "virus_error_code", "taxonomy_error_code", "reason", "message", "invalid_identifiers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assembly_error_code": obj.get("assembly_error_code") if obj.get("assembly_error_code") is not None else V2reportsErrorAssemblyErrorCode.UNKNOWN_ASSEMBLY_ERROR_CODE,
            "gene_error_code": obj.get("gene_error_code") if obj.get("gene_error_code") is not None else V2reportsErrorGeneErrorCode.UNKNOWN_GENE_ERROR_CODE,
            "organelle_error_code": obj.get("organelle_error_code") if obj.get("organelle_error_code") is not None else V2reportsErrorOrganelleErrorCode.UNKNOWN_ORGANELLE_ERROR_CODE,
            "virus_error_code": obj.get("virus_error_code") if obj.get("virus_error_code") is not None else V2reportsErrorVirusErrorCode.UNKNOWN_VIRUS_ERROR_CODE,
            "taxonomy_error_code": obj.get("taxonomy_error_code") if obj.get("taxonomy_error_code") is not None else V2reportsErrorTaxonomyErrorCode.UNKNOWN_TAXONOMY_ERROR_CODE,
            "reason": obj.get("reason"),
            "message": obj.get("message"),
            "invalid_identifiers": obj.get("invalid_identifiers")
        })
        return _obj


