# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_annotation import V2reportsAnnotation
from ncbi.datasets.openapi.models.v2reports_gene_group import V2reportsGeneGroup
from ncbi.datasets.openapi.models.v2reports_gene_ontology import V2reportsGeneOntology
from ncbi.datasets.openapi.models.v2reports_gene_summary import V2reportsGeneSummary
from ncbi.datasets.openapi.models.v2reports_gene_type import V2reportsGeneType
from ncbi.datasets.openapi.models.v2reports_genomic_region import V2reportsGenomicRegion
from ncbi.datasets.openapi.models.v2reports_nomenclature_authority import V2reportsNomenclatureAuthority
from ncbi.datasets.openapi.models.v2reports_orientation import V2reportsOrientation
from ncbi.datasets.openapi.models.v2reports_rna_type import V2reportsRnaType
from ncbi.datasets.openapi.models.v2reports_transcript_type_count import V2reportsTranscriptTypeCount
from typing import Optional, Set
from typing_extensions import Self

class V2reportsGeneDescriptor(BaseModel):
    """
    V2reportsGeneDescriptor
    """ # noqa: E501
    gene_id: Optional[StrictStr] = None
    symbol: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    tax_id: Optional[StrictStr] = None
    taxname: Optional[StrictStr] = None
    common_name: Optional[StrictStr] = None
    type: Optional[V2reportsGeneType] = V2reportsGeneType.UNKNOWN
    rna_type: Optional[V2reportsRnaType] = V2reportsRnaType.RNA_UNKNOWN
    orientation: Optional[V2reportsOrientation] = V2reportsOrientation.NONE
    reference_standards: Optional[List[V2reportsGenomicRegion]] = None
    genomic_regions: Optional[List[V2reportsGenomicRegion]] = None
    chromosomes: Optional[List[StrictStr]] = None
    nomenclature_authority: Optional[V2reportsNomenclatureAuthority] = None
    swiss_prot_accessions: Optional[List[StrictStr]] = None
    ensembl_gene_ids: Optional[List[StrictStr]] = None
    omim_ids: Optional[List[StrictStr]] = None
    synonyms: Optional[List[StrictStr]] = None
    replaced_gene_id: Optional[StrictStr] = None
    annotations: Optional[List[V2reportsAnnotation]] = None
    transcript_count: Optional[StrictInt] = None
    protein_count: Optional[StrictInt] = None
    transcript_type_counts: Optional[List[V2reportsTranscriptTypeCount]] = None
    gene_groups: Optional[List[V2reportsGeneGroup]] = None
    summary: Optional[List[V2reportsGeneSummary]] = None
    gene_ontology: Optional[V2reportsGeneOntology] = None
    locus_tag: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["gene_id", "symbol", "description", "tax_id", "taxname", "common_name", "type", "rna_type", "orientation", "reference_standards", "genomic_regions", "chromosomes", "nomenclature_authority", "swiss_prot_accessions", "ensembl_gene_ids", "omim_ids", "synonyms", "replaced_gene_id", "annotations", "transcript_count", "protein_count", "transcript_type_counts", "gene_groups", "summary", "gene_ontology", "locus_tag"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsGeneDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in reference_standards (list)
        _items = []
        if self.reference_standards:
            for _item_reference_standards in self.reference_standards:
                if _item_reference_standards:
                    _items.append(_item_reference_standards.to_dict())
            _dict['reference_standards'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in genomic_regions (list)
        _items = []
        if self.genomic_regions:
            for _item_genomic_regions in self.genomic_regions:
                if _item_genomic_regions:
                    _items.append(_item_genomic_regions.to_dict())
            _dict['genomic_regions'] = _items
        # override the default output from pydantic by calling `to_dict()` of nomenclature_authority
        if self.nomenclature_authority:
            _dict['nomenclature_authority'] = self.nomenclature_authority.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item_annotations in self.annotations:
                if _item_annotations:
                    _items.append(_item_annotations.to_dict())
            _dict['annotations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transcript_type_counts (list)
        _items = []
        if self.transcript_type_counts:
            for _item_transcript_type_counts in self.transcript_type_counts:
                if _item_transcript_type_counts:
                    _items.append(_item_transcript_type_counts.to_dict())
            _dict['transcript_type_counts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gene_groups (list)
        _items = []
        if self.gene_groups:
            for _item_gene_groups in self.gene_groups:
                if _item_gene_groups:
                    _items.append(_item_gene_groups.to_dict())
            _dict['gene_groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in summary (list)
        _items = []
        if self.summary:
            for _item_summary in self.summary:
                if _item_summary:
                    _items.append(_item_summary.to_dict())
            _dict['summary'] = _items
        # override the default output from pydantic by calling `to_dict()` of gene_ontology
        if self.gene_ontology:
            _dict['gene_ontology'] = self.gene_ontology.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsGeneDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "gene_id": obj.get("gene_id"),
            "symbol": obj.get("symbol"),
            "description": obj.get("description"),
            "tax_id": obj.get("tax_id"),
            "taxname": obj.get("taxname"),
            "common_name": obj.get("common_name"),
            "type": obj.get("type") if obj.get("type") is not None else V2reportsGeneType.UNKNOWN,
            "rna_type": obj.get("rna_type") if obj.get("rna_type") is not None else V2reportsRnaType.RNA_UNKNOWN,
            "orientation": obj.get("orientation") if obj.get("orientation") is not None else V2reportsOrientation.NONE,
            "reference_standards": [V2reportsGenomicRegion.from_dict(_item) for _item in obj["reference_standards"]] if obj.get("reference_standards") is not None else None,
            "genomic_regions": [V2reportsGenomicRegion.from_dict(_item) for _item in obj["genomic_regions"]] if obj.get("genomic_regions") is not None else None,
            "chromosomes": obj.get("chromosomes"),
            "nomenclature_authority": V2reportsNomenclatureAuthority.from_dict(obj["nomenclature_authority"]) if obj.get("nomenclature_authority") is not None else None,
            "swiss_prot_accessions": obj.get("swiss_prot_accessions"),
            "ensembl_gene_ids": obj.get("ensembl_gene_ids"),
            "omim_ids": obj.get("omim_ids"),
            "synonyms": obj.get("synonyms"),
            "replaced_gene_id": obj.get("replaced_gene_id"),
            "annotations": [V2reportsAnnotation.from_dict(_item) for _item in obj["annotations"]] if obj.get("annotations") is not None else None,
            "transcript_count": obj.get("transcript_count"),
            "protein_count": obj.get("protein_count"),
            "transcript_type_counts": [V2reportsTranscriptTypeCount.from_dict(_item) for _item in obj["transcript_type_counts"]] if obj.get("transcript_type_counts") is not None else None,
            "gene_groups": [V2reportsGeneGroup.from_dict(_item) for _item in obj["gene_groups"]] if obj.get("gene_groups") is not None else None,
            "summary": [V2reportsGeneSummary.from_dict(_item) for _item in obj["summary"]] if obj.get("summary") is not None else None,
            "gene_ontology": V2reportsGeneOntology.from_dict(obj["gene_ontology"]) if obj.get("gene_ontology") is not None else None,
            "locus_tag": obj.get("locus_tag")
        })
        return _obj


