# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_process_metadata import V2reportsProcessMetadata
from typing import Optional, Set
from typing_extensions import Self

class V2reportsGeneOntology(BaseModel):
    """
    V2reportsGeneOntology
    """ # noqa: E501
    assigned_by: Optional[StrictStr] = None
    molecular_functions: Optional[List[V2reportsProcessMetadata]] = None
    biological_processes: Optional[List[V2reportsProcessMetadata]] = None
    cellular_components: Optional[List[V2reportsProcessMetadata]] = None
    __properties: ClassVar[List[str]] = ["assigned_by", "molecular_functions", "biological_processes", "cellular_components"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsGeneOntology from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in molecular_functions (list)
        _items = []
        if self.molecular_functions:
            for _item_molecular_functions in self.molecular_functions:
                if _item_molecular_functions:
                    _items.append(_item_molecular_functions.to_dict())
            _dict['molecular_functions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in biological_processes (list)
        _items = []
        if self.biological_processes:
            for _item_biological_processes in self.biological_processes:
                if _item_biological_processes:
                    _items.append(_item_biological_processes.to_dict())
            _dict['biological_processes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cellular_components (list)
        _items = []
        if self.cellular_components:
            for _item_cellular_components in self.cellular_components:
                if _item_cellular_components:
                    _items.append(_item_cellular_components.to_dict())
            _dict['cellular_components'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsGeneOntology from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assigned_by": obj.get("assigned_by"),
            "molecular_functions": [V2reportsProcessMetadata.from_dict(_item) for _item in obj["molecular_functions"]] if obj.get("molecular_functions") is not None else None,
            "biological_processes": [V2reportsProcessMetadata.from_dict(_item) for _item in obj["biological_processes"]] if obj.get("biological_processes") is not None else None,
            "cellular_components": [V2reportsProcessMetadata.from_dict(_item) for _item in obj["cellular_components"]] if obj.get("cellular_components") is not None else None
        })
        return _obj


