# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_error import V2reportsError
from ncbi.datasets.openapi.models.v2reports_genome_annotation import V2reportsGenomeAnnotation
from ncbi.datasets.openapi.models.v2reports_warning import V2reportsWarning
from typing import Optional, Set
from typing_extensions import Self

class V2reportsGenomeAnnotationReportMatch(BaseModel):
    """
    V2reportsGenomeAnnotationReportMatch
    """ # noqa: E501
    annotation: Optional[V2reportsGenomeAnnotation] = None
    query: Optional[List[StrictStr]] = None
    warning: Optional[V2reportsWarning] = None
    errors: Optional[List[V2reportsError]] = None
    row_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["annotation", "query", "warning", "errors", "row_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsGenomeAnnotationReportMatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of annotation
        if self.annotation:
            _dict['annotation'] = self.annotation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of warning
        if self.warning:
            _dict['warning'] = self.warning.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsGenomeAnnotationReportMatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "annotation": V2reportsGenomeAnnotation.from_dict(obj["annotation"]) if obj.get("annotation") is not None else None,
            "query": obj.get("query"),
            "warning": V2reportsWarning.from_dict(obj["warning"]) if obj.get("warning") is not None else None,
            "errors": [V2reportsError.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "row_id": obj.get("row_id")
        })
        return _obj


