# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_bio_project import V2reportsBioProject
from ncbi.datasets.openapi.models.v2reports_organelle_biosample import V2reportsOrganelleBiosample
from ncbi.datasets.openapi.models.v2reports_organelle_gene_counts import V2reportsOrganelleGeneCounts
from ncbi.datasets.openapi.models.v2reports_organelle_topology import V2reportsOrganelleTopology
from ncbi.datasets.openapi.models.v2reports_organelle_type import V2reportsOrganelleType
from ncbi.datasets.openapi.models.v2reports_organism import V2reportsOrganism
from ncbi.datasets.openapi.models.v2reports_sequence_information import V2reportsSequenceInformation
from typing import Optional, Set
from typing_extensions import Self

class V2reportsOrganelle(BaseModel):
    """
    V2reportsOrganelle
    """ # noqa: E501
    description: Optional[V2reportsOrganelleType] = V2reportsOrganelleType.ORGANELLE_TYPE_UNKNOWN
    genbank: Optional[V2reportsSequenceInformation] = None
    refseq: Optional[V2reportsSequenceInformation] = None
    organism: Optional[V2reportsOrganism] = None
    bioprojects: Optional[List[V2reportsBioProject]] = None
    biosample: Optional[V2reportsOrganelleBiosample] = None
    gene_counts: Optional[V2reportsOrganelleGeneCounts] = None
    length: Optional[StrictInt] = None
    topology: Optional[V2reportsOrganelleTopology] = V2reportsOrganelleTopology.TOPOLOGY_UNKNOWN
    gene_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["description", "genbank", "refseq", "organism", "bioprojects", "biosample", "gene_counts", "length", "topology", "gene_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsOrganelle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of genbank
        if self.genbank:
            _dict['genbank'] = self.genbank.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refseq
        if self.refseq:
            _dict['refseq'] = self.refseq.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organism
        if self.organism:
            _dict['organism'] = self.organism.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in bioprojects (list)
        _items = []
        if self.bioprojects:
            for _item_bioprojects in self.bioprojects:
                if _item_bioprojects:
                    _items.append(_item_bioprojects.to_dict())
            _dict['bioprojects'] = _items
        # override the default output from pydantic by calling `to_dict()` of biosample
        if self.biosample:
            _dict['biosample'] = self.biosample.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gene_counts
        if self.gene_counts:
            _dict['gene_counts'] = self.gene_counts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsOrganelle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description") if obj.get("description") is not None else V2reportsOrganelleType.ORGANELLE_TYPE_UNKNOWN,
            "genbank": V2reportsSequenceInformation.from_dict(obj["genbank"]) if obj.get("genbank") is not None else None,
            "refseq": V2reportsSequenceInformation.from_dict(obj["refseq"]) if obj.get("refseq") is not None else None,
            "organism": V2reportsOrganism.from_dict(obj["organism"]) if obj.get("organism") is not None else None,
            "bioprojects": [V2reportsBioProject.from_dict(_item) for _item in obj["bioprojects"]] if obj.get("bioprojects") is not None else None,
            "biosample": V2reportsOrganelleBiosample.from_dict(obj["biosample"]) if obj.get("biosample") is not None else None,
            "gene_counts": V2reportsOrganelleGeneCounts.from_dict(obj["gene_counts"]) if obj.get("gene_counts") is not None else None,
            "length": obj.get("length"),
            "topology": obj.get("topology") if obj.get("topology") is not None else V2reportsOrganelleTopology.TOPOLOGY_UNKNOWN,
            "gene_count": obj.get("gene_count")
        })
        return _obj


