# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_infraspecific_names import V2reportsInfraspecificNames
from ncbi.datasets.openapi.models.v2reports_lineage_organism import V2reportsLineageOrganism
from typing import Optional, Set
from typing_extensions import Self

class V2reportsOrganism(BaseModel):
    """
    V2reportsOrganism
    """ # noqa: E501
    tax_id: Optional[StrictInt] = None
    sci_name: Optional[StrictStr] = None
    organism_name: Optional[StrictStr] = None
    common_name: Optional[StrictStr] = None
    lineage: Optional[List[V2reportsLineageOrganism]] = None
    strain: Optional[StrictStr] = None
    pangolin_classification: Optional[StrictStr] = None
    infraspecific_names: Optional[V2reportsInfraspecificNames] = None
    __properties: ClassVar[List[str]] = ["tax_id", "sci_name", "organism_name", "common_name", "lineage", "strain", "pangolin_classification", "infraspecific_names"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsOrganism from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lineage (list)
        _items = []
        if self.lineage:
            for _item_lineage in self.lineage:
                if _item_lineage:
                    _items.append(_item_lineage.to_dict())
            _dict['lineage'] = _items
        # override the default output from pydantic by calling `to_dict()` of infraspecific_names
        if self.infraspecific_names:
            _dict['infraspecific_names'] = self.infraspecific_names.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsOrganism from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tax_id": obj.get("tax_id"),
            "sci_name": obj.get("sci_name"),
            "organism_name": obj.get("organism_name"),
            "common_name": obj.get("common_name"),
            "lineage": [V2reportsLineageOrganism.from_dict(_item) for _item in obj["lineage"]] if obj.get("lineage") is not None else None,
            "strain": obj.get("strain"),
            "pangolin_classification": obj.get("pangolin_classification"),
            "infraspecific_names": V2reportsInfraspecificNames.from_dict(obj["infraspecific_names"]) if obj.get("infraspecific_names") is not None else None
        })
        return _obj


