# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_assembly_status import V2reportsAssemblyStatus
from typing import Optional, Set
from typing_extensions import Self

class V2reportsPairedAssembly(BaseModel):
    """
    V2reportsPairedAssembly
    """ # noqa: E501
    accession: Optional[StrictStr] = None
    status: Optional[V2reportsAssemblyStatus] = V2reportsAssemblyStatus.ASSEMBLY_STATUS_UNKNOWN
    annotation_name: Optional[StrictStr] = None
    only_genbank: Optional[StrictStr] = None
    only_refseq: Optional[StrictStr] = None
    changed: Optional[StrictStr] = None
    manual_diff: Optional[StrictStr] = None
    refseq_genbank_are_different: Optional[StrictBool] = None
    differences: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["accession", "status", "annotation_name", "only_genbank", "only_refseq", "changed", "manual_diff", "refseq_genbank_are_different", "differences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsPairedAssembly from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsPairedAssembly from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession": obj.get("accession"),
            "status": obj.get("status") if obj.get("status") is not None else V2reportsAssemblyStatus.ASSEMBLY_STATUS_UNKNOWN,
            "annotation_name": obj.get("annotation_name"),
            "only_genbank": obj.get("only_genbank"),
            "only_refseq": obj.get("only_refseq"),
            "changed": obj.get("changed"),
            "manual_diff": obj.get("manual_diff"),
            "refseq_genbank_are_different": obj.get("refseq_genbank_are_different"),
            "differences": obj.get("differences")
        })
        return _obj


