# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_gene_type import V2reportsGeneType
from ncbi.datasets.openapi.models.v2reports_rna_type import V2reportsRnaType
from ncbi.datasets.openapi.models.v2reports_transcript import V2reportsTranscript
from ncbi.datasets.openapi.models.v2reports_transcript_type_count import V2reportsTranscriptTypeCount
from typing import Optional, Set
from typing_extensions import Self

class V2reportsProductDescriptor(BaseModel):
    """
    V2reportsProductDescriptor
    """ # noqa: E501
    gene_id: Optional[StrictStr] = None
    symbol: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    tax_id: Optional[StrictStr] = None
    taxname: Optional[StrictStr] = None
    common_name: Optional[StrictStr] = None
    type: Optional[V2reportsGeneType] = V2reportsGeneType.UNKNOWN
    rna_type: Optional[V2reportsRnaType] = V2reportsRnaType.RNA_UNKNOWN
    transcripts: Optional[List[V2reportsTranscript]] = None
    transcript_count: Optional[StrictInt] = None
    protein_count: Optional[StrictInt] = None
    transcript_type_counts: Optional[List[V2reportsTranscriptTypeCount]] = None
    __properties: ClassVar[List[str]] = ["gene_id", "symbol", "description", "tax_id", "taxname", "common_name", "type", "rna_type", "transcripts", "transcript_count", "protein_count", "transcript_type_counts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsProductDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in transcripts (list)
        _items = []
        if self.transcripts:
            for _item_transcripts in self.transcripts:
                if _item_transcripts:
                    _items.append(_item_transcripts.to_dict())
            _dict['transcripts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transcript_type_counts (list)
        _items = []
        if self.transcript_type_counts:
            for _item_transcript_type_counts in self.transcript_type_counts:
                if _item_transcript_type_counts:
                    _items.append(_item_transcript_type_counts.to_dict())
            _dict['transcript_type_counts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsProductDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "gene_id": obj.get("gene_id"),
            "symbol": obj.get("symbol"),
            "description": obj.get("description"),
            "tax_id": obj.get("tax_id"),
            "taxname": obj.get("taxname"),
            "common_name": obj.get("common_name"),
            "type": obj.get("type") if obj.get("type") is not None else V2reportsGeneType.UNKNOWN,
            "rna_type": obj.get("rna_type") if obj.get("rna_type") is not None else V2reportsRnaType.RNA_UNKNOWN,
            "transcripts": [V2reportsTranscript.from_dict(_item) for _item in obj["transcripts"]] if obj.get("transcripts") is not None else None,
            "transcript_count": obj.get("transcript_count"),
            "protein_count": obj.get("protein_count"),
            "transcript_type_counts": [V2reportsTranscriptTypeCount.from_dict(_item) for _item in obj["transcript_type_counts"]] if obj.get("transcript_type_counts") is not None else None
        })
        return _obj


