# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_functional_site import V2reportsFunctionalSite
from ncbi.datasets.openapi.models.v2reports_protein_conserved_domain import V2reportsProteinConservedDomain
from ncbi.datasets.openapi.models.v2reports_protein_family import V2reportsProteinFamily
from typing import Optional, Set
from typing_extensions import Self

class V2reportsProteinDataReport(BaseModel):
    """
    V2reportsProteinDataReport
    """ # noqa: E501
    accession: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    length: Optional[StrictInt] = None
    gene_id: Optional[StrictInt] = None
    identical_protein_group: Optional[StrictInt] = None
    tax_id: Optional[StrictInt] = None
    conserved_domains: Optional[List[V2reportsProteinConservedDomain]] = None
    functional_sites: Optional[List[V2reportsFunctionalSite]] = None
    protein_families: Optional[List[V2reportsProteinFamily]] = None
    __properties: ClassVar[List[str]] = ["accession", "description", "length", "gene_id", "identical_protein_group", "tax_id", "conserved_domains", "functional_sites", "protein_families"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsProteinDataReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conserved_domains (list)
        _items = []
        if self.conserved_domains:
            for _item_conserved_domains in self.conserved_domains:
                if _item_conserved_domains:
                    _items.append(_item_conserved_domains.to_dict())
            _dict['conserved_domains'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in functional_sites (list)
        _items = []
        if self.functional_sites:
            for _item_functional_sites in self.functional_sites:
                if _item_functional_sites:
                    _items.append(_item_functional_sites.to_dict())
            _dict['functional_sites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in protein_families (list)
        _items = []
        if self.protein_families:
            for _item_protein_families in self.protein_families:
                if _item_protein_families:
                    _items.append(_item_protein_families.to_dict())
            _dict['protein_families'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsProteinDataReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession": obj.get("accession"),
            "description": obj.get("description"),
            "length": obj.get("length"),
            "gene_id": obj.get("gene_id"),
            "identical_protein_group": obj.get("identical_protein_group"),
            "tax_id": obj.get("tax_id"),
            "conserved_domains": [V2reportsProteinConservedDomain.from_dict(_item) for _item in obj["conserved_domains"]] if obj.get("conserved_domains") is not None else None,
            "functional_sites": [V2reportsFunctionalSite.from_dict(_item) for _item in obj["functional_sites"]] if obj.get("functional_sites") is not None else None,
            "protein_families": [V2reportsProteinFamily.from_dict(_item) for _item in obj["protein_families"]] if obj.get("protein_families") is not None else None
        })
        return _obj


