# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class V2reportsSequenceInfo(BaseModel):
    """
    V2reportsSequenceInfo
    """ # noqa: E501
    assembly_accession: Optional[StrictStr] = None
    chr_name: Optional[StrictStr] = None
    ucsc_style_name: Optional[StrictStr] = None
    sort_order: Optional[StrictInt] = None
    assigned_molecule_location_type: Optional[StrictStr] = None
    refseq_accession: Optional[StrictStr] = None
    assembly_unit: Optional[StrictStr] = None
    length: Optional[StrictInt] = None
    genbank_accession: Optional[StrictStr] = None
    gc_count: Optional[StrictStr] = None
    gc_percent: Optional[Union[StrictFloat, StrictInt]] = None
    unlocalized_count: Optional[StrictInt] = None
    assembly_unplaced_count: Optional[StrictInt] = None
    role: Optional[StrictStr] = None
    sequence_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["assembly_accession", "chr_name", "ucsc_style_name", "sort_order", "assigned_molecule_location_type", "refseq_accession", "assembly_unit", "length", "genbank_accession", "gc_count", "gc_percent", "unlocalized_count", "assembly_unplaced_count", "role", "sequence_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsSequenceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsSequenceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assembly_accession": obj.get("assembly_accession"),
            "chr_name": obj.get("chr_name"),
            "ucsc_style_name": obj.get("ucsc_style_name"),
            "sort_order": obj.get("sort_order"),
            "assigned_molecule_location_type": obj.get("assigned_molecule_location_type"),
            "refseq_accession": obj.get("refseq_accession"),
            "assembly_unit": obj.get("assembly_unit"),
            "length": obj.get("length"),
            "genbank_accession": obj.get("genbank_accession"),
            "gc_count": obj.get("gc_count"),
            "gc_percent": obj.get("gc_percent"),
            "unlocalized_count": obj.get("unlocalized_count"),
            "assembly_unplaced_count": obj.get("assembly_unplaced_count"),
            "role": obj.get("role"),
            "sequence_name": obj.get("sequence_name")
        })
        return _obj


