# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_classification import V2reportsClassification
from ncbi.datasets.openapi.models.v2reports_name_and_authority import V2reportsNameAndAuthority
from ncbi.datasets.openapi.models.v2reports_rank_type import V2reportsRankType
from ncbi.datasets.openapi.models.v2reports_taxonomy_node_count_by_type import V2reportsTaxonomyNodeCountByType
from typing import Optional, Set
from typing_extensions import Self

class V2reportsTaxonomyNode(BaseModel):
    """
    V2reportsTaxonomyNode
    """ # noqa: E501
    tax_id: Optional[StrictInt] = None
    rank: Optional[V2reportsRankType] = V2reportsRankType.NO_RANK
    current_scientific_name: Optional[V2reportsNameAndAuthority] = None
    basionym: Optional[V2reportsNameAndAuthority] = None
    curator_common_name: Optional[StrictStr] = None
    group_name: Optional[StrictStr] = None
    has_type_material: Optional[StrictBool] = None
    classification: Optional[V2reportsClassification] = None
    parents: Optional[List[StrictInt]] = None
    children: Optional[List[StrictInt]] = None
    counts: Optional[List[V2reportsTaxonomyNodeCountByType]] = None
    genomic_moltype: Optional[StrictStr] = None
    current_scientific_name_is_formal: Optional[StrictBool] = None
    secondary_tax_ids: Optional[List[StrictInt]] = None
    extinct: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["tax_id", "rank", "current_scientific_name", "basionym", "curator_common_name", "group_name", "has_type_material", "classification", "parents", "children", "counts", "genomic_moltype", "current_scientific_name_is_formal", "secondary_tax_ids", "extinct"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsTaxonomyNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of current_scientific_name
        if self.current_scientific_name:
            _dict['current_scientific_name'] = self.current_scientific_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of basionym
        if self.basionym:
            _dict['basionym'] = self.basionym.to_dict()
        # override the default output from pydantic by calling `to_dict()` of classification
        if self.classification:
            _dict['classification'] = self.classification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in counts (list)
        _items = []
        if self.counts:
            for _item_counts in self.counts:
                if _item_counts:
                    _items.append(_item_counts.to_dict())
            _dict['counts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsTaxonomyNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tax_id": obj.get("tax_id"),
            "rank": obj.get("rank") if obj.get("rank") is not None else V2reportsRankType.NO_RANK,
            "current_scientific_name": V2reportsNameAndAuthority.from_dict(obj["current_scientific_name"]) if obj.get("current_scientific_name") is not None else None,
            "basionym": V2reportsNameAndAuthority.from_dict(obj["basionym"]) if obj.get("basionym") is not None else None,
            "curator_common_name": obj.get("curator_common_name"),
            "group_name": obj.get("group_name"),
            "has_type_material": obj.get("has_type_material"),
            "classification": V2reportsClassification.from_dict(obj["classification"]) if obj.get("classification") is not None else None,
            "parents": obj.get("parents"),
            "children": obj.get("children"),
            "counts": [V2reportsTaxonomyNodeCountByType.from_dict(_item) for _item in obj["counts"]] if obj.get("counts") is not None else None,
            "genomic_moltype": obj.get("genomic_moltype"),
            "current_scientific_name_is_formal": obj.get("current_scientific_name_is_formal"),
            "secondary_tax_ids": obj.get("secondary_tax_ids"),
            "extinct": obj.get("extinct")
        })
        return _obj


