# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_genomic_location import V2reportsGenomicLocation
from ncbi.datasets.openapi.models.v2reports_protein import V2reportsProtein
from ncbi.datasets.openapi.models.v2reports_seq_range_set import V2reportsSeqRangeSet
from ncbi.datasets.openapi.models.v2reports_transcript_select_category import V2reportsTranscriptSelectCategory
from ncbi.datasets.openapi.models.v2reports_transcript_transcript_type import V2reportsTranscriptTranscriptType
from typing import Optional, Set
from typing_extensions import Self

class V2reportsTranscript(BaseModel):
    """
    V2reportsTranscript
    """ # noqa: E501
    accession_version: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    length: Optional[StrictInt] = None
    cds: Optional[V2reportsSeqRangeSet] = None
    genomic_locations: Optional[List[V2reportsGenomicLocation]] = None
    ensembl_transcript: Optional[StrictStr] = None
    protein: Optional[V2reportsProtein] = None
    type: Optional[V2reportsTranscriptTranscriptType] = V2reportsTranscriptTranscriptType.UNKNOWN
    select_category: Optional[V2reportsTranscriptSelectCategory] = V2reportsTranscriptSelectCategory.SELECT_UNKNOWN
    __properties: ClassVar[List[str]] = ["accession_version", "name", "length", "cds", "genomic_locations", "ensembl_transcript", "protein", "type", "select_category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsTranscript from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cds
        if self.cds:
            _dict['cds'] = self.cds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in genomic_locations (list)
        _items = []
        if self.genomic_locations:
            for _item_genomic_locations in self.genomic_locations:
                if _item_genomic_locations:
                    _items.append(_item_genomic_locations.to_dict())
            _dict['genomic_locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of protein
        if self.protein:
            _dict['protein'] = self.protein.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsTranscript from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession_version": obj.get("accession_version"),
            "name": obj.get("name"),
            "length": obj.get("length"),
            "cds": V2reportsSeqRangeSet.from_dict(obj["cds"]) if obj.get("cds") is not None else None,
            "genomic_locations": [V2reportsGenomicLocation.from_dict(_item) for _item in obj["genomic_locations"]] if obj.get("genomic_locations") is not None else None,
            "ensembl_transcript": obj.get("ensembl_transcript"),
            "protein": V2reportsProtein.from_dict(obj["protein"]) if obj.get("protein") is not None else None,
            "type": obj.get("type") if obj.get("type") is not None else V2reportsTranscriptTranscriptType.UNKNOWN,
            "select_category": obj.get("select_category") if obj.get("select_category") is not None else V2reportsTranscriptSelectCategory.SELECT_UNKNOWN
        })
        return _obj


