# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2reports_isolate import V2reportsIsolate
from ncbi.datasets.openapi.models.v2reports_organism import V2reportsOrganism
from ncbi.datasets.openapi.models.v2reports_purpose_of_sampling import V2reportsPurposeOfSampling
from ncbi.datasets.openapi.models.v2reports_seq_range_set_fasta import V2reportsSeqRangeSetFasta
from ncbi.datasets.openapi.models.v2reports_virus_assembly_collection_location import V2reportsVirusAssemblyCollectionLocation
from ncbi.datasets.openapi.models.v2reports_virus_assembly_completeness import V2reportsVirusAssemblyCompleteness
from ncbi.datasets.openapi.models.v2reports_virus_assembly_submitter_info import V2reportsVirusAssemblySubmitterInfo
from typing import Optional, Set
from typing_extensions import Self

class V2reportsVirusAssembly(BaseModel):
    """
    V2reportsVirusAssembly
    """ # noqa: E501
    accession: Optional[StrictStr] = None
    is_complete: Optional[StrictBool] = None
    is_annotated: Optional[StrictBool] = None
    isolate: Optional[V2reportsIsolate] = None
    source_database: Optional[StrictStr] = None
    protein_count: Optional[StrictInt] = None
    host: Optional[V2reportsOrganism] = None
    virus: Optional[V2reportsOrganism] = None
    bioprojects: Optional[List[StrictStr]] = None
    location: Optional[V2reportsVirusAssemblyCollectionLocation] = None
    update_date: Optional[StrictStr] = None
    release_date: Optional[StrictStr] = None
    nucleotide_completeness: Optional[StrictStr] = None
    completeness: Optional[V2reportsVirusAssemblyCompleteness] = V2reportsVirusAssemblyCompleteness.UNKNOWN
    length: Optional[StrictInt] = None
    gene_count: Optional[StrictInt] = None
    mature_peptide_count: Optional[StrictInt] = None
    biosample: Optional[StrictStr] = None
    mol_type: Optional[StrictStr] = None
    nucleotide: Optional[V2reportsSeqRangeSetFasta] = None
    purpose_of_sampling: Optional[V2reportsPurposeOfSampling] = V2reportsPurposeOfSampling.PURPOSE_OF_SAMPLING_UNKNOWN
    sra_accessions: Optional[List[StrictStr]] = None
    submitter: Optional[V2reportsVirusAssemblySubmitterInfo] = None
    lab_host: Optional[StrictStr] = None
    is_lab_host: Optional[StrictBool] = None
    is_vaccine_strain: Optional[StrictBool] = None
    segment: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["accession", "is_complete", "is_annotated", "isolate", "source_database", "protein_count", "host", "virus", "bioprojects", "location", "update_date", "release_date", "nucleotide_completeness", "completeness", "length", "gene_count", "mature_peptide_count", "biosample", "mol_type", "nucleotide", "purpose_of_sampling", "sra_accessions", "submitter", "lab_host", "is_lab_host", "is_vaccine_strain", "segment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2reportsVirusAssembly from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of isolate
        if self.isolate:
            _dict['isolate'] = self.isolate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of host
        if self.host:
            _dict['host'] = self.host.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virus
        if self.virus:
            _dict['virus'] = self.virus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nucleotide
        if self.nucleotide:
            _dict['nucleotide'] = self.nucleotide.to_dict()
        # override the default output from pydantic by calling `to_dict()` of submitter
        if self.submitter:
            _dict['submitter'] = self.submitter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2reportsVirusAssembly from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession": obj.get("accession"),
            "is_complete": obj.get("is_complete"),
            "is_annotated": obj.get("is_annotated"),
            "isolate": V2reportsIsolate.from_dict(obj["isolate"]) if obj.get("isolate") is not None else None,
            "source_database": obj.get("source_database"),
            "protein_count": obj.get("protein_count"),
            "host": V2reportsOrganism.from_dict(obj["host"]) if obj.get("host") is not None else None,
            "virus": V2reportsOrganism.from_dict(obj["virus"]) if obj.get("virus") is not None else None,
            "bioprojects": obj.get("bioprojects"),
            "location": V2reportsVirusAssemblyCollectionLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "update_date": obj.get("update_date"),
            "release_date": obj.get("release_date"),
            "nucleotide_completeness": obj.get("nucleotide_completeness"),
            "completeness": obj.get("completeness") if obj.get("completeness") is not None else V2reportsVirusAssemblyCompleteness.UNKNOWN,
            "length": obj.get("length"),
            "gene_count": obj.get("gene_count"),
            "mature_peptide_count": obj.get("mature_peptide_count"),
            "biosample": obj.get("biosample"),
            "mol_type": obj.get("mol_type"),
            "nucleotide": V2reportsSeqRangeSetFasta.from_dict(obj["nucleotide"]) if obj.get("nucleotide") is not None else None,
            "purpose_of_sampling": obj.get("purpose_of_sampling") if obj.get("purpose_of_sampling") is not None else V2reportsPurposeOfSampling.PURPOSE_OF_SAMPLING_UNKNOWN,
            "sra_accessions": obj.get("sra_accessions"),
            "submitter": V2reportsVirusAssemblySubmitterInfo.from_dict(obj["submitter"]) if obj.get("submitter") is not None else None,
            "lab_host": obj.get("lab_host"),
            "is_lab_host": obj.get("is_lab_host"),
            "is_vaccine_strain": obj.get("is_vaccine_strain"),
            "segment": obj.get("segment")
        })
        return _obj


