/*
* @license Apache-2.0
*
* Copyright (c) 2022 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 4.1

/**
* High word mask for the sign bit of a double-precision floating-point number.
*
* @example
* var mask = FLOAT64_HIGH_WORD_SIGN_MASK;
* // returns 2147483648
*/
declare const FLOAT64_HIGH_WORD_SIGN_MASK: number;


// EXPORTS //

export = FLOAT64_HIGH_WORD_SIGN_MASK;
