/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 4.1

/**
* The maximum biased base 2 exponent for a subnormal double-precision floating-point number.
*
* @example
* var exp = FLOAT64_MAX_BASE2_EXPONENT_SUBNORMAL;
* // returns -1023
*/
declare const FLOAT64_MAX_BASE2_EXPONENT_SUBNORMAL: number;


// EXPORTS //

export = FLOAT64_MAX_BASE2_EXPONENT_SUBNORMAL;
