<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->


<details>
  <summary>
    About stdlib...
  </summary>
  <p>We believe in a future in which the web is a preferred environment for numerical computation. To help realize this future, we've built stdlib. stdlib is a standard library, with an emphasis on numerical and scientific computation, written in JavaScript (and C) for execution in browsers and in Node.js.</p>
  <p>The library is fully decomposable, being architected in such a way that you can swap out and mix and match APIs and functionality to cater to your exact preferences and use cases.</p>
  <p>When you use stdlib, you can be absolutely certain that you are using the most thorough, rigorous, well-written, studied, documented, tested, measured, and high-quality code out there.</p>
  <p>To join us in bringing numerical computing to the web, get started by checking us out on <a href="https://github.com/stdlib-js/stdlib">GitHub</a>, and please consider <a href="https://opencollective.com/stdlib">financially supporting stdlib</a>. We greatly appreciate your continued support!</p>
</details>

# Constant Function

[![NPM version][npm-image]][npm-url] [![Build Status][test-image]][test-url] [![Coverage Status][coverage-image]][coverage-url] <!-- [![dependencies][dependencies-image]][dependencies-url] -->

> Constant function.

<section class="intro">

A [constant function][constant-function] is a `function` whose output value is the same for every input value.

</section>

<!-- /.intro -->

<section class="installation">

## Installation

```bash
npm install @stdlib/utils-constant-function
```

</section>

<section class="usage">

## Usage

```javascript
var constantFunction = require( '@stdlib/utils-constant-function' );
```

#### constantFunction( x )

Returns a [constant function][constant-function] which always returns `x`.

```javascript
var fcn = constantFunction( 'beep' );
// returns <Function>

var v = fcn();
// returns 'beep'

v = fcn();
// returns 'beep'
```

</section>

<!-- /.usage -->

<section class="notes">

## Notes

-   When provided an object reference, the returned `function` always returns the same reference.

    ```javascript
    var obj = {};
    var fcn = constantFunction( obj );

    var bool = ( fcn() === obj );
    // returns true
    ```

</section>

<!-- /.notes -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var constantFunction = require( '@stdlib/utils-constant-function' );

var bool;
var fcn;
var arr;
var v;
var i;

fcn = constantFunction( 3.14 );
for ( i = 0; i < 10; i++ ) {
    v = fcn();
    // returns 3.14
}

arr = [ 1, 2, 3 ];
fcn = constantFunction( arr );
for ( i = 0; i < 10; i++ ) {
    v = fcn();
    bool = ( v === arr );
    // returns true
}
```

</section>

<!-- /.examples -->

<!-- Section for related `stdlib` packages. Do not manually edit this section, as it is automatically populated. -->

<section class="related">

* * *

## See Also

-   <span class="package-name">[`@stdlib/utils-argument-function`][@stdlib/utils/argument-function]</span><span class="delimiter">: </span><span class="description">argument function.</span>
-   <span class="package-name">[`@stdlib/utils-identity-function`][@stdlib/utils/identity-function]</span><span class="delimiter">: </span><span class="description">identity function.</span>

</section>

<!-- /.related -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->


<section class="main-repo" >

* * *

## Notice

This package is part of [stdlib][stdlib], a standard library for JavaScript and Node.js, with an emphasis on numerical and scientific computing. The library provides a collection of robust, high performance libraries for mathematics, statistics, streams, utilities, and more.

For more information on the project, filing bug reports and feature requests, and guidance on how to develop [stdlib][stdlib], see the main project [repository][stdlib].

#### Community

[![Chat][chat-image]][chat-url]

---

## License

See [LICENSE][stdlib-license].


## Copyright

Copyright &copy; 2016-2024. The Stdlib [Authors][stdlib-authors].

</section>

<!-- /.stdlib -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[npm-image]: http://img.shields.io/npm/v/@stdlib/utils-constant-function.svg
[npm-url]: https://npmjs.org/package/@stdlib/utils-constant-function

[test-image]: https://github.com/stdlib-js/utils-constant-function/actions/workflows/test.yml/badge.svg?branch=v0.2.2
[test-url]: https://github.com/stdlib-js/utils-constant-function/actions/workflows/test.yml?query=branch:v0.2.2

[coverage-image]: https://img.shields.io/codecov/c/github/stdlib-js/utils-constant-function/main.svg
[coverage-url]: https://codecov.io/github/stdlib-js/utils-constant-function?branch=main

<!--

[dependencies-image]: https://img.shields.io/david/stdlib-js/utils-constant-function.svg
[dependencies-url]: https://david-dm.org/stdlib-js/utils-constant-function/main

-->

[chat-image]: https://img.shields.io/gitter/room/stdlib-js/stdlib.svg
[chat-url]: https://app.gitter.im/#/room/#stdlib-js_stdlib:gitter.im

[stdlib]: https://github.com/stdlib-js/stdlib

[stdlib-authors]: https://github.com/stdlib-js/stdlib/graphs/contributors

[umd]: https://github.com/umdjs/umd
[es-module]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules

[deno-url]: https://github.com/stdlib-js/utils-constant-function/tree/deno
[deno-readme]: https://github.com/stdlib-js/utils-constant-function/blob/deno/README.md
[umd-url]: https://github.com/stdlib-js/utils-constant-function/tree/umd
[umd-readme]: https://github.com/stdlib-js/utils-constant-function/blob/umd/README.md
[esm-url]: https://github.com/stdlib-js/utils-constant-function/tree/esm
[esm-readme]: https://github.com/stdlib-js/utils-constant-function/blob/esm/README.md
[branches-url]: https://github.com/stdlib-js/utils-constant-function/blob/main/branches.md

[stdlib-license]: https://raw.githubusercontent.com/stdlib-js/utils-constant-function/main/LICENSE

[constant-function]: https://en.wikipedia.org/wiki/Constant_function

<!-- <related-links> -->

[@stdlib/utils/argument-function]: https://www.npmjs.com/package/@stdlib/utils-argument-function

[@stdlib/utils/identity-function]: https://www.npmjs.com/package/@stdlib/utils-identity-function

<!-- </related-links> -->

</section>

<!-- /.links -->
