/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 4.1

/**
* Interface defining function options.
*/
interface Options {
	/**
	* Base search directory.
	*/
	basedir?: string;

	/**
	* Path convention.
	*/
	paths?: string;
}

/**
* Returns a configuration.
*
* @param fpath - manifest file path
* @param conditions - conditions
* @param options - options
* @param options.basedir - base search directory
* @param options.paths - path convention
* @throws must provide valid options
* @returns configuration
*
* @example
* var conf = manifest( './manifest.json', {} );
*/
declare function manifest( fpath: string, conditions: any, options?: Options ): any;


// EXPORTS //

export = manifest;
