# Converting a narrative to PDF
<!-- WARNING -->
<!-- Do not edit this file from within the docs.nextstrain.org repository. -->
<!-- It is fetched from another repository to be included in the docs.nextstrain.org build. -->
<!-- So, if you edit it after it is fetched into docs.nextstrain.org, your changes will be lost. -->
<!-- Instead, edit this file in its own repository and commit your changes there. -->
<!-- For more details on this (temporary) implementation, see https://github.com/nextstrain/docs.nextstrain.org#fetching-of-documents-from-other-repositories -->
<!-- This file is located at (fetched from): https://github.com/nextstrain/auspice/blob/master/docs/narratives/create-pdf.md -->
<!-- WARNING -->
<!-- WARNING -->
<!-- WARNING -->

This documentation will walk through how to turn a narrative into a static PDF.
We understand that there are multiple reasons why PDFs may be a necessary method of distribution, but stress that narratives are designed to be viewed through auspice where you have the ability to interact with and interrogate the data.

If you run into any bugs, please [get in contact with us](https://nextstrain.org/contact).

## Prerequisites

This requires [Decktape](https://github.com/astefanutti/decktape) to be installed, which itself requires Node.js.
If you've followed the [auspice install instructions](https://docs.nextstrain.org/projects/auspice/page/introduction/install.html) and are using a conda environment then this is straightforward.
If not, you can create the necessary conda environment via:

```bash
conda create --name auspice nodejs=14
```

Install Decktape via:
```bash
conda activate auspice # or whichever conda environment has nodejs
npm install --global decktape
```


## Saving an online narrative to PDF

Let's say we want to save the example Genomic-Epi Situation Report for Ebola in the DRC available at [nextstrain.org/narratives/inrb-ebola-example-sit-rep](https://nextstrain.org/narratives/inrb-ebola-example-sit-rep) which you can see has 6 different "pages" of content.
We use decktape to access these different pages & save their output as PDF via:

```bash
decktape generic --load-pause 3000 --key ArrowDown --size 1600x900 \
  https://nextstrain.org/narratives/inrb-ebola-example-sit-rep example.pdf
```
You'll see a lot of bad-looking warning messages printed in the terminal 😱, but as long as you see "Printed 7 slides" or similar then the command has worked.
You should now be able to view a static PDF of the narrative, in this case at `example.pdf`.
Feel free to play around with the different options available to decktape (run `decktape generic --help` to see them).

> Note that this technique won't work if authentication is required. Please refer to the section on saving local narratives to PDF for how to do this.

## Saving a local narrative to PDF

If you have a local narrative then the concept is similar to saving an online narrative, except we need to start a auspice server locally to display our narrative & allow it to be accessed by decktape.
These instructions assume you have installed auspice into a conda enviornment as per the [auspice install instructions](https://docs.nextstrain.org/projects/auspice/page/introduction/install.html).

Start up auspice locally, sourcing your own datasets & narratives via:
```bash
conda activate auspice # or whichever conda environment has auspice installed
auspice view --datasetDir <path-to-datasets> --narrativeDir <path-to-narratives>
```

You should now be able to view your narrative at [localhost:4000](http://localhost:4000).
For the purposes of this guide, i'll assume that we've followed the [Writing a Narrative](../../tutorials/narratives-how-to-write.md) guide, and thus have a narrative describing mumps in North America available at [localhost:4000/narratives/example](http://localhost:4000/narratives/example).

In a separate terminal window, run
```bash
conda activate auspice # or whichever conda environment has dectape installed from earlier
decktape generic --load-pause 3000 --key ArrowDown --size 1600x900 \
  http://localhost:4000/narratives/example example.pdf
```
You'll see a lot of bad-looking warning messages printed in the terminal 😱, but as long as you see "Printed 11 slides" or similar then the command has worked.
You should now be able to view a static PDF of the narrative, in this case at `example.pdf`.
