import React from "react";
import Card from "./card";

export const PanelSpinner = ({height, width}) => {
  return (
    <Card>
      <div style={{ height: height, width }}>
        <div className="rootSpinner"> {/* CSS definition in entry index.html */}
          <SvgLogo/>
        </div>
      </div>
    </Card>
  );
};

export function FullPageSpinner() {
  return (
    <div style={{display: "flex", flexDirection: "column", justifyContent: "center", height: "50vh"}}>
      <div className="rootSpinner"> {/* CSS definition in entry index.html */}
        <SvgLogo/>
      </div>
    </div>
  );
}

function SvgLogo() {
  // This SVG is also inlined in the entrypoint src/index.html - please make edits to both when necessary
  // (It's not a 1:1 copy as react necessitates styles as objects)
  return (
    <svg version="1.1" width="80px" height="80px" viewBox="4.5 4.5 35.5 35.5" xmlns="http://www.w3.org/2000/svg">
      <g>
        <g style={{display: "inline", strokeWidth: 2.26946759}} transform="matrix(0.440632,0,0,0.440632,-33.437126,4.4700111)">
        <path d="m124.852 78.88-.64-.032-.947-.413c-.521-.227-.966-.43-.989-.448-.022-.02.786-.718 1.796-1.553l1.838-1.518 1.808 1.214c.995.668 1.803 1.232 1.796 1.253s-.438.359-.96.75l-.946.712-.39.04c-.433.044-1.393.042-2.366-.005" style={{fill: "#a6be55"}} />
        <path d="M129.643 78.728c0-.026.226-.212.5-.414l.497-.367.614.14c.338.078.614.156.614.173s-.131.098-.292.18c-.224.115-.435.164-.905.211-.337.035-.707.076-.821.093-.115.017-.208.01-.207-.016" style={{fill: "#b9bc4a"}} />
        <path d="M117.056 77.675a25 25 0 0 1-1.31-.228c-.543-.124-2.702-.84-2.808-.93a4 4 0 0 0-.494-.287c-.324-.168-.392-.225-.334-.277.15-.136 7.091-4.004 7.172-3.996.099.009 5.41 2.34 5.474 2.403.024.023-.816.754-1.866 1.624l-1.909 1.582-.918.094c-1.62.167-1.985.169-3.007.015" style={{fill: "#92bc63"}} />
        <path d="M134.454 77.591c-.59-.067-1.378-.213-2.312-.43l-1.416-.33-2.31-1.556-2.311-1.557-3.091-1.355c-1.7-.745-3.177-1.395-3.282-1.444-.13-.061-1.216-1.241-3.374-3.664l-3.183-3.574.063-.463 1.118-7.985 1.055-7.521 5.39-3.307c4.709-2.888 5.47-3.337 6.015-3.546.344-.132.658-.24.698-.24s2.384 1.17 5.21 2.598l5.136 2.598 4.639 10.288 4.638 10.29-1.765 3.554-1.765 3.555-1.443 1.164c-1.428 1.15-1.453 1.167-2.32 1.578-.481.228-.913.447-.96.488-.086.077-1.64.579-2.568.83-.614.166-.655.166-1.862.03" style={{fill: "#80b974"}} />
        <path d="M109.955 75.114c-.459-.163-.876-.298-.927-.3-.112-.004-1.197-.576-2.196-1.159l-.73-.424-.824-1.33-.823-1.329-1.046-3.018-1.045-3.017.621-.034c.342-.02 2.591-.044 4.998-.056l4.376-.022 2.994 3.36c1.646 1.848 2.985 3.368 2.974 3.378-.013.013-6.904 3.897-7.508 4.232-.016.008-.404-.118-.864-.281M145.18 72.82c.002-.023.685-1.395 1.518-3.049l1.514-3.007 2.673-1.654 2.673-1.655.016.179c.01.098-.047 1.016-.123 2.04l-.14 1.86-.67.678c-.368.373-.67.705-.67.737 0 .062-.99.925-1.853 1.614-.332.265-.86.593-1.554.965-.9.482-1.22.62-2.204.949-1.282.428-1.184.4-1.18.343" style={{fill: "#6eb389"}} />
        <path d="M103.384 71.378c-.33-.253-.303-.29.095-.137.124.048.376.397.284.394-.024 0-.195-.116-.379-.257" style={{fill: "#80b974"}} />
        <path d="M102.104 69.614c-.785-.271-.885-.323-1.637-.845a14 14 0 0 1-1.302-1.03c-.575-.544-1.878-1.944-1.878-2.02 0-.027-.242-.417-.538-.866-.454-.69-1.278-2.222-1.225-2.276.015-.014 5.548 1.764 5.597 1.8.027.019 1.901 5.425 1.901 5.485 0 .07-.002.07-.918-.248" style={{fill: "#549db2"}} />
        <path d="M154.55 65.86c.018-.208.076-1.007.13-1.778l.096-1.402 1.247-.9c.686-.496 1.263-.885 1.281-.867.02.02-.016.57-.079 1.225l-.113 1.191-.49.632c-1.021 1.314-1.893 2.274-2.066 2.274-.021 0-.024-.17-.006-.376z" style={{fill: "#b9bc4a"}} />
        <path d="M143.508 55.655c-2.459-5.454-4.461-9.925-4.45-9.935.063-.054 20.945-7.612 20.99-7.597.03.01.8 1.25 1.712 2.755l1.66 2.737.214 1.87.214 1.869-.147.91c-.08.5-.147.997-.147 1.103 0 .197-.305 1.386-.619 2.409-.1.326-.395 1.012-.699 1.623l-.526 1.058-1.021 1.17a142 142 0 0 0-2.043 2.405l-1.022 1.235-1.845 1.33c-1.47 1.06-2.432 1.694-4.735 3.119-1.59.984-2.93 1.804-2.977 1.822-.07.027-.958-1.898-4.559-9.883" style={{fill: "#a6be55"}} />
        <path d="m98.188 62.259-3.47-1.132-1.114-1.106-1.115-1.106-.692-1.393c-.38-.767-.692-1.458-.692-1.537s-.138-1.163-.308-2.41l-.308-2.266 2.377-3.02c1.307-1.661 2.429-3.074 2.493-3.14l.118-.12 9.369 1.405c5.153.773 9.38 1.417 9.395 1.431.03.03-2.113 15.353-2.153 15.393-.027.027-1.877.052-7.701.106l-2.729.026z" style={{fill: "#60aa9e"}} />
        <path d="M158.433 61.288c-.001-.041.027-.38.062-.752l.064-.676.393-.467c.217-.256.4-.445.41-.418.008.027-.017.3-.057.605-.07.526-.091.585-.386 1.059-.385.616-.484.748-.486.649" style={{fill: "#cbb742"}} />
        <path d="m89.25 49.22-.657-.973-.135-.69c-.304-1.554-.39-2.38-.36-3.467l.028-1.011 2.06-1.704c1.133-.937 2.083-1.695 2.112-1.686.03.01.55 1.065 1.159 2.344l1.106 2.325-.49.623c-2.54 3.232-4.095 5.19-4.127 5.2-.02.007-.334-.426-.695-.96" style={{fill: "#549db2"}} />
        <path d="m105.11 45.358-9.522-1.431-.16-.332c-.089-.182-.662-1.383-1.275-2.67l-1.114-2.339-.635-2.164-.635-2.164-.166-1.706a40 40 0 0 0-.442-3.25c-.217-1.22-.288-1.778-.339-2.646l-.064-1.1.361-.808c.199-.444.5-1.084.67-1.423.295-.588.344-.65 1.08-1.374.686-.676.943-.879 2.36-1.863l1.59-1.104 5.76-.575c10.35-1.033 14.832-1.448 14.9-1.38.035.034 2.142 3.257 4.683 7.162l4.62 7.1.099 4.14c.056 2.317.078 4.159.051 4.182-.026.024-.319.147-.65.273-.518.199-1.352.691-6.047 3.572-2.995 1.838-5.48 3.34-5.524 3.337s-4.363-.65-9.6-1.437" style={{fill: "#e56a2f"}} />
        <path d="m133.205 42.23-5.075-2.57c-.02-.008-.081-1.89-.137-4.18l-.1-4.166 6.303-6.304 6.304-6.304 4.803-.852c2.641-.468 4.853-.85 4.914-.85.061.002 1.347.33 2.856.73l2.745.728 1.46.712 1.46.712.453.774c.25.426.597 1.036.773 1.355l.32.58.598 2.538c.375 1.593.697 3.122.864 4.105l.266 1.566-1.073 3.086-1.073 3.086-10.72 3.896c-5.896 2.143-10.761 3.9-10.81 3.904s-2.36-1.141-5.131-2.546" style={{fill: "#cbb742"}} />
        <path d="M163.413 41.471c-1.518-2.49-2.476-4.097-2.475-4.153.002-.133 1.764-5.13 1.814-5.145.028-.009.351.439.719.994l.668 1.01.12.84c.067.462.151 1.18.188 1.593.064.715.06.802-.082 1.782-.131.912-.615 3.442-.667 3.494-.011.011-.14-.175-.285-.415" style={{fill: "#b9bc4a"}} />
        <path d="M87.968 41.638a5 5 0 0 1-.066-.49c-.02-.214-.057-.427-.08-.473-.051-.103.035-3.06.094-3.219.036-.096 2.742-2.087 2.941-2.164.04-.015.091.07.13.215.034.132.247.87.473 1.643l.41 1.403-1.872 1.544c-1.03.849-1.901 1.566-1.937 1.593q-.064.047-.093-.052" style={{fill: "#e04929"}} />
        <path d="M88.075 35.705c.013-.1.087-.593.163-1.097s.139-.945.139-.982c0-.036.356-.338.79-.67 1.141-.874 1.217-.929 1.246-.9.031.031.189 1.546.19 1.833.001.202-.009.21-1.254 1.1-.69.493-1.265.897-1.277.897s-.011-.082.003-.181" style={{fill: "#e68634"}} />
        <path d="M88.767 31.782c0-.021.113-.476.253-1.01l.253-.971.34-.383c.187-.21.35-.374.36-.363.012.011.086.389.165.839.13.736.136.826.059.885-.86.661-1.37 1.042-1.397 1.042-.018 0-.033-.018-.033-.04" style={{fill: "#e29d39"}} />
        <path d="M163.286 30.916c-.139-.201-.323-.805-.264-.865.008-.009.08.069.159.172.133.175.355.854.298.911-.014.015-.101-.084-.193-.218" style={{fill: "#deb857"}} />
        <path d="M122.903 23.318c-2.466-3.787-4.489-6.925-4.495-6.974-.007-.048 1.473-3.22 3.287-7.049l3.3-6.96.722-.191c.675-.179.772-.19 1.501-.18 1.161.017 2.477.115 2.73.203.122.042.548.145.946.228.516.107.758.184.845.267.067.065.582.712 1.146 1.437l1.024 1.32 1.637 1.47 1.638 1.47 1.209 4.84 1.209 4.839-6.08 6.084c-3.345 3.346-6.093 6.083-6.109 6.082-.015-.001-2.045-3.1-4.51-6.886" style={{fill: "#e29d39"}} />
        <path d="M94.28 19.344c0-.332.555-1.212 1.635-2.594.373-.478.76-.825.76-.682 0 .123-.52 1.971-.574 2.04-.03.04-.296.237-.59.44s-.692.481-.883.617-.348.216-.348.179" style={{fill: "#e68634"}} />
        <path d="M156.947 17.786c-.502-.237-.462-.174-.607-.964-.037-.2-.033-.21.067-.148.125.078 1.094 1.355 1.011 1.331-.01-.002-.222-.101-.471-.22" style={{fill: "#d9ad3d"}} />
        <path d="M97.397 17.746c0-.023.18-.719.401-1.546l.403-1.503.576-.891c.317-.49.657-.975.754-1.077.234-.244 1.485-1.376 1.883-1.703l.312-.256 1.22.136c.67.076 2.458.228 3.973.339 1.516.11 2.762.207 2.769.214.01.01-3.744 5.348-3.857 5.484-.018.022-8.058.84-8.28.843-.084 0-.153-.017-.154-.04" style={{fill: "#e04929"}} />
        <path d="M139.5 13.067a423 423 0 0 1-1.135-4.6c-.007-.072.524-.332 2.302-1.125l2.31-1.03 1 .254c.947.242 1.032.275 1.67.651.37.218.985.602 1.368.854l.696.457.483.913.482.912.459 2.773c.267 1.613.438 2.792.408 2.817-.027.024-2.004.39-4.393.814-2.39.423-4.384.78-4.433.793-.076.02-.27-.694-1.216-4.483" style={{fill: "#b9bc4a"}} />
        <path d="M153.002 16.571c-1.226-.323-2.24-.606-2.256-.628-.046-.063-.855-5.004-.825-5.034.016-.015.307.038.65.118l.62.145.488.424c.876.762 1.924 1.863 2.535 2.666l.6.787.223 1.017c.122.559.216 1.034.207 1.055-.008.022-1.017-.226-2.242-.55" style={{fill: "#a6be55"}} />
        <path d="M107.329 16.762c.025-.067 3.169-4.512 5.89-8.33 1.305-1.83 1.723-2.368 2.856-3.675a313 313 0 0 1 1.397-1.606c.038-.04.417-.16.843-.267.425-.106.91-.24 1.08-.297.33-.112 1.432-.287 2.591-.413.656-.07.77-.07 1.25.018.292.053.525.121.52.151-.032.161-6.373 13.474-6.433 13.505-.04.02-2.253.24-4.917.488-2.665.248-4.903.46-4.974.47-.08.013-.119-.004-.103-.044" style={{fill: "#e68634"}} />
        <path d="M107.509 10.178c-1.377-.104-2.514-.2-2.528-.214s.056-.436.156-.938l.18-.912.816-.5c.968-.593 1.922-1.131 2.006-1.131.032 0 .471-.147.975-.327l.915-.327 1.612.257c.886.142 1.619.28 1.628.306.01.026-.616.934-1.389 2.018l-1.406 1.971-.231-.007c-.128-.004-1.358-.092-2.734-.196" style={{fill: "#e29d39"}} />
        <path d="M103.283 9.839c-.147-.012-.26-.044-.25-.07.033-.094.908-.718.928-.662.01.03-.01.217-.048.414-.076.4-.01.366-.63.318M136.533 6.302c-.662-.59-1.205-1.097-1.207-1.128s.565-.365 1.262-.743l1.267-.688.677.226c.372.124 1.045.367 1.494.54.678.26.9.377 1.31.684.272.204.496.384.497.4.004.035-3.957 1.783-4.038 1.782-.033 0-.6-.483-1.262-1.073" style={{fill: "#e68634"}} />
        <path d="M112.826 5.158c-.946-.156-1.174-.21-1.093-.257.057-.034.17-.115.25-.18.15-.123 1.745-.723 2.65-.997.276-.084.624-.16.775-.172l.273-.019-.11.125c-.061.068-.42.481-.798.918-.378.436-.702.79-.72.786z" style={{fill: "#cbb742"}} />
        <path d="M133.89 3.605c-.3-.389-.567-.742-.593-.784-.093-.153.96-.045 1.987.204.515.125.962.243.992.261.048.03-1.694 1.018-1.8 1.023-.021.001-.285-.316-.585-.704" style={{fill: "#d9ad3d"}} />
        </g>
      </g>
    </svg>
  )
}
