"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _immutable = _interopRequireDefault(require("immutable"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var React = _interopRequireWildcard(require("react"));
var _CellMeasurer = _interopRequireDefault(require("./CellMeasurer"));
var _CellMeasurerCache = _interopRequireDefault(require("./CellMeasurerCache"));
var _List = _interopRequireDefault(require("../List"));
var _CellMeasurerExample = _interopRequireDefault(require("./CellMeasurer.example.css"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2["default"])(o), (0, _possibleConstructorReturn2["default"])(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2["default"])(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var DynamicHeightList = exports["default"] = /*#__PURE__*/function (_React$PureComponent) {
  function DynamicHeightList(props, context) {
    var _this;
    (0, _classCallCheck2["default"])(this, DynamicHeightList);
    _this = _callSuper(this, DynamicHeightList, [props, context]);
    _this._cache = new _CellMeasurerCache["default"]({
      fixedWidth: true,
      minHeight: 50
    });
    _this._rowRenderer = _this._rowRenderer.bind(_this);
    return _this;
  }
  (0, _inherits2["default"])(DynamicHeightList, _React$PureComponent);
  return (0, _createClass2["default"])(DynamicHeightList, [{
    key: "render",
    value: function render() {
      var width = this.props.width;
      return /*#__PURE__*/React.createElement(_List["default"], {
        className: _CellMeasurerExample["default"].BodyGrid,
        deferredMeasurementCache: this._cache,
        height: 400,
        overscanRowCount: 0,
        rowCount: 1000,
        rowHeight: this._cache.rowHeight,
        rowRenderer: this._rowRenderer,
        width: width
      });
    }
  }, {
    key: "_rowRenderer",
    value: function _rowRenderer(_ref) {
      var index = _ref.index,
        key = _ref.key,
        parent = _ref.parent,
        style = _ref.style;
      var _this$props = this.props,
        getClassName = _this$props.getClassName,
        list = _this$props.list;
      var datum = list.get(index % list.size);
      var classNames = getClassName({
        columnIndex: 0,
        rowIndex: index
      });
      var imageWidth = 300;
      var imageHeight = datum.size * (1 + index % 3);
      var source = "https://www.fillmurray.com/".concat(imageWidth, "/").concat(imageHeight);
      return /*#__PURE__*/React.createElement(_CellMeasurer["default"], {
        cache: this._cache,
        columnIndex: 0,
        key: key,
        rowIndex: index,
        parent: parent
      }, function (_ref2) {
        var measure = _ref2.measure,
          registerChild = _ref2.registerChild;
        return /*#__PURE__*/React.createElement("div", {
          ref: registerChild,
          className: classNames,
          style: style
        }, /*#__PURE__*/React.createElement("img", {
          onLoad: measure,
          src: source,
          style: {
            width: imageWidth
          }
        }));
      });
    }
  }]);
}(React.PureComponent);
DynamicHeightList.propTypes = process.env.NODE_ENV !== "production" ? {
  getClassName: _propTypes["default"].func.isRequired,
  list: _propTypes["default"].instanceOf(_immutable["default"].List).isRequired,
  width: _propTypes["default"].number.isRequired
} : {};