"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxElementSize = void 0;
var DEFAULT_MAX_ELEMENT_SIZE = 1500000;
var CHROME_MAX_ELEMENT_SIZE = 1.67771e7;
var isBrowser = function isBrowser() {
  return typeof window !== 'undefined';
};
var isChrome = function isChrome() {
  return !!window.chrome;
};
var getMaxElementSize = exports.getMaxElementSize = function getMaxElementSize() /*: number*/{
  if (isBrowser()) {
    if (isChrome()) {
      return CHROME_MAX_ELEMENT_SIZE;
    }
  }
  return DEFAULT_MAX_ELEMENT_SIZE;
};