# coding: utf-8
import typing

from pyhmmer.easel import Alphabet
from pyhmmer.plan7 import HMM

statuscode: typing.Dict[int, str]

class UnexpectedError(RuntimeError):
    code: int
    function: str
    def __init__(self, code: int, function: str) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...

class AllocationError(MemoryError):
    ctype: str
    itemsize: int
    count: int
    def __init__(self, ctype: str, itemsize: int, count: int = 1) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...

class EaselError(RuntimeError):
    code: int
    message: str
    def __init__(self, code: int, message: str) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...

class AlphabetMismatch(ValueError):
    expected: Alphabet
    actual: typing.Optional[Alphabet]
    def __init__(self, expected: Alphabet, actual: typing.Optional[Alphabet]) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def __eq__(self, other: object) -> bool: ...

class ServerError(RuntimeError):
    code: int
    message: str
    def __init__(self, code: int, message: str) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


class MissingCutoffs(ValueError):
    def __init__(
        self,
        model_name: typing.Optional[str] = None,
        bit_cutoffs: typing.Optional[str] = None,
    ) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


class InvalidParameter(ValueError):
    name: str
    value: object
    choices: typing.Optional[typing.List[str]]
    hint: typing.Optional[str]
    def __init__(
        self,
        name: str,
        value: object,
        *,
        choices: typing.Optional[typing.List[str]],
        hint: typing.Optional[str]
    ) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


class InvalidHMM(ValueError):
    hmm: HMM
    message: str
    def __init__(self, hmm: HMM, message: str) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


