from __future__ import annotations
from typing import overload, Any, List, Dict, Tuple, Set, Sequence, Union
from pyopenms import *  # pylint: disable=wildcard-import; lgtm(py/polluting-import)
import numpy as _np

from enum import Enum as _PyEnum


def __static_AASequence_fromString(s: Union[bytes, str, String] ) -> AASequence:
    """
    Cython signature: AASequence fromString(String s)
        deprecated. Use AASequence(String) instead.
    """
    ...

def __static_AASequence_fromStringPermissive(s: Union[bytes, str, String] , permissive: bool ) -> AASequence:
    """
    Cython signature: AASequence fromStringPermissive(String s, bool permissive)
        deprecated. Use AASequence(String, bool) instead.
    """
    ...

def __static_OpenMSOSInfo_getBinaryArchitecture() -> Union[bytes, str, String]:
    """
    Cython signature: String getBinaryArchitecture()
    """
    ...

def __static_OpenMSBuildInfo_getBuildType() -> Union[bytes, str, String]:
    """
    Cython signature: String getBuildType()
    """
    ...

def __static_OpenMSOSInfo_getOSInfo() -> OpenMSOSInfo:
    """
    Cython signature: OpenMSOSInfo getOSInfo()
    """
    ...

def __static_OpenMSBuildInfo_getOpenMPMaxNumThreads() -> int:
    """
    Cython signature: size_t getOpenMPMaxNumThreads()
    """
    ...

def __static_OpenMSBuildInfo_isOpenMPEnabled() -> bool:
    """
    Cython signature: bool isOpenMPEnabled()
    """
    ...

def __static_ChromatogramExtractor_prepare_coordinates(output_chromatograms: List[OSChromatogram] , extraction_coordinates: List[ExtractionCoordinates] , targeted: TargetedExperiment , rt_extraction_window: float , ms1: bool , ms1_isotopes: int ) -> None:
    """
    Cython signature: void prepare_coordinates(libcpp_vector[shared_ptr[OSChromatogram]] & output_chromatograms, libcpp_vector[ExtractionCoordinates] & extraction_coordinates, TargetedExperiment & targeted, double rt_extraction_window, bool ms1, int ms1_isotopes)
    """
    ...

def __static_OpenMSBuildInfo_setOpenMPNumThreads(num_threads: int ) -> None:
    """
    Cython signature: void setOpenMPNumThreads(int num_threads)
    """
    ...


class AASequence:
    """
    Cython implementation of _AASequence

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1AASequence.html>`_

    Representation of a peptide/protein sequence
    This class represents amino acid sequences in OpenMS. An AASequence
    instance primarily contains a sequence of residues.
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void AASequence()
        """
        ...
    
    @overload
    def __init__(self, in_0: AASequence ) -> None:
        """
        Cython signature: void AASequence(AASequence &)
        """
        ...
    
    @overload
    def __init__(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void AASequence(const String &)
        Constructor from amino acid sequence (e.g. "PEPTM(Oxidatio)IDE")
        """
        ...
    
    @overload
    def __init__(self, in_0: Union[bytes, str, String] , permissive: bool ) -> None:
        """
        Cython signature: void AASequence(const String &, bool permissive)
        Constructor from amino acid sequence (e.g. "PEPTM(Oxidatio)IDE"), permissive allows for '+', '*', and '#' in the sequence
        """
        ...
    
    def __add__(self: AASequence, other: AASequence) -> AASequence:
        ...
    
    def __iadd__(self: AASequence, other: AASequence) -> AASequence:
        ...
    
    def __getitem__(self, in_0: int ) -> Residue:
        """
        Cython signature: Residue operator[](size_t)
        """
        ...
    
    def empty(self) -> bool:
        """
        Cython signature: bool empty()
        Check if sequence is empty
        """
        ...
    
    def toString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String toString()
        Returns the peptide as string with modifications embedded in brackets
        """
        ...
    
    def toUnmodifiedString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String toUnmodifiedString()
        Returns the peptide as string without any modifications
        """
        ...
    
    def toUniModString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String toUniModString()
        Returns the peptide as string with UniMod-style modifications embedded in brackets
        """
        ...
    
    @overload
    def toBracketString(self, ) -> Union[bytes, str, String]:
        """
        Cython signature: String toBracketString()
        Create a TPP compatible string of the modified sequence using bracket notation. Uses integer mass by default
        """
        ...
    
    @overload
    def toBracketString(self, integer_mass: bool ) -> Union[bytes, str, String]:
        """
        Cython signature: String toBracketString(bool integer_mass)
        Create a TPP compatible string of the modified sequence using bracket notation
        """
        ...
    
    @overload
    def toBracketString(self, integer_mass: bool , mass_delta: bool ) -> Union[bytes, str, String]:
        """
        Cython signature: String toBracketString(bool integer_mass, bool mass_delta)
        Create a TPP compatible string of the modified sequence using bracket notation.
        """
        ...
    
    @overload
    def toBracketString(self, integer_mass: bool , mass_delta: bool , fixed_modifications: List[bytes] ) -> Union[bytes, str, String]:
        """
        Cython signature: String toBracketString(bool integer_mass, bool mass_delta, libcpp_vector[String] fixed_modifications)
        Create a TPP compatible string of the modified sequence using bracket notation
        """
        ...
    
    @overload
    def setModification(self, index: int , modification: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setModification(size_t index, const String & modification)
        Sets the modification of the residue at position index. If an empty string is passed replaces the residue with its unmodified version
        """
        ...
    
    @overload
    def setModification(self, index: int , modification: ResidueModification ) -> None:
        """
        Cython signature: void setModification(size_t index, const ResidueModification & modification)
        Sets the modification of AA at index by providing a ResidueModification object. Stricter than just looking for the name and adds the Modification to the DB if not present
        """
        ...
    
    def setModificationByDiffMonoMass(self, index: int , diffMonoMass: float ) -> None:
        """
        Cython signature: void setModificationByDiffMonoMass(size_t index, double diffMonoMass)
        Modifies the residue at index in the sequence and potentially in the ResidueDB
        """
        ...
    
    @overload
    def setNTerminalModification(self, modification: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setNTerminalModification(String modification)
        Sets the N-terminal modification (by lookup in the mod names of the ModificationsDB). Throws if nothing is found (since the name is not enough information to create a new mod)
        """
        ...
    
    @overload
    def setNTerminalModification(self, mod: ResidueModification ) -> None:
        """
        Cython signature: void setNTerminalModification(const ResidueModification & mod)
        Sets the N-terminal modification (copies and adds to database if not present)
        """
        ...
    
    def setNTerminalModificationByDiffMonoMass(self, diffMonoMass: float , protein_term: bool ) -> None:
        """
        Cython signature: void setNTerminalModificationByDiffMonoMass(double diffMonoMass, bool protein_term)
        Sets the N-terminal modification by the monoisotopic mass difference it introduces (creates a "user-defined" mod if not present)
        """
        ...
    
    @overload
    def setCTerminalModification(self, modification: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCTerminalModification(String modification)
        Sets the C-terminal modification (by lookup in the mod names of the ModificationsDB). Throws if nothing is found (since the name is not enough information to create a new mod)
        """
        ...
    
    @overload
    def setCTerminalModification(self, mod: ResidueModification ) -> None:
        """
        Cython signature: void setCTerminalModification(const ResidueModification & mod)
        Sets the C-terminal modification (copies and adds to database if not present)
        """
        ...
    
    def setCTerminalModificationByDiffMonoMass(self, diffMonoMass: float , protein_term: bool ) -> None:
        """
        Cython signature: void setCTerminalModificationByDiffMonoMass(double diffMonoMass, bool protein_term)
        Sets the C-terminal modification by the monoisotopic mass difference it introduces (creates a "user-defined" mod if not present)
        """
        ...
    
    def getNTerminalModificationName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getNTerminalModificationName()
        Returns the name (ID) of the N-terminal modification, or an empty string if none is set
        """
        ...
    
    def getNTerminalModification(self) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getNTerminalModification()
        Returns a copy of the name N-terminal modification object, or None
        """
        ...
    
    def getCTerminalModificationName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getCTerminalModificationName()
        Returns the name (ID) of the C-terminal modification, or an empty string if none is set
        """
        ...
    
    def getCTerminalModification(self) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getCTerminalModification()
        Returns a copy of the name C-terminal modification object, or None
        """
        ...
    
    def getResidue(self, index: int ) -> Residue:
        """
        Cython signature: Residue getResidue(size_t index)
        Returns the residue at position index
        """
        ...
    
    @overload
    def getFormula(self, ) -> EmpiricalFormula:
        """
        Cython signature: EmpiricalFormula getFormula()
        Convenience function with ResidueType=Full and charge = 0 by default
        """
        ...
    
    @overload
    def getFormula(self, type_: int , charge: int ) -> EmpiricalFormula:
        """
        Cython signature: EmpiricalFormula getFormula(ResidueType type_, int charge)
        """
        ...
    
    @overload
    def getAverageWeight(self, ) -> float:
        """
        Cython signature: double getAverageWeight()
        Returns the average weight of the peptide
        """
        ...
    
    @overload
    def getAverageWeight(self, type_: int , charge: int ) -> float:
        """
        Cython signature: double getAverageWeight(ResidueType type_, int charge)
        """
        ...
    
    @overload
    def getMonoWeight(self, ) -> float:
        """
        Cython signature: double getMonoWeight()
        Returns the mono isotopic weight of the peptide
        """
        ...
    
    @overload
    def getMonoWeight(self, type_: int , charge: int ) -> float:
        """
        Cython signature: double getMonoWeight(ResidueType type_, int charge)
        """
        ...
    
    @overload
    def getMZ(self, charge: int ) -> float:
        """
        Cython signature: double getMZ(int charge)
        Returns the mass-to-charge ratio of the peptide
        """
        ...
    
    @overload
    def getMZ(self, charge: int , type_: int ) -> float:
        """
        Cython signature: double getMZ(int charge, ResidueType type_)
        """
        ...
    
    def size(self) -> int:
        """
        Cython signature: size_t size()
        Returns the number of residues
        """
        ...
    
    def getPrefix(self, index: int ) -> AASequence:
        """
        Cython signature: AASequence getPrefix(size_t index)
        Returns a peptide sequence of the first index residues
        """
        ...
    
    def getSuffix(self, index: int ) -> AASequence:
        """
        Cython signature: AASequence getSuffix(size_t index)
        Returns a peptide sequence of the last index residues
        """
        ...
    
    def getSubsequence(self, index: int , number: int ) -> AASequence:
        """
        Cython signature: AASequence getSubsequence(size_t index, unsigned int number)
        Returns a peptide sequence of number residues, beginning at position index
        """
        ...
    
    def has(self, residue: Residue ) -> bool:
        """
        Cython signature: bool has(Residue residue)
        Returns true if the peptide contains the given residue
        """
        ...
    
    def hasSubsequence(self, peptide: AASequence ) -> bool:
        """
        Cython signature: bool hasSubsequence(AASequence peptide)
        Returns true if the peptide contains the given peptide
        """
        ...
    
    def hasPrefix(self, peptide: AASequence ) -> bool:
        """
        Cython signature: bool hasPrefix(AASequence peptide)
        Returns true if the peptide has the given prefix
        """
        ...
    
    def hasSuffix(self, peptide: AASequence ) -> bool:
        """
        Cython signature: bool hasSuffix(AASequence peptide)
        Returns true if the peptide has the given suffix
        """
        ...
    
    def hasNTerminalModification(self) -> bool:
        """
        Cython signature: bool hasNTerminalModification()
        Predicate which is true if the peptide is N-term modified
        """
        ...
    
    def hasCTerminalModification(self) -> bool:
        """
        Cython signature: bool hasCTerminalModification()
        Predicate which is true if the peptide is C-term modified
        """
        ...
    
    def isModified(self) -> bool:
        """
        Cython signature: bool isModified()
        Returns true if any of the residues or termini are modified
        """
        ...
    
    def __str__(self) -> Union[bytes, str, String]:
        """
        Cython signature: String toString()
        Returns the peptide as string with modifications embedded in brackets
        """
        ...
    
    def __richcmp__(self, other: AASequence, op: int) -> Any:
        ...
    
    fromString: __static_AASequence_fromString
    
    fromStringPermissive: __static_AASequence_fromStringPermissive 


class AbsoluteQuantitation:
    """
    Cython implementation of _AbsoluteQuantitation

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1AbsoluteQuantitation.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void AbsoluteQuantitation()
        """
        ...
    
    @overload
    def __init__(self, in_0: AbsoluteQuantitation ) -> None:
        """
        Cython signature: void AbsoluteQuantitation(AbsoluteQuantitation &)
        """
        ...
    
    def setQuantMethods(self, quant_methods: List[AbsoluteQuantitationMethod] ) -> None:
        """
        Cython signature: void setQuantMethods(libcpp_vector[AbsoluteQuantitationMethod] & quant_methods)
        """
        ...
    
    def getQuantMethods(self) -> List[AbsoluteQuantitationMethod]:
        """
        Cython signature: libcpp_vector[AbsoluteQuantitationMethod] getQuantMethods()
        """
        ...
    
    def calculateRatio(self, component_1: Feature , component_2: Feature , feature_name: Union[bytes, str, String] ) -> float:
        """
        Cython signature: double calculateRatio(Feature & component_1, Feature & component_2, const String & feature_name)
        """
        ...
    
    def applyCalibration(self, component: Feature , IS_component: Feature , feature_name: Union[bytes, str, String] , transformation_model: Union[bytes, str, String] , transformation_model_params: Param ) -> float:
        """
        Cython signature: double applyCalibration(const Feature & component, const Feature & IS_component, const String & feature_name, const String & transformation_model, const Param & transformation_model_params)
        """
        ...
    
    def quantifyComponents(self, unknowns: FeatureMap ) -> None:
        """
        Cython signature: void quantifyComponents(FeatureMap & unknowns)
        This function applies the calibration curve, hence quantifying all the components
        """
        ...
    
    def optimizeCalibrationCurveIterative(self, component_concentrations: List[AQS_featureConcentration] , feature_name: Union[bytes, str, String] , transformation_model: Union[bytes, str, String] , transformation_model_params: Param , optimized_params: Param ) -> bool:
        """
        Cython signature: bool optimizeCalibrationCurveIterative(libcpp_vector[AQS_featureConcentration] & component_concentrations, const String & feature_name, const String & transformation_model, const Param & transformation_model_params, Param & optimized_params)
        """
        ...
    
    def optimizeSingleCalibrationCurve(self, component_name: Union[bytes, str, String] , component_concentrations: List[AQS_featureConcentration] ) -> None:
        """
        Cython signature: void optimizeSingleCalibrationCurve(const String & component_name, libcpp_vector[AQS_featureConcentration] & component_concentrations)
        """
        ...
    
    def calculateBias(self, actual_concentration: float , calculated_concentration: float ) -> float:
        """
        Cython signature: double calculateBias(double actual_concentration, double calculated_concentration)
        This function calculates the bias of the calibration
        """
        ...
    
    def fitCalibration(self, component_concentrations: List[AQS_featureConcentration] , feature_name: Union[bytes, str, String] , transformation_model: Union[bytes, str, String] , transformation_model_params: Param ) -> Param:
        """
        Cython signature: Param fitCalibration(libcpp_vector[AQS_featureConcentration] & component_concentrations, const String & feature_name, const String & transformation_model, Param transformation_model_params)
        """
        ...
    
    def calculateBiasAndR(self, component_concentrations: List[AQS_featureConcentration] , feature_name: Union[bytes, str, String] , transformation_model: Union[bytes, str, String] , transformation_model_params: Param , biases: List[float] , correlation_coefficient: float ) -> None:
        """
        Cython signature: void calculateBiasAndR(libcpp_vector[AQS_featureConcentration] & component_concentrations, const String & feature_name, const String & transformation_model, Param & transformation_model_params, libcpp_vector[double] & biases, double & correlation_coefficient)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class Attachment:
    """
    Cython implementation of _Attachment

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::QcMLFile_1_1Attachment.html>`_
    """
    
    name: Union[bytes, str, String]
    
    id: Union[bytes, str, String]
    
    value: Union[bytes, str, String]
    
    cvRef: Union[bytes, str, String]
    
    cvAcc: Union[bytes, str, String]
    
    unitRef: Union[bytes, str, String]
    
    unitAcc: Union[bytes, str, String]
    
    binary: Union[bytes, str, String]
    
    qualityRef: Union[bytes, str, String]
    
    colTypes: List[bytes]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Attachment()
        """
        ...
    
    @overload
    def __init__(self, in_0: Attachment ) -> None:
        """
        Cython signature: void Attachment(Attachment &)
        """
        ...
    
    def toXMLString(self, indentation_level: int ) -> Union[bytes, str, String]:
        """
        Cython signature: String toXMLString(unsigned int indentation_level)
        """
        ...
    
    def toCSVString(self, separator: Union[bytes, str, String] ) -> Union[bytes, str, String]:
        """
        Cython signature: String toCSVString(String separator)
        """
        ...
    
    def __richcmp__(self, other: Attachment, op: int) -> Any:
        ... 


class BiGaussFitter1D:
    """
    Cython implementation of _BiGaussFitter1D

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1BiGaussFitter1D.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void BiGaussFitter1D()
        """
        ...
    
    @overload
    def __init__(self, in_0: BiGaussFitter1D ) -> None:
        """
        Cython signature: void BiGaussFitter1D(BiGaussFitter1D &)
        """
        ... 


class CVMappingTerm:
    """
    Cython implementation of _CVMappingTerm

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1CVMappingTerm.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void CVMappingTerm()
        """
        ...
    
    @overload
    def __init__(self, in_0: CVMappingTerm ) -> None:
        """
        Cython signature: void CVMappingTerm(CVMappingTerm &)
        """
        ...
    
    def setAccession(self, accession: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setAccession(String accession)
        Sets the accession string of the term
        """
        ...
    
    def getAccession(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getAccession()
        Returns the accession string of the term
        """
        ...
    
    def setUseTermName(self, use_term_name: bool ) -> None:
        """
        Cython signature: void setUseTermName(bool use_term_name)
        Sets whether the term name should be used, instead of the accession
        """
        ...
    
    def getUseTermName(self) -> bool:
        """
        Cython signature: bool getUseTermName()
        Returns whether the term name should be used, instead of the accession
        """
        ...
    
    def setUseTerm(self, use_term: bool ) -> None:
        """
        Cython signature: void setUseTerm(bool use_term)
        Sets whether the term itself can be used (or only its children)
        """
        ...
    
    def getUseTerm(self) -> bool:
        """
        Cython signature: bool getUseTerm()
        Returns true if the term can be used, false if only children are allowed
        """
        ...
    
    def setTermName(self, term_name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setTermName(String term_name)
        Sets the name of the term
        """
        ...
    
    def getTermName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getTermName()
        Returns the name of the term
        """
        ...
    
    def setIsRepeatable(self, is_repeatable: bool ) -> None:
        """
        Cython signature: void setIsRepeatable(bool is_repeatable)
        Sets whether this term can be repeated
        """
        ...
    
    def getIsRepeatable(self) -> bool:
        """
        Cython signature: bool getIsRepeatable()
        Returns true if this term can be repeated, false otherwise
        """
        ...
    
    def setAllowChildren(self, allow_children: bool ) -> None:
        """
        Cython signature: void setAllowChildren(bool allow_children)
        Sets whether children of this term are allowed
        """
        ...
    
    def getAllowChildren(self) -> bool:
        """
        Cython signature: bool getAllowChildren()
        Returns true if the children of this term are allowed to be used
        """
        ...
    
    def setCVIdentifierRef(self, cv_identifier_ref: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCVIdentifierRef(String cv_identifier_ref)
        Sets the CV identifier reference string, e.g. UO for unit obo
        """
        ...
    
    def getCVIdentifierRef(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getCVIdentifierRef()
        Returns the CV identifier reference string
        """
        ...
    
    def __richcmp__(self, other: CVMappingTerm, op: int) -> Any:
        ... 


class CVTerm:
    """
    Cython implementation of _CVTerm

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1CVTerm.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void CVTerm()
        """
        ...
    
    @overload
    def __init__(self, in_0: CVTerm ) -> None:
        """
        Cython signature: void CVTerm(CVTerm &)
        """
        ...
    
    def setAccession(self, accession: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setAccession(String accession)
        Sets the accession string of the term
        """
        ...
    
    def getAccession(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getAccession()
        Returns the accession string of the term
        """
        ...
    
    def setName(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(String name)
        Sets the name of the term
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name of the term
        """
        ...
    
    def setCVIdentifierRef(self, cv_id_ref: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCVIdentifierRef(String cv_id_ref)
        Sets the CV identifier reference string, e.g. UO for unit obo
        """
        ...
    
    def getCVIdentifierRef(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getCVIdentifierRef()
        Returns the CV identifier reference string
        """
        ...
    
    def getValue(self) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getValue()
        Returns the value of the term
        """
        ...
    
    def setValue(self, value: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setValue(DataValue value)
        Sets the value of the term
        """
        ...
    
    def setUnit(self, unit: Unit ) -> None:
        """
        Cython signature: void setUnit(Unit & unit)
        Sets the unit of the term
        """
        ...
    
    def getUnit(self) -> Unit:
        """
        Cython signature: Unit getUnit()
        Returns the unit
        """
        ...
    
    def hasValue(self) -> bool:
        """
        Cython signature: bool hasValue()
        Checks whether the term has a value
        """
        ...
    
    def hasUnit(self) -> bool:
        """
        Cython signature: bool hasUnit()
        Checks whether the term has a unit
        """
        ...
    
    def __richcmp__(self, other: CVTerm, op: int) -> Any:
        ... 


class CachedSwathFileConsumer:
    """
    Cython implementation of _CachedSwathFileConsumer

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1CachedSwathFileConsumer.html>`_
      -- Inherits from ['FullSwathFileConsumer']
    """
    
    @overload
    def __init__(self, in_0: CachedSwathFileConsumer ) -> None:
        """
        Cython signature: void CachedSwathFileConsumer(CachedSwathFileConsumer &)
        """
        ...
    
    @overload
    def __init__(self, cachedir: Union[bytes, str, String] , basename: Union[bytes, str, String] , nr_ms1_spectra: int , nr_ms2_spectra: List[int] ) -> None:
        """
        Cython signature: void CachedSwathFileConsumer(String cachedir, String basename, size_t nr_ms1_spectra, libcpp_vector[int] nr_ms2_spectra)
        """
        ...
    
    def setExpectedSize(self, s: int , c: int ) -> None:
        """
        Cython signature: void setExpectedSize(size_t s, size_t c)
        """
        ...
    
    def setExperimentalSettings(self, exp: ExperimentalSettings ) -> None:
        """
        Cython signature: void setExperimentalSettings(ExperimentalSettings exp)
        """
        ...
    
    def retrieveSwathMaps(self, maps: List[SwathMap] ) -> None:
        """
        Cython signature: void retrieveSwathMaps(libcpp_vector[SwathMap] & maps)
        """
        ...
    
    def consumeSpectrum(self, s: MSSpectrum ) -> None:
        """
        Cython signature: void consumeSpectrum(MSSpectrum & s)
        """
        ...
    
    def consumeChromatogram(self, c: MSChromatogram ) -> None:
        """
        Cython signature: void consumeChromatogram(MSChromatogram & c)
        """
        ... 


class ChromatogramExtractor:
    """
    Cython implementation of _ChromatogramExtractor

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ChromatogramExtractor.html>`_
      -- Inherits from ['ProgressLogger']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ChromatogramExtractor()
        """
        ...
    
    @overload
    def __init__(self, in_0: ChromatogramExtractor ) -> None:
        """
        Cython signature: void ChromatogramExtractor(ChromatogramExtractor &)
        """
        ...
    
    def extractChromatograms(self, input: SpectrumAccessOpenMS , output: List[OSChromatogram] , extraction_coordinates: List[ExtractionCoordinates] , mz_extraction_window: float , ppm: bool , im_extraction_window: float , filter: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void extractChromatograms(shared_ptr[SpectrumAccessOpenMS] input, libcpp_vector[shared_ptr[OSChromatogram]] & output, libcpp_vector[ExtractionCoordinates] extraction_coordinates, double mz_extraction_window, bool ppm, double im_extraction_window, String filter)
        """
        ...
    
    def setLogType(self, in_0: int ) -> None:
        """
        Cython signature: void setLogType(LogType)
        Sets the progress log that should be used. The default type is NONE!
        """
        ...
    
    def getLogType(self) -> int:
        """
        Cython signature: LogType getLogType()
        Returns the type of progress log being used
        """
        ...
    
    def startProgress(self, begin: int , end: int , label: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void startProgress(ptrdiff_t begin, ptrdiff_t end, String label)
        """
        ...
    
    def setProgress(self, value: int ) -> None:
        """
        Cython signature: void setProgress(ptrdiff_t value)
        Sets the current progress
        """
        ...
    
    def endProgress(self) -> None:
        """
        Cython signature: void endProgress()
        Ends the progress display
        """
        ...
    
    def nextProgress(self) -> None:
        """
        Cython signature: void nextProgress()
        Increment progress by 1 (according to range begin-end)
        """
        ...
    
    prepare_coordinates: __static_ChromatogramExtractor_prepare_coordinates 


class ColumnHeader:
    """
    Cython implementation of _ColumnHeader

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::ConsensusMap_1_1ColumnHeader.html>`_
      -- Inherits from ['MetaInfoInterface']
    """
    
    filename: Union[bytes, str, String]
    
    label: Union[bytes, str, String]
    
    size: int
    
    unique_id: int
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ColumnHeader()
        """
        ...
    
    @overload
    def __init__(self, in_0: ColumnHeader ) -> None:
        """
        Cython signature: void ColumnHeader(ColumnHeader &)
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: ColumnHeader, op: int) -> Any:
        ... 


class Compomer:
    """
    Cython implementation of _Compomer

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Compomer.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Compomer()
        """
        ...
    
    @overload
    def __init__(self, in_0: Compomer ) -> None:
        """
        Cython signature: void Compomer(Compomer &)
        """
        ...
    
    def add(self, a: Adduct , side: int ) -> None:
        """
        Cython signature: void add(Adduct & a, unsigned int side)
        """
        ...
    
    def isConflicting(self, cmp: Compomer , side_this: int , side_other: int ) -> bool:
        """
        Cython signature: bool isConflicting(Compomer & cmp, unsigned int side_this, unsigned int side_other)
        """
        ...
    
    def setID(self, id: int ) -> None:
        """
        Cython signature: void setID(size_t id)
        Sets an Id which allows unique identification of a compomer
        """
        ...
    
    def getID(self) -> int:
        """
        Cython signature: size_t getID()
        Returns Id which allows unique identification of this compomer
        """
        ...
    
    def getNetCharge(self) -> int:
        """
        Cython signature: int getNetCharge()
        Net charge of compomer (i.e. difference between left and right side of compomer)
        """
        ...
    
    def getMass(self) -> float:
        """
        Cython signature: double getMass()
        Mass of all contained adducts
        """
        ...
    
    def getPositiveCharges(self) -> int:
        """
        Cython signature: int getPositiveCharges()
        Summed positive charges of contained adducts
        """
        ...
    
    def getNegativeCharges(self) -> int:
        """
        Cython signature: int getNegativeCharges()
        Summed negative charges of contained adducts
        """
        ...
    
    def getLogP(self) -> float:
        """
        Cython signature: double getLogP()
        Returns the log probability
        """
        ...
    
    def getRTShift(self) -> float:
        """
        Cython signature: double getRTShift()
        Returns the log probability
        """
        ...
    
    @overload
    def getAdductsAsString(self, ) -> Union[bytes, str, String]:
        """
        Cython signature: String getAdductsAsString()
        Get adducts with their abundance as compact string for both sides
        """
        ...
    
    @overload
    def getAdductsAsString(self, side: int ) -> Union[bytes, str, String]:
        """
        Cython signature: String getAdductsAsString(unsigned int side)
        Get adducts with their abundance as compact string (amounts are absolute unless side=BOTH)
        """
        ...
    
    def isSingleAdduct(self, a: Adduct , side: int ) -> bool:
        """
        Cython signature: bool isSingleAdduct(Adduct & a, unsigned int side)
        Check if Compomer only contains a single adduct on side @p side
        """
        ...
    
    @overload
    def removeAdduct(self, a: Adduct ) -> Compomer:
        """
        Cython signature: Compomer removeAdduct(Adduct & a)
        Remove ALL instances of the given adduct
        """
        ...
    
    @overload
    def removeAdduct(self, a: Adduct , side: int ) -> Compomer:
        """
        Cython signature: Compomer removeAdduct(Adduct & a, unsigned int side)
        """
        ...
    
    def getLabels(self, side: int ) -> List[bytes]:
        """
        Cython signature: StringList getLabels(unsigned int side)
        Returns the adduct labels from parameter(side) given. (LEFT or RIGHT)
        """
        ... 


class ConsensusMap:
    """
    Cython implementation of _ConsensusMap

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::ConsensusMap_1_1ConsensusMap.html>`_
      -- Inherits from ['UniqueIdInterface', 'DocumentIdentifier', 'RangeManagerRtMzInt', 'MetaInfoInterface']

    A container for consensus elements.
    
    A ConsensusMap is a container holding 2-dimensional consensus elements
    (ConsensusFeature) which in turn represent analytes that have been
    quantified across multiple LC-MS/MS experiments. Each analyte in a
    ConsensusFeature is linked to its original LC-MS/MS run, the links are
    maintained by the ConsensusMap class.
    The map is implemented as a vector of elements of type ConsensusFeature.
    
    To be consistent, all maps who are referenced by ConsensusFeature objects
    (through a unique id) need to be registered in this class.
    
    This class supports direct iteration in Python.
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ConsensusMap()
        """
        ...
    
    @overload
    def __init__(self, in_0: ConsensusMap ) -> None:
        """
        Cython signature: void ConsensusMap(ConsensusMap &)
        """
        ...
    
    def size(self) -> int:
        """
        Cython signature: int size()
        """
        ...
    
    def empty(self) -> bool:
        """
        Cython signature: bool empty()
        """
        ...
    
    def reserve(self, s: int ) -> None:
        """
        Cython signature: void reserve(size_t s)
        """
        ...
    
    def __getitem__(self, in_0: int ) -> ConsensusFeature:
        """
        Cython signature: ConsensusFeature & operator[](size_t)
        """
        ...
    def __setitem__(self, key: int, value: ConsensusFeature ) -> None:
        """Cython signature: ConsensusFeature & operator[](size_t)"""
        ...
    
    def push_back(self, spec: ConsensusFeature ) -> None:
        """
        Cython signature: void push_back(ConsensusFeature spec)
        """
        ...
    
    def appendRows(self, in_0: ConsensusMap ) -> ConsensusMap:
        """
        Cython signature: ConsensusMap appendRows(ConsensusMap)
        Add consensus map entries as new rows
        """
        ...
    
    def appendColumns(self, in_0: ConsensusMap ) -> ConsensusMap:
        """
        Cython signature: ConsensusMap appendColumns(ConsensusMap)
        Add consensus map entries as new columns
        """
        ...
    
    @overload
    def clear(self, clear_meta_data: bool ) -> None:
        """
        Cython signature: void clear(bool clear_meta_data)
        Clears all data and meta data
        """
        ...
    
    @overload
    def clear(self, ) -> None:
        """
        Cython signature: void clear()
        """
        ...
    
    def updateRanges(self) -> None:
        """
        Cython signature: void updateRanges()
        """
        ...
    
    def getProteinIdentifications(self) -> List[ProteinIdentification]:
        """
        Cython signature: libcpp_vector[ProteinIdentification] getProteinIdentifications()
        """
        ...
    
    def setProteinIdentifications(self, in_0: List[ProteinIdentification] ) -> None:
        """
        Cython signature: void setProteinIdentifications(libcpp_vector[ProteinIdentification])
        Sets the protein identifications
        """
        ...
    
    def getUnassignedPeptideIdentifications(self) -> List[PeptideIdentification]:
        """
        Cython signature: libcpp_vector[PeptideIdentification] getUnassignedPeptideIdentifications()
        """
        ...
    
    def setUnassignedPeptideIdentifications(self, in_0: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void setUnassignedPeptideIdentifications(libcpp_vector[PeptideIdentification])
        Sets the unassigned peptide identifications
        """
        ...
    
    def getDataProcessing(self) -> List[DataProcessing]:
        """
        Cython signature: libcpp_vector[DataProcessing] getDataProcessing()
        Returns a const reference to the description of the applied data processing
        """
        ...
    
    def setDataProcessing(self, in_0: List[DataProcessing] ) -> None:
        """
        Cython signature: void setDataProcessing(libcpp_vector[DataProcessing])
        Sets the description of the applied data processing
        """
        ...
    
    @overload
    def setPrimaryMSRunPath(self, s: List[bytes] ) -> None:
        """
        Cython signature: void setPrimaryMSRunPath(StringList & s)
        Sets the file paths to the primary MS run (stored in ColumnHeaders)
        """
        ...
    
    @overload
    def setPrimaryMSRunPath(self, s: List[bytes] , e: MSExperiment ) -> None:
        """
        Cython signature: void setPrimaryMSRunPath(StringList & s, MSExperiment & e)
        """
        ...
    
    def getPrimaryMSRunPath(self, toFill: List[bytes] ) -> None:
        """
        Cython signature: void getPrimaryMSRunPath(StringList & toFill)
        Returns the MS run path (stored in ColumnHeaders)
        """
        ...
    
    @overload
    def sortByIntensity(self, reverse: bool ) -> None:
        """
        Cython signature: void sortByIntensity(bool reverse)
        Sorts the peaks according to ascending intensity.
        """
        ...
    
    @overload
    def sortByIntensity(self, ) -> None:
        """
        Cython signature: void sortByIntensity()
        """
        ...
    
    def sortByRT(self) -> None:
        """
        Cython signature: void sortByRT()
        Sorts the peaks according to RT position
        """
        ...
    
    def sortByMZ(self) -> None:
        """
        Cython signature: void sortByMZ()
        Sorts the peaks according to m/z position
        """
        ...
    
    def sortByPosition(self) -> None:
        """
        Cython signature: void sortByPosition()
        Lexicographically sorts the peaks by their position (First RT then m/z)
        """
        ...
    
    @overload
    def sortByQuality(self, reverse: bool ) -> None:
        """
        Cython signature: void sortByQuality(bool reverse)
        Sorts the peaks according to ascending quality.
        """
        ...
    
    @overload
    def sortByQuality(self, ) -> None:
        """
        Cython signature: void sortByQuality()
        """
        ...
    
    def sortBySize(self) -> None:
        """
        Cython signature: void sortBySize()
        Sorts with respect to the size (number of elements)
        """
        ...
    
    def sortByMaps(self) -> None:
        """
        Cython signature: void sortByMaps()
        Sorts with respect to the sets of maps covered by the consensus features (lexicographically)
        """
        ...
    
    def getExperimentType(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getExperimentType()
        Non-mutable access to the experiment type
        """
        ...
    
    def setExperimentType(self, experiment_type: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setExperimentType(String experiment_type)
        Mutable access to the experiment type
        """
        ...
    
    def sortPeptideIdentificationsByMapIndex(self) -> None:
        """
        Cython signature: void sortPeptideIdentificationsByMapIndex()
        Sorts PeptideIdentifications of consensus features with respect to their map index.
        """
        ...
    
    def getUniqueId(self) -> int:
        """
        Cython signature: size_t getUniqueId()
        Returns the unique id
        """
        ...
    
    def clearUniqueId(self) -> int:
        """
        Cython signature: size_t clearUniqueId()
        Clear the unique id. The new unique id will be invalid. Returns 1 if the unique id was changed, 0 otherwise
        """
        ...
    
    def hasValidUniqueId(self) -> int:
        """
        Cython signature: size_t hasValidUniqueId()
        Returns whether the unique id is valid. Returns 1 if the unique id is valid, 0 otherwise
        """
        ...
    
    def hasInvalidUniqueId(self) -> int:
        """
        Cython signature: size_t hasInvalidUniqueId()
        Returns whether the unique id is invalid. Returns 1 if the unique id is invalid, 0 otherwise
        """
        ...
    
    def setUniqueId(self, rhs: int ) -> None:
        """
        Cython signature: void setUniqueId(uint64_t rhs)
        Assigns a new, valid unique id. Always returns 1
        """
        ...
    
    def ensureUniqueId(self) -> int:
        """
        Cython signature: size_t ensureUniqueId()
        Assigns a valid unique id, but only if the present one is invalid. Returns 1 if the unique id was changed, 0 otherwise
        """
        ...
    
    def isValid(self, unique_id: int ) -> bool:
        """
        Cython signature: bool isValid(uint64_t unique_id)
        Returns true if the unique_id is valid, false otherwise
        """
        ...
    
    def setIdentifier(self, id: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setIdentifier(String id)
        Sets document identifier (e.g. an LSID)
        """
        ...
    
    def getIdentifier(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getIdentifier()
        Retrieve document identifier (e.g. an LSID)
        """
        ...
    
    def setLoadedFileType(self, file_name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setLoadedFileType(String file_name)
        Sets the file_type according to the type of the file loaded from, preferably done whilst loading
        """
        ...
    
    def getLoadedFileType(self) -> int:
        """
        Cython signature: int getLoadedFileType()
        Returns the file_type (e.g. featureXML, consensusXML, mzData, mzXML, mzML, ...) of the file loaded
        """
        ...
    
    def setLoadedFilePath(self, file_name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setLoadedFilePath(String file_name)
        Sets the file_name according to absolute path of the file loaded, preferably done whilst loading
        """
        ...
    
    def getLoadedFilePath(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getLoadedFilePath()
        Returns the file_name which is the absolute path to the file loaded
        """
        ...
    
    def getMinRT(self) -> float:
        """
        Cython signature: double getMinRT()
        Returns the minimum RT
        """
        ...
    
    def getMaxRT(self) -> float:
        """
        Cython signature: double getMaxRT()
        Returns the maximum RT
        """
        ...
    
    def getMinMZ(self) -> float:
        """
        Cython signature: double getMinMZ()
        Returns the minimum m/z
        """
        ...
    
    def getMaxMZ(self) -> float:
        """
        Cython signature: double getMaxMZ()
        Returns the maximum m/z
        """
        ...
    
    def getMinIntensity(self) -> float:
        """
        Cython signature: double getMinIntensity()
        Returns the minimum intensity
        """
        ...
    
    def getMaxIntensity(self) -> float:
        """
        Cython signature: double getMaxIntensity()
        Returns the maximum intensity
        """
        ...
    
    def clearRanges(self) -> None:
        """
        Cython signature: void clearRanges()
        Resets all range dimensions as empty
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: ConsensusMap, op: int) -> Any:
        ...
    
    def __iter__(self) -> ConsensusFeature:
       ... 


class DataProcessing:
    """
    Cython implementation of _DataProcessing

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1DataProcessing.html>`_
      -- Inherits from ['MetaInfoInterface']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void DataProcessing()
        """
        ...
    
    @overload
    def __init__(self, in_0: DataProcessing ) -> None:
        """
        Cython signature: void DataProcessing(DataProcessing &)
        """
        ...
    
    def setProcessingActions(self, in_0: Set[int] ) -> None:
        """
        Cython signature: void setProcessingActions(libcpp_set[ProcessingAction])
        """
        ...
    
    def getProcessingActions(self) -> Set[int]:
        """
        Cython signature: libcpp_set[ProcessingAction] getProcessingActions()
        """
        ...
    
    def getSoftware(self) -> Software:
        """
        Cython signature: Software getSoftware()
        """
        ...
    
    def setSoftware(self, s: Software ) -> None:
        """
        Cython signature: void setSoftware(Software s)
        """
        ...
    
    def getCompletionTime(self) -> DateTime:
        """
        Cython signature: DateTime getCompletionTime()
        """
        ...
    
    def setCompletionTime(self, t: DateTime ) -> None:
        """
        Cython signature: void setCompletionTime(DateTime t)
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: DataProcessing, op: int) -> Any:
        ...
    ProcessingAction : __ProcessingAction 


class DistanceMatrix:
    """
    Cython implementation of _DistanceMatrix[float]

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1DistanceMatrix[float].html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void DistanceMatrix()
        """
        ...
    
    @overload
    def __init__(self, in_0: DistanceMatrix ) -> None:
        """
        Cython signature: void DistanceMatrix(DistanceMatrix &)
        """
        ...
    
    @overload
    def __init__(self, dimensionsize: int , value: float ) -> None:
        """
        Cython signature: void DistanceMatrix(size_t dimensionsize, float value)
        """
        ...
    
    def getValue(self, i: int , j: int ) -> float:
        """
        Cython signature: float getValue(size_t i, size_t j)
        """
        ...
    
    def setValue(self, i: int , j: int , value: float ) -> None:
        """
        Cython signature: void setValue(size_t i, size_t j, float value)
        """
        ...
    
    def setValueQuick(self, i: int , j: int , value: float ) -> None:
        """
        Cython signature: void setValueQuick(size_t i, size_t j, float value)
        """
        ...
    
    def clear(self) -> None:
        """
        Cython signature: void clear()
        """
        ...
    
    def resize(self, dimensionsize: int , value: float ) -> None:
        """
        Cython signature: void resize(size_t dimensionsize, float value)
        """
        ...
    
    def reduce(self, j: int ) -> None:
        """
        Cython signature: void reduce(size_t j)
        """
        ...
    
    def dimensionsize(self) -> int:
        """
        Cython signature: size_t dimensionsize()
        """
        ...
    
    def updateMinElement(self) -> None:
        """
        Cython signature: void updateMinElement()
        """
        ...
    
    def getMinElementCoordinates(self) -> List[int, int]:
        """
        Cython signature: libcpp_pair[size_t,size_t] getMinElementCoordinates()
        """
        ...
    
    def __richcmp__(self, other: DistanceMatrix, op: int) -> Any:
        ... 


class EDTAFile:
    """
    Cython implementation of _EDTAFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1EDTAFile.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void EDTAFile()
        """
        ...
    
    @overload
    def __init__(self, in_0: EDTAFile ) -> None:
        """
        Cython signature: void EDTAFile(EDTAFile &)
        """
        ...
    
    @overload
    def store(self, filename: Union[bytes, str, String] , map: FeatureMap ) -> None:
        """
        Cython signature: void store(String filename, FeatureMap & map)
        """
        ...
    
    @overload
    def store(self, filename: Union[bytes, str, String] , map: ConsensusMap ) -> None:
        """
        Cython signature: void store(String filename, ConsensusMap & map)
        """
        ...
    
    def load(self, filename: Union[bytes, str, String] , consensus_map: ConsensusMap ) -> None:
        """
        Cython signature: void load(String filename, ConsensusMap & consensus_map)
        """
        ... 


class EmgModel:
    """
    Cython implementation of _EmgModel

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1EmgModel.html>`_
      -- Inherits from ['InterpolationModel']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void EmgModel()
        Exponentially modified gaussian distribution model for elution profiles
        """
        ...
    
    @overload
    def __init__(self, in_0: EmgModel ) -> None:
        """
        Cython signature: void EmgModel(EmgModel &)
        """
        ...
    
    def getIntensity(self, coord: float ) -> float:
        """
        Cython signature: double getIntensity(double coord)
        Access model predicted intensity at position 'pos'
        """
        ...
    
    def getScalingFactor(self) -> float:
        """
        Cython signature: double getScalingFactor()
        Returns the interpolation class
        """
        ...
    
    def setOffset(self, offset: float ) -> None:
        """
        Cython signature: void setOffset(double offset)
        Sets the offset of the model
        """
        ...
    
    def getCenter(self) -> float:
        """
        Cython signature: double getCenter()
        Returns the "center" of the model, particular definition (depends on the derived model)
        """
        ...
    
    def setSamples(self) -> None:
        """
        Cython signature: void setSamples()
        Sets sample/supporting points of interpolation wrt params
        """
        ...
    
    def setInterpolationStep(self, interpolation_step: float ) -> None:
        """
        Cython signature: void setInterpolationStep(double interpolation_step)
        Sets the interpolation step for the linear interpolation of the model
        """
        ...
    
    def setScalingFactor(self, scaling: float ) -> None:
        """
        Cython signature: void setScalingFactor(double scaling)
        Sets the scaling factor of the model
        """
        ...
    
    def getInterpolation(self) -> LinearInterpolation:
        """
        Cython signature: LinearInterpolation getInterpolation()
        Returns the interpolation class
        """
        ... 


class FIAMSDataProcessor:
    """
    Cython implementation of _FIAMSDataProcessor

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1FIAMSDataProcessor.html>`_
      -- Inherits from ['DefaultParamHandler']

      ADD PYTHON DOCUMENTATION HERE
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void FIAMSDataProcessor()
        Data processing for FIA-MS data
        """
        ...
    
    @overload
    def __init__(self, in_0: FIAMSDataProcessor ) -> None:
        """
        Cython signature: void FIAMSDataProcessor(FIAMSDataProcessor &)
        """
        ...
    
    def run(self, experiment: MSExperiment , n_seconds: float , output: MzTab , load_cached_spectrum: bool ) -> bool:
        """
        Cython signature: bool run(MSExperiment & experiment, float & n_seconds, MzTab & output, bool load_cached_spectrum)
        Run the full analysis for the experiment for the given time interval\n
        
        The workflow steps are:
        - the time axis of the experiment is cut to the interval from 0 to n_seconds
        - the spectra are summed into one along the time axis with the bin size determined by mz and instrument resolution
        - data is smoothed by applying the Savitzky-Golay filter
        - peaks are picked
        - the accurate mass search for all the picked peaks is performed
        
        The intermediate summed spectra and picked peaks can be saved to the filesystem.
        Also, the results of the accurate mass search and the signal-to-noise information
        of the resulting spectrum is saved.
        
        
        :param experiment: Input MSExperiment
        :param n_seconds: Input number of seconds
        :param load_cached_spectrum: Load the cached picked spectrum if exists
        :param output: Output of the accurate mass search results
        :return: A boolean indicating if the picked spectrum was loaded from the cached file
        """
        ...
    
    def extractPeaks(self, input_: MSSpectrum ) -> MSSpectrum:
        """
        Cython signature: MSSpectrum extractPeaks(MSSpectrum & input_)
        Pick peaks from the summed spectrum
        
        
        :param input: Input vector of spectra
        :return: A spectrum with picked peaks
        """
        ...
    
    def convertToFeatureMap(self, input_: MSSpectrum ) -> FeatureMap:
        """
        Cython signature: FeatureMap convertToFeatureMap(MSSpectrum & input_)
        Convert a spectrum to a feature map with the corresponding polarity\n
        
        Applies `SavitzkyGolayFilter` and `PeakPickerHiRes`
        
        
        :param input: Input a picked spectrum
        :return: A feature map with the peaks converted to features and polarity from the parameters
        """
        ...
    
    def trackNoise(self, input_: MSSpectrum ) -> MSSpectrum:
        """
        Cython signature: MSSpectrum trackNoise(MSSpectrum & input_)
        Estimate noise for each peak\n
        
        Uses `SignalToNoiseEstimatorMedianRapid`
        
        
        :param input: Input a picked spectrum
        :return: A spectrum object storing logSN information
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class FeatureFindingMetabo:
    """
    Cython implementation of _FeatureFindingMetabo

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1FeatureFindingMetabo.html>`_
      -- Inherits from ['ProgressLogger', 'DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void FeatureFindingMetabo()
        Method for the assembly of mass traces belonging to the same isotope
        pattern, i.e., that are compatible in retention times, mass-to-charge ratios,
        and isotope abundances
        """
        ...
    
    @overload
    def __init__(self, in_0: FeatureFindingMetabo ) -> None:
        """
        Cython signature: void FeatureFindingMetabo(FeatureFindingMetabo &)
        """
        ...
    
    def run(self, input_mtraces: List[Kernel_MassTrace] , output_featmap: FeatureMap , output_chromatograms: List[List[MSChromatogram]] ) -> None:
        """
        Cython signature: void run(libcpp_vector[Kernel_MassTrace] input_mtraces, FeatureMap & output_featmap, libcpp_vector[libcpp_vector[MSChromatogram]] & output_chromatograms)
        """
        ...
    
    def setLogType(self, in_0: int ) -> None:
        """
        Cython signature: void setLogType(LogType)
        Sets the progress log that should be used. The default type is NONE!
        """
        ...
    
    def getLogType(self) -> int:
        """
        Cython signature: LogType getLogType()
        Returns the type of progress log being used
        """
        ...
    
    def startProgress(self, begin: int , end: int , label: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void startProgress(ptrdiff_t begin, ptrdiff_t end, String label)
        """
        ...
    
    def setProgress(self, value: int ) -> None:
        """
        Cython signature: void setProgress(ptrdiff_t value)
        Sets the current progress
        """
        ...
    
    def endProgress(self) -> None:
        """
        Cython signature: void endProgress()
        Ends the progress display
        """
        ...
    
    def nextProgress(self) -> None:
        """
        Cython signature: void nextProgress()
        Increment progress by 1 (according to range begin-end)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class Fitter1D:
    """
    Cython implementation of _Fitter1D

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Fitter1D.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Fitter1D()
        Abstract base class for all 1D-dimensional model fitter
        """
        ...
    
    @overload
    def __init__(self, in_0: Fitter1D ) -> None:
        """
        Cython signature: void Fitter1D(Fitter1D &)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class GNPSMGFFile:
    """
    Cython implementation of _GNPSMGFFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1GNPSMGFFile.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void GNPSMGFFile()
        """
        ...
    
    @overload
    def __init__(self, in_0: GNPSMGFFile ) -> None:
        """
        Cython signature: void GNPSMGFFile(GNPSMGFFile &)
        """
        ...
    
    def store(self, consensus_file_path: Union[bytes, str, String] , mzml_file_paths: List[bytes] , out: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void store(const String & consensus_file_path, const StringList & mzml_file_paths, const String & out)
        Export consensus file from default workflow to GNPS MGF format
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class Instrument:
    """
    Cython implementation of _Instrument

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Instrument.html>`_
      -- Inherits from ['MetaInfoInterface']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Instrument()
        Description of a MS instrument
        """
        ...
    
    @overload
    def __init__(self, in_0: Instrument ) -> None:
        """
        Cython signature: void Instrument(Instrument &)
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name of the instrument
        """
        ...
    
    def setName(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(String name)
        Sets the name of the instrument
        """
        ...
    
    def getVendor(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getVendor()
        Returns the instrument vendor
        """
        ...
    
    def setVendor(self, vendor: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setVendor(String vendor)
        Sets the instrument vendor
        """
        ...
    
    def getModel(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getModel()
        Returns the instrument model
        """
        ...
    
    def setModel(self, model: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setModel(String model)
        Sets the instrument model
        """
        ...
    
    def getCustomizations(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getCustomizations()
        Returns a description of customizations
        """
        ...
    
    def setCustomizations(self, customizations: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCustomizations(String customizations)
        Sets the a description of customizations
        """
        ...
    
    def getIonSources(self) -> List[IonSource]:
        """
        Cython signature: libcpp_vector[IonSource] getIonSources()
        Returns the ion source list
        """
        ...
    
    def setIonSources(self, ion_sources: List[IonSource] ) -> None:
        """
        Cython signature: void setIonSources(libcpp_vector[IonSource] ion_sources)
        Sets the ion source list
        """
        ...
    
    def getMassAnalyzers(self) -> List[MassAnalyzer]:
        """
        Cython signature: libcpp_vector[MassAnalyzer] getMassAnalyzers()
        Returns the mass analyzer list
        """
        ...
    
    def setMassAnalyzers(self, mass_analyzers: List[MassAnalyzer] ) -> None:
        """
        Cython signature: void setMassAnalyzers(libcpp_vector[MassAnalyzer] mass_analyzers)
        Sets the mass analyzer list
        """
        ...
    
    def getIonDetectors(self) -> List[IonDetector]:
        """
        Cython signature: libcpp_vector[IonDetector] getIonDetectors()
        Returns the ion detector list
        """
        ...
    
    def setIonDetectors(self, ion_detectors: List[IonDetector] ) -> None:
        """
        Cython signature: void setIonDetectors(libcpp_vector[IonDetector] ion_detectors)
        Sets the ion detector list
        """
        ...
    
    def getSoftware(self) -> Software:
        """
        Cython signature: Software getSoftware()
        Returns the instrument software
        """
        ...
    
    def setSoftware(self, software: Software ) -> None:
        """
        Cython signature: void setSoftware(Software software)
        Sets the instrument software
        """
        ...
    
    def getIonOptics(self) -> int:
        """
        Cython signature: IonOpticsType getIonOptics()
        Returns the ion optics type
        """
        ...
    
    def setIonOptics(self, ion_optics: int ) -> None:
        """
        Cython signature: void setIonOptics(IonOpticsType ion_optics)
        Sets the ion optics type
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: Instrument, op: int) -> Any:
        ... 


class IsobaricQuantifier:
    """
    Cython implementation of _IsobaricQuantifier

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1IsobaricQuantifier.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, in_0: IsobaricQuantifier ) -> None:
        """
        Cython signature: void IsobaricQuantifier(IsobaricQuantifier &)
        """
        ...
    
    @overload
    def __init__(self, quant_method: ItraqFourPlexQuantitationMethod ) -> None:
        """
        Cython signature: void IsobaricQuantifier(ItraqFourPlexQuantitationMethod * quant_method)
        """
        ...
    
    @overload
    def __init__(self, quant_method: ItraqEightPlexQuantitationMethod ) -> None:
        """
        Cython signature: void IsobaricQuantifier(ItraqEightPlexQuantitationMethod * quant_method)
        """
        ...
    
    @overload
    def __init__(self, quant_method: TMTSixPlexQuantitationMethod ) -> None:
        """
        Cython signature: void IsobaricQuantifier(TMTSixPlexQuantitationMethod * quant_method)
        """
        ...
    
    @overload
    def __init__(self, quant_method: TMTTenPlexQuantitationMethod ) -> None:
        """
        Cython signature: void IsobaricQuantifier(TMTTenPlexQuantitationMethod * quant_method)
        """
        ...
    
    def quantify(self, consensus_map_in: ConsensusMap , consensus_map_out: ConsensusMap ) -> None:
        """
        Cython signature: void quantify(ConsensusMap & consensus_map_in, ConsensusMap & consensus_map_out)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class IsotopePattern:
    """
    Cython implementation of _IsotopePattern

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::FeatureFinderAlgorithmPickedHelperStructs_1_1IsotopePattern.html>`_
    """
    
    spectrum: List[int]
    
    intensity: List[float]
    
    mz_score: List[float]
    
    theoretical_mz: List[float]
    
    theoretical_pattern: TheoreticalIsotopePattern
    
    @overload
    def __init__(self, size: int ) -> None:
        """
        Cython signature: void IsotopePattern(size_t size)
        """
        ...
    
    @overload
    def __init__(self, in_0: IsotopePattern ) -> None:
        """
        Cython signature: void IsotopePattern(IsotopePattern &)
        """
        ... 


class MassTrace:
    """
    Cython implementation of _MassTrace

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::FeatureFinderAlgorithmPickedHelperStructs_1_1MassTrace.html>`_
    """
    
    max_rt: float
    
    theoretical_int: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MassTrace()
        """
        ...
    
    @overload
    def __init__(self, in_0: MassTrace ) -> None:
        """
        Cython signature: void MassTrace(MassTrace &)
        """
        ...
    
    def getConvexhull(self) -> ConvexHull2D:
        """
        Cython signature: ConvexHull2D getConvexhull()
        """
        ...
    
    def updateMaximum(self) -> None:
        """
        Cython signature: void updateMaximum()
        """
        ...
    
    def getAvgMZ(self) -> float:
        """
        Cython signature: double getAvgMZ()
        """
        ...
    
    def isValid(self) -> bool:
        """
        Cython signature: bool isValid()
        """
        ... 


class MassTraces:
    """
    Cython implementation of _MassTraces

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::FeatureFinderAlgorithmPickedHelperStructs_1_1MassTraces.html>`_
    """
    
    max_trace: int
    
    baseline: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MassTraces()
        """
        ...
    
    @overload
    def __init__(self, in_0: MassTraces ) -> None:
        """
        Cython signature: void MassTraces(MassTraces &)
        """
        ...
    
    def getPeakCount(self) -> int:
        """
        Cython signature: size_t getPeakCount()
        """
        ...
    
    def isValid(self, seed_mz: float , trace_tolerance: float ) -> bool:
        """
        Cython signature: bool isValid(double seed_mz, double trace_tolerance)
        """
        ...
    
    def getTheoreticalmaxPosition(self) -> int:
        """
        Cython signature: size_t getTheoreticalmaxPosition()
        """
        ...
    
    def updateBaseline(self) -> None:
        """
        Cython signature: void updateBaseline()
        """
        ...
    
    def getRTBounds(self) -> List[float, float]:
        """
        Cython signature: libcpp_pair[double,double] getRTBounds()
        """
        ... 


class ModificationsDB:
    """
    Cython implementation of _ModificationsDB

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ModificationsDB.html>`_
    """
    
    def getNumberOfModifications(self) -> int:
        """
        Cython signature: size_t getNumberOfModifications()
        Returns the number of modifications read from the unimod.xml file
        """
        ...
    
    def searchModifications(self, mods: Set[ResidueModification] , mod_name: Union[bytes, str, String] , residue: Union[bytes, str, String] , term_spec: int ) -> None:
        """
        Cython signature: void searchModifications(libcpp_set[const ResidueModification *] & mods, const String & mod_name, const String & residue, TermSpecificity term_spec)
        Collects all modifications which have the given name as synonym
        
        If `residue` is set, only modifications with matching residue of origin are considered
        If `term_spec` is set, only modifications with matching term specificity are considered
        The resulting set of modifications will be empty if no modification exists that fulfills the criteria
        """
        ...
    
    @overload
    def getModification(self, index: int ) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getModification(size_t index)
        Returns the modification with the given index
        """
        ...
    
    @overload
    def getModification(self, mod_name: Union[bytes, str, String] ) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getModification(const String & mod_name)
        Returns the modification with the given name
        """
        ...
    
    @overload
    def getModification(self, mod_name: Union[bytes, str, String] , residue: Union[bytes, str, String] , term_spec: int ) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getModification(const String & mod_name, const String & residue, TermSpecificity term_spec)
        Returns the modification with the given arguments
        """
        ...
    
    def has(self, modification: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool has(String modification)
        Returns true if the modification exists
        """
        ...
    
    def addModification(self, new_mod: ResidueModification ) -> ResidueModification:
        """
        Cython signature: const ResidueModification * addModification(const ResidueModification & new_mod)
        Add a new modification to ModificationsDB. If the modification already exists (based on its fullID) it is not added. Returns the modification in the ModificationDB (which can differ from input if mod was already present).
        """
        ...
    
    def findModificationIndex(self, mod_name: Union[bytes, str, String] ) -> int:
        """
        Cython signature: size_t findModificationIndex(const String & mod_name)
        Returns the index of the modification in the mods_ vector; a unique name must be given
        """
        ...
    
    def searchModificationsByDiffMonoMass(self, mods: List[bytes] , mass: float , max_error: float , residue: Union[bytes, str, String] , term_spec: int ) -> None:
        """
        Cython signature: void searchModificationsByDiffMonoMass(libcpp_vector[String] & mods, double mass, double max_error, const String & residue, TermSpecificity term_spec)
        Collects all modifications with delta mass inside a tolerance window
        """
        ...
    
    def getBestModificationByDiffMonoMass(self, mass: float , max_error: float , residue: Union[bytes, str, String] , term_spec: int ) -> ResidueModification:
        """
        Cython signature: const ResidueModification * getBestModificationByDiffMonoMass(double mass, double max_error, const String & residue, TermSpecificity term_spec)
        Returns the best matching modification for the given delta mass and residue
        
        Query the modifications DB to get the best matching modification with
        the given delta mass at the given residue (NULL pointer means no result,
        maybe the maximal error tolerance needs to be increased). Possible
        input for CAM modification would be a delta mass of 57 and a residue
        of "C".
        
        Note: If there are multiple possible matches with equal masses, it
        will choose the _first_ match which defaults to the first matching
        UniMod entry.
        
        
        :param residue: The residue at which the modifications occurs
        :param mass: The monoisotopic mass of the residue including the mass of the modification
        :param max_error: The maximal mass error in the modification search
        :return: A pointer to the best matching modification (or NULL if none was found)
        """
        ...
    
    def getAllSearchModifications(self, modifications: List[bytes] ) -> None:
        """
        Cython signature: void getAllSearchModifications(libcpp_vector[String] & modifications)
        Collects all modifications that can be used for identification searches
        """
        ...
    
    def isInstantiated(self) -> bool:
        """
        Cython signature: bool isInstantiated()
        Check whether ModificationsDB was instantiated before
        """
        ... 


class MzMLSwathFileConsumer:
    """
    Cython implementation of _MzMLSwathFileConsumer

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MzMLSwathFileConsumer.html>`_
      -- Inherits from ['FullSwathFileConsumer']
    """
    
    @overload
    def __init__(self, in_0: MzMLSwathFileConsumer ) -> None:
        """
        Cython signature: void MzMLSwathFileConsumer(MzMLSwathFileConsumer)
        """
        ...
    
    @overload
    def __init__(self, cachedir: Union[bytes, str, String] , basename: Union[bytes, str, String] , nr_ms1_spectra: int , nr_ms2_spectra: List[int] ) -> None:
        """
        Cython signature: void MzMLSwathFileConsumer(String cachedir, String basename, size_t nr_ms1_spectra, libcpp_vector[int] nr_ms2_spectra)
        """
        ...
    
    @overload
    def __init__(self, known_window_boundaries: List[SwathMap] , cachedir: Union[bytes, str, String] , basename: Union[bytes, str, String] , nr_ms1_spectra: int , nr_ms2_spectra: List[int] ) -> None:
        """
        Cython signature: void MzMLSwathFileConsumer(libcpp_vector[SwathMap] known_window_boundaries, String cachedir, String basename, size_t nr_ms1_spectra, libcpp_vector[int] nr_ms2_spectra)
        """
        ...
    
    def setExpectedSize(self, s: int , c: int ) -> None:
        """
        Cython signature: void setExpectedSize(size_t s, size_t c)
        """
        ...
    
    def setExperimentalSettings(self, exp: ExperimentalSettings ) -> None:
        """
        Cython signature: void setExperimentalSettings(ExperimentalSettings exp)
        """
        ...
    
    def retrieveSwathMaps(self, maps: List[SwathMap] ) -> None:
        """
        Cython signature: void retrieveSwathMaps(libcpp_vector[SwathMap] & maps)
        """
        ...
    
    def consumeSpectrum(self, s: MSSpectrum ) -> None:
        """
        Cython signature: void consumeSpectrum(MSSpectrum & s)
        """
        ...
    
    def consumeChromatogram(self, c: MSChromatogram ) -> None:
        """
        Cython signature: void consumeChromatogram(MSChromatogram & c)
        """
        ... 


class OMSSACSVFile:
    """
    Cython implementation of _OMSSACSVFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1OMSSACSVFile.html>`_

    File adapter for OMSSACSV files
    
    The files contain the results of the OMSSA algorithm in a comma separated manner. This file adapter is able to
    load the data from such a file into the structures of OpenMS
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OMSSACSVFile()
        """
        ...
    
    @overload
    def __init__(self, in_0: OMSSACSVFile ) -> None:
        """
        Cython signature: void OMSSACSVFile(OMSSACSVFile &)
        """
        ...
    
    def load(self, filename: Union[bytes, str, String] , protein_identification: ProteinIdentification , id_data: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void load(const String & filename, ProteinIdentification & protein_identification, libcpp_vector[PeptideIdentification] & id_data)
        Loads a OMSSA file
        
        The content of the file is stored in `features`
        
        
        :param filename: The name of the file to read from
        :param protein_identification: The protein ProteinIdentification data
        :param id_data: The peptide ids of the file
        :raises:
          Exception: FileNotFound is thrown if the file could not be opened
        :raises:
          Exception: ParseError is thrown if an error occurs during parsing
        """
        ... 


class OSChromatogramMeta:
    """
    Cython implementation of _OSChromatogramMeta

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenSwath_1_1OSChromatogramMeta.html>`_
    """
    
    index: int
    
    id: bytes
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OSChromatogramMeta()
        """
        ...
    
    @overload
    def __init__(self, in_0: OSChromatogramMeta ) -> None:
        """
        Cython signature: void OSChromatogramMeta(OSChromatogramMeta &)
        """
        ... 


class OpenMSBuildInfo:
    """
    Cython implementation of _OpenMSBuildInfo

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Internal_1_1OpenMSBuildInfo.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OpenMSBuildInfo()
        """
        ...
    
    @overload
    def __init__(self, in_0: OpenMSBuildInfo ) -> None:
        """
        Cython signature: void OpenMSBuildInfo(OpenMSBuildInfo &)
        """
        ...
    
    getBuildType: __static_OpenMSBuildInfo_getBuildType
    
    getOpenMPMaxNumThreads: __static_OpenMSBuildInfo_getOpenMPMaxNumThreads
    
    isOpenMPEnabled: __static_OpenMSBuildInfo_isOpenMPEnabled
    
    setOpenMPNumThreads: __static_OpenMSBuildInfo_setOpenMPNumThreads 


class OpenMSOSInfo:
    """
    Cython implementation of _OpenMSOSInfo

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Internal_1_1OpenMSOSInfo.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OpenMSOSInfo()
        """
        ...
    
    @overload
    def __init__(self, in_0: OpenMSOSInfo ) -> None:
        """
        Cython signature: void OpenMSOSInfo(OpenMSOSInfo &)
        """
        ...
    
    def getOSAsString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getOSAsString()
        """
        ...
    
    def getArchAsString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getArchAsString()
        """
        ...
    
    def getOSVersionAsString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getOSVersionAsString()
        """
        ...
    
    getBinaryArchitecture: __static_OpenMSOSInfo_getBinaryArchitecture
    
    getOSInfo: __static_OpenMSOSInfo_getOSInfo 


class PScore:
    """
    Cython implementation of _PScore

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1PScore.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void PScore()
        """
        ...
    
    @overload
    def __init__(self, in_0: PScore ) -> None:
        """
        Cython signature: void PScore(PScore &)
        """
        ...
    
    def calculateIntensityRankInMZWindow(self, mz: List[float] , intensities: List[float] , mz_window: float ) -> List[int]:
        """
        Cython signature: libcpp_vector[size_t] calculateIntensityRankInMZWindow(libcpp_vector[double] & mz, libcpp_vector[double] & intensities, double mz_window)
        Calculate local (windowed) peak ranks
        
        The peak rank is defined as the number of neighboring peaks in +/- (mz_window/2) that have higher intensity
        The result can be used to efficiently filter spectra for top 1..n peaks in mass windows
        
        
        :param mz: The m/z positions of the peaks
        :param intensities: The intensities of the peaks
        :param mz_window: The window in Thomson centered at each peak
        """
        ...
    
    def calculateRankMap(self, peak_map: MSExperiment , mz_window: float ) -> List[List[int]]:
        """
        Cython signature: libcpp_vector[libcpp_vector[size_t]] calculateRankMap(MSExperiment & peak_map, double mz_window)
        Precalculated, windowed peak ranks for a whole experiment
        
        The peak rank is defined as the number of neighboring peaks in +/- (mz_window/2) that have higher intensity
        
        
        :param peak_map: Fragment spectra used for rank calculation. Typically a peak map after removal of all MS1 spectra
        :param mz_window: Window in Thomson centered at each peak
        """
        ...
    
    def calculatePeakLevelSpectra(self, spec: MSSpectrum , ranks: List[int] , min_level: int , max_level: int ) -> Dict[int, MSSpectrum]:
        """
        Cython signature: libcpp_map[size_t,MSSpectrum] calculatePeakLevelSpectra(MSSpectrum & spec, libcpp_vector[size_t] & ranks, size_t min_level, size_t max_level)
        Calculates spectra for peak level between min_level to max_level and stores them in the map
        
        A spectrum of peak level n retains the (n+1) top intensity peaks in a sliding mz_window centered at each peak
        """
        ...
    
    @overload
    def computePScore(self, fragment_mass_tolerance: float , fragment_mass_tolerance_unit_ppm: bool , peak_level_spectra: Dict[int, MSSpectrum] , theo_spectra: List[MSSpectrum] , mz_window: float ) -> float:
        """
        Cython signature: double computePScore(double fragment_mass_tolerance, bool fragment_mass_tolerance_unit_ppm, libcpp_map[size_t,MSSpectrum] & peak_level_spectra, libcpp_vector[MSSpectrum] & theo_spectra, double mz_window)
        Computes the PScore for a vector of theoretical spectra
        
        Similar to Andromeda, a vector of theoretical spectra can be provided that e.g. contain loss spectra or higher charge spectra depending on the sequence.
        The best score obtained by scoring all those theoretical spectra against the experimental ones is returned
        
        
        :param fragment_mass_tolerance: Mass tolerance for matching peaks
        :param fragment_mass_tolerance_unit_ppm: Whether Thomson or ppm is used
        :param peak_level_spectra: Spectra for different peak levels (=filtered by maximum rank).
        :param theo_spectra: Theoretical spectra as obtained e.g. from TheoreticalSpectrumGenerator
        :param mz_window: Window in Thomson centered at each peak
        """
        ...
    
    @overload
    def computePScore(self, fragment_mass_tolerance: float , fragment_mass_tolerance_unit_ppm: bool , peak_level_spectra: Dict[int, MSSpectrum] , theo_spectrum: MSSpectrum , mz_window: float ) -> float:
        """
        Cython signature: double computePScore(double fragment_mass_tolerance, bool fragment_mass_tolerance_unit_ppm, libcpp_map[size_t,MSSpectrum] & peak_level_spectra, MSSpectrum & theo_spectrum, double mz_window)
        Computes the PScore for a single theoretical spectrum
        
        
        :param fragment_mass_tolerance: Mass tolerance for matching peaks
        :param fragment_mass_tolerance_unit_ppm: Whether Thomson or ppm is used
        :param peak_level_spectra: Spectra for different peak levels (=filtered by maximum rank)
        :param theo_spectra: Theoretical spectra as obtained e.g. from TheoreticalSpectrumGenerator
        :param mz_window: Window in Thomson centered at each peak
        """
        ... 


class PosteriorErrorProbabilityModel:
    """
    Cython implementation of _PosteriorErrorProbabilityModel

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Math_1_1PosteriorErrorProbabilityModel.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    def __init__(self) -> None:
        """
        Cython signature: void PosteriorErrorProbabilityModel()
        """
        ...
    
    @overload
    def fit(self, search_engine_scores: List[float] , outlier_handling: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool fit(libcpp_vector[double] & search_engine_scores, String outlier_handling)
        Fits the distributions to the data points(search_engine_scores). Estimated parameters for the distributions are saved in member variables
        computeProbability can be used afterwards
        Uses two Gaussians to fit. And Gauss+Gauss or Gumbel+Gauss to plot and calculate final probabilities
        
        
        :param search_engine_scores: A vector which holds the data points
        :return: `true` if algorithm has run through. Else false will be returned. In that case no plot and no probabilities are calculated
        """
        ...
    
    @overload
    def fit(self, search_engine_scores: List[float] , probabilities: List[float] , outlier_handling: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool fit(libcpp_vector[double] & search_engine_scores, libcpp_vector[double] & probabilities, String outlier_handling)
        Fits the distributions to the data points(search_engine_scores). Estimated parameters for the distributions are saved in member variables
        computeProbability can be used afterwards
        Uses two Gaussians to fit. And Gauss+Gauss or Gumbel+Gauss to plot and calculate final probabilities
        
        
        :param search_engine_scores: A vector which holds the data points
        :param probabilities: A vector which holds the probability for each data point after running this function. If it has some content it will be overwritten
        :return: `true` if algorithm has run through. Else false will be returned. In that case no plot and no probabilities are calculated
        """
        ...
    
    def fillDensities(self, x_scores: List[float] , incorrect_density: List[float] , correct_density: List[float] ) -> None:
        """
        Cython signature: void fillDensities(libcpp_vector[double] & x_scores, libcpp_vector[double] & incorrect_density, libcpp_vector[double] & correct_density)
        Writes the distributions densities into the two vectors for a set of scores. Incorrect_densities represent the incorrectly assigned sequences
        """
        ...
    
    def fillLogDensities(self, x_scores: List[float] , incorrect_density: List[float] , correct_density: List[float] ) -> None:
        """
        Cython signature: void fillLogDensities(libcpp_vector[double] & x_scores, libcpp_vector[double] & incorrect_density, libcpp_vector[double] & correct_density)
        Writes the log distributions densities into the two vectors for a set of scores. Incorrect_densities represent the incorrectly assigned sequences
        """
        ...
    
    def computeLogLikelihood(self, incorrect_density: List[float] , correct_density: List[float] ) -> float:
        """
        Cython signature: double computeLogLikelihood(libcpp_vector[double] & incorrect_density, libcpp_vector[double] & correct_density)
        Computes the Maximum Likelihood with a log-likelihood function
        """
        ...
    
    def pos_neg_mean_weighted_posteriors(self, x_scores: List[float] , incorrect_posteriors: List[float] ) -> List[float, float]:
        """
        Cython signature: libcpp_pair[double,double] pos_neg_mean_weighted_posteriors(libcpp_vector[double] & x_scores, libcpp_vector[double] & incorrect_posteriors)
        """
        ...
    
    def getCorrectlyAssignedFitResult(self) -> GaussFitResult:
        """
        Cython signature: GaussFitResult getCorrectlyAssignedFitResult()
        Returns estimated parameters for correctly assigned sequences. Fit should be used before
        """
        ...
    
    def getIncorrectlyAssignedFitResult(self) -> GaussFitResult:
        """
        Cython signature: GaussFitResult getIncorrectlyAssignedFitResult()
        Returns estimated parameters for correctly assigned sequences. Fit should be used before
        """
        ...
    
    def getNegativePrior(self) -> float:
        """
        Cython signature: double getNegativePrior()
        Returns the estimated negative prior probability
        """
        ...
    
    def computeProbability(self, score: float ) -> float:
        """
        Cython signature: double computeProbability(double score)
        Returns the computed posterior error probability for a given score
        """
        ...
    
    def initPlots(self, x_scores: List[float] ) -> TextFile:
        """
        Cython signature: TextFile initPlots(libcpp_vector[double] & x_scores)
        Initializes the plots
        """
        ...
    
    def getGumbelGnuplotFormula(self, params: GaussFitResult ) -> Union[bytes, str, String]:
        """
        Cython signature: String getGumbelGnuplotFormula(GaussFitResult & params)
        Returns the gnuplot formula of the fitted gumbel distribution
        """
        ...
    
    def getGaussGnuplotFormula(self, params: GaussFitResult ) -> Union[bytes, str, String]:
        """
        Cython signature: String getGaussGnuplotFormula(GaussFitResult & params)
        Returns the gnuplot formula of the fitted gauss distribution
        """
        ...
    
    def getBothGnuplotFormula(self, incorrect: GaussFitResult , correct: GaussFitResult ) -> Union[bytes, str, String]:
        """
        Cython signature: String getBothGnuplotFormula(GaussFitResult & incorrect, GaussFitResult & correct)
        Returns the gnuplot formula of the fitted mixture distribution
        """
        ...
    
    def plotTargetDecoyEstimation(self, target: List[float] , decoy: List[float] ) -> None:
        """
        Cython signature: void plotTargetDecoyEstimation(libcpp_vector[double] & target, libcpp_vector[double] & decoy)
        Plots the estimated distribution against target and decoy hits
        """
        ...
    
    def getSmallestScore(self) -> float:
        """
        Cython signature: double getSmallestScore()
        Returns the smallest score used in the last fit
        """
        ...
    
    def tryGnuplot(self, gp_file: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void tryGnuplot(const String & gp_file)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class ProteaseDigestion:
    """
    Cython implementation of _ProteaseDigestion

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ProteaseDigestion.html>`_
      -- Inherits from ['EnzymaticDigestion']

    Class for the enzymatic digestion of proteins
    
    Digestion can be performed using simple regular expressions, e.g. [KR] | [^P] for trypsin.
    Also missed cleavages can be modeled, i.e. adjacent peptides are not cleaved
    due to enzyme malfunction/access restrictions. If n missed cleavages are allowed, all possible resulting
    peptides (cleaved and uncleaved) with up to n missed cleavages are returned.
    Thus no random selection of just n specific missed cleavage sites is performed.
    
    Usage:
    
    .. code-block:: python
    
          from pyopenms import *
          from urllib.request import urlretrieve
          #
          urlretrieve ("http://www.uniprot.org/uniprot/P02769.fasta", "bsa.fasta")
          #
          dig = ProteaseDigestion()
          dig.setEnzyme('Lys-C')
          bsa_string = "".join([l.strip() for l in open("bsa.fasta").readlines()[1:]])
          bsa_oms_string = String(bsa_string) # convert python string to OpenMS::String for further processing
          #
          minlen = 6
          maxlen = 30
          #
          # Using AASequence and digest
          result_digest = []
          result_digest_min_max = []
          bsa_aaseq = AASequence.fromString(bsa_oms_string)
          dig.digest(bsa_aaseq, result_digest)
          dig.digest(bsa_aaseq, result_digest_min_max, minlen, maxlen)
          print(result_digest[4].toString()) # GLVLIAFSQYLQQCPFDEHVK
          print(len(result_digest)) # 57 peptides
          print(result_digest_min_max[4].toString()) # LVNELTEFAK
          print(len(result_digest_min_max)) # 42 peptides
          #
          # Using digestUnmodified without the need for AASequence from the EnzymaticDigestion base class
          result_digest_unmodified = []
          dig.digestUnmodified(StringView(bsa_oms_string), result_digest_unmodified, minlen, maxlen)
          print(result_digest_unmodified[4].getString()) # LVNELTEFAK
          print(len(result_digest_unmodified)) # 42 peptides
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ProteaseDigestion()
        """
        ...
    
    @overload
    def __init__(self, in_0: ProteaseDigestion ) -> None:
        """
        Cython signature: void ProteaseDigestion(ProteaseDigestion &)
        """
        ...
    
    @overload
    def setEnzyme(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setEnzyme(String name)
        Sets the enzyme for the digestion (by name)
        """
        ...
    
    @overload
    def setEnzyme(self, enzyme: DigestionEnzyme ) -> None:
        """
        Cython signature: void setEnzyme(DigestionEnzyme * enzyme)
        Sets the enzyme for the digestion
        """
        ...
    
    @overload
    def digest(self, protein: AASequence , output: List[AASequence] ) -> int:
        """
        Cython signature: size_t digest(AASequence & protein, libcpp_vector[AASequence] & output)
        """
        ...
    
    @overload
    def digest(self, protein: AASequence , output: List[AASequence] , min_length: int , max_length: int ) -> int:
        """
        Cython signature: size_t digest(AASequence & protein, libcpp_vector[AASequence] & output, size_t min_length, size_t max_length)
          Performs the enzymatic digestion of a protein.
        
        
          :param protein: Sequence to digest
          :param output: Digestion products (peptides)
          :param min_length: Minimal length of reported products
          :param max_length: Maximal length of reported products (0 = no restriction)
          :return: Number of discarded digestion products (which are not matching length restrictions)
        """
        ...
    
    def peptideCount(self, protein: AASequence ) -> int:
        """
        Cython signature: size_t peptideCount(AASequence & protein)
        Returns the number of peptides a digestion of protein would yield under the current enzyme and missed cleavage settings
        """
        ...
    
    @overload
    def isValidProduct(self, protein: AASequence , pep_pos: int , pep_length: int , ignore_missed_cleavages: bool , methionine_cleavage: bool ) -> bool:
        """
        Cython signature: bool isValidProduct(AASequence protein, size_t pep_pos, size_t pep_length, bool ignore_missed_cleavages, bool methionine_cleavage)
          Variant of EnzymaticDigestion::isValidProduct() with support for n-term protein cleavage and random D|P cleavage
        
          Checks if peptide is a valid digestion product of the enzyme, taking into account specificity and the flags provided here
        
        
          :param protein: Protein sequence
          :param pep_pos: Starting index of potential peptide
          :param pep_length: Length of potential peptide
          :param ignore_missed_cleavages: Do not compare MC's of potential peptide to the maximum allowed MC's
          :param allow_nterm_protein_cleavage: Regard peptide as n-terminal of protein if it starts only at pos=1 or 2 and protein starts with 'M'
          :param allow_random_asp_pro_cleavage: Allow cleavage at D|P sites to count as n/c-terminal
          :return: True if peptide has correct n/c terminals (according to enzyme, specificity and above flags)
        """
        ...
    
    @overload
    def isValidProduct(self, protein: Union[bytes, str, String] , pep_pos: int , pep_length: int , ignore_missed_cleavages: bool , methionine_cleavage: bool ) -> bool:
        """
        Cython signature: bool isValidProduct(String protein, size_t pep_pos, size_t pep_length, bool ignore_missed_cleavages, bool methionine_cleavage)
        Forwards to isValidProduct using protein.toUnmodifiedString()
        """
        ...
    
    @overload
    def isValidProduct(self, sequence: Union[bytes, str, String] , pos: int , length: int , ignore_missed_cleavages: bool ) -> bool:
        """
        Cython signature: bool isValidProduct(String sequence, int pos, int length, bool ignore_missed_cleavages)
        Boolean operator returns true if the peptide fragment starting at position `pos` with length `length` within the sequence `sequence` generated by the current enzyme\n
        Checks if peptide is a valid digestion product of the enzyme, taking into account specificity and the MC flag provided here
        
        
        :param protein: Protein sequence
        :param pep_pos: Starting index of potential peptide
        :param pep_length: Length of potential peptide
        :param ignore_missed_cleavages: Do not compare MC's of potential peptide to the maximum allowed MC's
        :return: True if peptide has correct n/c terminals (according to enzyme, specificity and missed cleavages)
        """
        ...
    
    def getMissedCleavages(self) -> int:
        """
        Cython signature: size_t getMissedCleavages()
        Returns the max. number of allowed missed cleavages for the digestion
        """
        ...
    
    def setMissedCleavages(self, missed_cleavages: int ) -> None:
        """
        Cython signature: void setMissedCleavages(size_t missed_cleavages)
        Sets the max. number of allowed missed cleavages for the digestion (default is 0). This setting is ignored when log model is used
        """
        ...
    
    def countInternalCleavageSites(self, sequence: Union[bytes, str, String] ) -> int:
        """
        Cython signature: size_t countInternalCleavageSites(String sequence)
        Returns the number of internal cleavage sites for this sequence.
        """
        ...
    
    def getEnzymeName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getEnzymeName()
        Returns the enzyme for the digestion
        """
        ...
    
    def getSpecificity(self) -> int:
        """
        Cython signature: Specificity getSpecificity()
        Returns the specificity for the digestion
        """
        ...
    
    def setSpecificity(self, spec: int ) -> None:
        """
        Cython signature: void setSpecificity(Specificity spec)
        Sets the specificity for the digestion (default is SPEC_FULL)
        """
        ...
    
    def getSpecificityByName(self, name: Union[bytes, str, String] ) -> int:
        """
        Cython signature: Specificity getSpecificityByName(String name)
        Returns the specificity by name. Returns SPEC_UNKNOWN if name is not valid
        """
        ...
    
    def digestUnmodified(self, sequence: StringView , output: List[StringView] , min_length: int , max_length: int ) -> int:
        """
        Cython signature: size_t digestUnmodified(StringView sequence, libcpp_vector[StringView] & output, size_t min_length, size_t max_length)
        Performs the enzymatic digestion of an unmodified sequence\n
        By returning only references into the original string this is very fast
        
        
        :param sequence: Sequence to digest
        :param output: Digestion products
        :param min_length: Minimal length of reported products
        :param max_length: Maximal length of reported products (0 = no restriction)
        :return: Number of discarded digestion products (which are not matching length restrictions)
        """
        ... 


class RangeIntensity:
    """
    Cython implementation of _RangeIntensity

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RangeIntensity.html>`_
      -- Inherits from ['RangeBase']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void RangeIntensity()
        """
        ...
    
    @overload
    def __init__(self, in_0: RangeIntensity ) -> None:
        """
        Cython signature: void RangeIntensity(RangeIntensity &)
        """
        ...
    
    def setMinIntensity(self, min: float ) -> None:
        """
        Cython signature: void setMinIntensity(double min)
        """
        ...
    
    def setMaxIntensity(self, max: float ) -> None:
        """
        Cython signature: void setMaxIntensity(double max)
        """
        ...
    
    def getMinIntensity(self) -> float:
        """
        Cython signature: double getMinIntensity()
        Returns the minimum intensity
        """
        ...
    
    def getMaxIntensity(self) -> float:
        """
        Cython signature: double getMaxIntensity()
        Returns the maximum intensity
        """
        ...
    
    def extendIntensity(self, value: float ) -> None:
        """
        Cython signature: void extendIntensity(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def containsIntensity(self, value: float ) -> bool:
        """
        Cython signature: bool containsIntensity(double value)
        Is value within [min, max]?
        """
        ...
    
    def setMin(self, min: float ) -> None:
        """
        Cython signature: void setMin(double min)
        """
        ...
    
    def setMax(self, max: float ) -> None:
        """
        Cython signature: void setMax(double max)
        """
        ...
    
    def getMin(self) -> float:
        """
        Cython signature: double getMin()
        """
        ...
    
    def getMax(self) -> float:
        """
        Cython signature: double getMax()
        """
        ...
    
    def extend(self, value: float ) -> None:
        """
        Cython signature: void extend(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def contains(self, value: float ) -> bool:
        """
        Cython signature: bool contains(double value)
        Is value within [min, max]?
        """
        ... 


class RangeMZ:
    """
    Cython implementation of _RangeMZ

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RangeMZ.html>`_
      -- Inherits from ['RangeBase']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void RangeMZ()
        """
        ...
    
    @overload
    def __init__(self, in_0: RangeMZ ) -> None:
        """
        Cython signature: void RangeMZ(RangeMZ &)
        """
        ...
    
    def setMinMZ(self, min: float ) -> None:
        """
        Cython signature: void setMinMZ(double min)
        """
        ...
    
    def setMaxMZ(self, max: float ) -> None:
        """
        Cython signature: void setMaxMZ(double max)
        """
        ...
    
    def getMinMZ(self) -> float:
        """
        Cython signature: double getMinMZ()
        """
        ...
    
    def getMaxMZ(self) -> float:
        """
        Cython signature: double getMaxMZ()
        """
        ...
    
    def extendMZ(self, value: float ) -> None:
        """
        Cython signature: void extendMZ(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def containsMZ(self, value: float ) -> bool:
        """
        Cython signature: bool containsMZ(double value)
        Is value within [min, max]?
        """
        ...
    
    def setMin(self, min: float ) -> None:
        """
        Cython signature: void setMin(double min)
        """
        ...
    
    def setMax(self, max: float ) -> None:
        """
        Cython signature: void setMax(double max)
        """
        ...
    
    def getMin(self) -> float:
        """
        Cython signature: double getMin()
        """
        ...
    
    def getMax(self) -> float:
        """
        Cython signature: double getMax()
        """
        ...
    
    def extend(self, value: float ) -> None:
        """
        Cython signature: void extend(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def contains(self, value: float ) -> bool:
        """
        Cython signature: bool contains(double value)
        Is value within [min, max]?
        """
        ... 


class RangeMobility:
    """
    Cython implementation of _RangeMobility

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RangeMobility.html>`_
      -- Inherits from ['RangeBase']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void RangeMobility()
        """
        ...
    
    @overload
    def __init__(self, in_0: RangeMobility ) -> None:
        """
        Cython signature: void RangeMobility(RangeMobility &)
        """
        ...
    
    def setMinMobility(self, min: float ) -> None:
        """
        Cython signature: void setMinMobility(double min)
        """
        ...
    
    def setMaxMobility(self, max: float ) -> None:
        """
        Cython signature: void setMaxMobility(double max)
        """
        ...
    
    def getMinMobility(self) -> float:
        """
        Cython signature: double getMinMobility()
        Returns the minimum Mobility
        """
        ...
    
    def getMaxMobility(self) -> float:
        """
        Cython signature: double getMaxMobility()
        Returns the maximum Mobility
        """
        ...
    
    def extendMobility(self, value: float ) -> None:
        """
        Cython signature: void extendMobility(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def containsMobility(self, value: float ) -> bool:
        """
        Cython signature: bool containsMobility(double value)
        Is value within [min, max]?
        """
        ...
    
    def setMin(self, min: float ) -> None:
        """
        Cython signature: void setMin(double min)
        """
        ...
    
    def setMax(self, max: float ) -> None:
        """
        Cython signature: void setMax(double max)
        """
        ...
    
    def getMin(self) -> float:
        """
        Cython signature: double getMin()
        """
        ...
    
    def getMax(self) -> float:
        """
        Cython signature: double getMax()
        """
        ...
    
    def extend(self, value: float ) -> None:
        """
        Cython signature: void extend(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def contains(self, value: float ) -> bool:
        """
        Cython signature: bool contains(double value)
        Is value within [min, max]?
        """
        ... 


class RangeRT:
    """
    Cython implementation of _RangeRT

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RangeRT.html>`_
      -- Inherits from ['RangeBase']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void RangeRT()
        """
        ...
    
    @overload
    def __init__(self, in_0: RangeRT ) -> None:
        """
        Cython signature: void RangeRT(RangeRT &)
        """
        ...
    
    def setMinRT(self, min: float ) -> None:
        """
        Cython signature: void setMinRT(double min)
        """
        ...
    
    def setMaxRT(self, max: float ) -> None:
        """
        Cython signature: void setMaxRT(double max)
        """
        ...
    
    def getMinRT(self) -> float:
        """
        Cython signature: double getMinRT()
        """
        ...
    
    def getMaxRT(self) -> float:
        """
        Cython signature: double getMaxRT()
        """
        ...
    
    def extendRT(self, value: float ) -> None:
        """
        Cython signature: void extendRT(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def containsRT(self, value: float ) -> bool:
        """
        Cython signature: bool containsRT(double value)
        Is value within [min, max]?
        """
        ...
    
    def setMin(self, min: float ) -> None:
        """
        Cython signature: void setMin(double min)
        """
        ...
    
    def setMax(self, max: float ) -> None:
        """
        Cython signature: void setMax(double max)
        """
        ...
    
    def getMin(self) -> float:
        """
        Cython signature: double getMin()
        """
        ...
    
    def getMax(self) -> float:
        """
        Cython signature: double getMax()
        """
        ...
    
    def extend(self, value: float ) -> None:
        """
        Cython signature: void extend(double value)
        Extend the range such that it includes the given @p value
        """
        ...
    
    def contains(self, value: float ) -> bool:
        """
        Cython signature: bool contains(double value)
        Is value within [min, max]?
        """
        ... 


class RealMassDecomposer:
    """
    Cython implementation of _RealMassDecomposer

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::ims_1_1RealMassDecomposer.html>`_
    """
    
    @overload
    def __init__(self, in_0: RealMassDecomposer ) -> None:
        """
        Cython signature: void RealMassDecomposer(RealMassDecomposer)
        """
        ...
    
    @overload
    def __init__(self, weights: IMSWeights ) -> None:
        """
        Cython signature: void RealMassDecomposer(IMSWeights & weights)
        """
        ...
    
    def getNumberOfDecompositions(self, mass: float , error: float ) -> int:
        """
        Cython signature: uint64_t getNumberOfDecompositions(double mass, double error)
        Gets a number of all decompositions for amass with an error
        allowed. It's similar to thegetDecompositions(double,double) function
        but less space consuming, since doesn't use container to store decompositions
        
        
        :param mass: Mass to be decomposed
        :param error: Error allowed between given and result decomposition
        :return: Number of all decompositions for a given mass and error
        """
        ... 


class RegularSwathFileConsumer:
    """
    Cython implementation of _RegularSwathFileConsumer

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RegularSwathFileConsumer.html>`_
      -- Inherits from ['FullSwathFileConsumer']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void RegularSwathFileConsumer()
        """
        ...
    
    @overload
    def __init__(self, in_0: RegularSwathFileConsumer ) -> None:
        """
        Cython signature: void RegularSwathFileConsumer(RegularSwathFileConsumer &)
        """
        ...
    
    def setExpectedSize(self, s: int , c: int ) -> None:
        """
        Cython signature: void setExpectedSize(size_t s, size_t c)
        """
        ...
    
    def setExperimentalSettings(self, exp: ExperimentalSettings ) -> None:
        """
        Cython signature: void setExperimentalSettings(ExperimentalSettings exp)
        """
        ...
    
    def retrieveSwathMaps(self, maps: List[SwathMap] ) -> None:
        """
        Cython signature: void retrieveSwathMaps(libcpp_vector[SwathMap] & maps)
        """
        ...
    
    def consumeSpectrum(self, s: MSSpectrum ) -> None:
        """
        Cython signature: void consumeSpectrum(MSSpectrum & s)
        """
        ...
    
    def consumeChromatogram(self, c: MSChromatogram ) -> None:
        """
        Cython signature: void consumeChromatogram(MSChromatogram & c)
        """
        ... 


class ResidueDB:
    """
    Cython implementation of _ResidueDB

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ResidueDB.html>`_
    """
    
    def getNumberOfResidues(self) -> int:
        """
        Cython signature: size_t getNumberOfResidues()
        Returns the number of residues stored
        """
        ...
    
    def getNumberOfModifiedResidues(self) -> int:
        """
        Cython signature: size_t getNumberOfModifiedResidues()
        Returns the number of modified residues stored
        """
        ...
    
    def getResidue(self, name: Union[bytes, str, String] ) -> Residue:
        """
        Cython signature: const Residue * getResidue(const String & name)
        Returns a pointer to the residue with name, 3 letter code or 1 letter code name
        """
        ...
    
    @overload
    def getModifiedResidue(self, name: Union[bytes, str, String] ) -> Residue:
        """
        Cython signature: const Residue * getModifiedResidue(const String & name)
        Returns a pointer to a modified residue given a modification name
        """
        ...
    
    @overload
    def getModifiedResidue(self, residue: Residue , name: Union[bytes, str, String] ) -> Residue:
        """
        Cython signature: const Residue * getModifiedResidue(Residue * residue, const String & name)
        Returns a pointer to a modified residue given a residue and a modification name
        """
        ...
    
    def getResidues(self, residue_set: Union[bytes, str, String] ) -> Set[Residue]:
        """
        Cython signature: libcpp_set[const Residue *] getResidues(const String & residue_set)
        Returns a set of all residues stored in this residue db
        """
        ...
    
    def getResidueSets(self) -> Set[bytes]:
        """
        Cython signature: libcpp_set[String] getResidueSets()
        Returns all residue sets that are registered which this instance
        """
        ...
    
    def hasResidue(self, name: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool hasResidue(const String & name)
        Returns true if the db contains a residue with the given name
        """
        ... 


class Seed:
    """
    Cython implementation of _Seed

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::FeatureFinderAlgorithmPickedHelperStructs_1_1Seed.html>`_
    """
    
    spectrum: int
    
    peak: int
    
    intensity: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Seed()
        """
        ...
    
    @overload
    def __init__(self, in_0: Seed ) -> None:
        """
        Cython signature: void Seed(Seed &)
        """
        ...
    
    def __richcmp__(self, other: Seed, op: int) -> Any:
        ... 


class SemanticValidator:
    """
    Cython implementation of _SemanticValidator

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Internal_1_1SemanticValidator.html>`_
    """
    
    def __init__(self, mapping: CVMappings , cv: ControlledVocabulary ) -> None:
        """
        Cython signature: void SemanticValidator(CVMappings mapping, ControlledVocabulary cv)
        """
        ...
    
    def validate(self, filename: Union[bytes, str, String] , errors: List[bytes] , warnings: List[bytes] ) -> bool:
        """
        Cython signature: bool validate(String filename, StringList errors, StringList warnings)
        """
        ...
    
    def locateTerm(self, path: Union[bytes, str, String] , parsed_term: SemanticValidator_CVTerm ) -> bool:
        """
        Cython signature: bool locateTerm(String path, SemanticValidator_CVTerm & parsed_term)
        Checks if a CVTerm is allowed in a given path
        """
        ...
    
    def setTag(self, tag: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setTag(String tag)
        Sets the CV parameter tag name (default 'cvParam')
        """
        ...
    
    def setAccessionAttribute(self, accession: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setAccessionAttribute(String accession)
        Sets the name of the attribute for accessions in the CV parameter tag name (default 'accession')
        """
        ...
    
    def setNameAttribute(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setNameAttribute(String name)
        Sets the name of the attribute for accessions in the CV parameter tag name (default 'name')
        """
        ...
    
    def setValueAttribute(self, value: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setValueAttribute(String value)
        Sets the name of the attribute for accessions in the CV parameter tag name (default 'value')
        """
        ...
    
    def setCheckTermValueTypes(self, check: bool ) -> None:
        """
        Cython signature: void setCheckTermValueTypes(bool check)
        Sets if CV term value types should be check (enabled by default)
        """
        ...
    
    def setCheckUnits(self, check: bool ) -> None:
        """
        Cython signature: void setCheckUnits(bool check)
        Sets if CV term units should be check (disabled by default)
        """
        ...
    
    def setUnitAccessionAttribute(self, accession: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setUnitAccessionAttribute(String accession)
        Sets the name of the unit accession attribute (default 'unitAccession')
        """
        ...
    
    def setUnitNameAttribute(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setUnitNameAttribute(String name)
        Sets the name of the unit name attribute (default 'unitName')
        """
        ... 


class SemanticValidator_CVTerm:
    """
    Cython implementation of _SemanticValidator_CVTerm

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Internal_1_1SemanticValidator_CVTerm.html>`_
    """
    
    accession: Union[bytes, str, String]
    
    name: Union[bytes, str, String]
    
    value: Union[bytes, str, String]
    
    has_value: bool
    
    unit_accession: Union[bytes, str, String]
    
    has_unit_accession: bool
    
    unit_name: Union[bytes, str, String]
    
    has_unit_name: bool
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SemanticValidator_CVTerm()
        """
        ...
    
    @overload
    def __init__(self, in_0: SemanticValidator_CVTerm ) -> None:
        """
        Cython signature: void SemanticValidator_CVTerm(SemanticValidator_CVTerm &)
        """
        ... 


class SpectraMerger:
    """
    Cython implementation of _SpectraMerger

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SpectraMerger.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SpectraMerger()
        Merges blocks of MS or MS2 spectra
        """
        ...
    
    @overload
    def __init__(self, in_0: SpectraMerger ) -> None:
        """
        Cython signature: void SpectraMerger(SpectraMerger &)
        """
        ...
    
    def mergeSpectraBlockWise(self, exp: MSExperiment ) -> None:
        """
        Cython signature: void mergeSpectraBlockWise(MSExperiment & exp)
        """
        ...
    
    def mergeSpectraPrecursors(self, exp: MSExperiment ) -> None:
        """
        Cython signature: void mergeSpectraPrecursors(MSExperiment & exp)
        Merges spectra with similar precursors (must have MS2 level)
        """
        ...
    
    def average(self, exp: MSExperiment , average_type: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void average(MSExperiment & exp, String average_type)
        Average over neighbouring spectra
        
        :param exp: Experimental data to be averaged
        :param average_type: Averaging type to be used ("gaussian" or "tophat")
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class SpectrumSettings:
    """
    Cython implementation of _SpectrumSettings

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SpectrumSettings.html>`_
      -- Inherits from ['MetaInfoInterface']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SpectrumSettings()
        """
        ...
    
    @overload
    def __init__(self, in_0: SpectrumSettings ) -> None:
        """
        Cython signature: void SpectrumSettings(SpectrumSettings &)
        """
        ...
    
    def unify(self, in_0: SpectrumSettings ) -> None:
        """
        Cython signature: void unify(SpectrumSettings)
        """
        ...
    
    def getType(self) -> int:
        """
        Cython signature: int getType()
        Returns the spectrum type (centroided (PEAKS) or profile data (RAW))
        """
        ...
    
    def setType(self, in_0: int ) -> None:
        """
        Cython signature: void setType(SpectrumType)
        Sets the spectrum type
        """
        ...
    
    def getNativeID(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getNativeID()
        Returns the native identifier for the spectrum, used by the acquisition software
        """
        ...
    
    def setNativeID(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setNativeID(String)
        Sets the native identifier for the spectrum, used by the acquisition software
        """
        ...
    
    def getComment(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getComment()
        Returns the free-text comment
        """
        ...
    
    def setComment(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setComment(String)
        Sets the free-text comment
        """
        ...
    
    def getInstrumentSettings(self) -> InstrumentSettings:
        """
        Cython signature: InstrumentSettings getInstrumentSettings()
        Returns a const reference to the instrument settings of the current spectrum
        """
        ...
    
    def setInstrumentSettings(self, in_0: InstrumentSettings ) -> None:
        """
        Cython signature: void setInstrumentSettings(InstrumentSettings)
        Sets the instrument settings of the current spectrum
        """
        ...
    
    def getAcquisitionInfo(self) -> AcquisitionInfo:
        """
        Cython signature: AcquisitionInfo getAcquisitionInfo()
        Returns a const reference to the acquisition info
        """
        ...
    
    def setAcquisitionInfo(self, in_0: AcquisitionInfo ) -> None:
        """
        Cython signature: void setAcquisitionInfo(AcquisitionInfo)
        Sets the acquisition info
        """
        ...
    
    def getSourceFile(self) -> SourceFile:
        """
        Cython signature: SourceFile getSourceFile()
        Returns a const reference to the source file
        """
        ...
    
    def setSourceFile(self, in_0: SourceFile ) -> None:
        """
        Cython signature: void setSourceFile(SourceFile)
        Sets the source file
        """
        ...
    
    def getPrecursors(self) -> List[Precursor]:
        """
        Cython signature: libcpp_vector[Precursor] getPrecursors()
        Returns a const reference to the precursors
        """
        ...
    
    def setPrecursors(self, in_0: List[Precursor] ) -> None:
        """
        Cython signature: void setPrecursors(libcpp_vector[Precursor])
        Sets the precursors
        """
        ...
    
    def getProducts(self) -> List[Product]:
        """
        Cython signature: libcpp_vector[Product] getProducts()
        Returns a const reference to the products
        """
        ...
    
    def setProducts(self, in_0: List[Product] ) -> None:
        """
        Cython signature: void setProducts(libcpp_vector[Product])
        Sets the products
        """
        ...
    
    def getPeptideIdentifications(self) -> List[PeptideIdentification]:
        """
        Cython signature: libcpp_vector[PeptideIdentification] getPeptideIdentifications()
        Returns a const reference to the PeptideIdentification vector
        """
        ...
    
    def setPeptideIdentifications(self, in_0: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void setPeptideIdentifications(libcpp_vector[PeptideIdentification])
        Sets the PeptideIdentification vector
        """
        ...
    
    def getDataProcessing(self) -> List[DataProcessing]:
        """
        Cython signature: libcpp_vector[shared_ptr[DataProcessing]] getDataProcessing()
        """
        ...
    
    def setDataProcessing(self, in_0: List[DataProcessing] ) -> None:
        """
        Cython signature: void setDataProcessing(libcpp_vector[shared_ptr[DataProcessing]])
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: SpectrumSettings, op: int) -> Any:
        ...
    SpectrumType : __SpectrumType 


class TMTEighteenPlexQuantitationMethod:
    """
    Cython implementation of _TMTEighteenPlexQuantitationMethod

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1TMTEighteenPlexQuantitationMethod.html>`_
      -- Inherits from ['IsobaricQuantitationMethod']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void TMTEighteenPlexQuantitationMethod()
        """
        ...
    
    @overload
    def __init__(self, in_0: TMTEighteenPlexQuantitationMethod ) -> None:
        """
        Cython signature: void TMTEighteenPlexQuantitationMethod(TMTEighteenPlexQuantitationMethod &)
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        """
        ...
    
    def getChannelInformation(self) -> List[IsobaricChannelInformation]:
        """
        Cython signature: libcpp_vector[IsobaricChannelInformation] getChannelInformation()
        """
        ...
    
    def getNumberOfChannels(self) -> int:
        """
        Cython signature: size_t getNumberOfChannels()
        """
        ...
    
    def getIsotopeCorrectionMatrix(self) -> MatrixDouble:
        """
        Cython signature: MatrixDouble getIsotopeCorrectionMatrix()
        """
        ...
    
    def getReferenceChannel(self) -> int:
        """
        Cython signature: size_t getReferenceChannel()
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class TheoreticalIsotopePattern:
    """
    Cython implementation of _TheoreticalIsotopePattern

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::FeatureFinderAlgorithmPickedHelperStructs_1_1TheoreticalIsotopePattern.html>`_
    """
    
    intensity: List[float]
    
    optional_begin: int
    
    optional_end: int
    
    max: float
    
    trimmed_left: int
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void TheoreticalIsotopePattern()
        """
        ...
    
    @overload
    def __init__(self, in_0: TheoreticalIsotopePattern ) -> None:
        """
        Cython signature: void TheoreticalIsotopePattern(TheoreticalIsotopePattern &)
        """
        ...
    
    def size(self) -> int:
        """
        Cython signature: size_t size()
        """
        ... 


class Unit:
    """
    Cython implementation of _Unit

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Unit.html>`_
    """
    
    accession: Union[bytes, str, String]
    
    name: Union[bytes, str, String]
    
    cv_ref: Union[bytes, str, String]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Unit()
        """
        ...
    
    @overload
    def __init__(self, in_0: Unit ) -> None:
        """
        Cython signature: void Unit(Unit)
        """
        ...
    
    @overload
    def __init__(self, p_accession: Union[bytes, str, String] , p_name: Union[bytes, str, String] , p_cv_ref: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void Unit(const String & p_accession, const String & p_name, const String & p_cv_ref)
        """
        ...
    
    def __richcmp__(self, other: Unit, op: int) -> Any:
        ... 


class XLPrecursor:
    """
    Cython implementation of _XLPrecursor

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1XLPrecursor.html>`_
    """
    
    precursor_mass: float
    
    alpha_index: int
    
    beta_index: int
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void XLPrecursor()
        """
        ...
    
    @overload
    def __init__(self, in_0: XLPrecursor ) -> None:
        """
        Cython signature: void XLPrecursor(XLPrecursor &)
        """
        ... 


class XMLHandler:
    """
    Cython implementation of _XMLHandler

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Internal_1_1XMLHandler.html>`_
    """
    
    def __init__(self, filename: Union[bytes, str, String] , version: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void XMLHandler(const String & filename, const String & version)
        """
        ...
    
    def reset(self) -> None:
        """
        Cython signature: void reset()
        """
        ...
    
    def error(self, mode: int , msg: Union[bytes, str, String] , line: int , column: int ) -> None:
        """
        Cython signature: void error(ActionMode mode, const String & msg, unsigned int line, unsigned int column)
        """
        ...
    
    def warning(self, mode: int , msg: Union[bytes, str, String] , line: int , column: int ) -> None:
        """
        Cython signature: void warning(ActionMode mode, const String & msg, unsigned int line, unsigned int column)
        """
        ...
    ActionMode : __ActionMode 


class __ActionMode:
    None
    LOAD : int
    STORE : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class IonOpticsType:
    None
    UNKNOWN : int
    MAGNETIC_DEFLECTION : int
    DELAYED_EXTRACTION : int
    COLLISION_QUADRUPOLE : int
    SELECTED_ION_FLOW_TUBE : int
    TIME_LAG_FOCUSING : int
    REFLECTRON : int
    EINZEL_LENS : int
    FIRST_STABILITY_REGION : int
    FRINGING_FIELD : int
    KINETIC_ENERGY_ANALYZER : int
    STATIC_FIELD : int
    SIZE_OF_IONOPTICSTYPE : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __ProcessingAction:
    None
    DATA_PROCESSING : int
    CHARGE_DECONVOLUTION : int
    DEISOTOPING : int
    SMOOTHING : int
    CHARGE_CALCULATION : int
    PRECURSOR_RECALCULATION : int
    BASELINE_REDUCTION : int
    PEAK_PICKING : int
    ALIGNMENT : int
    CALIBRATION : int
    NORMALIZATION : int
    FILTERING : int
    QUANTITATION : int
    FEATURE_GROUPING : int
    IDENTIFICATION_MAPPING : int
    FORMAT_CONVERSION : int
    CONVERSION_MZDATA : int
    CONVERSION_MZML : int
    CONVERSION_MZXML : int
    CONVERSION_DTA : int
    IDENTIFICATION : int
    SIZE_OF_PROCESSINGACTION : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class SIDE:
    None
    LEFT : int
    RIGHT : int
    BOTH : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __SpectrumType:
    None
    UNKNOWN : int
    CENTROID : int
    PROFILE : int
    SIZE_OF_SPECTRUMTYPE : int

    def getMapping(self) -> Dict[int, str]:
       ... 

