#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified May 23, 2014

Description:  Grades mapping correctness of a sam file of synthetic reads with headers generated by RandomReads3.java

Usage:   gradesam.sh in=<sam file> reads=<number of reads>

Parameters:
in=<file>       Specify the input sam file, or stdin.
reads=<int>     Number of reads in mapper's input (i.e., the fastq file).
thresh=20       Max deviation from correct location to be considered 'loosely correct'.
blasr=f         Set to 't' for BLASR output; fixes extra information added to read names.
ssaha2=f        Set to 't' for SSAHA2 or SMALT output; fixes incorrect soft-clipped read locations.
quality=3       Reads with a mapping quality of this or below will be considered ambiguously mapped.
bitset=t        Track read ID's to detect secondary alignments.
                Necessary for mappers that incorrectly output multiple primary alignments per read.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
For documentation and the latest version, visit: https://bbmap.org
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

function gradesam() {
	local CMD="java $EA $EOOM -Xmx200m -cp $CP align2.GradeSamFile $@"
#	echo $CMD >&2
	eval $CMD
}

gradesam "$@"
