#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified January 20, 2017

Description:  Creates a ROC curve from a sam file of synthetic reads with headers generated by RandomReads3.java

Usage:  samtoroc.sh in=<sam file> reads=<number of reads in input fastq>

Parameters:
in=<file>       Specify the input sam file, or stdin.
thresh=20       Max deviation from correct location to be considered 'loosely correct'.
blasr=f         Set to 't' for BLASR output; fixes extra information added to read names.
ssaha2=f        Set to 't' for SSAHA2 or SMALT output; fixes incorrect soft-clipped read locations.
bitset=t        Track read ID's to detect secondary alignments.
                Necessary for mappers that incorrectly output multiple primary alignments per read.

Java Parameters:
-Xmx            This will set Java's memory usage, overriding autodetection.
                -Xmx20g will specify 20 gigs of RAM, and -Xmx200m will specify 200 megs.
                    The max is typically 85% of physical memory.
-eoom           This flag will cause the process to exit if an out-of-memory
                exception occurs.  Requires Java 8u92+.
-da             Disable assertions.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
For documentation and the latest version, visit: https://bbmap.org
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"

z="-Xmx200m"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

calcXmx () {
	source "$DIR""/calcmem.sh"
	setEnvironment
	parseXmx "$@"
}
calcXmx "$@"

samtoroc() {
	local CMD="java $EA $EOOM $z -cp $CP align2.MakeRocCurve $@"
#	echo $CMD >&2
	eval $CMD
}

samtoroc "$@"
