#!/bin/bash

set -x -e

# adapted from recipes/blast/run_test.sh

TMPDIR=$(mktemp -d)
trap "rm -rf $TMPDIR" 0 INT QUIT ABRT PIPE TERM

cp test*.fa test*.sam $TMPDIR
cd $TMPDIR

#bbmap.sh in=test.fa ref=testdatabase.fa out=result.sam nodisk
#diff <(tail -2 result.sam) testexpected.sam



set -ex



bbmap.sh -V 2>&1 | grep "BBMap" > /dev/null
bbmerge.sh -V 2>&1 | grep "BBMerge" > /dev/null
bbduk.sh -V 2>&1 | grep "BBDuk" > /dev/null
bbmask.sh -V 2>&1 | grep "BBMask" > /dev/null
bbnorm.sh --help 2>&1 | grep "BBNorm" > /dev/null
exit 0
