/////////////////////////////////////////////////////////////////
// GetDefaultComplementaryValues()
//
// Retrieve default parameter values.
/////////////////////////////////////////////////////////////////

template<class RealT>
std::vector<RealT> GetDefaultComplementaryValues()
{
    RealT values[] =
    {
        0.0000000000,        // base_pair_AA
        0.0000000000,        // base_pair_AC
        0.0000000000,        // base_pair_AG
        0.5979119900,        // base_pair_AU
        0.0000000000,        // base_pair_CC
        1.5442906410,        // base_pair_CG
        0.0000000000,        // base_pair_CU
        0.0000000000,        // base_pair_GG
        -0.0130475499,       // base_pair_GU
        0.0000000000,        // base_pair_UU
        0.0000000000,        // terminal_mismatch_AAAA
        0.0000000000,        // terminal_mismatch_AAAC
        0.0000000000,        // terminal_mismatch_AAAG
        0.0000000000,        // terminal_mismatch_AAAU
        0.0000000000,        // terminal_mismatch_AACA
        0.0000000000,        // terminal_mismatch_AACC
        0.0000000000,        // terminal_mismatch_AACG
        0.0000000000,        // terminal_mismatch_AACU
        0.0000000000,        // terminal_mismatch_AAGA
        0.0000000000,        // terminal_mismatch_AAGC
        0.0000000000,        // terminal_mismatch_AAGG
        0.0000000000,        // terminal_mismatch_AAGU
        0.0000000000,        // terminal_mismatch_AAUA
        0.0000000000,        // terminal_mismatch_AAUC
        0.0000000000,        // terminal_mismatch_AAUG
        0.0000000000,        // terminal_mismatch_AAUU
        0.0000000000,        // terminal_mismatch_ACAA
        0.0000000000,        // terminal_mismatch_ACAC
        0.0000000000,        // terminal_mismatch_ACAG
        0.0000000000,        // terminal_mismatch_ACAU
        0.0000000000,        // terminal_mismatch_ACCA
        0.0000000000,        // terminal_mismatch_ACCC
        0.0000000000,        // terminal_mismatch_ACCG
        0.0000000000,        // terminal_mismatch_ACCU
        0.0000000000,        // terminal_mismatch_ACGA
        0.0000000000,        // terminal_mismatch_ACGC
        0.0000000000,        // terminal_mismatch_ACGG
        0.0000000000,        // terminal_mismatch_ACGU
        0.0000000000,        // terminal_mismatch_ACUA
        0.0000000000,        // terminal_mismatch_ACUC
        0.0000000000,        // terminal_mismatch_ACUG
        0.0000000000,        // terminal_mismatch_ACUU
        0.0000000000,        // terminal_mismatch_AGAA
        0.0000000000,        // terminal_mismatch_AGAC
        0.0000000000,        // terminal_mismatch_AGAG
        0.0000000000,        // terminal_mismatch_AGAU
        0.0000000000,        // terminal_mismatch_AGCA
        0.0000000000,        // terminal_mismatch_AGCC
        0.0000000000,        // terminal_mismatch_AGCG
        0.0000000000,        // terminal_mismatch_AGCU
        0.0000000000,        // terminal_mismatch_AGGA
        0.0000000000,        // terminal_mismatch_AGGC
        0.0000000000,        // terminal_mismatch_AGGG
        0.0000000000,        // terminal_mismatch_AGGU
        0.0000000000,        // terminal_mismatch_AGUA
        0.0000000000,        // terminal_mismatch_AGUC
        0.0000000000,        // terminal_mismatch_AGUG
        0.0000000000,        // terminal_mismatch_AGUU
        -0.1845460640,       // terminal_mismatch_AUAA
        -0.1181844187,       // terminal_mismatch_AUAC
        -0.4461469607,       // terminal_mismatch_AUAG
        -0.6175254495,       // terminal_mismatch_AUAU
        0.0047884587,        // terminal_mismatch_AUCA
        0.0831939515,        // terminal_mismatch_AUCC
        -0.2249479995,       // terminal_mismatch_AUCG
        -0.3981327204,       // terminal_mismatch_AUCU
        0.5191110288,        // terminal_mismatch_AUGA
        -0.3524119307,       // terminal_mismatch_AUGC
        -0.4056429433,       // terminal_mismatch_AUGG
        -0.7733932162,       // terminal_mismatch_AUGU
        -0.0157440352,       // terminal_mismatch_AUUA
        0.2685700420,        // terminal_mismatch_AUUC
        -0.0934388741,       // terminal_mismatch_AUUG
        0.3373711531,        // terminal_mismatch_AUUU
        0.0000000000,        // terminal_mismatch_CAAA
        0.0000000000,        // terminal_mismatch_CAAC
        0.0000000000,        // terminal_mismatch_CAAG
        0.0000000000,        // terminal_mismatch_CAAU
        0.0000000000,        // terminal_mismatch_CACA
        0.0000000000,        // terminal_mismatch_CACC
        0.0000000000,        // terminal_mismatch_CACG
        0.0000000000,        // terminal_mismatch_CACU
        0.0000000000,        // terminal_mismatch_CAGA
        0.0000000000,        // terminal_mismatch_CAGC
        0.0000000000,        // terminal_mismatch_CAGG
        0.0000000000,        // terminal_mismatch_CAGU
        0.0000000000,        // terminal_mismatch_CAUA
        0.0000000000,        // terminal_mismatch_CAUC
        0.0000000000,        // terminal_mismatch_CAUG
        0.0000000000,        // terminal_mismatch_CAUU
        0.0000000000,        // terminal_mismatch_CCAA
        0.0000000000,        // terminal_mismatch_CCAC
        0.0000000000,        // terminal_mismatch_CCAG
        0.0000000000,        // terminal_mismatch_CCAU
        0.0000000000,        // terminal_mismatch_CCCA
        0.0000000000,        // terminal_mismatch_CCCC
        0.0000000000,        // terminal_mismatch_CCCG
        0.0000000000,        // terminal_mismatch_CCCU
        0.0000000000,        // terminal_mismatch_CCGA
        0.0000000000,        // terminal_mismatch_CCGC
        0.0000000000,        // terminal_mismatch_CCGG
        0.0000000000,        // terminal_mismatch_CCGU
        0.0000000000,        // terminal_mismatch_CCUA
        0.0000000000,        // terminal_mismatch_CCUC
        0.0000000000,        // terminal_mismatch_CCUG
        0.0000000000,        // terminal_mismatch_CCUU
        0.0838642353,        // terminal_mismatch_CGAA
        -0.2520716816,       // terminal_mismatch_CGAC
        -0.6711841881,       // terminal_mismatch_CGAG
        -0.3816350028,       // terminal_mismatch_CGAU
        0.1117852189,        // terminal_mismatch_CGCA
        -0.1704393624,       // terminal_mismatch_CGCC
        -0.2179987732,       // terminal_mismatch_CGCG
        -0.4592676350,       // terminal_mismatch_CGCU
        0.8520640313,        // terminal_mismatch_CGGA
        -0.9332488517,       // terminal_mismatch_CGGC
        -0.3289551692,       // terminal_mismatch_CGGG
        -0.7778822056,       // terminal_mismatch_CGGU
        -0.2422339958,       // terminal_mismatch_CGUA
        -0.0378050925,       // terminal_mismatch_CGUC
        -0.4322334143,       // terminal_mismatch_CGUG
        -0.2419976114,       // terminal_mismatch_CGUU
        0.0000000000,        // terminal_mismatch_CUAA
        0.0000000000,        // terminal_mismatch_CUAC
        0.0000000000,        // terminal_mismatch_CUAG
        0.0000000000,        // terminal_mismatch_CUAU
        0.0000000000,        // terminal_mismatch_CUCA
        0.0000000000,        // terminal_mismatch_CUCC
        0.0000000000,        // terminal_mismatch_CUCG
        0.0000000000,        // terminal_mismatch_CUCU
        0.0000000000,        // terminal_mismatch_CUGA
        0.0000000000,        // terminal_mismatch_CUGC
        0.0000000000,        // terminal_mismatch_CUGG
        0.0000000000,        // terminal_mismatch_CUGU
        0.0000000000,        // terminal_mismatch_CUUA
        0.0000000000,        // terminal_mismatch_CUUC
        0.0000000000,        // terminal_mismatch_CUUG
        0.0000000000,        // terminal_mismatch_CUUU
        0.0000000000,        // terminal_mismatch_GAAA
        0.0000000000,        // terminal_mismatch_GAAC
        0.0000000000,        // terminal_mismatch_GAAG
        0.0000000000,        // terminal_mismatch_GAAU
        0.0000000000,        // terminal_mismatch_GACA
        0.0000000000,        // terminal_mismatch_GACC
        0.0000000000,        // terminal_mismatch_GACG
        0.0000000000,        // terminal_mismatch_GACU
        0.0000000000,        // terminal_mismatch_GAGA
        0.0000000000,        // terminal_mismatch_GAGC
        0.0000000000,        // terminal_mismatch_GAGG
        0.0000000000,        // terminal_mismatch_GAGU
        0.0000000000,        // terminal_mismatch_GAUA
        0.0000000000,        // terminal_mismatch_GAUC
        0.0000000000,        // terminal_mismatch_GAUG
        0.0000000000,        // terminal_mismatch_GAUU
        -0.1703136025,       // terminal_mismatch_GCAA
        -0.0915405636,       // terminal_mismatch_GCAC
        -0.2522413002,       // terminal_mismatch_GCAG
        -0.8520314799,       // terminal_mismatch_GCAU
        0.0476322419,        // terminal_mismatch_GCCA
        -0.2428654283,       // terminal_mismatch_GCCC
        -0.2079275061,       // terminal_mismatch_GCCG
        -0.1874270053,       // terminal_mismatch_GCCU
        0.6540033983,        // terminal_mismatch_GCGA
        -0.7823988605,       // terminal_mismatch_GCGC
        0.1995898255,        // terminal_mismatch_GCGG
        -0.4432169392,       // terminal_mismatch_GCGU
        -0.1736921762,       // terminal_mismatch_GCUA
        0.2884943620,        // terminal_mismatch_GCUC
        -0.0163823806,       // terminal_mismatch_GCUG
        0.6757988971,        // terminal_mismatch_GCUU
        0.0000000000,        // terminal_mismatch_GGAA
        0.0000000000,        // terminal_mismatch_GGAC
        0.0000000000,        // terminal_mismatch_GGAG
        0.0000000000,        // terminal_mismatch_GGAU
        0.0000000000,        // terminal_mismatch_GGCA
        0.0000000000,        // terminal_mismatch_GGCC
        0.0000000000,        // terminal_mismatch_GGCG
        0.0000000000,        // terminal_mismatch_GGCU
        0.0000000000,        // terminal_mismatch_GGGA
        0.0000000000,        // terminal_mismatch_GGGC
        0.0000000000,        // terminal_mismatch_GGGG
        0.0000000000,        // terminal_mismatch_GGGU
        0.0000000000,        // terminal_mismatch_GGUA
        0.0000000000,        // terminal_mismatch_GGUC
        0.0000000000,        // terminal_mismatch_GGUG
        0.0000000000,        // terminal_mismatch_GGUU
        -0.4871607613,       // terminal_mismatch_GUAA
        0.1105031953,        // terminal_mismatch_GUAC
        0.3633739160,        // terminal_mismatch_GUAG
        -0.6193199348,       // terminal_mismatch_GUAU
        0.3451056056,        // terminal_mismatch_GUCA
        0.0314944976,        // terminal_mismatch_GUCC
        -0.3799172956,       // terminal_mismatch_GUCG
        -0.0322297318,       // terminal_mismatch_GUCU
        0.4948638637,        // terminal_mismatch_GUGA
        -0.2821952552,       // terminal_mismatch_GUGC
        -0.2702227211,       // terminal_mismatch_GUGG
        -0.0665839529,       // terminal_mismatch_GUGU
        -0.4306154451,       // terminal_mismatch_GUUA
        -0.0949786347,       // terminal_mismatch_GUUC
        -0.3130794485,       // terminal_mismatch_GUUG
        -0.2283242981,       // terminal_mismatch_GUUU
        0.0115363879,        // terminal_mismatch_UAAA
        -0.3923408221,       // terminal_mismatch_UAAC
        0.0566106360,        // terminal_mismatch_UAAG
        -0.1251485388,       // terminal_mismatch_UAAU
        -0.0654507476,       // terminal_mismatch_UACA
        -0.3167200568,       // terminal_mismatch_UACC
        0.0022583840,        // terminal_mismatch_UACG
        -0.4222177240,       // terminal_mismatch_UACU
        0.5458416646,        // terminal_mismatch_UAGA
        -0.2085887954,       // terminal_mismatch_UAGC
        -0.1971766062,       // terminal_mismatch_UAGG
        -0.4722410132,       // terminal_mismatch_UAGU
        -0.1779642496,       // terminal_mismatch_UAUA
        0.1643454344,        // terminal_mismatch_UAUC
        -0.5005617032,       // terminal_mismatch_UAUG
        0.1333867679,        // terminal_mismatch_UAUU
        0.0000000000,        // terminal_mismatch_UCAA
        0.0000000000,        // terminal_mismatch_UCAC
        0.0000000000,        // terminal_mismatch_UCAG
        0.0000000000,        // terminal_mismatch_UCAU
        0.0000000000,        // terminal_mismatch_UCCA
        0.0000000000,        // terminal_mismatch_UCCC
        0.0000000000,        // terminal_mismatch_UCCG
        0.0000000000,        // terminal_mismatch_UCCU
        0.0000000000,        // terminal_mismatch_UCGA
        0.0000000000,        // terminal_mismatch_UCGC
        0.0000000000,        // terminal_mismatch_UCGG
        0.0000000000,        // terminal_mismatch_UCGU
        0.0000000000,        // terminal_mismatch_UCUA
        0.0000000000,        // terminal_mismatch_UCUC
        0.0000000000,        // terminal_mismatch_UCUG
        0.0000000000,        // terminal_mismatch_UCUU
        0.1218741278,        // terminal_mismatch_UGAA
        0.1990260141,        // terminal_mismatch_UGAC
        0.0468189393,        // terminal_mismatch_UGAG
        0.3256264491,        // terminal_mismatch_UGAU
        0.1186812326,        // terminal_mismatch_UGCA
        -0.1851065102,       // terminal_mismatch_UGCC
        -0.0431151268,       // terminal_mismatch_UGCG
        -0.6150608139,       // terminal_mismatch_UGCU
        0.7549332180,        // terminal_mismatch_UGGA
        -0.3150708483,       // terminal_mismatch_UGGC
        0.1569582926,        // terminal_mismatch_UGGG
        -0.5149700070,       // terminal_mismatch_UGGU
        -0.2926246029,       // terminal_mismatch_UGUA
        0.1373068149,        // terminal_mismatch_UGUC
        -0.0542233336,       // terminal_mismatch_UGUG
        0.0308677692,        // terminal_mismatch_UGUU
        0.0000000000,        // terminal_mismatch_UUAA
        0.0000000000,        // terminal_mismatch_UUAC
        0.0000000000,        // terminal_mismatch_UUAG
        0.0000000000,        // terminal_mismatch_UUAU
        0.0000000000,        // terminal_mismatch_UUCA
        0.0000000000,        // terminal_mismatch_UUCC
        0.0000000000,        // terminal_mismatch_UUCG
        0.0000000000,        // terminal_mismatch_UUCU
        0.0000000000,        // terminal_mismatch_UUGA
        0.0000000000,        // terminal_mismatch_UUGC
        0.0000000000,        // terminal_mismatch_UUGG
        0.0000000000,        // terminal_mismatch_UUGU
        0.0000000000,        // terminal_mismatch_UUUA
        0.0000000000,        // terminal_mismatch_UUUC
        0.0000000000,        // terminal_mismatch_UUUG
        0.0000000000,        // terminal_mismatch_UUUU
        -5.9931801580,       // hairpin_length_at_least_0
        -3.1081057620,       // hairpin_length_at_least_1
        0.4168976347,        // hairpin_length_at_least_2
        2.2054190660,        // hairpin_length_at_least_3
        1.9267496920,        // hairpin_length_at_least_4
        -0.5873245329,       // hairpin_length_at_least_5
        -0.0827571778,       // hairpin_length_at_least_6
        0.5783889844,        // hairpin_length_at_least_7
        -0.7220883372,       // hairpin_length_at_least_8
        -0.1725874624,       // hairpin_length_at_least_9
        -0.3025089867,       // hairpin_length_at_least_10
        -0.0296315939,       // hairpin_length_at_least_11
        -0.9268995948,       // hairpin_length_at_least_12
        -0.0315775398,       // hairpin_length_at_least_13
        -0.1022472101,       // hairpin_length_at_least_14
        0.1901407346,        // hairpin_length_at_least_15
        -0.0928090983,       // hairpin_length_at_least_16
        0.1690448408,        // hairpin_length_at_least_17
        -0.0817256647,       // hairpin_length_at_least_18
        -0.3445939031,       // hairpin_length_at_least_19
        -0.1091502940,       // hairpin_length_at_least_20
        -0.2903523693,       // hairpin_length_at_least_21
        -0.3393713667,       // hairpin_length_at_least_22
        -0.1915364117,       // hairpin_length_at_least_23
        -0.0501920938,       // hairpin_length_at_least_24
        -0.0387462092,       // hairpin_length_at_least_25
        0.0475147075,        // hairpin_length_at_least_26
        0.0674432193,        // hairpin_length_at_least_27
        0.0972187573,        // hairpin_length_at_least_28
        0.1673131733,        // hairpin_length_at_least_29
        0.2329937249,        // hairpin_length_at_least_30
        -0.1754591076,       // internal_explicit_1_1
        0.0308378710,        // internal_explicit_1_2
        -0.1715654350,       // internal_explicit_1_3
        -0.2294680983,       // internal_explicit_1_4
        -0.1304072693,       // internal_explicit_2_2
        -0.0773032955,       // internal_explicit_2_3
        0.2782767264,        // internal_explicit_2_4
        -0.0289894962,       // internal_explicit_3_3
        0.3112350694,        // internal_explicit_3_4
        -0.3226348245,       // internal_explicit_4_4
        -2.3995484720,       // bulge_length_at_least_1
        -0.8945183117,       // bulge_length_at_least_2
        -0.9088550909,       // bulge_length_at_least_3
        -0.8412474755,       // bulge_length_at_least_4
        -0.4365479343,       // bulge_length_at_least_5
        -0.5699187801,       // bulge_length_at_least_6
        0.2002834224,        // bulge_length_at_least_7
        0.7538761358,        // bulge_length_at_least_8
        -0.6045045455,       // bulge_length_at_least_9
        -0.7200948098,       // bulge_length_at_least_10
        -0.5136721921,       // bulge_length_at_least_11
        -0.3614726679,       // bulge_length_at_least_12
        -0.2614454392,       // bulge_length_at_least_13
        -0.1593926893,       // bulge_length_at_least_14
        -0.0862466828,       // bulge_length_at_least_15
        -0.0310709100,       // bulge_length_at_least_16
        -0.0109722203,       // bulge_length_at_least_17
        0.0300122028,        // bulge_length_at_least_18
        0.0475912379,        // bulge_length_at_least_19
        -0.0429617207,       // bulge_length_at_least_20
        -0.0179189966,       // bulge_length_at_least_21
        -0.0780055152,       // bulge_length_at_least_22
        -0.0709932643,       // bulge_length_at_least_23
        -0.0576795290,       // bulge_length_at_least_24
        -0.0463379468,       // bulge_length_at_least_25
        -0.0355942046,       // bulge_length_at_least_26
        -0.0267493439,       // bulge_length_at_least_27
        -0.0181895797,       // bulge_length_at_least_28
        -0.0105230073,       // bulge_length_at_least_29
        -0.0051536268,       // bulge_length_at_least_30
        -0.4290614430,       // internal_length_at_least_2
        -0.3532111501,       // internal_length_at_least_3
        -0.3963797535,       // internal_length_at_least_4
        -0.3111199175,       // internal_length_at_least_5
        -0.2551945472,       // internal_length_at_least_6
        -0.0514911690,       // internal_length_at_least_7
        -0.0431900241,       // internal_length_at_least_8
        0.0019854895,        // internal_length_at_least_9
        -0.1761513136,       // internal_length_at_least_10
        -0.2639686207,       // internal_length_at_least_11
        -0.3460613577,       // internal_length_at_least_12
        -0.2926603079,       // internal_length_at_least_13
        -0.0362425031,       // internal_length_at_least_14
        -0.1199953761,       // internal_length_at_least_15
        -0.0435477193,       // internal_length_at_least_16
        -0.0820929313,       // internal_length_at_least_17
        -0.0071132260,       // internal_length_at_least_18
        0.0235482485,        // internal_length_at_least_19
        0.0306697357,        // internal_length_at_least_20
        -0.0661824109,       // internal_length_at_least_21
        -0.1316092383,       // internal_length_at_least_22
        -0.1407995514,       // internal_length_at_least_23
        -0.0660029186,       // internal_length_at_least_24
        -0.0777920474,       // internal_length_at_least_25
        -0.0508420126,       // internal_length_at_least_26
        -0.0413987560,       // internal_length_at_least_27
        0.0032765834,        // internal_length_at_least_28
        0.0059245828,        // internal_length_at_least_29
        0.0068757380,        // internal_length_at_least_30
        -0.5467082599,       // internal_symmetric_length_at_least_1
        -0.3854701647,       // internal_symmetric_length_at_least_2
        -0.2588466401,       // internal_symmetric_length_at_least_3
        -0.2340836745,       // internal_symmetric_length_at_least_4
        0.1450577765,        // internal_symmetric_length_at_least_5
        -0.6562932515,       // internal_symmetric_length_at_least_6
        -0.3021088369,       // internal_symmetric_length_at_least_7
        -0.0303227527,       // internal_symmetric_length_at_least_8
        -0.3517944058,       // internal_symmetric_length_at_least_9
        -0.2159132506,       // internal_symmetric_length_at_least_10
        -0.1228270454,       // internal_symmetric_length_at_least_11
        -0.1552208595,       // internal_symmetric_length_at_least_12
        -0.0854112074,       // internal_symmetric_length_at_least_13
        -0.0459210980,       // internal_symmetric_length_at_least_14
        -0.0223223424,       // internal_symmetric_length_at_least_15
        -2.1056467190,       // internal_asymmetry_at_least_1
        -0.5520140431,       // internal_asymmetry_at_least_2
        -0.5770707670,       // internal_asymmetry_at_least_3
        -0.6136667847,       // internal_asymmetry_at_least_4
        -0.3057156841,       // internal_asymmetry_at_least_5
        -0.1155052001,       // internal_asymmetry_at_least_6
        -0.2105612231,       // internal_asymmetry_at_least_7
        -0.3145743130,       // internal_asymmetry_at_least_8
        -0.3148961681,       // internal_asymmetry_at_least_9
        -0.0901818949,       // internal_asymmetry_at_least_10
        -0.2200026794,       // internal_asymmetry_at_least_11
        -0.1406483243,       // internal_asymmetry_at_least_12
        -0.2162411259,       // internal_asymmetry_at_least_13
        -0.1725531435,       // internal_asymmetry_at_least_14
        -0.1558911866,       // internal_asymmetry_at_least_15
        -0.1040858663,       // internal_asymmetry_at_least_16
        -0.0696768423,       // internal_asymmetry_at_least_17
        -0.0410597749,       // internal_asymmetry_at_least_18
        -0.0157062432,       // internal_asymmetry_at_least_19
        0.0138200064,        // internal_asymmetry_at_least_20
        0.0413198856,        // internal_asymmetry_at_least_21
        0.0359418595,        // internal_asymmetry_at_least_22
        0.0282218628,        // internal_asymmetry_at_least_23
        0.0163658587,        // internal_asymmetry_at_least_24
        0.0255005618,        // internal_asymmetry_at_least_25
        0.0334803279,        // internal_asymmetry_at_least_26
        0.0397192441,        // internal_asymmetry_at_least_27
        -0.0025451139,       // internal_asymmetry_at_least_28
        -0.1216861662,       // bulge_0x1_nucleotides_A
        -0.0711124113,       // bulge_0x1_nucleotides_C
        0.0089470266,        // bulge_0x1_nucleotides_G
        -0.0026857637,       // bulge_0x1_nucleotides_U
        0.2944404686,        // internal_1x1_nucleotides_AA
        0.0864136097,        // internal_1x1_nucleotides_AC
        -0.3664197228,       // internal_1x1_nucleotides_AG
        -0.2053107048,       // internal_1x1_nucleotides_AU
        -0.1582543624,       // internal_1x1_nucleotides_CC
        0.4175273724,        // internal_1x1_nucleotides_CG
        0.1368762582,        // internal_1x1_nucleotides_CU
        -0.1193514754,       // internal_1x1_nucleotides_GG
        -0.4188101413,       // internal_1x1_nucleotides_GU
        0.1471406530,        // internal_1x1_nucleotides_UU
        0.0000000000,        // helix_stacking_AAAA
        0.0000000000,        // helix_stacking_AAAC
        0.0000000000,        // helix_stacking_AAAG
        0.0000000000,        // helix_stacking_AAAU
        0.0000000000,        // helix_stacking_AACA
        0.0000000000,        // helix_stacking_AACC
        0.0000000000,        // helix_stacking_AACG
        0.0000000000,        // helix_stacking_AACU
        0.0000000000,        // helix_stacking_AAGA
        0.0000000000,        // helix_stacking_AAGC
        0.0000000000,        // helix_stacking_AAGG
        0.0000000000,        // helix_stacking_AAGU
        0.0000000000,        // helix_stacking_AAUA
        0.0000000000,        // helix_stacking_AAUC
        0.0000000000,        // helix_stacking_AAUG
        0.0000000000,        // helix_stacking_AAUU
        0.0000000000,        // helix_stacking_ACAC
        0.0000000000,        // helix_stacking_ACAG
        0.0000000000,        // helix_stacking_ACAU
        0.0000000000,        // helix_stacking_ACCA
        0.0000000000,        // helix_stacking_ACCC
        0.0000000000,        // helix_stacking_ACCG
        0.0000000000,        // helix_stacking_ACCU
        0.0000000000,        // helix_stacking_ACGA
        0.0000000000,        // helix_stacking_ACGC
        0.0000000000,        // helix_stacking_ACGG
        0.0000000000,        // helix_stacking_ACGU
        0.0000000000,        // helix_stacking_ACUA
        0.0000000000,        // helix_stacking_ACUC
        0.0000000000,        // helix_stacking_ACUG
        0.0000000000,        // helix_stacking_ACUU
        0.0000000000,        // helix_stacking_AGAC
        0.0000000000,        // helix_stacking_AGAG
        0.0000000000,        // helix_stacking_AGAU
        0.0000000000,        // helix_stacking_AGCC
        0.0000000000,        // helix_stacking_AGCG
        0.0000000000,        // helix_stacking_AGCU
        0.0000000000,        // helix_stacking_AGGA
        0.0000000000,        // helix_stacking_AGGC
        0.0000000000,        // helix_stacking_AGGG
        0.0000000000,        // helix_stacking_AGGU
        0.0000000000,        // helix_stacking_AGUA
        0.0000000000,        // helix_stacking_AGUC
        0.0000000000,        // helix_stacking_AGUG
        0.0000000000,        // helix_stacking_AGUU
        0.0000000000,        // helix_stacking_AUAC
        0.0000000000,        // helix_stacking_AUAG
        0.1482005248,        // helix_stacking_AUAU
        0.0000000000,        // helix_stacking_AUCC
        0.4343497127,        // helix_stacking_AUCG
        0.0000000000,        // helix_stacking_AUCU
        0.7079642577,        // helix_stacking_AUGC
        0.0000000000,        // helix_stacking_AUGG
        -0.1010777582,       // helix_stacking_AUGU
        0.2432566560,        // helix_stacking_AUUA
        0.0000000000,        // helix_stacking_AUUC
        0.1623654243,        // helix_stacking_AUUG
        0.0000000000,        // helix_stacking_AUUU
        0.0000000000,        // helix_stacking_CAAC
        0.0000000000,        // helix_stacking_CAAG
        0.0000000000,        // helix_stacking_CAAU
        0.0000000000,        // helix_stacking_CACC
        0.0000000000,        // helix_stacking_CACG
        0.0000000000,        // helix_stacking_CACU
        0.0000000000,        // helix_stacking_CAGC
        0.0000000000,        // helix_stacking_CAGG
        0.0000000000,        // helix_stacking_CAGU
        0.0000000000,        // helix_stacking_CAUC
        0.0000000000,        // helix_stacking_CAUG
        0.0000000000,        // helix_stacking_CAUU
        0.0000000000,        // helix_stacking_CCAG
        0.0000000000,        // helix_stacking_CCAU
        0.0000000000,        // helix_stacking_CCCC
        0.0000000000,        // helix_stacking_CCCG
        0.0000000000,        // helix_stacking_CCCU
        0.0000000000,        // helix_stacking_CCGC
        0.0000000000,        // helix_stacking_CCGG
        0.0000000000,        // helix_stacking_CCGU
        0.0000000000,        // helix_stacking_CCUC
        0.0000000000,        // helix_stacking_CCUG
        0.0000000000,        // helix_stacking_CCUU
        0.0000000000,        // helix_stacking_CGAG
        0.4878707793,        // helix_stacking_CGAU
        0.8481320247,        // helix_stacking_CGCG
        0.0000000000,        // helix_stacking_CGCU
        0.4784248478,        // helix_stacking_CGGC
        0.0000000000,        // helix_stacking_CGGG
        -0.1811268205,       // helix_stacking_CGGU
        0.0000000000,        // helix_stacking_CGUC
        0.4849351028,        // helix_stacking_CGUG
        0.0000000000,        // helix_stacking_CGUU
        0.0000000000,        // helix_stacking_CUAG
        0.0000000000,        // helix_stacking_CUAU
        0.0000000000,        // helix_stacking_CUCG
        0.0000000000,        // helix_stacking_CUCU
        0.0000000000,        // helix_stacking_CUGG
        0.0000000000,        // helix_stacking_CUGU
        0.0000000000,        // helix_stacking_CUUC
        0.0000000000,        // helix_stacking_CUUG
        0.0000000000,        // helix_stacking_CUUU
        0.0000000000,        // helix_stacking_GAAG
        0.0000000000,        // helix_stacking_GAAU
        0.0000000000,        // helix_stacking_GACG
        0.0000000000,        // helix_stacking_GACU
        0.0000000000,        // helix_stacking_GAGG
        0.0000000000,        // helix_stacking_GAGU
        0.0000000000,        // helix_stacking_GAUG
        0.0000000000,        // helix_stacking_GAUU
        0.5551785831,        // helix_stacking_GCAU
        0.5008324248,        // helix_stacking_GCCG
        0.0000000000,        // helix_stacking_GCCU
        0.0000000000,        // helix_stacking_GCGG
        0.2165962476,        // helix_stacking_GCGU
        0.4864603589,        // helix_stacking_GCUG
        0.0000000000,        // helix_stacking_GCUU
        0.0000000000,        // helix_stacking_GGAU
        0.0000000000,        // helix_stacking_GGCU
        0.0000000000,        // helix_stacking_GGGG
        0.0000000000,        // helix_stacking_GGGU
        0.0000000000,        // helix_stacking_GGUG
        0.0000000000,        // helix_stacking_GGUU
        -0.0466536503,       // helix_stacking_GUAU
        0.0000000000,        // helix_stacking_GUCU
        0.1833447295,        // helix_stacking_GUGU
        -0.2858970755,       // helix_stacking_GUUG
        0.0000000000,        // helix_stacking_GUUU
        0.3897593783,        // helix_stacking_UAAU
        0.0000000000,        // helix_stacking_UACU
        -0.1157333764,       // helix_stacking_UAGU
        0.0000000000,        // helix_stacking_UAUU
        0.0000000000,        // helix_stacking_UCCU
        0.0000000000,        // helix_stacking_UCGU
        0.0000000000,        // helix_stacking_UCUU
        0.1202965380,        // helix_stacking_UGGU
        0.0000000000,        // helix_stacking_UGUU
        0.0000000000,        // helix_stacking_UUUU
        0.0000000000,        // helix_closing_AA
        0.0000000000,        // helix_closing_AC
        0.0000000000,        // helix_closing_AG
        -0.9770893163,       // helix_closing_AU
        0.0000000000,        // helix_closing_CA
        0.0000000000,        // helix_closing_CC
        -0.4574650937,       // helix_closing_CG
        0.0000000000,        // helix_closing_CU
        0.0000000000,        // helix_closing_GA
        -0.8265995623,       // helix_closing_GC
        0.0000000000,        // helix_closing_GG
        -1.0516789280,       // helix_closing_GU
        -0.9246140521,       // helix_closing_UA
        0.0000000000,        // helix_closing_UC
        -0.3698708172,       // helix_closing_UG
        0.0000000000,        // helix_closing_UU
        -1.1990550760,       // multi_base
        -0.1983300391,       // multi_unpaired
        -0.9253883752,       // multi_paired
        0.0000000000,        // dangle_left_AAA
        0.0000000000,        // dangle_left_AAC
        0.0000000000,        // dangle_left_AAG
        0.0000000000,        // dangle_left_AAU
        0.0000000000,        // dangle_left_ACA
        0.0000000000,        // dangle_left_ACC
        0.0000000000,        // dangle_left_ACG
        0.0000000000,        // dangle_left_ACU
        0.0000000000,        // dangle_left_AGA
        0.0000000000,        // dangle_left_AGC
        0.0000000000,        // dangle_left_AGG
        0.0000000000,        // dangle_left_AGU
        -0.1251037681,       // dangle_left_AUA
        0.0441606708,        // dangle_left_AUC
        -0.0254187908,       // dangle_left_AUG
        0.0078509847,        // dangle_left_AUU
        0.0000000000,        // dangle_left_CAA
        0.0000000000,        // dangle_left_CAC
        0.0000000000,        // dangle_left_CAG
        0.0000000000,        // dangle_left_CAU
        0.0000000000,        // dangle_left_CCA
        0.0000000000,        // dangle_left_CCC
        0.0000000000,        // dangle_left_CCG
        0.0000000000,        // dangle_left_CCU
        0.0722438137,        // dangle_left_CGA
        0.0527928187,        // dangle_left_CGC
        0.1009554299,        // dangle_left_CGG
        -0.1515059013,       // dangle_left_CGU
        0.0000000000,        // dangle_left_CUA
        0.0000000000,        // dangle_left_CUC
        0.0000000000,        // dangle_left_CUG
        0.0000000000,        // dangle_left_CUU
        0.0000000000,        // dangle_left_GAA
        0.0000000000,        // dangle_left_GAC
        0.0000000000,        // dangle_left_GAG
        0.0000000000,        // dangle_left_GAU
        -0.1829535099,       // dangle_left_GCA
        0.0339300039,        // dangle_left_GCC
        0.1335339061,        // dangle_left_GCG
        -0.1604274506,       // dangle_left_GCU
        0.0000000000,        // dangle_left_GGA
        0.0000000000,        // dangle_left_GGC
        0.0000000000,        // dangle_left_GGG
        0.0000000000,        // dangle_left_GGU
        -0.0651751134,       // dangle_left_GUA
        -0.0425088242,       // dangle_left_GUC
        0.0287597181,        // dangle_left_GUG
        -0.0435972743,       // dangle_left_GUU
        -0.0337384766,       // dangle_left_UAA
        -0.0050703243,       // dangle_left_UAC
        -0.1186861149,       // dangle_left_UAG
        -0.0116235773,       // dangle_left_UAU
        0.0000000000,        // dangle_left_UCA
        0.0000000000,        // dangle_left_UCC
        0.0000000000,        // dangle_left_UCG
        0.0000000000,        // dangle_left_UCU
        -0.0804713915,       // dangle_left_UGA
        0.0016080007,        // dangle_left_UGC
        0.1016272216,        // dangle_left_UGG
        -0.0920084283,       // dangle_left_UGU
        0.0000000000,        // dangle_left_UUA
        0.0000000000,        // dangle_left_UUC
        0.0000000000,        // dangle_left_UUG
        0.0000000000,        // dangle_left_UUU
        0.0000000000,        // dangle_right_AAA
        0.0000000000,        // dangle_right_AAC
        0.0000000000,        // dangle_right_AAG
        0.0000000000,        // dangle_right_AAU
        0.0000000000,        // dangle_right_ACA
        0.0000000000,        // dangle_right_ACC
        0.0000000000,        // dangle_right_ACG
        0.0000000000,        // dangle_right_ACU
        0.0000000000,        // dangle_right_AGA
        0.0000000000,        // dangle_right_AGC
        0.0000000000,        // dangle_right_AGG
        0.0000000000,        // dangle_right_AGU
        0.0323257820,        // dangle_right_AUA
        -0.0909681949,       // dangle_right_AUC
        -0.0740750973,       // dangle_right_AUG
        -0.0162115738,       // dangle_right_AUU
        0.0000000000,        // dangle_right_CAA
        0.0000000000,        // dangle_right_CAC
        0.0000000000,        // dangle_right_CAG
        0.0000000000,        // dangle_right_CAU
        0.0000000000,        // dangle_right_CCA
        0.0000000000,        // dangle_right_CCC
        0.0000000000,        // dangle_right_CCG
        0.0000000000,        // dangle_right_CCU
        0.2133964379,        // dangle_right_CGA
        -0.0623481099,       // dangle_right_CGC
        -0.0700853104,       // dangle_right_CGG
        -0.2141912285,       // dangle_right_CGU
        0.0000000000,        // dangle_right_CUA
        0.0000000000,        // dangle_right_CUC
        0.0000000000,        // dangle_right_CUG
        0.0000000000,        // dangle_right_CUU
        0.0000000000,        // dangle_right_GAA
        0.0000000000,        // dangle_right_GAC
        0.0000000000,        // dangle_right_GAG
        0.0000000000,        // dangle_right_GAU
        0.0158195755,        // dangle_right_GCA
        0.0056443201,        // dangle_right_GCC
        -0.0094329769,       // dangle_right_GCG
        -0.2597793095,       // dangle_right_GCU
        0.0000000000,        // dangle_right_GGA
        0.0000000000,        // dangle_right_GGC
        0.0000000000,        // dangle_right_GGG
        0.0000000000,        // dangle_right_GGU
        -0.0448027178,       // dangle_right_GUA
        -0.0732121300,       // dangle_right_GUC
        0.0127049487,        // dangle_right_GUG
        -0.0571703399,       // dangle_right_GUU
        -0.1631918513,       // dangle_right_UAA
        0.0676930499,        // dangle_right_UAC
        -0.0878907441,       // dangle_right_UAG
        -0.0552557001,       // dangle_right_UAU
        0.0000000000,        // dangle_right_UCA
        0.0000000000,        // dangle_right_UCC
        0.0000000000,        // dangle_right_UCG
        0.0000000000,        // dangle_right_UCU
        0.0410545819,        // dangle_right_UGA
        -0.0081366426,       // dangle_right_UGC
        -0.0380859202,       // dangle_right_UGG
        -0.0862937343,       // dangle_right_UGU
        0.0000000000,        // dangle_right_UUA
        0.0000000000,        // dangle_right_UUC
        0.0000000000,        // dangle_right_UUG
        0.0000000000,        // dangle_right_UUU
        -0.0097288309,       // external_unpaired
        -0.0009674111        // external_paired
    };

    return std::vector<RealT>(values, values + 708);
}


/////////////////////////////////////////////////////////////////
// GetDefaultNoncomplementaryValues()
//
// Retrieve default parameter values.
/////////////////////////////////////////////////////////////////

template<class RealT>
std::vector<RealT> GetDefaultNoncomplementaryValues()
{
    RealT values[] =
    {
        -1.4553810520,       // base_pair_AA
        -1.6811729540,       // base_pair_AC
        -1.4749457500,       // base_pair_AG
        -0.0876653056,       // base_pair_AU
        -1.4522350750,       // base_pair_CC
        0.8402649820,        // base_pair_CG
        -1.7459919730,       // base_pair_CU
        -1.3034063060,       // base_pair_GG
        -0.3219267076,       // base_pair_GU
        -1.1196768820,       // base_pair_UU
        0.0354865073,        // terminal_mismatch_AAAA
        -0.1530635317,       // terminal_mismatch_AAAC
        -0.1376895893,       // terminal_mismatch_AAAG
        -0.0976081047,       // terminal_mismatch_AAAU
        -0.0901562693,       // terminal_mismatch_AACA
        -0.0173477569,       // terminal_mismatch_AACC
        -0.0511912910,       // terminal_mismatch_AACG
        -0.0276276206,       // terminal_mismatch_AACU
        0.1157343804,        // terminal_mismatch_AAGA
        0.0480545698,        // terminal_mismatch_AAGC
        -0.1768981931,       // terminal_mismatch_AAGG
        -0.0413001097,       // terminal_mismatch_AAGU
        -0.0564212344,       // terminal_mismatch_AAUA
        0.0402627577,        // terminal_mismatch_AAUC
        -0.1131403360,       // terminal_mismatch_AAUG
        0.2857400342,        // terminal_mismatch_AAUU
        -0.0317494979,       // terminal_mismatch_ACAA
        -0.0558409921,       // terminal_mismatch_ACAC
        -0.1095104674,       // terminal_mismatch_ACAG
        0.0788614779,        // terminal_mismatch_ACAU
        0.2040702031,        // terminal_mismatch_ACCA
        0.0242609466,        // terminal_mismatch_ACCC
        -0.0673221061,       // terminal_mismatch_ACCG
        -0.0337625797,       // terminal_mismatch_ACCU
        0.0144758186,        // terminal_mismatch_ACGA
        -0.0181655414,       // terminal_mismatch_ACGC
        -0.0123244933,       // terminal_mismatch_ACGG
        0.0220538040,        // terminal_mismatch_ACGU
        -0.0954346345,       // terminal_mismatch_ACUA
        0.0249455833,        // terminal_mismatch_ACUC
        -0.0518815910,       // terminal_mismatch_ACUG
        -0.0927614943,       // terminal_mismatch_ACUU
        -0.0848231848,       // terminal_mismatch_AGAA
        -0.0794464582,       // terminal_mismatch_AGAC
        -0.1037895444,       // terminal_mismatch_AGAG
        -0.0949604634,       // terminal_mismatch_AGAU
        -0.0420234813,       // terminal_mismatch_AGCA
        0.0434131739,        // terminal_mismatch_AGCC
        0.2132451101,        // terminal_mismatch_AGCG
        0.1819992194,        // terminal_mismatch_AGCU
        -0.1623879358,       // terminal_mismatch_AGGA
        -0.0888318631,       // terminal_mismatch_AGGC
        -0.0829075809,       // terminal_mismatch_AGGG
        0.0594955867,        // terminal_mismatch_AGGU
        -0.0611732190,       // terminal_mismatch_AGUA
        -0.0612852178,       // terminal_mismatch_AGUC
        -0.1054431644,       // terminal_mismatch_AGUG
        0.0694935639,        // terminal_mismatch_AGUU
        -0.0045851066,       // terminal_mismatch_AUAA
        -0.0787888743,       // terminal_mismatch_AUAC
        -0.0261926842,       // terminal_mismatch_AUAG
        -0.3376671294,       // terminal_mismatch_AUAU
        0.1407209183,        // terminal_mismatch_AUCA
        0.1963991331,        // terminal_mismatch_AUCC
        0.0982888945,        // terminal_mismatch_AUCG
        -0.3588639465,       // terminal_mismatch_AUCU
        0.4005052091,        // terminal_mismatch_AUGA
        0.0178195832,        // terminal_mismatch_AUGC
        0.0494665502,        // terminal_mismatch_AUGG
        -0.2847832400,       // terminal_mismatch_AUGU
        0.0082631685,        // terminal_mismatch_AUUA
        0.1196292682,        // terminal_mismatch_AUUC
        -0.1635291659,       // terminal_mismatch_AUUG
        0.2247224398,        // terminal_mismatch_AUUU
        -0.1898713443,       // terminal_mismatch_CAAA
        -0.0333566729,       // terminal_mismatch_CAAC
        0.0872316791,        // terminal_mismatch_CAAG
        -0.0717281695,       // terminal_mismatch_CAAU
        -0.0219850401,       // terminal_mismatch_CACA
        -0.0553786664,       // terminal_mismatch_CACC
        -0.0970147097,       // terminal_mismatch_CACG
        -0.0890545223,       // terminal_mismatch_CACU
        0.1678518209,        // terminal_mismatch_CAGA
        -0.0635231872,       // terminal_mismatch_CAGC
        0.0618238264,        // terminal_mismatch_CAGG
        -0.0490267003,       // terminal_mismatch_CAGU
        -0.0613188256,       // terminal_mismatch_CAUA
        -0.0792933062,       // terminal_mismatch_CAUC
        -0.1723035626,       // terminal_mismatch_CAUG
        0.1880000212,        // terminal_mismatch_CAUU
        -0.0017250768,       // terminal_mismatch_CCAA
        -0.1354308286,       // terminal_mismatch_CCAC
        0.1624126758,        // terminal_mismatch_CCAG
        -0.0692794425,       // terminal_mismatch_CCAU
        -0.1537286390,       // terminal_mismatch_CCCA
        -0.0734554444,       // terminal_mismatch_CCCC
        0.0068614142,        // terminal_mismatch_CCCG
        -0.0773961705,       // terminal_mismatch_CCCU
        0.1364828673,        // terminal_mismatch_CCGA
        -0.0516673223,       // terminal_mismatch_CCGC
        0.2693659476,        // terminal_mismatch_CCGG
        0.1065688311,        // terminal_mismatch_CCGU
        -0.1021275330,       // terminal_mismatch_CCUA
        -0.0470691918,       // terminal_mismatch_CCUC
        0.0453145799,        // terminal_mismatch_CCUG
        -0.1436397983,       // terminal_mismatch_CCUU
        0.3029696819,        // terminal_mismatch_CGAA
        -0.0941403715,       // terminal_mismatch_CGAC
        -0.1515946813,       // terminal_mismatch_CGAG
        -0.2189502915,       // terminal_mismatch_CGAU
        0.2069876839,        // terminal_mismatch_CGCA
        0.0294577389,        // terminal_mismatch_CGCC
        0.1520809123,        // terminal_mismatch_CGCG
        0.2517091925,        // terminal_mismatch_CGCU
        0.4215461402,        // terminal_mismatch_CGGA
        -0.3878585773,       // terminal_mismatch_CGGC
        0.1308663325,        // terminal_mismatch_CGGG
        -0.4961206727,       // terminal_mismatch_CGGU
        -0.2549457084,       // terminal_mismatch_CGUA
        -0.1386448896,       // terminal_mismatch_CGUC
        -0.1523039446,       // terminal_mismatch_CGUG
        0.0879390997,        // terminal_mismatch_CGUU
        0.0638783798,        // terminal_mismatch_CUAA
        -0.0781217458,       // terminal_mismatch_CUAC
        0.1052978704,        // terminal_mismatch_CUAG
        -0.0824793182,       // terminal_mismatch_CUAU
        -0.0745853021,       // terminal_mismatch_CUCA
        -0.1149551661,       // terminal_mismatch_CUCC
        -0.0746381790,       // terminal_mismatch_CUCG
        0.0037041991,        // terminal_mismatch_CUCU
        -0.0561484947,       // terminal_mismatch_CUGA
        -0.0797613716,       // terminal_mismatch_CUGC
        0.0529088365,        // terminal_mismatch_CUGG
        -0.0961321157,       // terminal_mismatch_CUGU
        0.1260507476,        // terminal_mismatch_CUUA
        0.0596327155,        // terminal_mismatch_CUUC
        0.0325063751,        // terminal_mismatch_CUUG
        -0.0550074397,       // terminal_mismatch_CUUU
        0.3319532212,        // terminal_mismatch_GAAA
        -0.0232540841,       // terminal_mismatch_GAAC
        -0.0788848188,       // terminal_mismatch_GAAG
        -0.0491212286,       // terminal_mismatch_GAAU
        -0.1480164013,       // terminal_mismatch_GACA
        0.0971988160,        // terminal_mismatch_GACC
        -0.0819417006,       // terminal_mismatch_GACG
        -0.0307180827,       // terminal_mismatch_GACU
        0.1596878404,        // terminal_mismatch_GAGA
        -0.0313071233,       // terminal_mismatch_GAGC
        -0.1694026596,       // terminal_mismatch_GAGG
        -0.0293065150,       // terminal_mismatch_GAGU
        -0.0635010819,       // terminal_mismatch_GAUA
        -0.0213256998,       // terminal_mismatch_GAUC
        0.0031648068,        // terminal_mismatch_GAUG
        0.0414446294,        // terminal_mismatch_GAUU
        -0.0107456522,       // terminal_mismatch_GCAA
        -0.2344372673,       // terminal_mismatch_GCAC
        0.1235368250,        // terminal_mismatch_GCAG
        -0.3240115044,       // terminal_mismatch_GCAU
        -0.2463240629,       // terminal_mismatch_GCCA
        0.0812993583,        // terminal_mismatch_GCCC
        -0.3418477741,       // terminal_mismatch_GCCG
        0.1141264232,        // terminal_mismatch_GCCU
        0.4502405743,        // terminal_mismatch_GCGA
        -0.1295241897,       // terminal_mismatch_GCGC
        0.1976837690,        // terminal_mismatch_GCGG
        -0.5725821693,       // terminal_mismatch_GCGU
        -0.2527075422,       // terminal_mismatch_GCUA
        0.1861584031,        // terminal_mismatch_GCUC
        0.1973216517,        // terminal_mismatch_GCUG
        0.5585036196,        // terminal_mismatch_GCUU
        -0.0447027731,       // terminal_mismatch_GGAA
        -0.0172432983,       // terminal_mismatch_GGAC
        -0.1217482982,       // terminal_mismatch_GGAG
        -0.1684999018,       // terminal_mismatch_GGAU
        0.0280178196,        // terminal_mismatch_GGCA
        -0.0167422392,       // terminal_mismatch_GGCC
        -0.0350423273,       // terminal_mismatch_GGCG
        -0.0327612057,       // terminal_mismatch_GGCU
        -0.0133016361,       // terminal_mismatch_GGGA
        0.0104729725,        // terminal_mismatch_GGGC
        0.3582150361,        // terminal_mismatch_GGGG
        -0.0301061889,       // terminal_mismatch_GGGU
        -0.1529902536,       // terminal_mismatch_GGUA
        -0.0770899002,       // terminal_mismatch_GGUC
        -0.0201977032,       // terminal_mismatch_GGUG
        0.0585588028,        // terminal_mismatch_GGUU
        -0.0825799796,       // terminal_mismatch_GUAA
        0.1861922864,        // terminal_mismatch_GUAC
        0.0300896357,        // terminal_mismatch_GUAG
        -0.3405347249,       // terminal_mismatch_GUAU
        0.3747115441,        // terminal_mismatch_GUCA
        0.1923350740,        // terminal_mismatch_GUCC
        -0.1968330458,       // terminal_mismatch_GUCG
        0.0706461954,        // terminal_mismatch_GUCU
        -0.1505860398,       // terminal_mismatch_GUGA
        -0.1310959680,       // terminal_mismatch_GUGC
        0.0688261318,        // terminal_mismatch_GUGG
        -0.0310167970,       // terminal_mismatch_GUGU
        -0.0882400497,       // terminal_mismatch_GUUA
        0.1283837462,        // terminal_mismatch_GUUC
        -0.1385590960,       // terminal_mismatch_GUUG
        -0.0300234821,       // terminal_mismatch_GUUU
        0.0228308237,        // terminal_mismatch_UAAA
        -0.1983025729,       // terminal_mismatch_UAAC
        0.0974699976,        // terminal_mismatch_UAAG
        -0.1433175754,       // terminal_mismatch_UAAU
        0.1996635373,        // terminal_mismatch_UACA
        0.1225010573,        // terminal_mismatch_UACC
        0.2514404349,        // terminal_mismatch_UACG
        -0.0435151795,       // terminal_mismatch_UACU
        0.2185566232,        // terminal_mismatch_UAGA
        -0.0067251441,       // terminal_mismatch_UAGC
        -0.0490701609,       // terminal_mismatch_UAGG
        -0.2602507314,       // terminal_mismatch_UAGU
        0.0218557215,        // terminal_mismatch_UAUA
        0.1683684793,        // terminal_mismatch_UAUC
        -0.1971153840,       // terminal_mismatch_UAUG
        0.0999160464,        // terminal_mismatch_UAUU
        0.0475439701,        // terminal_mismatch_UCAA
        -0.1076421324,       // terminal_mismatch_UCAC
        0.0005462953,        // terminal_mismatch_UCAG
        -0.0907500387,       // terminal_mismatch_UCAU
        -0.0099295948,       // terminal_mismatch_UCCA
        0.0862504944,        // terminal_mismatch_UCCC
        0.0101638720,        // terminal_mismatch_UCCG
        -0.0388469035,       // terminal_mismatch_UCCU
        0.0793779168,        // terminal_mismatch_UCGA
        0.0733326335,        // terminal_mismatch_UCGC
        -0.0579450991,       // terminal_mismatch_UCGG
        -0.0696754661,       // terminal_mismatch_UCGU
        -0.0174492557,       // terminal_mismatch_UCUA
        -0.1543539480,       // terminal_mismatch_UCUC
        -0.0964656697,       // terminal_mismatch_UCUG
        0.1799949698,        // terminal_mismatch_UCUU
        0.2216946906,        // terminal_mismatch_UGAA
        0.2816462956,        // terminal_mismatch_UGAC
        0.3821923258,        // terminal_mismatch_UGAG
        -0.1799939484,       // terminal_mismatch_UGAU
        -0.0259164049,       // terminal_mismatch_UGCA
        0.0965678065,        // terminal_mismatch_UGCC
        0.1574431837,        // terminal_mismatch_UGCG
        -0.1959233487,       // terminal_mismatch_UGCU
        0.4898105659,        // terminal_mismatch_UGGA
        -0.3450962473,       // terminal_mismatch_UGGC
        -0.0184266528,       // terminal_mismatch_UGGG
        -0.3829115707,       // terminal_mismatch_UGGU
        -0.3351997341,       // terminal_mismatch_UGUA
        0.1524349141,        // terminal_mismatch_UGUC
        -0.1513850177,       // terminal_mismatch_UGUG
        0.0431779248,        // terminal_mismatch_UGUU
        0.0276986574,        // terminal_mismatch_UUAA
        -0.0916596157,       // terminal_mismatch_UUAC
        0.0667501263,        // terminal_mismatch_UUAG
        -0.1342800896,       // terminal_mismatch_UUAU
        -0.0218788541,       // terminal_mismatch_UUCA
        -0.0952206190,       // terminal_mismatch_UUCC
        -0.0201863033,       // terminal_mismatch_UUCG
        -0.0642781539,       // terminal_mismatch_UUCU
        0.1835869429,        // terminal_mismatch_UUGA
        -0.0436922833,       // terminal_mismatch_UUGC
        0.0895434092,        // terminal_mismatch_UUGG
        -0.0345348559,       // terminal_mismatch_UUGU
        0.0058818715,        // terminal_mismatch_UUUA
        -0.0592426431,       // terminal_mismatch_UUUC
        -0.0957648610,       // terminal_mismatch_UUUG
        0.0951280272,        // terminal_mismatch_UUUU
        -7.0018938340,       // hairpin_length_at_least_0
        -0.8108827120,       // hairpin_length_at_least_1
        0.9459053555,        // hairpin_length_at_least_2
        1.9431663380,        // hairpin_length_at_least_3
        0.9552748326,        // hairpin_length_at_least_4
        -0.3580276865,       // hairpin_length_at_least_5
        -0.0958231689,       // hairpin_length_at_least_6
        -0.0964579392,       // hairpin_length_at_least_7
        -0.2889275791,       // hairpin_length_at_least_8
        -0.2894783109,       // hairpin_length_at_least_9
        0.1273574641,        // hairpin_length_at_least_10
        -0.2948182011,       // hairpin_length_at_least_11
        -0.7491577273,       // hairpin_length_at_least_12
        0.0439780943,        // hairpin_length_at_least_13
        -0.1619802369,       // hairpin_length_at_least_14
        -0.1588823981,       // hairpin_length_at_least_15
        -0.0418693521,       // hairpin_length_at_least_16
        0.1708840763,        // hairpin_length_at_least_17
        0.1565663030,        // hairpin_length_at_least_18
        -0.5294077573,       // hairpin_length_at_least_19
        0.0375850154,        // hairpin_length_at_least_20
        -0.1840024096,       // hairpin_length_at_least_21
        -0.4869328207,       // hairpin_length_at_least_22
        -0.2177204558,       // hairpin_length_at_least_23
        -0.0871135986,       // hairpin_length_at_least_24
        -0.2041734367,       // hairpin_length_at_least_25
        -0.2576012642,       // hairpin_length_at_least_26
        -0.1732091363,       // hairpin_length_at_least_27
        0.0030304683,        // hairpin_length_at_least_28
        0.1243949244,        // hairpin_length_at_least_29
        0.3326705310,        // hairpin_length_at_least_30
        0.0303202931,        // internal_explicit_1_1
        -0.1078180662,       // internal_explicit_1_2
        0.0203262414,        // internal_explicit_1_3
        -0.0583460487,       // internal_explicit_1_4
        -0.0504598348,       // internal_explicit_2_2
        0.0675303095,        // internal_explicit_2_3
        0.0955525727,        // internal_explicit_2_4
        0.0824593448,        // internal_explicit_3_3
        0.1746772079,        // internal_explicit_3_4
        -0.0600452627,       // internal_explicit_4_4
        -1.0890671250,       // bulge_length_at_least_1
        -1.4563128720,       // bulge_length_at_least_2
        -0.8642668045,       // bulge_length_at_least_3
        -0.7684476691,       // bulge_length_at_least_4
        -0.7987608753,       // bulge_length_at_least_5
        -0.4559018916,       // bulge_length_at_least_6
        0.1718975607,        // bulge_length_at_least_7
        0.1122889416,        // bulge_length_at_least_8
        -0.0090528401,       // bulge_length_at_least_9
        -0.3528021103,       // bulge_length_at_least_10
        -0.6210992298,       // bulge_length_at_least_11
        -0.4667844678,       // bulge_length_at_least_12
        -0.3545731643,       // bulge_length_at_least_13
        -0.1869129881,       // bulge_length_at_least_14
        -0.1029032471,       // bulge_length_at_least_15
        0.0124336094,        // bulge_length_at_least_16
        -0.0580629422,       // bulge_length_at_least_17
        0.0304866416,        // bulge_length_at_least_18
        0.0697462601,        // bulge_length_at_least_19
        -0.1053239465,       // bulge_length_at_least_20
        -0.0080276181,       // bulge_length_at_least_21
        -0.1693063411,       // bulge_length_at_least_22
        -0.1869480197,       // bulge_length_at_least_23
        -0.1338882236,       // bulge_length_at_least_24
        -0.0891294118,       // bulge_length_at_least_25
        -0.0444939799,       // bulge_length_at_least_26
        -0.0045356025,       // bulge_length_at_least_27
        -0.0638784923,       // bulge_length_at_least_28
        -0.0406102973,       // bulge_length_at_least_29
        -0.0196666910,       // bulge_length_at_least_30
        -0.8384982243,       // internal_length_at_least_2
        -0.8145392134,       // internal_length_at_least_3
        -0.4274419136,       // internal_length_at_least_4
        -0.3196080489,       // internal_length_at_least_5
        -0.3482691295,       // internal_length_at_least_6
        -0.0146731023,       // internal_length_at_least_7
        -0.1704908718,       // internal_length_at_least_8
        -0.2747498090,       // internal_length_at_least_9
        -0.2816993027,       // internal_length_at_least_10
        -0.0501309420,       // internal_length_at_least_11
        -0.1157513247,       // internal_length_at_least_12
        -0.3261911703,       // internal_length_at_least_13
        -0.0979074061,       // internal_length_at_least_14
        -0.2117025949,       // internal_length_at_least_15
        -0.2165291009,       // internal_length_at_least_16
        -0.0706027938,       // internal_length_at_least_17
        -0.0262894508,       // internal_length_at_least_18
        0.0818008512,        // internal_length_at_least_19
        0.1028309860,        // internal_length_at_least_20
        -0.1224144603,       // internal_length_at_least_21
        -0.3109183699,       // internal_length_at_least_22
        -0.2718499691,       // internal_length_at_least_23
        -0.0010460064,       // internal_length_at_least_24
        -0.1323005654,       // internal_length_at_least_25
        -0.1094109113,       // internal_length_at_least_26
        -0.0541578866,       // internal_length_at_least_27
        0.0376283763,        // internal_length_at_least_28
        0.0424713902,        // internal_length_at_least_29
        0.0664362943,        // internal_length_at_least_30
        -0.0291561738,       // internal_symmetric_length_at_least_1
        -0.0593842325,       // internal_symmetric_length_at_least_2
        -0.0100989593,       // internal_symmetric_length_at_least_3
        -0.0903255551,       // internal_symmetric_length_at_least_4
        -0.0318324532,       // internal_symmetric_length_at_least_5
        -0.0313158534,       // internal_symmetric_length_at_least_6
        -0.0788036172,       // internal_symmetric_length_at_least_7
        -0.0977018705,       // internal_symmetric_length_at_least_8
        -0.0698358738,       // internal_symmetric_length_at_least_9
        -0.0384446362,       // internal_symmetric_length_at_least_10
        -0.0093797905,       // internal_symmetric_length_at_least_11
        -0.0172839398,       // internal_symmetric_length_at_least_12
        -0.0137997314,       // internal_symmetric_length_at_least_13
        -0.0137042633,       // internal_symmetric_length_at_least_14
        -0.0079166876,       // internal_symmetric_length_at_least_15
        -0.6248854515,       // internal_asymmetry_at_least_1
        -0.2130110176,       // internal_asymmetry_at_least_2
        -0.4388708483,       // internal_asymmetry_at_least_3
        -0.4577389008,       // internal_asymmetry_at_least_4
        -0.1073350387,       // internal_asymmetry_at_least_5
        -0.0815262583,       // internal_asymmetry_at_least_6
        -0.2498828148,       // internal_asymmetry_at_least_7
        -0.3261732738,       // internal_asymmetry_at_least_8
        -0.2648834833,       // internal_asymmetry_at_least_9
        -0.1413539627,       // internal_asymmetry_at_least_10
        -0.1611720656,       // internal_asymmetry_at_least_11
        -0.0840318467,       // internal_asymmetry_at_least_12
        -0.2796784443,       // internal_asymmetry_at_least_13
        -0.2315456117,       // internal_asymmetry_at_least_14
        -0.2250828215,       // internal_asymmetry_at_least_15
        -0.1790093214,       // internal_asymmetry_at_least_16
        -0.1394856705,       // internal_asymmetry_at_least_17
        -0.1088535885,       // internal_asymmetry_at_least_18
        -0.0775250547,       // internal_asymmetry_at_least_19
        -0.0595936208,       // internal_asymmetry_at_least_20
        -0.0414244511,       // internal_asymmetry_at_least_21
        -0.0315535456,       // internal_asymmetry_at_least_22
        -0.0228581872,       // internal_asymmetry_at_least_23
        -0.0167659612,       // internal_asymmetry_at_least_24
        -0.0109717742,       // internal_asymmetry_at_least_25
        -0.0071090679,       // internal_asymmetry_at_least_26
        -0.0034974650,       // internal_asymmetry_at_least_27
        -0.0016707264,       // internal_asymmetry_at_least_28
        -0.0608527161,       // bulge_0x1_nucleotides_A
        0.0010527308,        // bulge_0x1_nucleotides_C
        0.0791970190,        // bulge_0x1_nucleotides_G
        -0.0078854073,       // bulge_0x1_nucleotides_U
        -0.0398465706,       // internal_1x1_nucleotides_AA
        0.1799238798,        // internal_1x1_nucleotides_AC
        -0.1776183674,       // internal_1x1_nucleotides_AG
        0.0964356335,        // internal_1x1_nucleotides_AU
        0.0111219169,        // internal_1x1_nucleotides_CC
        0.1783947299,        // internal_1x1_nucleotides_CG
        -0.1259603120,       // internal_1x1_nucleotides_CU
        0.0128763988,        // internal_1x1_nucleotides_GG
        0.0040905055,        // internal_1x1_nucleotides_GU
        -0.1064232283,       // internal_1x1_nucleotides_UU
        0.3546221768,        // helix_stacking_AAAA
        -0.0431544699,       // helix_stacking_AAAC
        0.5016203773,        // helix_stacking_AAAG
        -0.5307966490,       // helix_stacking_AAAU
        0.2872436178,        // helix_stacking_AACA
        0.3691829843,        // helix_stacking_AACC
        -0.9953433048,       // helix_stacking_AACG
        0.0808715712,        // helix_stacking_AACU
        0.1677825197,        // helix_stacking_AAGA
        -0.6782658720,       // helix_stacking_AAGC
        -0.0938366968,       // helix_stacking_AAGG
        -0.5104866535,       // helix_stacking_AAGU
        -0.8089949963,       // helix_stacking_AAUA
        0.0375592566,        // helix_stacking_AAUC
        -0.5472344567,       // helix_stacking_AAUG
        0.5539306686,        // helix_stacking_AAUU
        0.2589964621,        // helix_stacking_ACAC
        -0.3522259076,       // helix_stacking_ACAG
        -0.3266392301,       // helix_stacking_ACAU
        0.1047725635,        // helix_stacking_ACCA
        0.0311510280,        // helix_stacking_ACCC
        -0.5174541432,       // helix_stacking_ACCG
        -0.0014882129,       // helix_stacking_ACCU
        0.4064263760,        // helix_stacking_ACGA
        -0.1867679593,       // helix_stacking_ACGC
        0.3704147668,        // helix_stacking_ACGG
        -0.0447509633,       // helix_stacking_ACGU
        -0.4204688848,       // helix_stacking_ACUA
        -0.0814710979,       // helix_stacking_ACUC
        -0.2525676388,       // helix_stacking_ACUG
        0.1202721996,        // helix_stacking_ACUU
        -0.0543602383,       // helix_stacking_AGAC
        0.1845945852,        // helix_stacking_AGAG
        -0.6334949651,       // helix_stacking_AGAU
        0.1641296660,        // helix_stacking_AGCC
        -0.2877376098,       // helix_stacking_AGCG
        0.4098605924,        // helix_stacking_AGCU
        -0.1055221936,       // helix_stacking_AGGA
        -0.2921646674,       // helix_stacking_AGGC
        0.0101876429,        // helix_stacking_AGGG
        0.1931504062,        // helix_stacking_AGGU
        -0.4943545079,       // helix_stacking_AGUA
        0.0620168631,        // helix_stacking_AGUC
        -0.2403228316,       // helix_stacking_AGUG
        0.2978012208,        // helix_stacking_AGUU
        -0.1929017687,       // helix_stacking_AUAC
        -0.3754001328,       // helix_stacking_AUAG
        0.8097237953,        // helix_stacking_AUAU
        -0.4891632689,       // helix_stacking_AUCC
        1.1320303350,        // helix_stacking_AUCG
        -0.2122122383,       // helix_stacking_AUCU
        1.1309634150,        // helix_stacking_AUGC
        -0.4156413885,       // helix_stacking_AUGG
        0.1489146395,        // helix_stacking_AUGU
        0.9217793712,        // helix_stacking_AUUA
        -0.5209762190,       // helix_stacking_AUUC
        0.4958919356,        // helix_stacking_AUUG
        -0.6967771576,       // helix_stacking_AUUU
        0.3516155114,        // helix_stacking_CAAC
        -0.2006481968,       // helix_stacking_CAAG
        -0.2214284327,       // helix_stacking_CAAU
        -0.0800719763,       // helix_stacking_CACC
        -0.2421687057,       // helix_stacking_CACG
        -0.0821491856,       // helix_stacking_CACU
        -0.4295873116,       // helix_stacking_CAGC
        -0.1981385431,       // helix_stacking_CAGG
        -0.1313833772,       // helix_stacking_CAGU
        0.1792984608,        // helix_stacking_CAUC
        -0.0461268061,       // helix_stacking_CAUG
        0.1948754160,        // helix_stacking_CAUU
        0.0157146570,        // helix_stacking_CCAG
        -0.4249477318,       // helix_stacking_CCAU
        -0.1256736814,       // helix_stacking_CCCC
        -0.8566085239,       // helix_stacking_CCCG
        -0.1141455454,       // helix_stacking_CCCU
        -0.8614197122,       // helix_stacking_CCGC
        0.5770731595,        // helix_stacking_CCGG
        -0.0133855091,       // helix_stacking_CCGU
        0.0606503170,        // helix_stacking_CCUC
        0.0108723871,        // helix_stacking_CCUG
        0.0819399538,        // helix_stacking_CCUU
        -0.6764832054,       // helix_stacking_CGAG
        1.0245114360,        // helix_stacking_CGAU
        1.5780362300,        // helix_stacking_CGCG
        -0.3538203962,       // helix_stacking_CGCU
        1.0800983920,        // helix_stacking_CGGC
        -0.8315727806,       // helix_stacking_CGGG
        0.2329343463,        // helix_stacking_CGGU
        -0.3528944225,       // helix_stacking_CGUC
        0.8098234766,        // helix_stacking_CGUG
        -0.6244259092,       // helix_stacking_CGUU
        0.3519082557,        // helix_stacking_CUAG
        -0.6877454743,       // helix_stacking_CUAU
        -0.6612901629,       // helix_stacking_CUCG
        0.1733793766,        // helix_stacking_CUCU
        0.2222988309,        // helix_stacking_CUGG
        -0.1138509130,       // helix_stacking_CUGU
        0.4351153974,        // helix_stacking_CUUC
        -0.1156703626,       // helix_stacking_CUUG
        0.0673595683,        // helix_stacking_CUUU
        1.0196612530,        // helix_stacking_GAAG
        -0.5917556439,       // helix_stacking_GAAU
        -0.9041064326,       // helix_stacking_GACG
        -0.0336163103,       // helix_stacking_GACU
        0.1934827478,        // helix_stacking_GAGG
        -0.2383785167,       // helix_stacking_GAGU
        0.0235960299,        // helix_stacking_GAUG
        0.1306743273,        // helix_stacking_GAUU
        1.1943561520,        // helix_stacking_GCAU
        1.1134312100,        // helix_stacking_GCCG
        -0.1722298720,       // helix_stacking_GCCU
        -0.6672644747,       // helix_stacking_GCGG
        0.7230014783,        // helix_stacking_GCGU
        0.8610183195,        // helix_stacking_GCUG
        -0.5428076909,       // helix_stacking_GCUU
        -0.5509451391,       // helix_stacking_GGAU
        0.2107153820,        // helix_stacking_GGCU
        0.0696024740,        // helix_stacking_GGGG
        -0.1636600385,       // helix_stacking_GGGU
        -0.2597428596,       // helix_stacking_GGUG
        -0.0244723945,       // helix_stacking_GGUU
        0.3621158768,        // helix_stacking_GUAU
        -0.2341237246,       // helix_stacking_GUCU
        0.3424878938,        // helix_stacking_GUGU
        0.1039838924,        // helix_stacking_GUUG
        -0.4995377850,       // helix_stacking_GUUU
        1.0129740860,        // helix_stacking_UAAU
        -0.4726399200,       // helix_stacking_UACU
        0.5340581688,        // helix_stacking_UAGU
        -0.5309098207,       // helix_stacking_UAUU
        0.1344187062,        // helix_stacking_UCCU
        -0.4078546373,       // helix_stacking_UCGU
        0.3822876695,        // helix_stacking_UCUU
        0.3340793140,        // helix_stacking_UGGU
        -0.6872220771,       // helix_stacking_UGUU
        0.4541580212,        // helix_stacking_UUUU
        -1.9770341200,       // helix_closing_AA
        -1.5596341140,       // helix_closing_AC
        -1.5289066660,       // helix_closing_AG
        -1.3616015140,       // helix_closing_AU
        -1.4594615590,       // helix_closing_CA
        -1.5557533040,       // helix_closing_CC
        -1.1036086480,       // helix_closing_CG
        -1.6230847810,       // helix_closing_CU
        -2.0038603260,       // helix_closing_GA
        -1.2543274470,       // helix_closing_GC
        -1.5949373590,       // helix_closing_GG
        -1.5969532650,       // helix_closing_GU
        -1.3371253030,       // helix_closing_UA
        -1.5803682180,       // helix_closing_UC
        -1.1138363510,       // helix_closing_UG
        -1.8476353300,       // helix_closing_UU
        -0.4432287566,       // multi_base
        -0.1661807958,       // multi_unpaired
        -1.0393510460,       // multi_paired
        0.0308052690,        // dangle_left_AAA
        -0.0155781224,       // dangle_left_AAC
        0.0057333793,        // dangle_left_AAG
        -0.0302715908,       // dangle_left_AAU
        0.0321287855,        // dangle_left_ACA
        0.0044790954,        // dangle_left_ACC
        -0.0132928680,       // dangle_left_ACG
        -0.0475763929,       // dangle_left_ACU
        0.0486914612,        // dangle_left_AGA
        0.0610111825,        // dangle_left_AGC
        0.0234047612,        // dangle_left_AGG
        -0.0541594636,       // dangle_left_AGU
        -0.1555170799,       // dangle_left_AUA
        -0.1584186333,       // dangle_left_AUC
        0.1049449411,        // dangle_left_AUG
        0.0588720686,        // dangle_left_AUU
        0.1688104162,        // dangle_left_CAA
        -0.0351565540,       // dangle_left_CAC
        0.0040939771,        // dangle_left_CAG
        -0.0595153955,       // dangle_left_CAU
        -0.0227679388,       // dangle_left_CCA
        -0.0124855532,       // dangle_left_CCC
        -0.0186710573,       // dangle_left_CCG
        -0.0100314617,       // dangle_left_CCU
        0.1356012710,        // dangle_left_CGA
        0.0722031943,        // dangle_left_CGC
        -0.0599346265,       // dangle_left_CGG
        -0.1386561816,       // dangle_left_CGU
        0.0192937469,        // dangle_left_CUA
        -0.0121379923,       // dangle_left_CUC
        0.0249046487,        // dangle_left_CUG
        -0.0454296359,       // dangle_left_CUU
        0.0336977299,        // dangle_left_GAA
        -0.0276456539,       // dangle_left_GAC
        -0.0557562163,       // dangle_left_GAG
        -0.0255651518,       // dangle_left_GAU
        -0.0331197126,       // dangle_left_GCA
        -0.0392125109,       // dangle_left_GCC
        0.1555398170,        // dangle_left_GCG
        -0.1536314435,       // dangle_left_GCU
        -0.0242016250,       // dangle_left_GGA
        0.0362640400,        // dangle_left_GGC
        -0.0100751419,       // dangle_left_GGG
        -0.0216986383,       // dangle_left_GGU
        -0.0135206863,       // dangle_left_GUA
        -0.0837476885,       // dangle_left_GUC
        -0.0046323265,       // dangle_left_GUG
        0.0471571955,        // dangle_left_GUU
        0.0590768209,        // dangle_left_UAA
        -0.0012780666,       // dangle_left_UAC
        -0.1736001705,       // dangle_left_UAG
        -0.1902719183,       // dangle_left_UAU
        0.0021598296,        // dangle_left_UCA
        -0.0123460867,       // dangle_left_UCC
        -0.0206367473,       // dangle_left_UCG
        0.0077814291,        // dangle_left_UCU
        -0.0664420362,       // dangle_left_UGA
        -0.0238917026,       // dangle_left_UGC
        0.1574534200,        // dangle_left_UGG
        -0.2585948344,       // dangle_left_UGU
        0.0742935756,        // dangle_left_UUA
        -0.0317544729,       // dangle_left_UUC
        -0.0657958948,       // dangle_left_UUG
        0.0121319924,        // dangle_left_UUU
        -0.0143044921,       // dangle_right_AAA
        0.0483192634,        // dangle_right_AAC
        -0.0512676379,       // dangle_right_AAG
        -0.0103701333,       // dangle_right_AAU
        -0.0174310203,       // dangle_right_ACA
        -0.0315053194,       // dangle_right_ACC
        -0.0137226276,       // dangle_right_ACG
        -0.0065502290,       // dangle_right_ACU
        -0.0021064953,       // dangle_right_AGA
        0.0312282017,        // dangle_right_AGC
        -0.0207387633,       // dangle_right_AGG
        0.0795797111,        // dangle_right_AGU
        0.1347319363,        // dangle_right_AUA
        -0.0813449484,       // dangle_right_AUC
        0.0201754745,        // dangle_right_AUG
        -0.2190612231,       // dangle_right_AUU
        0.0698070688,        // dangle_right_CAA
        -0.0039713310,       // dangle_right_CAC
        0.0031809808,        // dangle_right_CAG
        0.0038852667,        // dangle_right_CAU
        -0.0350723472,       // dangle_right_CCA
        -0.0043524048,       // dangle_right_CCC
        0.0042837869,        // dangle_right_CCG
        -0.0308381136,       // dangle_right_CCU
        0.0514556340,        // dangle_right_CGA
        -0.0641658904,       // dangle_right_CGC
        -0.0752839708,       // dangle_right_CGG
        -0.2239441833,       // dangle_right_CGU
        -0.0469553491,       // dangle_right_CUA
        -0.0391343946,       // dangle_right_CUC
        0.0307872079,        // dangle_right_CUG
        -0.0122169923,       // dangle_right_CUU
        0.0262763255,        // dangle_right_GAA
        -0.0458147860,       // dangle_right_GAC
        -0.0512891399,       // dangle_right_GAG
        -0.0206673532,       // dangle_right_GAU
        0.0115277732,        // dangle_right_GCA
        0.0655267521,        // dangle_right_GCC
        -0.1032959984,       // dangle_right_GCG
        -0.1965599296,       // dangle_right_GCU
        -0.0496631161,       // dangle_right_GGA
        -0.0142087721,       // dangle_right_GGC
        0.0590157038,        // dangle_right_GGG
        -0.0169253333,       // dangle_right_GGU
        0.1957498321,        // dangle_right_GUA
        -0.1568392687,       // dangle_right_GUC
        -0.0812000038,       // dangle_right_GUG
        -0.1048127001,       // dangle_right_GUU
        -0.1921468549,       // dangle_right_UAA
        0.0659908574,        // dangle_right_UAC
        0.0875506286,        // dangle_right_UAG
        -0.2545133106,       // dangle_right_UAU
        -0.0439937912,       // dangle_right_UCA
        0.0536797881,        // dangle_right_UCC
        -0.0492375296,       // dangle_right_UCG
        -0.0156349331,       // dangle_right_UCU
        0.0413621662,        // dangle_right_UGA
        0.1933397566,        // dangle_right_UGC
        -0.2310365581,       // dangle_right_UGG
        -0.2098640295,       // dangle_right_UGU
        0.0116755758,        // dangle_right_UUA
        0.0282697957,        // dangle_right_UUC
        -0.0194941615,       // dangle_right_UUG
        -0.0459807978,       // dangle_right_UUU
        -0.0491202270,       // external_unpaired
        -0.0266953775        // external_paired
    };

    return std::vector<RealT>(values, values + 708);
}


/////////////////////////////////////////////////////////////////
// GetDefaultProfileValues()
//
// Retrieve default parameter values.
/////////////////////////////////////////////////////////////////

template<class RealT>
std::vector<RealT> GetDefaultProfileValues()
{
    RealT values[] =
    {
        -3.4035165040,       // base_pair_AA
        -3.8624326980,       // base_pair_AC
        -3.5032995850,       // base_pair_AG
        1.5537137200,        // base_pair_AU
        -2.7206835790,       // base_pair_CC
        2.9802365170,        // base_pair_CG
        -3.1543133400,       // base_pair_CU
        -2.9545150740,       // base_pair_GG
        0.3889900071,        // base_pair_GU
        -3.3301468480,       // base_pair_UU
        -0.0190497026,       // terminal_mismatch_AAAA
        -0.0017191794,       // terminal_mismatch_AAAC
        0.0063566207,        // terminal_mismatch_AAAG
        0.0068675746,        // terminal_mismatch_AAAU
        -0.0051783002,       // terminal_mismatch_AACA
        -0.0004470034,       // terminal_mismatch_AACC
        0.0019510575,        // terminal_mismatch_AACG
        0.0087476945,        // terminal_mismatch_AACU
        -0.0076670698,       // terminal_mismatch_AAGA
        -0.0044550862,       // terminal_mismatch_AAGC
        -0.0030179067,       // terminal_mismatch_AAGG
        0.0008812458,        // terminal_mismatch_AAGU
        -0.0079242638,       // terminal_mismatch_AAUA
        0.0007074860,        // terminal_mismatch_AAUC
        -0.0055504683,       // terminal_mismatch_AAUG
        0.0268638911,        // terminal_mismatch_AAUU
        0.0128377416,        // terminal_mismatch_ACAA
        0.0015327260,        // terminal_mismatch_ACAC
        0.0051020360,        // terminal_mismatch_ACAG
        0.0098367236,        // terminal_mismatch_ACAU
        0.0158278493,        // terminal_mismatch_ACCA
        -0.0035901716,       // terminal_mismatch_ACCC
        -0.0017600843,       // terminal_mismatch_ACCG
        -0.0026689643,       // terminal_mismatch_ACCU
        0.0089206931,        // terminal_mismatch_ACGA
        -0.0015967478,       // terminal_mismatch_ACGC
        0.0178306936,        // terminal_mismatch_ACGG
        0.0103125131,        // terminal_mismatch_ACGU
        0.0089484575,        // terminal_mismatch_ACUA
        0.0014831187,        // terminal_mismatch_ACUC
        -0.0078127213,       // terminal_mismatch_ACUG
        -0.0037866022,       // terminal_mismatch_ACUU
        -0.0109747928,       // terminal_mismatch_AGAA
        0.0088069856,        // terminal_mismatch_AGAC
        -0.0039354768,       // terminal_mismatch_AGAG
        -0.0106212367,       // terminal_mismatch_AGAU
        0.0011727156,        // terminal_mismatch_AGCA
        -0.0015765259,       // terminal_mismatch_AGCC
        0.0042905281,        // terminal_mismatch_AGCG
        0.0033291839,        // terminal_mismatch_AGCU
        -0.0091685027,       // terminal_mismatch_AGGA
        -0.0022236553,       // terminal_mismatch_AGGC
        -0.0016975056,       // terminal_mismatch_AGGG
        -0.0021646656,       // terminal_mismatch_AGGU
        0.0052921062,        // terminal_mismatch_AGUA
        0.0059450697,        // terminal_mismatch_AGUC
        -0.0099094980,       // terminal_mismatch_AGUG
        -0.0053380258,       // terminal_mismatch_AGUU
        -0.1339459170,       // terminal_mismatch_AUAA
        0.0266646733,        // terminal_mismatch_AUAC
        -0.1274129643,       // terminal_mismatch_AUAG
        -0.1310489237,       // terminal_mismatch_AUAU
        0.0288894348,        // terminal_mismatch_AUCA
        -0.1391051810,       // terminal_mismatch_AUCC
        -0.0191187483,       // terminal_mismatch_AUCG
        -0.0518206712,       // terminal_mismatch_AUCU
        0.0332720215,        // terminal_mismatch_AUGA
        0.0053513605,        // terminal_mismatch_AUGC
        0.0571618347,        // terminal_mismatch_AUGG
        -0.0448400438,       // terminal_mismatch_AUGU
        0.0027692998,        // terminal_mismatch_AUUA
        -0.0175033554,       // terminal_mismatch_AUUC
        -0.0300298631,       // terminal_mismatch_AUUG
        0.1241301829,        // terminal_mismatch_AUUU
        -0.0077412743,       // terminal_mismatch_CAAA
        -0.0111352674,       // terminal_mismatch_CAAC
        0.0106337871,        // terminal_mismatch_CAAG
        -0.0012032234,       // terminal_mismatch_CAAU
        0.0013062820,        // terminal_mismatch_CACA
        0.0035514826,        // terminal_mismatch_CACC
        0.0161002404,        // terminal_mismatch_CACG
        -0.0006937631,       // terminal_mismatch_CACU
        -0.0083370930,       // terminal_mismatch_CAGA
        -0.0081633680,       // terminal_mismatch_CAGC
        0.0009161382,        // terminal_mismatch_CAGG
        -0.0037325675,       // terminal_mismatch_CAGU
        -0.0025062896,       // terminal_mismatch_CAUA
        0.0117023594,        // terminal_mismatch_CAUC
        -0.0007243619,       // terminal_mismatch_CAUG
        0.0184975593,        // terminal_mismatch_CAUU
        -0.0040091266,       // terminal_mismatch_CCAA
        -0.0096220613,       // terminal_mismatch_CCAC
        0.0050335579,        // terminal_mismatch_CCAG
        -0.0003158385,       // terminal_mismatch_CCAU
        -0.0003843902,       // terminal_mismatch_CCCA
        -0.0018155818,       // terminal_mismatch_CCCC
        -0.0096961411,       // terminal_mismatch_CCCG
        0.0062711858,        // terminal_mismatch_CCCU
        -0.0034714197,       // terminal_mismatch_CCGA
        -0.0016427660,       // terminal_mismatch_CCGC
        0.0077191782,        // terminal_mismatch_CCGG
        0.0004860521,        // terminal_mismatch_CCGU
        0.0033564207,        // terminal_mismatch_CCUA
        -0.0020628768,       // terminal_mismatch_CCUC
        -0.0028476084,       // terminal_mismatch_CCUG
        -0.0030593921,       // terminal_mismatch_CCUU
        0.1257942724,        // terminal_mismatch_CGAA
        -0.0909093871,       // terminal_mismatch_CGAC
        -0.1530280212,       // terminal_mismatch_CGAG
        -0.0739788960,       // terminal_mismatch_CGAU
        -0.0501961890,       // terminal_mismatch_CGCA
        -0.0598274495,       // terminal_mismatch_CGCC
        0.0280456704,        // terminal_mismatch_CGCG
        0.0779298847,        // terminal_mismatch_CGCU
        -0.0921230088,       // terminal_mismatch_CGGA
        -0.1428512254,       // terminal_mismatch_CGGC
        0.0780068896,        // terminal_mismatch_CGGG
        -0.1724080214,       // terminal_mismatch_CGGU
        -0.1867967474,       // terminal_mismatch_CGUA
        -0.0277365764,       // terminal_mismatch_CGUC
        -0.1486660582,       // terminal_mismatch_CGUG
        0.1957108536,        // terminal_mismatch_CGUU
        -0.0125525295,       // terminal_mismatch_CUAA
        -0.0028749755,       // terminal_mismatch_CUAC
        -0.0002115998,       // terminal_mismatch_CUAG
        0.0013563163,        // terminal_mismatch_CUAU
        -0.0023284722,       // terminal_mismatch_CUCA
        -0.0025604108,       // terminal_mismatch_CUCC
        0.0004526658,        // terminal_mismatch_CUCG
        0.0041761321,        // terminal_mismatch_CUCU
        -0.0000260386,       // terminal_mismatch_CUGA
        0.0102409562,        // terminal_mismatch_CUGC
        -0.0062609184,       // terminal_mismatch_CUGG
        -0.0024398981,       // terminal_mismatch_CUGU
        -0.0015076566,       // terminal_mismatch_CUUA
        -0.0082568909,       // terminal_mismatch_CUUC
        0.0006283881,        // terminal_mismatch_CUUG
        -0.0077356375,       // terminal_mismatch_CUUU
        0.0011295503,        // terminal_mismatch_GAAA
        0.0234500204,        // terminal_mismatch_GAAC
        -0.0067680904,       // terminal_mismatch_GAAG
        0.0046884536,        // terminal_mismatch_GAAU
        -0.0040529662,       // terminal_mismatch_GACA
        0.0014120626,        // terminal_mismatch_GACC
        0.0053665859,        // terminal_mismatch_GACG
        -0.0029737312,       // terminal_mismatch_GACU
        0.0060282184,        // terminal_mismatch_GAGA
        0.0014782205,        // terminal_mismatch_GAGC
        -0.0018691235,       // terminal_mismatch_GAGG
        0.0016539854,        // terminal_mismatch_GAGU
        -0.0021598572,       // terminal_mismatch_GAUA
        -0.0059513682,       // terminal_mismatch_GAUC
        0.0012252456,        // terminal_mismatch_GAUG
        -0.0034800043,       // terminal_mismatch_GAUU
        -0.0789613072,       // terminal_mismatch_GCAA
        -0.2472491533,       // terminal_mismatch_GCAC
        -0.0542143859,       // terminal_mismatch_GCAG
        -0.1537956801,       // terminal_mismatch_GCAU
        -0.2045648428,       // terminal_mismatch_GCCA
        -0.1627529082,       // terminal_mismatch_GCCC
        -0.1987055124,       // terminal_mismatch_GCCG
        0.0117581656,        // terminal_mismatch_GCCU
        -0.0350850014,       // terminal_mismatch_GCGA
        0.0290017671,        // terminal_mismatch_GCGC
        0.1226421100,        // terminal_mismatch_GCGG
        -0.2183733722,       // terminal_mismatch_GCGU
        -0.1588111192,       // terminal_mismatch_GCUA
        0.0109259675,        // terminal_mismatch_GCUC
        0.2014929454,        // terminal_mismatch_GCUG
        0.1266862807,        // terminal_mismatch_GCUU
        0.0119229023,        // terminal_mismatch_GGAA
        -0.0009572412,       // terminal_mismatch_GGAC
        -0.0041350257,       // terminal_mismatch_GGAG
        -0.0048454088,       // terminal_mismatch_GGAU
        -0.0016079024,       // terminal_mismatch_GGCA
        -0.0053172409,       // terminal_mismatch_GGCC
        -0.0045031561,       // terminal_mismatch_GGCG
        -0.0117163741,       // terminal_mismatch_GGCU
        -0.0094933884,       // terminal_mismatch_GGGA
        0.0054653056,        // terminal_mismatch_GGGC
        0.0001936641,        // terminal_mismatch_GGGG
        0.0021824981,        // terminal_mismatch_GGGU
        0.0026606744,        // terminal_mismatch_GGUA
        -0.0042004900,       // terminal_mismatch_GGUC
        0.0089433752,        // terminal_mismatch_GGUG
        -0.0028940251,       // terminal_mismatch_GGUU
        -0.0851492327,       // terminal_mismatch_GUAA
        -0.0347547334,       // terminal_mismatch_GUAC
        -0.0438203410,       // terminal_mismatch_GUAG
        -0.0960298878,       // terminal_mismatch_GUAU
        0.1353368763,        // terminal_mismatch_GUCA
        -0.0165138502,       // terminal_mismatch_GUCC
        -0.0149790406,       // terminal_mismatch_GUCG
        -0.0008423759,       // terminal_mismatch_GUCU
        -0.0918709173,       // terminal_mismatch_GUGA
        -0.0408946937,       // terminal_mismatch_GUGC
        -0.0281552411,       // terminal_mismatch_GUGG
        -0.0452228859,       // terminal_mismatch_GUGU
        -0.0244486575,       // terminal_mismatch_GUUA
        0.0469007815,        // terminal_mismatch_GUUC
        -0.0605549722,       // terminal_mismatch_GUUG
        -0.0353766571,       // terminal_mismatch_GUUU
        0.0086735077,        // terminal_mismatch_UAAA
        -0.0859383357,       // terminal_mismatch_UAAC
        -0.0505508818,       // terminal_mismatch_UAAG
        -0.0798670384,       // terminal_mismatch_UAAU
        -0.0212775677,       // terminal_mismatch_UACA
        -0.1184051629,       // terminal_mismatch_UACC
        0.0465571889,        // terminal_mismatch_UACG
        -0.0360538886,       // terminal_mismatch_UACU
        -0.0796027801,       // terminal_mismatch_UAGA
        -0.0261777048,       // terminal_mismatch_UAGC
        -0.0108680505,       // terminal_mismatch_UAGG
        -0.0783379455,       // terminal_mismatch_UAGU
        -0.0814672485,       // terminal_mismatch_UAUA
        -0.0197234843,       // terminal_mismatch_UAUC
        -0.0795511833,       // terminal_mismatch_UAUG
        0.0810935803,        // terminal_mismatch_UAUU
        -0.0006883735,       // terminal_mismatch_UCAA
        -0.0054030618,       // terminal_mismatch_UCAC
        -0.0022463295,       // terminal_mismatch_UCAG
        -0.0024436110,       // terminal_mismatch_UCAU
        0.0024838696,        // terminal_mismatch_UCCA
        -0.0029560400,       // terminal_mismatch_UCCC
        0.0020057342,        // terminal_mismatch_UCCG
        0.0113499652,        // terminal_mismatch_UCCU
        -0.0046007993,       // terminal_mismatch_UCGA
        0.0022285001,        // terminal_mismatch_UCGC
        -0.0018159605,       // terminal_mismatch_UCGG
        -0.0024886819,       // terminal_mismatch_UCGU
        -0.0031193962,       // terminal_mismatch_UCUA
        -0.0003355943,       // terminal_mismatch_UCUC
        -0.0027120580,       // terminal_mismatch_UCUG
        -0.0010601994,       // terminal_mismatch_UCUU
        -0.0292953107,       // terminal_mismatch_UGAA
        0.0818298913,        // terminal_mismatch_UGAC
        0.0803829262,        // terminal_mismatch_UGAG
        -0.0585376978,       // terminal_mismatch_UGAU
        0.0051498706,        // terminal_mismatch_UGCA
        -0.0003422259,       // terminal_mismatch_UGCC
        0.0416446163,        // terminal_mismatch_UGCG
        -0.0177370156,       // terminal_mismatch_UGCU
        0.0819460155,        // terminal_mismatch_UGGA
        -0.0117229195,       // terminal_mismatch_UGGC
        -0.0771779150,       // terminal_mismatch_UGGG
        -0.1379654806,       // terminal_mismatch_UGGU
        -0.0444412724,       // terminal_mismatch_UGUA
        0.0411467341,        // terminal_mismatch_UGUC
        -0.0703302600,       // terminal_mismatch_UGUG
        0.0862048110,        // terminal_mismatch_UGUU
        0.0078812763,        // terminal_mismatch_UUAA
        0.0031430967,        // terminal_mismatch_UUAC
        -0.0041700433,       // terminal_mismatch_UUAG
        0.0007948167,        // terminal_mismatch_UUAU
        -0.0126293434,       // terminal_mismatch_UUCA
        -0.0070303496,       // terminal_mismatch_UUCC
        0.0039955171,        // terminal_mismatch_UUCG
        0.0140589323,        // terminal_mismatch_UUCU
        -0.0042134790,       // terminal_mismatch_UUGA
        0.0026454558,        // terminal_mismatch_UUGC
        0.0065009181,        // terminal_mismatch_UUGG
        0.0047173953,        // terminal_mismatch_UUGU
        0.0204692437,        // terminal_mismatch_UUUA
        -0.0065207354,       // terminal_mismatch_UUUC
        -0.0035457757,       // terminal_mismatch_UUUG
        -0.0099112907,       // terminal_mismatch_UUUU
        -11.2745404400,      // hairpin_length_at_least_0
        -0.7049874787,       // hairpin_length_at_least_1
        1.6584078500,        // hairpin_length_at_least_2
        2.5488887390,        // hairpin_length_at_least_3
        0.9944638313,        // hairpin_length_at_least_4
        0.1114930516,        // hairpin_length_at_least_5
        -0.0816401894,       // hairpin_length_at_least_6
        -0.2314032079,       // hairpin_length_at_least_7
        0.0841901663,        // hairpin_length_at_least_8
        -0.4135353798,       // hairpin_length_at_least_9
        -0.0545040748,       // hairpin_length_at_least_10
        0.1352513403,        // hairpin_length_at_least_11
        0.0500538242,        // hairpin_length_at_least_12
        -0.2420180411,       // hairpin_length_at_least_13
        -0.1932403432,       // hairpin_length_at_least_14
        -0.4459876615,       // hairpin_length_at_least_15
        0.0740179845,        // hairpin_length_at_least_16
        1.1453867310,        // hairpin_length_at_least_17
        -0.1552747600,       // hairpin_length_at_least_18
        -1.1221540710,       // hairpin_length_at_least_19
        -0.4596125450,       // hairpin_length_at_least_20
        0.8845817922,        // hairpin_length_at_least_21
        -0.4798837150,       // hairpin_length_at_least_22
        0.2232373651,        // hairpin_length_at_least_23
        0.3528749640,        // hairpin_length_at_least_24
        -0.6952888987,       // hairpin_length_at_least_25
        -0.1241539300,       // hairpin_length_at_least_26
        -0.2405423305,       // hairpin_length_at_least_27
        -0.0095265298,       // hairpin_length_at_least_28
        0.3154128371,        // hairpin_length_at_least_29
        0.9702676486,        // hairpin_length_at_least_30
        -0.1002141570,       // internal_explicit_1_1
        -0.1388267427,       // internal_explicit_1_2
        -0.0690085675,       // internal_explicit_1_3
        -0.0762692721,       // internal_explicit_1_4
        0.1272754652,        // internal_explicit_2_2
        0.0845233646,        // internal_explicit_2_3
        0.1113771719,        // internal_explicit_2_4
        0.0372082679,        // internal_explicit_3_3
        0.1607708252,        // internal_explicit_3_4
        -0.0494480936,       // internal_explicit_4_4
        -4.2581537570,       // bulge_length_at_least_1
        -1.8164929190,       // bulge_length_at_least_2
        -0.3008950692,       // bulge_length_at_least_3
        -1.0375758050,       // bulge_length_at_least_4
        -1.0541611930,       // bulge_length_at_least_5
        -0.7583329783,       // bulge_length_at_least_6
        0.0616421592,        // bulge_length_at_least_7
        0.6588945757,        // bulge_length_at_least_8
        0.8794927911,        // bulge_length_at_least_9
        -0.1800467105,       // bulge_length_at_least_10
        -0.8482388288,       // bulge_length_at_least_11
        -0.4888415235,       // bulge_length_at_least_12
        -0.0740585685,       // bulge_length_at_least_13
        0.1024246688,        // bulge_length_at_least_14
        -0.3298852888,       // bulge_length_at_least_15
        -0.1539144958,       // bulge_length_at_least_16
        -0.0687176012,       // bulge_length_at_least_17
        -0.0086018873,       // bulge_length_at_least_18
        0.0493621686,        // bulge_length_at_least_19
        0.0953932951,        // bulge_length_at_least_20
        0.1569528946,        // bulge_length_at_least_21
        -0.0069046314,       // bulge_length_at_least_22
        0.0350278827,        // bulge_length_at_least_23
        0.1004819585,        // bulge_length_at_least_24
        0.1317053650,        // bulge_length_at_least_25
        0.1748203998,        // bulge_length_at_least_26
        0.2117574286,        // bulge_length_at_least_27
        0.0800126973,        // bulge_length_at_least_28
        -0.0375842188,       // bulge_length_at_least_29
        -0.0153600410,       // bulge_length_at_least_30
        -2.5785411020,       // internal_length_at_least_2
        -1.7321130210,       // internal_length_at_least_3
        -0.4426925225,       // internal_length_at_least_4
        -0.4436652728,       // internal_length_at_least_5
        -0.4464306446,       // internal_length_at_least_6
        0.5028354199,        // internal_length_at_least_7
        -0.2544300290,       // internal_length_at_least_8
        -0.3709535245,       // internal_length_at_least_9
        -0.1894424283,       // internal_length_at_least_10
        -0.1533676121,       // internal_length_at_least_11
        0.0500754240,        // internal_length_at_least_12
        -0.4638130633,       // internal_length_at_least_13
        0.3620488764,        // internal_length_at_least_14
        -0.3155004838,       // internal_length_at_least_15
        0.1757922455,        // internal_length_at_least_16
        -0.1475837316,       // internal_length_at_least_17
        -0.3435837159,       // internal_length_at_least_18
        -0.2127962066,       // internal_length_at_least_19
        0.3934874237,        // internal_length_at_least_20
        -0.1285002250,       // internal_length_at_least_21
        -0.1626272610,       // internal_length_at_least_22
        0.0372511741,        // internal_length_at_least_23
        0.2345360224,        // internal_length_at_least_24
        -0.4777910787,       // internal_length_at_least_25
        -0.2184981220,       // internal_length_at_least_26
        0.0035252974,        // internal_length_at_least_27
        0.1565818883,        // internal_length_at_least_28
        0.2632979177,        // internal_length_at_least_29
        -0.0866325867,       // internal_length_at_least_30
        0.0124604131,        // internal_symmetric_length_at_least_1
        0.0904299395,        // internal_symmetric_length_at_least_2
        0.0062570559,        // internal_symmetric_length_at_least_3
        -0.0183078277,       // internal_symmetric_length_at_least_4
        0.0186149498,        // internal_symmetric_length_at_least_5
        -0.0759050261,       // internal_symmetric_length_at_least_6
        -0.0454983394,       // internal_symmetric_length_at_least_7
        -0.0612458550,       // internal_symmetric_length_at_least_8
        -0.0554688099,       // internal_symmetric_length_at_least_9
        -0.0364355397,       // internal_symmetric_length_at_least_10
        -0.0283552606,       // internal_symmetric_length_at_least_11
        -0.0199783782,       // internal_symmetric_length_at_least_12
        -0.0065044098,       // internal_symmetric_length_at_least_13
        -0.0102099161,       // internal_symmetric_length_at_least_14
        -0.0066432921,       // internal_symmetric_length_at_least_15
        -0.3398337864,       // internal_asymmetry_at_least_1
        -0.2327646341,       // internal_asymmetry_at_least_2
        -0.2742544636,       // internal_asymmetry_at_least_3
        -0.2714034775,       // internal_asymmetry_at_least_4
        -0.1066829219,       // internal_asymmetry_at_least_5
        -0.0703413442,       // internal_asymmetry_at_least_6
        -0.1077694713,       // internal_asymmetry_at_least_7
        -0.1191531781,       // internal_asymmetry_at_least_8
        -0.1191905600,       // internal_asymmetry_at_least_9
        -0.0601995580,       // internal_asymmetry_at_least_10
        -0.0728717115,       // internal_asymmetry_at_least_11
        -0.0386492178,       // internal_asymmetry_at_least_12
        -0.1195306559,       // internal_asymmetry_at_least_13
        -0.0746196700,       // internal_asymmetry_at_least_14
        -0.0694505082,       // internal_asymmetry_at_least_15
        -0.0501239643,       // internal_asymmetry_at_least_16
        -0.0386114112,       // internal_asymmetry_at_least_17
        -0.0297402379,       // internal_asymmetry_at_least_18
        -0.0095023409,       // internal_asymmetry_at_least_19
        0.0008804241,        // internal_asymmetry_at_least_20
        0.0080101695,        // internal_asymmetry_at_least_21
        0.0119467032,        // internal_asymmetry_at_least_22
        0.0149031878,        // internal_asymmetry_at_least_23
        0.0171015516,        // internal_asymmetry_at_least_24
        0.0187685883,        // internal_asymmetry_at_least_25
        0.0200709956,        // internal_asymmetry_at_least_26
        0.0170542682,        // internal_asymmetry_at_least_27
        0.0192648588,        // internal_asymmetry_at_least_28
        -0.1607307825,       // bulge_0x1_nucleotides_A
        -0.1430249970,       // bulge_0x1_nucleotides_C
        -0.1132349177,       // bulge_0x1_nucleotides_G
        -0.0738884437,       // bulge_0x1_nucleotides_U
        -0.7463309510,       // internal_1x1_nucleotides_AA
        -0.5734758932,       // internal_1x1_nucleotides_AC
        -0.7056134096,       // internal_1x1_nucleotides_AG
        0.5549172931,        // internal_1x1_nucleotides_AU
        -0.7817824419,       // internal_1x1_nucleotides_CC
        1.8613706260,        // internal_1x1_nucleotides_CG
        -0.8061017588,       // internal_1x1_nucleotides_CU
        -0.3909273675,       // internal_1x1_nucleotides_GG
        -0.2337333892,       // internal_1x1_nucleotides_GU
        -0.5427783767,       // internal_1x1_nucleotides_UU
        0.0011665170,        // helix_stacking_AAAA
        0.0026406280,        // helix_stacking_AAAC
        -0.0019667881,       // helix_stacking_AAAG
        -0.0055691533,       // helix_stacking_AAAU
        -0.0037462466,       // helix_stacking_AACA
        0.0022503872,        // helix_stacking_AACC
        -0.0058251217,       // helix_stacking_AACG
        0.0024192783,        // helix_stacking_AACU
        0.0029353271,        // helix_stacking_AAGA
        -0.0178482873,       // helix_stacking_AAGC
        0.0002872313,        // helix_stacking_AAGG
        0.0013987373,        // helix_stacking_AAGU
        -0.0220383821,       // helix_stacking_AAUA
        0.0008496010,        // helix_stacking_AAUC
        0.0082153041,        // helix_stacking_AAUG
        -0.0016802554,       // helix_stacking_AAUU
        0.0003182845,        // helix_stacking_ACAC
        0.0023315870,        // helix_stacking_ACAG
        -0.0115595853,       // helix_stacking_ACAU
        0.0021395415,        // helix_stacking_ACCA
        -0.0001087925,       // helix_stacking_ACCC
        -0.0155477107,       // helix_stacking_ACCG
        0.0016300031,        // helix_stacking_ACCU
        0.0018885978,        // helix_stacking_ACGA
        -0.0274352456,       // helix_stacking_ACGC
        0.0003814573,        // helix_stacking_ACGG
        -0.0018305559,       // helix_stacking_ACGU
        -0.0098723535,       // helix_stacking_ACUA
        0.0005562194,        // helix_stacking_ACUC
        -0.0034450973,       // helix_stacking_ACUG
        0.0033718359,        // helix_stacking_ACUU
        0.0021708980,        // helix_stacking_AGAC
        0.0040003212,        // helix_stacking_AGAG
        0.0013682127,        // helix_stacking_AGAU
        0.0015728342,        // helix_stacking_AGCC
        -0.0144248931,       // helix_stacking_AGCG
        0.0008485224,        // helix_stacking_AGCU
        -0.0003380934,       // helix_stacking_AGGA
        -0.0023256888,       // helix_stacking_AGGC
        0.0016051973,        // helix_stacking_AGGG
        0.0011905400,        // helix_stacking_AGGU
        -0.0043204529,       // helix_stacking_AGUA
        0.0000123507,        // helix_stacking_AGUC
        0.0024923143,        // helix_stacking_AGUG
        0.0001247495,        // helix_stacking_AGUU
        -0.0215966767,       // helix_stacking_AUAC
        -0.0035255476,       // helix_stacking_AUAG
        0.0518027390,        // helix_stacking_AUAU
        -0.0050229039,       // helix_stacking_AUCC
        0.1459431996,        // helix_stacking_AUCG
        0.0033990804,        // helix_stacking_AUCU
        0.0612094217,        // helix_stacking_AUGC
        -0.0031012150,       // helix_stacking_AUGG
        -0.1303183556,       // helix_stacking_AUGU
        0.0094534785,        // helix_stacking_AUUA
        0.0004138047,        // helix_stacking_AUUC
        -0.0146550034,       // helix_stacking_AUUG
        -0.0278698572,       // helix_stacking_AUUU
        0.0046359114,        // helix_stacking_CAAC
        0.0026829630,        // helix_stacking_CAAG
        0.0045091952,        // helix_stacking_CAAU
        0.0014853523,        // helix_stacking_CACC
        -0.0223658128,       // helix_stacking_CACG
        -0.0004636247,       // helix_stacking_CACU
        -0.0315287895,       // helix_stacking_CAGC
        -0.0021407162,       // helix_stacking_CAGG
        0.0024342401,        // helix_stacking_CAGU
        -0.0045481666,       // helix_stacking_CAUC
        0.0046849945,        // helix_stacking_CAUG
        0.0012066444,        // helix_stacking_CAUU
        -0.0024135547,       // helix_stacking_CCAG
        -0.0143992421,       // helix_stacking_CCAU
        -0.0002994048,       // helix_stacking_CCCC
        -0.0068061458,       // helix_stacking_CCCG
        -0.0009760749,       // helix_stacking_CCCU
        -0.0093360932,       // helix_stacking_CCGC
        0.0003024764,        // helix_stacking_CCGG
        -0.0080543399,       // helix_stacking_CCGU
        0.0026715008,        // helix_stacking_CCUC
        -0.0022915962,       // helix_stacking_CCUG
        0.0020985332,        // helix_stacking_CCUU
        -0.0002736467,       // helix_stacking_CGAG
        -0.0361610261,       // helix_stacking_CGAU
        0.2500883770,        // helix_stacking_CGCG
        -0.0145487915,       // helix_stacking_CGCU
        0.0078506732,        // helix_stacking_CGGC
        -0.0064911443,       // helix_stacking_CGGG
        -0.1026917617,       // helix_stacking_CGGU
        -0.0050867480,       // helix_stacking_CGUC
        0.0636203774,        // helix_stacking_CGUG
        -0.0386540932,       // helix_stacking_CGUU
        -0.0002186997,       // helix_stacking_CUAG
        -0.0171955042,       // helix_stacking_CUAU
        0.0001908408,        // helix_stacking_CUCG
        0.0039647056,        // helix_stacking_CUCU
        0.0049134545,        // helix_stacking_CUGG
        0.0040977477,        // helix_stacking_CUGU
        0.0062326786,        // helix_stacking_CUUC
        -0.0052770091,       // helix_stacking_CUUG
        0.0084782464,        // helix_stacking_CUUU
        0.0039577367,        // helix_stacking_GAAG
        -0.0041512595,       // helix_stacking_GAAU
        -0.0236371976,       // helix_stacking_GACG
        0.0010720887,        // helix_stacking_GACU
        0.0058963802,        // helix_stacking_GAGG
        -0.0033430223,       // helix_stacking_GAGU
        0.0045630315,        // helix_stacking_GAUG
        0.0011977718,        // helix_stacking_GAUU
        0.1377929899,        // helix_stacking_GCAU
        -0.0732114682,       // helix_stacking_GCCG
        -0.0061849929,       // helix_stacking_GCCU
        -0.0297868529,       // helix_stacking_GCGG
        0.0314882386,        // helix_stacking_GCGU
        0.0853319371,        // helix_stacking_GCUG
        -0.0116524623,       // helix_stacking_GCUU
        0.0027814463,        // helix_stacking_GGAU
        0.0024832337,        // helix_stacking_GGCU
        0.0020626924,        // helix_stacking_GGGG
        -0.0017532709,       // helix_stacking_GGGU
        -0.0030321095,       // helix_stacking_GGUG
        0.0046032693,        // helix_stacking_GGUU
        0.0041422641,        // helix_stacking_GUAU
        -0.0055971561,       // helix_stacking_GUCU
        -0.0048565614,       // helix_stacking_GUGU
        -0.0111410303,       // helix_stacking_GUUG
        0.0072147313,        // helix_stacking_GUUU
        -0.0230543450,       // helix_stacking_UAAU
        0.0147200830,        // helix_stacking_UACU
        0.1366622997,        // helix_stacking_UAGU
        -0.0009717172,       // helix_stacking_UAUU
        0.0010344013,        // helix_stacking_UCCU
        -0.0073020854,       // helix_stacking_UCGU
        0.0076172862,        // helix_stacking_UCUU
        -0.0428702348,       // helix_stacking_UGGU
        -0.0037930703,       // helix_stacking_UGUU
        0.0086971490,        // helix_stacking_UUUU
        0.0111290732,        // helix_closing_AA
        0.0270247430,        // helix_closing_AC
        -0.0028423321,       // helix_closing_AG
        0.0390189624,        // helix_closing_AU
        0.0211701415,        // helix_closing_CA
        -0.0013545861,       // helix_closing_CC
        0.0176597530,        // helix_closing_CG
        -0.0048870347,       // helix_closing_CU
        0.0024511733,        // helix_closing_GA
        -0.1668369921,       // helix_closing_GC
        -0.0045296329,       // helix_closing_GG
        -0.0370629739,       // helix_closing_GU
        -0.0747603115,       // helix_closing_UA
        -0.0042515938,       // helix_closing_UC
        0.1652654756,        // helix_closing_UG
        0.0124018913,        // helix_closing_UU
        -1.7430959250,       // multi_base
        -0.0430181711,       // multi_unpaired
        -1.9913186970,       // multi_paired
        0.0059484586,        // dangle_left_AAA
        -0.0049336344,       // dangle_left_AAC
        0.0204145569,        // dangle_left_AAG
        -0.0128266511,       // dangle_left_AAU
        -0.0027087191,       // dangle_left_ACA
        0.0119099526,        // dangle_left_ACC
        -0.0043594271,       // dangle_left_ACG
        -0.0014592214,       // dangle_left_ACU
        0.0020318568,        // dangle_left_AGA
        -0.0046416364,       // dangle_left_AGC
        0.0025956860,        // dangle_left_AGG
        0.0004582146,        // dangle_left_AGU
        -0.0399550283,       // dangle_left_AUA
        -0.0393332446,       // dangle_left_AUC
        0.0084976262,        // dangle_left_AUG
        0.0285409363,        // dangle_left_AUU
        -0.0008038518,       // dangle_left_CAA
        -0.0018285619,       // dangle_left_CAC
        0.0043056902,        // dangle_left_CAG
        -0.0006153586,       // dangle_left_CAU
        -0.0085119900,       // dangle_left_CCA
        0.0088225020,        // dangle_left_CCC
        -0.0028637441,       // dangle_left_CCG
        -0.0030859801,       // dangle_left_CCU
        0.1969440519,        // dangle_left_CGA
        -0.0559775852,       // dangle_left_CGC
        -0.0716728342,       // dangle_left_CGG
        -0.0601406211,       // dangle_left_CGU
        0.0087569866,        // dangle_left_CUA
        -0.0017690716,       // dangle_left_CUC
        -0.0000717762,       // dangle_left_CUG
        -0.0053524871,       // dangle_left_CUU
        0.0013403218,        // dangle_left_GAA
        -0.0014500232,       // dangle_left_GAC
        -0.0044922283,       // dangle_left_GAG
        -0.0049318446,       // dangle_left_GAU
        -0.0281446778,       // dangle_left_GCA
        -0.1196813055,       // dangle_left_GCC
        0.0276093334,        // dangle_left_GCG
        -0.1151969255,       // dangle_left_GCU
        0.0067863632,        // dangle_left_GGA
        -0.0077898484,       // dangle_left_GGC
        -0.0025365572,       // dangle_left_GGG
        -0.0022597446,       // dangle_left_GGU
        0.0177611804,        // dangle_left_GUA
        0.0187004959,        // dangle_left_GUC
        -0.0015319172,       // dangle_left_GUG
        0.0173535396,        // dangle_left_GUU
        0.0787220482,        // dangle_left_UAA
        0.0345397075,        // dangle_left_UAC
        -0.0912635895,       // dangle_left_UAG
        -0.1141568474,       // dangle_left_UAU
        -0.0015421884,       // dangle_left_UCA
        0.0001140509,        // dangle_left_UCC
        -0.0064963988,       // dangle_left_UCG
        -0.0006285923,       // dangle_left_UCU
        0.0629823003,        // dangle_left_UGA
        -0.0414548628,       // dangle_left_UGC
        0.1677199451,        // dangle_left_UGG
        -0.0551510026,       // dangle_left_UGU
        0.0118813392,        // dangle_left_UUA
        -0.0057919347,       // dangle_left_UUC
        -0.0099113140,       // dangle_left_UUG
        0.0029648344,        // dangle_left_UUU
        -0.0086526685,       // dangle_right_AAA
        0.0065100646,        // dangle_right_AAC
        -0.0020008295,       // dangle_right_AAG
        0.0005196107,        // dangle_right_AAU
        -0.0110463344,       // dangle_right_ACA
        0.0034727923,        // dangle_right_ACC
        0.0047011131,        // dangle_right_ACG
        0.0023581747,        // dangle_right_ACU
        0.0084856542,        // dangle_right_AGA
        -0.0008570779,       // dangle_right_AGC
        -0.0020194887,       // dangle_right_AGG
        -0.0038615974,       // dangle_right_AGU
        0.0955302314,        // dangle_right_AUA
        -0.0406921612,       // dangle_right_AUC
        0.0204608955,        // dangle_right_AUG
        -0.1201069678,       // dangle_right_AUU
        0.0019942146,        // dangle_right_CAA
        0.0022125209,        // dangle_right_CAC
        -0.0017300964,       // dangle_right_CAG
        0.0016799291,        // dangle_right_CAU
        0.0074264479,        // dangle_right_CCA
        -0.0041222471,       // dangle_right_CCC
        -0.0004970750,       // dangle_right_CCG
        -0.0059403146,       // dangle_right_CCU
        0.0349666395,        // dangle_right_CGA
        0.0084934348,        // dangle_right_CGC
        0.0218719383,        // dangle_right_CGG
        -0.1189782197,       // dangle_right_CGU
        0.0000083639,        // dangle_right_CUA
        -0.0043548711,       // dangle_right_CUC
        0.0022738498,        // dangle_right_CUG
        -0.0035945182,       // dangle_right_CUU
        -0.0026194444,       // dangle_right_GAA
        -0.0063562732,       // dangle_right_GAC
        -0.0059790190,       // dangle_right_GAG
        0.0015943826,        // dangle_right_GAU
        0.0229991813,        // dangle_right_GCA
        -0.0373967608,       // dangle_right_GCC
        -0.1860843714,       // dangle_right_GCG
        -0.0376274758,       // dangle_right_GCU
        -0.0061922724,       // dangle_right_GGA
        0.0077674626,        // dangle_right_GGC
        -0.0068004395,       // dangle_right_GGG
        -0.0035016427,       // dangle_right_GGU
        0.0686692897,        // dangle_right_GUA
        -0.0223187205,       // dangle_right_GUC
        0.0044172360,        // dangle_right_GUG
        -0.0419975662,       // dangle_right_GUU
        -0.1152577330,       // dangle_right_UAA
        0.0430268951,        // dangle_right_UAC
        0.1803824889,        // dangle_right_UAG
        -0.1840398136,       // dangle_right_UAU
        -0.0044671635,       // dangle_right_UCA
        0.0055419306,        // dangle_right_UCC
        -0.0039851961,       // dangle_right_UCG
        -0.0051780076,       // dangle_right_UCU
        0.1569276650,        // dangle_right_UGA
        0.0888593233,        // dangle_right_UGC
        -0.1080537799,       // dangle_right_UGG
        0.0313180684,        // dangle_right_UGU
        0.0038559609,        // dangle_right_UUA
        0.0065810819,        // dangle_right_UUC
        -0.0063469793,       // dangle_right_UUG
        -0.0109881502,       // dangle_right_UUU
        0.0388346167,        // external_unpaired
        -0.2577193192        // external_paired
    };

    return std::vector<RealT>(values, values + 708);
}

