# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import os
import sys

import mock  # noqa: available on readthedocs

sys.path.insert(0, os.path.abspath(".."))
# c_metrics is created, but rtd can't find it for some reason
# to fix this we do a mock import
MOCK_MODULES = ["gimmemotifs.c_metrics"]
for mod_name in MOCK_MODULES:
    sys.modules[mod_name] = mock.Mock()

from gimmemotifs import __version__  # noqa

# test if the import succeeded
print("\ngimmemotifs version:", __version__, "\n")


# -- Project information -----------------------------------------------------

project = "GimmeMotifs"
copyright = "2022, Simon van Heeringen, licensed under CC BY 4.0"
author = "Simon van Heeringen, Siebren Frölich, Maarten van der Sande"

# Major, minor and hotfix versions
version = __version__.split("+")[0]
# The full version, including alpha/beta/rc tags
release = __version__


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",  # automatic documentation from docstrings
    "sphinx.ext.coverage",  # gather documentation coverage stats
    "sphinx.ext.napoleon",  # recognize numpy & google style docstrings
    "sphinx.ext.autosummary",  # Create neat summary tables
    # 'numpydoc',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "bootstrap"  # 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


# -- Extension configuration -------------------------------------------------
