#pragma once
#include "common.hpp"  // arch macros

#include <cstdint>

#ifdef SVB16_X64
static constexpr uint8_t g_encode_shuffle_table[128 * 16] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
    0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
};

static uint8_t const g_decode_shuffle_table[256][16] = {
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0xFF},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E,
     0xFF},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0xFF,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0xFF,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0xFF,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0xFF,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0xFF,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0xFF,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0xFF,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0xFF,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0xFF,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0xFF,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0xFF,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D},
    {0x00,
     0x01,
     0x02,
     0xFF,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0xFF,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E},
    {0x00,
     0x01,
     0x02,
     0x03,
     0x04,
     0x05,
     0x06,
     0x07,
     0x08,
     0x09,
     0x0A,
     0x0B,
     0x0C,
     0x0D,
     0x0E,
     0x0F},
};

#endif
