# --------------------------------------------------------------------------
#                   OpenMS -- Open-Source Mass Spectrometry
# --------------------------------------------------------------------------
# Copyright OpenMS Inc. -- Eberhard Karls University Tuebingen,
# ETH Zurich, and Freie Universitaet Berlin 2002-present.
#
# This software is released under a three-clause BSD license:
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#  * Neither the name of any author or any participating institution
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
# For a full list of authors, refer to the file AUTHORS.
# --------------------------------------------------------------------------
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
# INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# --------------------------------------------------------------------------
# $Maintainer: Julianus Pfeuffer $
# $Authors: Julianus Pfeuffer $
# --------------------------------------------------------------------------


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was OpenMSConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

### CMake OpenMS config file for external code
### configured by the OpenMS build system from <OpenMS>/cmake/OpenMSConfig.cmake.in

include(CMakeFindDependencyMacro)
list(PREPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/Modules/")

# to mimic OpenMS CMake for finding dependencies
if(DEFINED OPENMS_CONTRIB_LIBS)
  list(PREPEND CMAKE_PREFIX_PATH ${OPENMS_CONTRIB_LIBS})
endif()

#------------------------------------------------------------------------------

#TODO somehow add the same/compatible versions that were found by OpenMS? And what about static vs dynamic? E.g. if we link to static zlib in OpenMS(.dll) what (if at all) can/should the consumer link against?
find_dependency(Qt6 6.1.0 COMPONENTS Core;Network)
find_dependency(XercesC)
find_dependency(Eigen3 3.3.4)
find_dependency(LIBSVM 2.91)

# Rest are private linked libraries
#find_dependency(Boost COMPONENTS date_time;regex)
#find_dependency(COIN)
#find_dependency(GLPK)
#find_dependency(ZLIB)
#find_dependency(BZip2)
#find_dependency(SQLite3 3.15.0)
#find_dependency(HDF5)

if (TRUE)
  find_dependency(Threads)
  find_dependency(OpenMP COMPONENTS CXX)
endif()

# TODO also find GUI dependencies by default? Probably leave it up to the dev, if they need it.
#  We should probably create components, e.g. OpenMS::Core, OpenMS::Gui, ...

# we need this to reference the target file
get_filename_component(OPENMS_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# include directories for targets


set(OPENMS_ADDCXX_FLAGS "")
set(OPENMS_DATA_DIR "${PACKAGE_PREFIX_DIR}/share/OpenMS")
set(OPENMS_SHARE_DIR "${PACKAGE_PREFIX_DIR}/share/OpenMS")
set(OPENMS_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(OPENMS_DOC_DIR "${PACKAGE_PREFIX_DIR}/share/doc")
set(OPENMS_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")

## The targets file
include("${OPENMS_CMAKE_DIR}/OpenMSTargets.cmake")
