# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: QualityControl
doc: "Computes various QC metrics.\nMany input formats are supported only the consensusXML is required.\nThe more optional files you provide, the more metrics you get."
inputs:
  in_cm:
    doc: ConsensusXML input, generated by FeatureLinker.
    type: File
  in_raw:
    doc: MzML input (after InternalCalibration, if available)
    type: File[]?
  in_postFDR:
    doc: FeatureXMLs after FDR filtering
    type: File[]?
  out:
    doc: Output mzTab with QC information
    type: string?
  out_cm:
    doc: ConsensusXML with QC information (as metavalues)
    type: string?
  in_contaminants:
    doc: Proteins considered contaminants
    type: File?
  in_fasta:
    doc: FASTA file used during MS/MS identification (including decoys). If the protein description contains 'GN=...' then gene names will be extracted
    type: File?
  in_trafo:
    doc: trafoXMLs from MapAligners
    type: File[]?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
  FragmentMassError__unit:
    doc: Unit for mass tolerance. 'auto' uses information from FeatureXML
    type: string?
  FragmentMassError__tolerance:
    doc: m/z search window for matching peaks in two spectra
    type: double?
  MS2_id_rate__assume_all_target:
    doc: Forces the metric to run even if target/decoy annotation is missing (accepts all pep_ids as target hits).
    type: boolean?
  out_txt__directory:
    doc: If a Path is given, '.txt' files compatible with MaxQuant will be created in this directory. If the directory does not exist, it will be created.
    type: string?
  out_txt__omit_mq_evidence:
    doc: Do NOT write the evidence.txt into 'out_txt:directory'?
    type: boolean?
  out_txt__omit_mq_msms:
    doc: Do NOT write the msms.txt into 'out_txt:directory'?
    type: boolean?
outputs:
  out:
    type: File?
    outputBinding:
      glob: $(inputs.out)
  out_cm:
    type: File?
    outputBinding:
      glob: $(inputs.out_cm)
  out_txt__directory:
    type: Directory?
    outputBinding:
      glob: $(inputs.out_txt__directory)
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - QualityControl
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
