from __future__ import annotations
from typing import overload, Any, List, Dict, Tuple, Set, Sequence, Union
from pyopenms import *  # pylint: disable=wildcard-import; lgtm(py/polluting-import)
import numpy as _np

from enum import Enum as _PyEnum


def __static_SpectrumMetaDataLookup_addMissingIMToPeptideIDs(in_0: List[PeptideIdentification] , exp: MSExperiment ) -> bool:
    """
    Cython signature: bool addMissingIMToPeptideIDs(libcpp_vector[PeptideIdentification], MSExperiment exp)
    """
    ...

def __static_SpectrumMetaDataLookup_addMissingRTsToPeptideIDs(in_0: List[PeptideIdentification] , exp: MSExperiment ) -> bool:
    """
    Cython signature: bool addMissingRTsToPeptideIDs(libcpp_vector[PeptideIdentification], MSExperiment exp)
    """
    ...

def __static_SpectrumMetaDataLookup_addMissingSpectrumReferences(in_0: List[PeptideIdentification] , filename: Union[bytes, str, String] , stop_on_error: bool , override_spectra_data: bool , override_spectra_references: bool , proteins: List[ProteinIdentification] ) -> bool:
    """
    Cython signature: bool addMissingSpectrumReferences(libcpp_vector[PeptideIdentification], String filename, bool stop_on_error, bool override_spectra_data, bool override_spectra_references, libcpp_vector[ProteinIdentification] proteins)
    """
    ...

def __static_MetaboliteSpectralMatching_computeHyperScore(fragment_mass_error: float , fragment_mass_tolerance_unit_ppm: bool , exp_spectrum: MSSpectrum , db_spectrum: MSSpectrum , annotations: List[PeptideHit_PeakAnnotation] , mz_lower_bound: float ) -> float:
    """
    Cython signature: double computeHyperScore(double fragment_mass_error, bool fragment_mass_tolerance_unit_ppm, MSSpectrum exp_spectrum, MSSpectrum db_spectrum, libcpp_vector[PeptideHit_PeakAnnotation] & annotations, double mz_lower_bound)
    """
    ...

def __static_ExperimentalDesign_fromConsensusMap(c: ConsensusMap ) -> ExperimentalDesign:
    """
    Cython signature: ExperimentalDesign fromConsensusMap(ConsensusMap c)
    """
    ...

def __static_ExperimentalDesign_fromFeatureMap(f: FeatureMap ) -> ExperimentalDesign:
    """
    Cython signature: ExperimentalDesign fromFeatureMap(FeatureMap f)
    """
    ...

def __static_ExperimentalDesign_fromIdentifications(proteins: List[ProteinIdentification] ) -> ExperimentalDesign:
    """
    Cython signature: ExperimentalDesign fromIdentifications(libcpp_vector[ProteinIdentification] & proteins)
    """
    ...

def __static_SpectrumMetaDataLookup_getSpectrumMetaData(spectrum: MSSpectrum , meta: SpectrumMetaData ) -> None:
    """
    Cython signature: void getSpectrumMetaData(MSSpectrum spectrum, SpectrumMetaData & meta)
    """
    ...

def __static_SpectrumHelper_removePeaks(p: MSChromatogram , pos_start: float , pos_end: float ) -> None:
    """
    Cython signature: void removePeaks(MSChromatogram & p, double pos_start, double pos_end)
    """
    ...

def __static_SpectrumHelper_removePeaks(p: MSSpectrum , pos_start: float , pos_end: float ) -> None:
    """
    Cython signature: void removePeaks(MSSpectrum & p, double pos_start, double pos_end)
    """
    ...

def __static_SpectrumHelper_subtractMinimumIntensity(p: MSChromatogram ) -> None:
    """
    Cython signature: void subtractMinimumIntensity(MSChromatogram & p)
    """
    ...

def __static_SpectrumHelper_subtractMinimumIntensity(p: MSSpectrum ) -> None:
    """
    Cython signature: void subtractMinimumIntensity(MSSpectrum & p)
    """
    ...


class BSpline2d:
    """
    Cython implementation of _BSpline2d

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1BSpline2d.html>`_
    """
    
    def __init__(self, x: List[float] , y: List[float] , wave_length: float , boundary_condition: int , num_nodes: int ) -> None:
        """
        Cython signature: void BSpline2d(libcpp_vector[double] x, libcpp_vector[double] y, double wave_length, BoundaryCondition boundary_condition, size_t num_nodes)
        """
        ...
    
    def solve(self, y: List[float] ) -> bool:
        """
        Cython signature: bool solve(libcpp_vector[double] y)
        Solve the spline curve for a new set of y values. Returns false if the solution fails
        """
        ...
    
    def eval(self, x: float ) -> float:
        """
        Cython signature: double eval(double x)
        Returns the evaluation of the smoothed curve at a particular x value. If current state is not ok(), returns zero
        """
        ...
    
    def derivative(self, x: float ) -> float:
        """
        Cython signature: double derivative(double x)
        Returns the first derivative of the spline curve at the given position x. Returns zero if the current state is not ok()
        """
        ...
    
    def ok(self) -> bool:
        """
        Cython signature: bool ok()
        Returns whether the spline fit was successful
        """
        ...
    
    def debug(self, enable: bool ) -> None:
        """
        Cython signature: void debug(bool enable)
        Enable or disable debug messages from the B-spline library
        """
        ... 


class Base64:
    """
    Cython implementation of _Base64

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Base64.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Base64()
        Class to encode and decode Base64, it supports two precisions 32 bit (float) and 64 bit (double).
        """
        ...
    
    @overload
    def __init__(self, in_0: Base64 ) -> None:
        """
        Cython signature: void Base64(Base64 &)
        """
        ...
    
    def encodeIntegers(self, in_: List[int] , to_byte_order: int , out: String , zlib_compression: bool ) -> None:
        """
        Cython signature: void encodeIntegers(libcpp_vector[int] & in_, ByteOrder to_byte_order, String & out, bool zlib_compression)
        Encodes a vector of integer point numbers to a Base64 string
        """
        ...
    
    def decodeIntegers(self, in_: Union[bytes, str, String] , from_byte_order: int , out: List[int] , zlib_compression: bool ) -> None:
        """
        Cython signature: void decodeIntegers(const String & in_, ByteOrder from_byte_order, libcpp_vector[int] & out, bool zlib_compression)
        Decodes a Base64 string to a vector of integer numbers
        """
        ...
    
    def encodeStrings(self, in_: List[bytes] , out: String , zlib_compression: bool ) -> None:
        """
        Cython signature: void encodeStrings(libcpp_vector[String] & in_, String & out, bool zlib_compression)
        Encodes a vector of strings to a Base64 string
        """
        ...
    
    def decodeStrings(self, in_: Union[bytes, str, String] , out: List[bytes] , zlib_compression: bool ) -> None:
        """
        Cython signature: void decodeStrings(const String & in_, libcpp_vector[String] & out, bool zlib_compression)
        Decodes a Base64 string to a vector of (null-terminated) strings
        """
        ...
    ByteOrder : __ByteOrder 


class CVMappingFile:
    """
    Cython implementation of _CVMappingFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1CVMappingFile.html>`_
    """
    
    def __init__(self) -> None:
        """
        Cython signature: void CVMappingFile()
        """
        ...
    
    def load(self, filename: Union[bytes, str, String] , cv_mappings: CVMappings , strip_namespaces: bool ) -> None:
        """
        Cython signature: void load(const String & filename, CVMappings & cv_mappings, bool strip_namespaces)
        Loads CvMappings from the given file
        """
        ... 


class ChromeleonFile:
    """
    Cython implementation of _ChromeleonFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ChromeleonFile.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ChromeleonFile()
        Load Chromeleon HPLC text file and save it into a `MSExperiment`.
        """
        ...
    
    @overload
    def __init__(self, in_0: ChromeleonFile ) -> None:
        """
        Cython signature: void ChromeleonFile(ChromeleonFile &)
        """
        ...
    
    def load(self, filename: Union[bytes, str, String] , experiment: MSExperiment ) -> None:
        """
        Cython signature: void load(const String & filename, MSExperiment & experiment)
        Load the file's data and metadata, and save it into a `MSExperiment`
        """
        ... 


class ConvexHull2D:
    """
    Cython implementation of _ConvexHull2D

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ConvexHull2D.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ConvexHull2D()
        """
        ...
    
    @overload
    def __init__(self, in_0: ConvexHull2D ) -> None:
        """
        Cython signature: void ConvexHull2D(ConvexHull2D &)
        """
        ...
    
    def clear(self) -> None:
        """
        Cython signature: void clear()
        Removes all points
        """
        ...
    
    def compress(self) -> int:
        """
        Cython signature: size_t compress()
        Allows to reduce the disk/memory footprint of a hull
        """
        ...
    
    def expandToBoundingBox(self) -> None:
        """
        Cython signature: void expandToBoundingBox()
        Expand a convex hull to its bounding box.
        """
        ...
    
    def addPoint(self, point: Union[Sequence[int], Sequence[float]] ) -> bool:
        """
        Cython signature: bool addPoint(DPosition2 point)
        Adds a point to the hull if it is not already contained. Returns if the point was added. This will trigger recomputation of the outer hull points (thus points set with setHullPoints() will be lost)
        """
        ...
    
    def addPoints(self, points: '_np.ndarray[Any, _np.dtype[_np.float32]]' ) -> None:
        """
        Cython signature: void addPoints(libcpp_vector[DPosition2] points)
        Adds points to the hull if it is not already contained. This will trigger recomputation of the outer hull points (thus points set with setHullPoints() will be lost)
        """
        ...
    
    def encloses(self, in_0: Union[Sequence[int], Sequence[float]] ) -> bool:
        """
        Cython signature: bool encloses(DPosition2)
        Returns if the `point` lies in the feature hull
        """
        ...
    
    def getHullPoints(self) -> '_np.ndarray[Any, _np.dtype[_np.float32]]':
        """
        Cython signature: libcpp_vector[DPosition2] getHullPoints()
        Accessor for the outer points
        """
        ...
    
    def setHullPoints(self, in_0: '_np.ndarray[Any, _np.dtype[_np.float32]]' ) -> None:
        """
        Cython signature: void setHullPoints(libcpp_vector[DPosition2])
        Accessor for the outer(!) points (no checking is performed if this is actually a convex hull)
        """
        ...
    
    def getBoundingBox(self) -> DBoundingBox2:
        """
        Cython signature: DBoundingBox2 getBoundingBox()
        Returns the bounding box of the feature hull points
        """
        ...
    
    def __richcmp__(self, other: ConvexHull2D, op: int) -> Any:
        ... 


class DigestionEnzymeProtein:
    """
    Cython implementation of _DigestionEnzymeProtein

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1DigestionEnzymeProtein.html>`_
      -- Inherits from ['DigestionEnzyme']

    Representation of a digestion enzyme for proteins (protease)
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void DigestionEnzymeProtein()
        """
        ...
    
    @overload
    def __init__(self, in_0: DigestionEnzymeProtein ) -> None:
        """
        Cython signature: void DigestionEnzymeProtein(DigestionEnzymeProtein &)
        """
        ...
    
    @overload
    def __init__(self, name: Union[bytes, str, String] , cleavage_regex: Union[bytes, str, String] , synonyms: Set[bytes] , regex_description: Union[bytes, str, String] , n_term_gain: EmpiricalFormula , c_term_gain: EmpiricalFormula , psi_id: Union[bytes, str, String] , xtandem_id: Union[bytes, str, String] , comet_id: int , omssa_id: int ) -> None:
        """
        Cython signature: void DigestionEnzymeProtein(String name, String cleavage_regex, libcpp_set[String] synonyms, String regex_description, EmpiricalFormula n_term_gain, EmpiricalFormula c_term_gain, String psi_id, String xtandem_id, unsigned int comet_id, unsigned int omssa_id)
        """
        ...
    
    def setNTermGain(self, value: EmpiricalFormula ) -> None:
        """
        Cython signature: void setNTermGain(EmpiricalFormula value)
        Sets the N-term gain
        """
        ...
    
    def setCTermGain(self, value: EmpiricalFormula ) -> None:
        """
        Cython signature: void setCTermGain(EmpiricalFormula value)
        Sets the C-term gain
        """
        ...
    
    def getNTermGain(self) -> EmpiricalFormula:
        """
        Cython signature: EmpiricalFormula getNTermGain()
        Returns the N-term gain
        """
        ...
    
    def getCTermGain(self) -> EmpiricalFormula:
        """
        Cython signature: EmpiricalFormula getCTermGain()
        Returns the C-term gain
        """
        ...
    
    def setPSIID(self, value: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setPSIID(String value)
        Sets the PSI ID
        """
        ...
    
    def getPSIID(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getPSIID()
        Returns the PSI ID
        """
        ...
    
    def setXTandemID(self, value: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setXTandemID(String value)
        Sets the X! Tandem enzyme ID
        """
        ...
    
    def getXTandemID(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getXTandemID()
        Returns the X! Tandem enzyme ID
        """
        ...
    
    def setCometID(self, value: int ) -> None:
        """
        Cython signature: void setCometID(int value)
        Sets the Comet enzyme ID
        """
        ...
    
    def getCometID(self) -> int:
        """
        Cython signature: int getCometID()
        Returns the Comet enzyme ID
        """
        ...
    
    def setOMSSAID(self, value: int ) -> None:
        """
        Cython signature: void setOMSSAID(int value)
        Sets the OMSSA enzyme ID
        """
        ...
    
    def getOMSSAID(self) -> int:
        """
        Cython signature: int getOMSSAID()
        Returns the OMSSA enzyme ID
        """
        ...
    
    def setMSGFID(self, value: int ) -> None:
        """
        Cython signature: void setMSGFID(int value)
        Sets the MSGFPlus enzyme id
        """
        ...
    
    def getMSGFID(self) -> int:
        """
        Cython signature: int getMSGFID()
        Returns the MSGFPlus enzyme id
        """
        ...
    
    def setName(self, name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String & name)
        Sets the name of the enzyme
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name of the enzyme
        """
        ...
    
    def setSynonyms(self, synonyms: Set[bytes] ) -> None:
        """
        Cython signature: void setSynonyms(libcpp_set[String] & synonyms)
        Sets the synonyms
        """
        ...
    
    def addSynonym(self, synonym: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void addSynonym(const String & synonym)
        Adds a synonym
        """
        ...
    
    def getSynonyms(self) -> Set[bytes]:
        """
        Cython signature: libcpp_set[String] getSynonyms()
        Returns the synonyms
        """
        ...
    
    def setRegEx(self, cleavage_regex: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setRegEx(const String & cleavage_regex)
        Sets the cleavage regex
        """
        ...
    
    def getRegEx(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getRegEx()
        Returns the cleavage regex
        """
        ...
    
    def setRegExDescription(self, value: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setRegExDescription(const String & value)
        Sets the regex description
        """
        ...
    
    def getRegExDescription(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getRegExDescription()
        Returns the regex description
        """
        ...
    
    def setValueFromFile(self, key: Union[bytes, str, String] , value: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool setValueFromFile(String key, String value)
        Sets the value of a member variable based on an entry from an input file
        """
        ...
    
    def __richcmp__(self, other: DigestionEnzymeProtein, op: int) -> Any:
        ... 


class __DigestionFilter:
    """
    Cython implementation of _DigestionFilter

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1DigestionFilter.html>`_
    """
    
    digestion_: ProteaseDigestion
    
    ignore_missed_cleavages_: bool
    
    methionine_cleavage_: bool
    
    def __init__(self, entries: List[FASTAEntry] , digestion: ProteaseDigestion , ignore_missed_cleavages: bool , methionine_cleavage: bool ) -> None:
        """
        Cython signature: void DigestionFilter(libcpp_vector[FASTAEntry] & entries, ProteaseDigestion & digestion, bool ignore_missed_cleavages, bool methionine_cleavage)
        """
        ...
    
    def filterPeptideEvidences(self, peptides: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void filterPeptideEvidences(libcpp_vector[PeptideIdentification] & peptides)
        """
        ... 


class EmgGradientDescent:
    """
    Cython implementation of _EmgGradientDescent

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1EmgGradientDescent.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void EmgGradientDescent()
        Compute the area, background and shape metrics of a peak
        """
        ...
    
    @overload
    def __init__(self, in_0: EmgGradientDescent ) -> None:
        """
        Cython signature: void EmgGradientDescent(EmgGradientDescent &)
        """
        ...
    
    def getDefaultParameters(self, in_0: Param ) -> None:
        """
        Cython signature: void getDefaultParameters(Param &)
        """
        ...
    
    @overload
    def fitEMGPeakModel(self, input_peak: MSChromatogram , output_peak: MSChromatogram ) -> None:
        """
        Cython signature: void fitEMGPeakModel(MSChromatogram & input_peak, MSChromatogram & output_peak)
        """
        ...
    
    @overload
    def fitEMGPeakModel(self, input_peak: MSSpectrum , output_peak: MSSpectrum ) -> None:
        """
        Cython signature: void fitEMGPeakModel(MSSpectrum & input_peak, MSSpectrum & output_peak)
        """
        ...
    
    @overload
    def fitEMGPeakModel(self, input_peak: MSChromatogram , output_peak: MSChromatogram , left_pos: float , right_pos: float ) -> None:
        """
        Cython signature: void fitEMGPeakModel(MSChromatogram & input_peak, MSChromatogram & output_peak, double left_pos, double right_pos)
        """
        ...
    
    @overload
    def fitEMGPeakModel(self, input_peak: MSSpectrum , output_peak: MSSpectrum , left_pos: float , right_pos: float ) -> None:
        """
        Cython signature: void fitEMGPeakModel(MSSpectrum & input_peak, MSSpectrum & output_peak, double left_pos, double right_pos)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class ExperimentalDesign:
    """
    Cython implementation of _ExperimentalDesign

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ExperimentalDesign.html>`_

    Representation of an experimental design in OpenMS. Instances can be loaded with the ExperimentalDesignFile class
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ExperimentalDesign()
        """
        ...
    
    @overload
    def __init__(self, in_0: ExperimentalDesign ) -> None:
        """
        Cython signature: void ExperimentalDesign(ExperimentalDesign &)
        """
        ...
    
    def getMSFileSection(self) -> List[ExperimentalDesign_MSFileSectionEntry]:
        """
        Cython signature: libcpp_vector[ExperimentalDesign_MSFileSectionEntry] getMSFileSection()
        """
        ...
    
    def setMSFileSection(self, msfile_section: List[ExperimentalDesign_MSFileSectionEntry] ) -> None:
        """
        Cython signature: void setMSFileSection(libcpp_vector[ExperimentalDesign_MSFileSectionEntry] msfile_section)
        """
        ...
    
    def getSampleSection(self) -> ExperimentalDesign_SampleSection:
        """
        Cython signature: ExperimentalDesign_SampleSection getSampleSection()
        Returns the Sample Section of the experimental design file
        """
        ...
    
    def setSampleSection(self, sample_section: ExperimentalDesign_SampleSection ) -> None:
        """
        Cython signature: void setSampleSection(ExperimentalDesign_SampleSection sample_section)
        Sets the Sample Section of the experimental design file
        """
        ...
    
    def getNumberOfSamples(self) -> int:
        """
        Cython signature: unsigned int getNumberOfSamples()
        Returns the number of samples measured (= highest sample index)
        """
        ...
    
    def getNumberOfFractions(self) -> int:
        """
        Cython signature: unsigned int getNumberOfFractions()
        Returns the number of fractions (= highest fraction index)
        """
        ...
    
    def getNumberOfLabels(self) -> int:
        """
        Cython signature: unsigned int getNumberOfLabels()
        Returns the number of labels per file
        """
        ...
    
    def getNumberOfMSFiles(self) -> int:
        """
        Cython signature: unsigned int getNumberOfMSFiles()
        Returns the number of MS files (= fractions * fraction_groups)
        """
        ...
    
    def getNumberOfFractionGroups(self) -> int:
        """
        Cython signature: unsigned int getNumberOfFractionGroups()
        Allows to group fraction ids and source files. Return the number of fraction_groups
        """
        ...
    
    def getSample(self, fraction_group: int , label: int ) -> int:
        """
        Cython signature: unsigned int getSample(unsigned int fraction_group, unsigned int label)
        Returns sample index (depends on fraction_group and label)
        """
        ...
    
    def isFractionated(self) -> bool:
        """
        Cython signature: bool isFractionated()
        Returns whether at least one fraction_group in this experimental design is fractionated
        """
        ...
    
    def sameNrOfMSFilesPerFraction(self) -> bool:
        """
        Cython signature: bool sameNrOfMSFilesPerFraction()
        Returns if each fraction number is associated with the same number of fraction_group
        """
        ...
    
    fromConsensusMap: __static_ExperimentalDesign_fromConsensusMap
    
    fromFeatureMap: __static_ExperimentalDesign_fromFeatureMap
    
    fromIdentifications: __static_ExperimentalDesign_fromIdentifications 


class ExperimentalDesign_MSFileSectionEntry:
    """
    Cython implementation of _ExperimentalDesign_MSFileSectionEntry

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ExperimentalDesign_MSFileSectionEntry.html>`_
    """
    
    path: bytes
    
    fraction_group: int
    
    fraction: int
    
    label: int
    
    sample: int
    
    def __init__(self) -> None:
        """
        Cython signature: void ExperimentalDesign_MSFileSectionEntry()
        """
        ... 


class ExperimentalDesign_SampleSection:
    """
    Cython implementation of _ExperimentalDesign_SampleSection

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ExperimentalDesign_SampleSection.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ExperimentalDesign_SampleSection()
        """
        ...
    
    @overload
    def __init__(self, in_0: ExperimentalDesign_SampleSection ) -> None:
        """
        Cython signature: void ExperimentalDesign_SampleSection(ExperimentalDesign_SampleSection)
        """
        ...
    
    def getSamples(self) -> Set[bytes]:
        """
        Cython signature: libcpp_set[String] getSamples()
        Returns a set of all samples that are present in the sample section
        """
        ...
    
    def getFactors(self) -> Set[bytes]:
        """
        Cython signature: libcpp_set[String] getFactors()
        Returns a set of all factors (column names) that were defined for the sample section
        """
        ...
    
    def hasSample(self, sample: int ) -> bool:
        """
        Cython signature: bool hasSample(unsigned int sample)
        Checks whether sample section has row for a sample number
        """
        ...
    
    def hasFactor(self, factor: String ) -> bool:
        """
        Cython signature: bool hasFactor(String & factor)
        Checks whether Sample Section has a specific factor (i.e. column name)
        """
        ...
    
    def getFactorValue(self, sample: int , factor: String ) -> Union[bytes, str, String]:
        """
        Cython signature: String getFactorValue(unsigned int sample, String & factor)
        Returns value of factor for given sample and factor name
        """
        ... 


class ExperimentalSettings:
    """
    Cython implementation of _ExperimentalSettings

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ExperimentalSettings.html>`_
      -- Inherits from ['DocumentIdentifier', 'MetaInfoInterface']

    Description of the experimental settings, provides meta-information
    about an LC-MS/MS injection.
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ExperimentalSettings()
        """
        ...
    
    @overload
    def __init__(self, in_0: ExperimentalSettings ) -> None:
        """
        Cython signature: void ExperimentalSettings(ExperimentalSettings &)
        """
        ...
    
    def getSourceFiles(self) -> List[SourceFile]:
        """
        Cython signature: libcpp_vector[SourceFile] getSourceFiles()
        Returns a reference to the source data file
        """
        ...
    
    def setSourceFiles(self, source_files: List[SourceFile] ) -> None:
        """
        Cython signature: void setSourceFiles(libcpp_vector[SourceFile] source_files)
        Sets the source data file
        """
        ...
    
    def getDateTime(self) -> DateTime:
        """
        Cython signature: DateTime getDateTime()
        Returns the date the experiment was performed
        """
        ...
    
    def setDateTime(self, date_time: DateTime ) -> None:
        """
        Cython signature: void setDateTime(DateTime date_time)
        Sets the date the experiment was performed
        """
        ...
    
    def getSample(self) -> Sample:
        """
        Cython signature: Sample getSample()
        Returns a reference to the sample description
        """
        ...
    
    def setSample(self, sample: Sample ) -> None:
        """
        Cython signature: void setSample(Sample sample)
        Sets the sample description
        """
        ...
    
    def getContacts(self) -> List[ContactPerson]:
        """
        Cython signature: libcpp_vector[ContactPerson] getContacts()
        Returns a reference to the list of contact persons
        """
        ...
    
    def setContacts(self, contacts: List[ContactPerson] ) -> None:
        """
        Cython signature: void setContacts(libcpp_vector[ContactPerson] contacts)
        Sets the list of contact persons
        """
        ...
    
    def getInstrument(self) -> Instrument:
        """
        Cython signature: Instrument getInstrument()
        Returns a reference to the MS instrument description
        """
        ...
    
    def setInstrument(self, instrument: Instrument ) -> None:
        """
        Cython signature: void setInstrument(Instrument instrument)
        Sets the MS instrument description
        """
        ...
    
    def getHPLC(self) -> HPLC:
        """
        Cython signature: HPLC getHPLC()
        Returns a reference to the description of the HPLC run
        """
        ...
    
    def setHPLC(self, hplc: HPLC ) -> None:
        """
        Cython signature: void setHPLC(HPLC hplc)
        Sets the description of the HPLC run
        """
        ...
    
    def getComment(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getComment()
        Returns the free-text comment
        """
        ...
    
    def setComment(self, comment: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setComment(String comment)
        Sets the free-text comment
        """
        ...
    
    def getProteinIdentifications(self) -> List[ProteinIdentification]:
        """
        Cython signature: libcpp_vector[ProteinIdentification] getProteinIdentifications()
        Returns a reference to the protein ProteinIdentification vector
        """
        ...
    
    def setProteinIdentifications(self, protein_identifications: List[ProteinIdentification] ) -> None:
        """
        Cython signature: void setProteinIdentifications(libcpp_vector[ProteinIdentification] protein_identifications)
        Sets the protein ProteinIdentification vector
        """
        ...
    
    def getFractionIdentifier(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getFractionIdentifier()
        Returns fraction identifier
        """
        ...
    
    def setFractionIdentifier(self, fraction_identifier: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setFractionIdentifier(String fraction_identifier)
        Sets the fraction identifier
        """
        ...
    
    def setIdentifier(self, id: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setIdentifier(String id)
        Sets document identifier (e.g. an LSID)
        """
        ...
    
    def getIdentifier(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getIdentifier()
        Retrieve document identifier (e.g. an LSID)
        """
        ...
    
    def setLoadedFileType(self, file_name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setLoadedFileType(String file_name)
        Sets the file_type according to the type of the file loaded from, preferably done whilst loading
        """
        ...
    
    def getLoadedFileType(self) -> int:
        """
        Cython signature: int getLoadedFileType()
        Returns the file_type (e.g. featureXML, consensusXML, mzData, mzXML, mzML, ...) of the file loaded
        """
        ...
    
    def setLoadedFilePath(self, file_name: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setLoadedFilePath(String file_name)
        Sets the file_name according to absolute path of the file loaded, preferably done whilst loading
        """
        ...
    
    def getLoadedFilePath(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getLoadedFilePath()
        Returns the file_name which is the absolute path to the file loaded
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: ExperimentalSettings, op: int) -> Any:
        ... 


class FIAMSScheduler:
    """
    Cython implementation of _FIAMSScheduler

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1FIAMSScheduler.html>`_

      ADD PYTHON DOCUMENTATION HERE
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void FIAMSScheduler()
        Scheduler for FIA-MS data batches. Works with FIAMSDataProcessor
        """
        ...
    
    @overload
    def __init__(self, in_0: FIAMSScheduler ) -> None:
        """
        Cython signature: void FIAMSScheduler(FIAMSScheduler &)
        """
        ...
    
    @overload
    def __init__(self, filename: Union[bytes, str, String] , base_dir: Union[bytes, str, String] , load_cached_: bool ) -> None:
        """
        Cython signature: void FIAMSScheduler(String filename, String base_dir, bool load_cached_)
        """
        ...
    
    def run(self) -> None:
        """
        Cython signature: void run()
        Run the FIA-MS data analysis for the batch defined in the @filename_
        """
        ...
    
    def getBaseDir(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getBaseDir()
        Returns the base directory for the relevant paths from the csv file
        """
        ... 


class GridBasedCluster:
    """
    Cython implementation of _GridBasedCluster

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1GridBasedCluster.html>`_
    """
    
    @overload
    def __init__(self, centre: Union[Sequence[int], Sequence[float]] , bounding_box: DBoundingBox2 , point_indices: List[int] , property_A: int , properties_B: List[int] ) -> None:
        """
        Cython signature: void GridBasedCluster(DPosition2 centre, DBoundingBox2 bounding_box, libcpp_vector[int] point_indices, int property_A, libcpp_vector[int] properties_B)
        """
        ...
    
    @overload
    def __init__(self, centre: Union[Sequence[int], Sequence[float]] , bounding_box: DBoundingBox2 , point_indices: List[int] ) -> None:
        """
        Cython signature: void GridBasedCluster(DPosition2 centre, DBoundingBox2 bounding_box, libcpp_vector[int] point_indices)
        """
        ...
    
    @overload
    def __init__(self, in_0: GridBasedCluster ) -> None:
        """
        Cython signature: void GridBasedCluster(GridBasedCluster &)
        """
        ...
    
    def getCentre(self) -> Union[Sequence[int], Sequence[float]]:
        """
        Cython signature: DPosition2 getCentre()
        Returns cluster centre
        """
        ...
    
    def getBoundingBox(self) -> DBoundingBox2:
        """
        Cython signature: DBoundingBox2 getBoundingBox()
        Returns bounding box
        """
        ...
    
    def getPoints(self) -> List[int]:
        """
        Cython signature: libcpp_vector[int] getPoints()
        Returns indices of points in cluster
        """
        ...
    
    def getPropertyA(self) -> int:
        """
        Cython signature: int getPropertyA()
        Returns property A
        """
        ...
    
    def getPropertiesB(self) -> List[int]:
        """
        Cython signature: libcpp_vector[int] getPropertiesB()
        Returns properties B of all points
        """
        ... 


class IDFilter:
    """
    Cython implementation of _IDFilter

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1IDFilter.html>`_

    Finds the best-scoring hit in a vector of peptide or protein identifications\n
    
    This class provides functions for filtering collections of peptide or protein identifications according to various criteria.
    It also contains helper functions and classes (functors that implement predicates) that are used in this context.\n
    
    The filter functions modify their inputs, rather than creating filtered copies.\n
    
    Most filters work on the hit level, i.e. they remove peptide or protein hits from peptide or protein identifications (IDs).
    A few filters work on the ID level instead, i.e. they remove peptide or protein IDs from vectors thereof.
    Independent of this, the inputs for all filter functions are vectors of IDs, because the data most often comes in this form.
    This design also allows many helper objects to be set up only once per vector, rather than once per ID.\n
    
    The filter functions for vectors of peptide/protein IDs do not include clean-up steps (e.g. removal of IDs without hits, reassignment of hit ranks, ...).
    They only carry out their specific filtering operations.
    This is so filters can be chained without having to repeat clean-up operations.
    The group of clean-up functions provides helpers that are useful to ensure data integrity after filters have been applied, but it is up to the individual developer to use them when necessary.\n
    
    The filter functions for MS/MS experiments do include clean-up steps, because they filter peptide and protein IDs in conjunction and potential contradictions between the two must be eliminated.
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void IDFilter()
        """
        ...
    
    @overload
    def __init__(self, in_0: IDFilter ) -> None:
        """
        Cython signature: void IDFilter(IDFilter &)
        """
        ...
    
    @overload
    def countHits(self, identifications: List[PeptideIdentification] ) -> int:
        """
        Cython signature: size_t countHits(libcpp_vector[PeptideIdentification] identifications)
        Returns the total number of peptide hits in a vector of peptide identifications
        """
        ...
    
    @overload
    def countHits(self, identifications: List[ProteinIdentification] ) -> int:
        """
        Cython signature: size_t countHits(libcpp_vector[ProteinIdentification] identifications)
        Returns the total number of protein hits in a vector of protein identifications
        """
        ...
    
    @overload
    def getBestHit(self, identifications: List[PeptideIdentification] , assume_sorted: bool , best_hit: PeptideHit ) -> bool:
        """
        Cython signature: bool getBestHit(libcpp_vector[PeptideIdentification] identifications, bool assume_sorted, PeptideHit & best_hit)
        Finds the best-scoring hit in a vector of peptide or protein identifications\n
        
        If there are several hits with the best score, the first one is taken
        
        
        :param identifications: Vector of peptide or protein IDs, each containing one or more (peptide/protein) hits
        :param assume_sorted: Are hits sorted by score (best score first) already? This allows for faster query, since only the first hit needs to be looked at
        :param best_hit: Contains the best hit if successful in a vector of peptide identifications
        :return: true if a hit was present, false otherwise
        """
        ...
    
    @overload
    def getBestHit(self, identifications: List[ProteinIdentification] , assume_sorted: bool , best_hit: ProteinHit ) -> bool:
        """
        Cython signature: bool getBestHit(libcpp_vector[ProteinIdentification] identifications, bool assume_sorted, ProteinHit & best_hit)
        Finds the best-scoring hit in a vector of peptide or protein identifications
        
        If there are several hits with the best score, the first one is taken
        
        
        :param identifications: Vector of peptide or protein IDs, each containing one or more (peptide/protein) hits
        :param assume_sorted: Are hits sorted by score (best score first) already? This allows for faster query, since only the first hit needs to be looked at
        :param best_hit: Contains the best hit if successful in a vector of protein identifications
        :return: true if a hit was present, false otherwise
        """
        ...
    
    def extractPeptideSequences(self, peptides: List[PeptideIdentification] , sequences: Set[bytes] , ignore_mods: bool ) -> None:
        """
        Cython signature: void extractPeptideSequences(libcpp_vector[PeptideIdentification] & peptides, libcpp_set[String] & sequences, bool ignore_mods)
        Extracts all unique peptide sequences from a list of peptide IDs
        
        
        :param peptides:
        :param ignore_mods: Boolean operator default to false in case of any modifications in sequences during extraction
        :return: Sequences
        """
        ...
    
    @overload
    def updateHitRanks(self, identifications: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void updateHitRanks(libcpp_vector[PeptideIdentification] & identifications)
        Updates the hit ranks on all peptide or protein IDs
        """
        ...
    
    @overload
    def updateHitRanks(self, identifications: List[ProteinIdentification] ) -> None:
        """
        Cython signature: void updateHitRanks(libcpp_vector[ProteinIdentification] & identifications)
        Updates the hit ranks on all peptide or protein IDs
        """
        ...
    
    def removeUnreferencedProteins(self, proteins: List[ProteinIdentification] , peptides: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void removeUnreferencedProteins(libcpp_vector[ProteinIdentification] & proteins, libcpp_vector[PeptideIdentification] & peptides)
        Removes protein hits from the protein IDs in a 'cmap' that are not referenced by a peptide in the features or if requested in the unassigned peptide list
        """
        ...
    
    def updateProteinReferences(self, peptides: List[PeptideIdentification] , proteins: List[ProteinIdentification] , remove_peptides_without_reference: bool ) -> None:
        """
        Cython signature: void updateProteinReferences(libcpp_vector[PeptideIdentification] & peptides, libcpp_vector[ProteinIdentification] & proteins, bool remove_peptides_without_reference)
        Removes references to missing proteins. Only PeptideEvidence entries that reference protein hits in 'proteins' are kept in the peptide hits
        """
        ...
    
    def updateProteinGroups(self, groups: List[ProteinGroup] , hits: List[ProteinHit] ) -> bool:
        """
        Cython signature: bool updateProteinGroups(libcpp_vector[ProteinGroup] & groups, libcpp_vector[ProteinHit] & hits)
        Update protein groups after protein hits were filtered
        
        
        :param groups: Input/output protein groups
        :param hits: Available protein hits (all others are removed from the groups)
        :return: Returns whether the groups are still valid (which is the case if only whole groups, if any, were removed)
        """
        ...
    
    @overload
    def removeEmptyIdentifications(self, ids: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void removeEmptyIdentifications(libcpp_vector[PeptideIdentification] & ids)
        Removes peptide or protein identifications that have no hits in them
        """
        ...
    
    @overload
    def removeEmptyIdentifications(self, ids: List[ProteinIdentification] ) -> None:
        """
        Cython signature: void removeEmptyIdentifications(libcpp_vector[ProteinIdentification] & ids)
        Removes peptide or protein identifications that have no hits in them
        """
        ...
    
    @overload
    def filterHitsByScore(self, ids: List[PeptideIdentification] , threshold_score: float ) -> None:
        """
        Cython signature: void filterHitsByScore(libcpp_vector[PeptideIdentification] & ids, double threshold_score)
        Filters peptide or protein identifications according to the score of the hits. The score orientation has to be set to higherscorebetter in each PeptideIdentification. Only peptide/protein hits with a score at least as good as 'threshold_score' are kept
        """
        ...
    
    @overload
    def filterHitsByScore(self, ids: List[ProteinIdentification] , threshold_score: float ) -> None:
        """
        Cython signature: void filterHitsByScore(libcpp_vector[ProteinIdentification] & ids, double threshold_score)
        Filters peptide or protein identifications according to the score of the hits. The score orientation has to be set to higherscorebetter in each PeptideIdentification/ProteinIdentifiation. Only peptide/protein hits with a score at least as good as 'threshold_score' are kept
        """
        ...
    
    @overload
    def filterHitsByScore(self, experiment: MSExperiment , peptide_threshold_score: float , protein_threshold_score: float ) -> None:
        """
        Cython signature: void filterHitsByScore(MSExperiment & experiment, double peptide_threshold_score, double protein_threshold_score)
        Filters an MS/MS experiment according to score thresholds
        """
        ...
    
    def keepNBestSpectra(self, peptides: List[PeptideIdentification] , n: int ) -> None:
        """
        Cython signature: void keepNBestSpectra(libcpp_vector[PeptideIdentification] & peptides, size_t n)
        Filter identifications by "N best" PeptideIdentification objects (better PeptideIdentification means better [best] PeptideHit than other)
        """
        ...
    
    @overload
    def keepNBestHits(self, ids: List[PeptideIdentification] , n: int ) -> None:
        """
        Cython signature: void keepNBestHits(libcpp_vector[PeptideIdentification] & ids, size_t n)
        """
        ...
    
    @overload
    def keepNBestHits(self, ids: List[ProteinIdentification] , n: int ) -> None:
        """
        Cython signature: void keepNBestHits(libcpp_vector[ProteinIdentification] & ids, size_t n)
        """
        ...
    
    @overload
    def keepNBestHits(self, experiment: MSExperiment , n: int ) -> None:
        """
        Cython signature: void keepNBestHits(MSExperiment & experiment, size_t n)
        Filters an MS/MS experiment by keeping the N best peptide hits for every spectrum
        """
        ...
    
    @overload
    def filterHitsByRank(self, ids: List[PeptideIdentification] , min_rank: int , max_rank: int ) -> None:
        """
        Cython signature: void filterHitsByRank(libcpp_vector[PeptideIdentification] & ids, size_t min_rank, size_t max_rank)
        Filters peptide or protein identifications according to the ranking of the hits\n
        
        The hits between 'min_rank' and 'max_rank' (both inclusive) in each ID are kept
        Counting starts at 1, i.e. the best (highest/lowest scoring) hit has rank 1
        The ranks are (re-)computed before filtering
        'max_rank' is ignored if it is smaller than 'min_rank'
        
        
        Note: There may be several hits with the same rank in a peptide or protein ID (if the scores are the same). This method is useful if a range of higher hits is needed for decoy fairness analysis
        """
        ...
    
    @overload
    def filterHitsByRank(self, ids: List[ProteinIdentification] , min_rank: int , max_rank: int ) -> None:
        """
        Cython signature: void filterHitsByRank(libcpp_vector[ProteinIdentification] & ids, size_t min_rank, size_t max_rank)
        Filters peptide or protein identifications according to the ranking of the hits\n
        
        The hits between 'min_rank' and 'max_rank' (both inclusive) in each ID are kept
        Counting starts at 1, i.e. the best (highest/lowest scoring) hit has rank 1
        The ranks are (re-)computed before filtering
        'max_rank' is ignored if it is smaller than 'min_rank'
        
        
        Note: There may be several hits with the same rank in a peptide or protein ID (if the scores are the same). This method is useful if a range of higher hits is needed for decoy fairness analysis
        """
        ...
    
    @overload
    def removeDecoyHits(self, ids: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void removeDecoyHits(libcpp_vector[PeptideIdentification] & ids)
        Removes hits annotated as decoys from peptide or protein identifications. Checks for meta values named "target_decoy" and "isDecoy", and removes protein/peptide hits if the values are "decoy" and "true", respectively
        """
        ...
    
    @overload
    def removeDecoyHits(self, ids: List[ProteinIdentification] ) -> None:
        """
        Cython signature: void removeDecoyHits(libcpp_vector[ProteinIdentification] & ids)
        Removes hits annotated as decoys from peptide or protein identifications. Checks for meta values named "target_decoy" and "isDecoy", and removes protein/peptide hits if the values are "decoy" and "true", respectively
        """
        ...
    
    @overload
    def removeHitsMatchingProteins(self, ids: List[PeptideIdentification] , accessions: Set[bytes] ) -> None:
        """
        Cython signature: void removeHitsMatchingProteins(libcpp_vector[PeptideIdentification] & ids, libcpp_set[String] accessions)
        Filters peptide or protein identifications according to the given proteins (negative)
        """
        ...
    
    @overload
    def removeHitsMatchingProteins(self, ids: List[ProteinIdentification] , accessions: Set[bytes] ) -> None:
        """
        Cython signature: void removeHitsMatchingProteins(libcpp_vector[ProteinIdentification] & ids, libcpp_set[String] accessions)
        Filters peptide or protein identifications according to the given proteins (negative)
        """
        ...
    
    @overload
    def keepHitsMatchingProteins(self, ids: List[PeptideIdentification] , accessions: Set[bytes] ) -> None:
        """
        Cython signature: void keepHitsMatchingProteins(libcpp_vector[PeptideIdentification] & ids, libcpp_set[String] accessions)
        Filters peptide or protein identifications according to the given proteins (positive)
        """
        ...
    
    @overload
    def keepHitsMatchingProteins(self, ids: List[ProteinIdentification] , accessions: Set[bytes] ) -> None:
        """
        Cython signature: void keepHitsMatchingProteins(libcpp_vector[ProteinIdentification] & ids, libcpp_set[String] accessions)
        Filters peptide or protein identifications according to the given proteins (positive)
        """
        ...
    
    @overload
    def keepHitsMatchingProteins(self, experiment: MSExperiment , proteins: List[FASTAEntry] ) -> None:
        """
        Cython signature: void keepHitsMatchingProteins(MSExperiment & experiment, libcpp_vector[FASTAEntry] & proteins)
        """
        ...
    
    def keepBestPeptideHits(self, peptides: List[PeptideIdentification] , strict: bool ) -> None:
        """
        Cython signature: void keepBestPeptideHits(libcpp_vector[PeptideIdentification] & peptides, bool strict)
        Filters peptide identifications keeping only the single best-scoring hit per ID
        
        
        :param peptides: Input/output
        :param strict: If set, keep the best hit only if its score is unique - i.e. ties are not allowed. (Otherwise all hits with the best score is kept.)
        """
        ...
    
    def filterPeptidesByLength(self, peptides: List[PeptideIdentification] , min_length: int , max_length: int ) -> None:
        """
        Cython signature: void filterPeptidesByLength(libcpp_vector[PeptideIdentification] & peptides, size_t min_length, size_t max_length)
        Filters peptide identifications according to peptide sequence length
        """
        ...
    
    def filterPeptidesByCharge(self, peptides: List[PeptideIdentification] , min_charge: int , max_charge: int ) -> None:
        """
        Cython signature: void filterPeptidesByCharge(libcpp_vector[PeptideIdentification] & peptides, size_t min_charge, size_t max_charge)
        Filters peptide identifications according to charge state
        """
        ...
    
    def filterPeptidesByRT(self, peptides: List[PeptideIdentification] , min_rt: int , max_rt: int ) -> None:
        """
        Cython signature: void filterPeptidesByRT(libcpp_vector[PeptideIdentification] & peptides, size_t min_rt, size_t max_rt)
        Filters peptide identifications by precursor RT, keeping only IDs in the given range
        """
        ...
    
    def filterPeptidesByMZ(self, peptides: List[PeptideIdentification] , min_mz: int , max_mz: int ) -> None:
        """
        Cython signature: void filterPeptidesByMZ(libcpp_vector[PeptideIdentification] & peptides, size_t min_mz, size_t max_mz)
        Filters peptide identifications by precursor m/z, keeping only IDs in the given range
        """
        ...
    
    def filterPeptidesByMZError(self, peptides: List[PeptideIdentification] , mass_error: float , unit_ppm: bool ) -> None:
        """
        Cython signature: void filterPeptidesByMZError(libcpp_vector[PeptideIdentification] & peptides, double mass_error, bool unit_ppm)
        Filter peptide identifications according to mass deviation
        """
        ...
    
    def filterPeptidesByRTPredictPValue(self, peptides: List[PeptideIdentification] , metavalue_key: Union[bytes, str, String] , threshold: float ) -> None:
        """
        Cython signature: void filterPeptidesByRTPredictPValue(libcpp_vector[PeptideIdentification] & peptides, const String & metavalue_key, double threshold)
        Filters peptide identifications according to p-values from RTPredict\n
        
        Filters the peptide hits by the probability (p-value) of a correct peptide identification having a deviation between observed and predicted RT equal to or greater than allowed
        
        
        :param peptides: Input/output
        :param metavalue_key: Name of the meta value that holds the p-value: "predicted_RT_p_value" or "predicted_RT_p_value_first_dim"
        :param threshold: P-value threshold
        """
        ...
    
    def removePeptidesWithMatchingModifications(self, peptides: List[PeptideIdentification] , modifications: Set[bytes] ) -> None:
        """
        Cython signature: void removePeptidesWithMatchingModifications(libcpp_vector[PeptideIdentification] & peptides, libcpp_set[String] & modifications)
        Removes all peptide hits that have at least one of the given modifications
        """
        ...
    
    def keepPeptidesWithMatchingModifications(self, peptides: List[PeptideIdentification] , modifications: Set[bytes] ) -> None:
        """
        Cython signature: void keepPeptidesWithMatchingModifications(libcpp_vector[PeptideIdentification] & peptides, libcpp_set[String] & modifications)
        Keeps only peptide hits that have at least one of the given modifications
        """
        ...
    
    def removePeptidesWithMatchingSequences(self, peptides: List[PeptideIdentification] , bad_peptides: List[PeptideIdentification] , ignore_mods: bool ) -> None:
        """
        Cython signature: void removePeptidesWithMatchingSequences(libcpp_vector[PeptideIdentification] & peptides, libcpp_vector[PeptideIdentification] & bad_peptides, bool ignore_mods)
        Removes all peptide hits with a sequence that matches one in 'bad_peptides'
        """
        ...
    
    def keepPeptidesWithMatchingSequences(self, peptides: List[PeptideIdentification] , bad_peptides: List[PeptideIdentification] , ignore_mods: bool ) -> None:
        """
        Cython signature: void keepPeptidesWithMatchingSequences(libcpp_vector[PeptideIdentification] & peptides, libcpp_vector[PeptideIdentification] & bad_peptides, bool ignore_mods)
        Removes all peptide hits with a sequence that does not match one in 'good_peptides'
        """
        ...
    
    def keepUniquePeptidesPerProtein(self, peptides: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void keepUniquePeptidesPerProtein(libcpp_vector[PeptideIdentification] & peptides)
        Removes all peptides that are not annotated as unique for a protein (by PeptideIndexer)
        """
        ...
    
    def removeDuplicatePeptideHits(self, peptides: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void removeDuplicatePeptideHits(libcpp_vector[PeptideIdentification] & peptides)
        Removes duplicate peptide hits from each peptide identification, keeping only unique hits (per ID)
        """
        ...
    
    def keepBestPerPeptide(self, peptides: List[PeptideIdentification] , ignore_mods: bool , ignore_charges: bool , nr_best_spectrum: int ) -> None:
        """
        Cython signature: void keepBestPerPeptide(libcpp_vector[PeptideIdentification] & peptides, bool ignore_mods, bool ignore_charges, size_t nr_best_spectrum)
        Filters PeptideHits from PeptideIdentification by keeping only the best peptide hits for every peptide sequence
        """
        ...
    
    def keepBestPerPeptidePerRun(self, prot_ids: List[ProteinIdentification] , peptides: List[PeptideIdentification] , ignore_mods: bool , ignore_charges: bool , nr_best_spectrum: int ) -> None:
        """
        Cython signature: void keepBestPerPeptidePerRun(libcpp_vector[ProteinIdentification] & prot_ids, libcpp_vector[PeptideIdentification] & peptides, bool ignore_mods, bool ignore_charges, size_t nr_best_spectrum)
        Filters PeptideHits from PeptideIdentification by keeping only the best peptide hits for every peptide sequence on a per run basis
        """
        ... 


class IndexedMzMLDecoder:
    """
    Cython implementation of _IndexedMzMLDecoder

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1IndexedMzMLDecoder.html>`_

    A class to analyze indexedmzML files and extract the offsets of individual tags
    
    Specifically, this class allows one to extract the offsets of the <indexList>
    tag and of all <spectrum> and <chromatogram> tag using the indices found at
    the end of the indexedmzML XML structure
    
    While findIndexListOffset tries extracts the offset of the indexList tag from
    the last 1024 bytes of the file, this offset allows the function parseOffsets
    to extract all elements contained in the <indexList> tag and thus get access
    to all spectra and chromatogram offsets
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void IndexedMzMLDecoder()
        """
        ...
    
    @overload
    def __init__(self, in_0: IndexedMzMLDecoder ) -> None:
        """
        Cython signature: void IndexedMzMLDecoder(IndexedMzMLDecoder &)
        """
        ...
    
    def findIndexListOffset(self, in_: Union[bytes, str, String] , buffersize: int ) -> streampos:
        """
        Cython signature: streampos findIndexListOffset(String in_, int buffersize)
        Tries to extract the indexList offset from an indexedmzML\n
        
        This function reads by default the last few (1024) bytes of the given
        input file and tries to read the content of the <indexListOffset> tag
        The idea is that somewhere in the last parts of the file specified by the
        input string, the string <indexListOffset>xxx</indexListOffset> occurs
        This function returns the xxx part converted to an integer\n
        
        Since this function cannot determine where it will start reading
        the XML, no regular XML parser can be used for this. Therefore it uses
        regex to do its job. It matches the <indexListOffset> part and any
        numerical characters that follow
        
        
        :param in: Filename of the input indexedmzML file
        :param buffersize: How many bytes of the input file should be searched for the tag
        :return: A positive integer containing the content of the indexListOffset tag, returns -1 in case of failure no tag was found (you can re-try with a larger buffersize but most likely its not an indexed mzML). Using -1 is what the reference docu recommends: http://en.cppreference.com/w/cpp/io/streamoff
        :raises:
          Exception: FileNotFound is thrown if file cannot be found
        :raises:
          Exception: ParseError if offset cannot be parsed
        """
        ... 


class MRMDecoy:
    """
    Cython implementation of _MRMDecoy

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MRMDecoy.html>`_
      -- Inherits from ['ProgressLogger']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MRMDecoy()
        """
        ...
    
    @overload
    def __init__(self, in_0: MRMDecoy ) -> None:
        """
        Cython signature: void MRMDecoy(MRMDecoy &)
        """
        ...
    
    def generateDecoys(self, exp: TargetedExperiment , dec: TargetedExperiment , method: Union[bytes, str, String] , aim_decoy_fraction: float , switchKR: bool , decoy_tag: Union[bytes, str, String] , max_attempts: int , identity_threshold: float , precursor_mz_shift: float , product_mz_shift: float , product_mz_threshold: float , fragment_types: List[bytes] , fragment_charges: List[int] , enable_specific_losses: bool , enable_unspecific_losses: bool , round_decPow: int ) -> None:
        """
        Cython signature: void generateDecoys(TargetedExperiment & exp, TargetedExperiment & dec, String method, double aim_decoy_fraction, bool switchKR, String decoy_tag, int max_attempts, double identity_threshold, double precursor_mz_shift, double product_mz_shift, double product_mz_threshold, libcpp_vector[String] fragment_types, libcpp_vector[size_t] fragment_charges, bool enable_specific_losses, bool enable_unspecific_losses, int round_decPow)
        Generate decoys from a TargetedExperiment
        
        Will generate decoy peptides for each target peptide provided in exp and
        write them into the decoy experiment
        
        Valid methods: shuffle, reverse, pseudo-reverse
        
        If theoretical is true, the target transitions will be returned but their
        masses will be adjusted to match the theoretical value of the fragment ion
        that is the most likely explanation for the product
        
        `mz_threshold` is used for the matching of theoretical ion series to the observed one
        
        To generate decoys with different precursor mass, use the "switchKR" flag
        which switches terminal K/R (switches K to R and R to K). This generates
        different precursor m/z and ensures that the y ion series has a different
        mass. For a description of the procedure, see (supplemental material)
        
        Bruderer et al. Mol Cell Proteomics. 2017. 10.1074/mcp.RA117.000314.
        """
        ...
    
    def findFixedResidues(self, sequence: Union[bytes, str, String] , keepN: bool , keepC: bool , keep_const_pattern: Union[bytes, str, String] ) -> List[int]:
        """
        Cython signature: libcpp_vector[size_t] findFixedResidues(const String & sequence, bool keepN, bool keepC, const String & keep_const_pattern)
        Find all residues in a sequence that should not be reversed / shuffled
        
        
        :param sequence: The amino acid sequence
        :param keepN: Whether to keep N terminus constant
        :param keepC: Whether to keep C terminus constant
        :param keep_const_pattern: A string containing the AA to not change (e.g. 'KRP')
        """
        ...
    
    def setLogType(self, in_0: int ) -> None:
        """
        Cython signature: void setLogType(LogType)
        Sets the progress log that should be used. The default type is NONE!
        """
        ...
    
    def getLogType(self) -> int:
        """
        Cython signature: LogType getLogType()
        Returns the type of progress log being used
        """
        ...
    
    def startProgress(self, begin: int , end: int , label: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void startProgress(ptrdiff_t begin, ptrdiff_t end, String label)
        """
        ...
    
    def setProgress(self, value: int ) -> None:
        """
        Cython signature: void setProgress(ptrdiff_t value)
        Sets the current progress
        """
        ...
    
    def endProgress(self) -> None:
        """
        Cython signature: void endProgress()
        Ends the progress display
        """
        ...
    
    def nextProgress(self) -> None:
        """
        Cython signature: void nextProgress()
        Increment progress by 1 (according to range begin-end)
        """
        ... 


class MRMFQC_ComponentGroupPairQCs:
    """
    Cython implementation of _MRMFQC_ComponentGroupPairQCs

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MRMFQC_ComponentGroupPairQCs.html>`_
    """
    
    component_group_name: Union[bytes, str, String]
    
    resolution_pair_name: Union[bytes, str, String]
    
    resolution_l: float
    
    resolution_u: float
    
    rt_diff_l: float
    
    rt_diff_u: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MRMFQC_ComponentGroupPairQCs()
        """
        ...
    
    @overload
    def __init__(self, in_0: MRMFQC_ComponentGroupPairQCs ) -> None:
        """
        Cython signature: void MRMFQC_ComponentGroupPairQCs(MRMFQC_ComponentGroupPairQCs &)
        """
        ... 


class MRMFQC_ComponentGroupQCs:
    """
    Cython implementation of _MRMFQC_ComponentGroupQCs

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MRMFQC_ComponentGroupQCs.html>`_
    """
    
    component_group_name: Union[bytes, str, String]
    
    retention_time_l: float
    
    retention_time_u: float
    
    intensity_l: float
    
    intensity_u: float
    
    overall_quality_l: float
    
    overall_quality_u: float
    
    n_heavy_l: int
    
    n_heavy_u: int
    
    n_light_l: int
    
    n_light_u: int
    
    n_detecting_l: int
    
    n_detecting_u: int
    
    n_quantifying_l: int
    
    n_quantifying_u: int
    
    n_identifying_l: int
    
    n_identifying_u: int
    
    n_transitions_l: int
    
    n_transitions_u: int
    
    ion_ratio_pair_name_1: Union[bytes, str, String]
    
    ion_ratio_pair_name_2: Union[bytes, str, String]
    
    ion_ratio_l: float
    
    ion_ratio_u: float
    
    ion_ratio_feature_name: Union[bytes, str, String]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MRMFQC_ComponentGroupQCs()
        """
        ...
    
    @overload
    def __init__(self, in_0: MRMFQC_ComponentGroupQCs ) -> None:
        """
        Cython signature: void MRMFQC_ComponentGroupQCs(MRMFQC_ComponentGroupQCs &)
        """
        ... 


class MRMFQC_ComponentQCs:
    """
    Cython implementation of _MRMFQC_ComponentQCs

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MRMFQC_ComponentQCs.html>`_
    """
    
    component_name: Union[bytes, str, String]
    
    retention_time_l: float
    
    retention_time_u: float
    
    intensity_l: float
    
    intensity_u: float
    
    overall_quality_l: float
    
    overall_quality_u: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MRMFQC_ComponentQCs()
        """
        ...
    
    @overload
    def __init__(self, in_0: MRMFQC_ComponentQCs ) -> None:
        """
        Cython signature: void MRMFQC_ComponentQCs(MRMFQC_ComponentQCs &)
        """
        ... 


class MRMFeatureQC:
    """
    Cython implementation of _MRMFeatureQC

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MRMFeatureQC.html>`_
    """
    
    component_qcs: List[MRMFQC_ComponentQCs]
    
    component_group_qcs: List[MRMFQC_ComponentGroupQCs]
    
    component_group_pair_qcs: List[MRMFQC_ComponentGroupPairQCs]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MRMFeatureQC()
        """
        ...
    
    @overload
    def __init__(self, in_0: MRMFeatureQC ) -> None:
        """
        Cython signature: void MRMFeatureQC(MRMFeatureQC &)
        """
        ... 


class MSNumpressCoder:
    """
    Cython implementation of _MSNumpressCoder

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MSNumpressCoder.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MSNumpressCoder()
        """
        ...
    
    @overload
    def __init__(self, in_0: MSNumpressCoder ) -> None:
        """
        Cython signature: void MSNumpressCoder(MSNumpressCoder &)
        """
        ...
    
    def encodeNP(self, in_: List[float] , result: String , zlib_compression: bool , config: NumpressConfig ) -> None:
        """
        Cython signature: void encodeNP(libcpp_vector[double] in_, String & result, bool zlib_compression, NumpressConfig config)
        Encodes a vector of floating point numbers into a Base64 string using numpress
        
        This code is obtained from the proteowizard implementation
        ./pwiz/pwiz/data/msdata/BinaryDataEncoder.cpp (adapted by Hannes Roest)
        
        This function will first apply the numpress encoding to the data, then
        encode the result in base64 (with optional zlib compression before
        base64 encoding)
        
        :note In case of error, result string is empty
        
        
        :param in: The vector of floating point numbers to be encoded
        :param result: The resulting string
        :param zlib_compression: Whether to apply zlib compression after numpress compression
        :param config: The numpress configuration defining the compression strategy
        """
        ...
    
    def decodeNP(self, in_: Union[bytes, str, String] , out: List[float] , zlib_compression: bool , config: NumpressConfig ) -> None:
        """
        Cython signature: void decodeNP(const String & in_, libcpp_vector[double] & out, bool zlib_compression, NumpressConfig config)
        Decodes a Base64 string to a vector of floating point numbers using numpress
        
        This code is obtained from the proteowizard implementation
        ./pwiz/pwiz/data/msdata/BinaryDataEncoder.cpp (adapted by Hannes Roest)
        
        This function will first decode the input base64 string (with optional
        zlib decompression after decoding) and then apply numpress decoding to
        the data
        
        
        :param in: The base64 encoded string
        :param out: The resulting vector of doubles
        :param zlib_compression: Whether to apply zlib de-compression before numpress de-compression
        :param config: The numpress configuration defining the compression strategy
        :raises:
          Exception: ConversionError if the string cannot be converted
        """
        ...
    
    def encodeNPRaw(self, in_: List[float] , result: String , config: NumpressConfig ) -> None:
        """
        Cython signature: void encodeNPRaw(libcpp_vector[double] in_, String & result, NumpressConfig config)
        Encode the data vector "in" to a raw byte array
        
        :note In case of error, "result" is given back unmodified
        :note The result is not a string but a raw byte array and may contain zero bytes
        
        This performs the raw numpress encoding on a set of data and does no
        Base64 encoding on the result. Therefore the result string is likely
        *unsafe* to handle and is a raw byte array.
        
        Please use the safe versions above unless you need access to the raw
        byte arrays
        
        
        :param in: The vector of floating point numbers to be encoded
        :param result: The resulting string
        :param config: The numpress configuration defining the compression strategy
        """
        ...
    
    def decodeNPRaw(self, in_: Union[bytes, str, String] , out: List[float] , config: NumpressConfig ) -> None:
        """
        Cython signature: void decodeNPRaw(const String & in_, libcpp_vector[double] & out, NumpressConfig config)
        Decode the raw byte array "in" to the result vector "out"
        
        :note The string in should *only* contain the data and _no_ extra
        null terminating byte
        
        This performs the raw numpress decoding on a raw byte array (not Base64
        encoded). Therefore the input string is likely *unsafe* to handle and is
        basically a byte container
        
        Please use the safe versions above unless you need access to the raw
        byte arrays
        
        
        :param in: The base64 encoded string
        :param out: The resulting vector of doubles
        :param config: The numpress configuration defining the compression strategy
        """
        ...
    NumpressCompression : __NumpressCompression 


class MSSpectrum:
    """
    Cython implementation of _MSSpectrum

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MSSpectrum.html>`_
      -- Inherits from ['SpectrumSettings', 'RangeManagerMzInt']

    The representation of a 1D spectrum.
    Raw data access is proved by `get_peaks` and `set_peaks`, which yields numpy arrays
    Iterations yields access to underlying peak objects but is slower
    Extra data arrays can be accessed through getFloatDataArrays / getIntegerDataArrays / getStringDataArrays
    See help(SpectrumSettings) for information about meta-information
    
    Usage:
    
    .. code-block:: python
    
      ms_level = spectrum.getMSLevel()
      rt = spectrum.getRT()
      mz, intensities = spectrum.get_peaks()
    
    
    Usage:
    
    .. code-block:: python
    
      from pyopenms import *
    
      spectrum = MSSpectrum()
      spectrum.setDriftTime(25) # 25 ms
      spectrum.setRT(205.2) # 205.2 s
      spectrum.setMSLevel(3) # MS3
      p = Precursor()
      p.setIsolationWindowLowerOffset(1.5)
      p.setIsolationWindowUpperOffset(1.5)
      p.setMZ(600) # isolation at 600 +/- 1.5 Th
      p.setActivationEnergy(40) # 40 eV
      p.setCharge(4) # 4+ ion
      spectrum.setPrecursors( [p] )
    
      # Add raw data to spectrum
      spectrum.set_peaks( ([401.5], [900]) )
    
      # Additional data arrays / peak annotations
      fda = FloatDataArray()
      fda.setName("Signal to Noise Array")
      fda.push_back(15)
      sda = StringDataArray()
      sda.setName("Peak annotation")
      sda.push_back("y15++")
      spectrum.setFloatDataArrays( [fda] )
      spectrum.setStringDataArrays( [sda] )
    
      # Add spectrum to MSExperiment
      exp = MSExperiment()
      exp.addSpectrum(spectrum)
    
      # Add second spectrum and store as mzML file
      spectrum2 = MSSpectrum()
      spectrum2.set_peaks( ([1, 2], [1, 2]) )
      exp.addSpectrum(spectrum2)
    
      MzMLFile().store("testfile.mzML", exp)
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MSSpectrum()
        """
        ...
    
    @overload
    def __init__(self, in_0: MSSpectrum ) -> None:
        """
        Cython signature: void MSSpectrum(MSSpectrum &)
        """
        ...
    
    def getRT(self) -> float:
        """
        Cython signature: double getRT()
        Returns the absolute retention time (in seconds)
        """
        ...
    
    def setRT(self, in_0: float ) -> None:
        """
        Cython signature: void setRT(double)
        Sets the absolute retention time (in seconds)
        """
        ...
    
    def getDriftTime(self) -> float:
        """
        Cython signature: double getDriftTime()
        Returns the drift time (-1 if not set)
        """
        ...
    
    def setDriftTime(self, in_0: float ) -> None:
        """
        Cython signature: void setDriftTime(double)
        Sets the drift time (-1 if not set)
        """
        ...
    
    def getDriftTimeUnit(self) -> int:
        """
        Cython signature: DriftTimeUnit getDriftTimeUnit()
        """
        ...
    
    def getDriftTimeUnitAsString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getDriftTimeUnitAsString()
        """
        ...
    
    def setDriftTimeUnit(self, dt: int ) -> None:
        """
        Cython signature: void setDriftTimeUnit(DriftTimeUnit dt)
        """
        ...
    
    def containsIMData(self) -> bool:
        """
        Cython signature: bool containsIMData()
        """
        ...
    
    def getMSLevel(self) -> int:
        """
        Cython signature: unsigned int getMSLevel()
        Returns the MS level
        """
        ...
    
    def setMSLevel(self, in_0: int ) -> None:
        """
        Cython signature: void setMSLevel(unsigned int)
        Sets the MS level
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(String)
        """
        ...
    
    def size(self) -> int:
        """
        Cython signature: size_t size()
        Returns the number of peaks in the spectrum
        """
        ...
    
    def reserve(self, n: int ) -> None:
        """
        Cython signature: void reserve(size_t n)
        """
        ...
    
    def resize(self, n: int ) -> None:
        """
        Cython signature: void resize(size_t n)
        Resize the peak array
        """
        ...
    
    def __getitem__(self, in_0: int ) -> Peak1D:
        """
        Cython signature: Peak1D & operator[](size_t)
        """
        ...
    def __setitem__(self, key: int, value: Peak1D ) -> None:
        """Cython signature: Peak1D & operator[](size_t)"""
        ...
    
    def updateRanges(self) -> None:
        """
        Cython signature: void updateRanges()
        """
        ...
    
    def clear(self, clear_meta_data: bool ) -> None:
        """
        Cython signature: void clear(bool clear_meta_data)
        Clears all data (and meta data if clear_meta_data is true)
        """
        ...
    
    def push_back(self, in_0: Peak1D ) -> None:
        """
        Cython signature: void push_back(Peak1D)
        Append a peak
        """
        ...
    
    def isSorted(self) -> bool:
        """
        Cython signature: bool isSorted()
        Returns true if the spectrum is sorte by m/z
        """
        ...
    
    @overload
    def findNearest(self, mz: float ) -> int:
        """
        Cython signature: int findNearest(double mz)
        Returns the index of the closest peak in m/z
        """
        ...
    
    @overload
    def findNearest(self, mz: float , tolerance: float ) -> int:
        """
        Cython signature: int findNearest(double mz, double tolerance)
        Returns the index of the closest peak in the provided +/- m/z tolerance window (-1 if none match)
        """
        ...
    
    @overload
    def findNearest(self, mz: float , tolerance_left: float , tolerance_right: float ) -> int:
        """
        Cython signature: int findNearest(double mz, double tolerance_left, double tolerance_right)
        Returns the index of the closest peak in the provided abs. m/z tolerance window to the left and right (-1 if none match)
        """
        ...
    
    def findHighestInWindow(self, mz: float , tolerance_left: float , tolerance_right: float ) -> int:
        """
        Cython signature: int findHighestInWindow(double mz, double tolerance_left, double tolerance_right)
        Returns the index of the highest peak in the provided abs. m/z tolerance window to the left and right (-1 if none match)
        """
        ...
    
    def select(self, indices: List[int] ) -> MSSpectrum:
        """
        Cython signature: MSSpectrum select(libcpp_vector[size_t] & indices)
        Subset the spectrum by indices. Also applies to associated data arrays if present.
        """
        ...
    
    def calculateTIC(self) -> float:
        """
        Cython signature: double calculateTIC()
        Returns the total ion current (=sum) of peak intensities in the spectrum
        """
        ...
    
    def sortByIntensity(self, reverse: bool ) -> None:
        """
        Cython signature: void sortByIntensity(bool reverse)
        """
        ...
    
    def sortByPosition(self) -> None:
        """
        Cython signature: void sortByPosition()
        """
        ...
    
    def getFloatDataArrays(self) -> List[FloatDataArray]:
        """
        Cython signature: libcpp_vector[FloatDataArray] getFloatDataArrays()
        Returns the additional float data arrays to store e.g. meta data
        """
        ...
    
    def getIntegerDataArrays(self) -> List[IntegerDataArray]:
        """
        Cython signature: libcpp_vector[IntegerDataArray] getIntegerDataArrays()
        Returns the additional int data arrays to store e.g. meta data
        """
        ...
    
    def getStringDataArrays(self) -> List[StringDataArray]:
        """
        Cython signature: libcpp_vector[StringDataArray] getStringDataArrays()
        Returns the additional string data arrays to store e.g. meta data
        """
        ...
    
    def setFloatDataArrays(self, fda: List[FloatDataArray] ) -> None:
        """
        Cython signature: void setFloatDataArrays(libcpp_vector[FloatDataArray] fda)
        Sets the additional float data arrays to store e.g. meta data
        """
        ...
    
    def setIntegerDataArrays(self, ida: List[IntegerDataArray] ) -> None:
        """
        Cython signature: void setIntegerDataArrays(libcpp_vector[IntegerDataArray] ida)
        Sets the additional int data arrays to store e.g. meta data
        """
        ...
    
    def setStringDataArrays(self, sda: List[StringDataArray] ) -> None:
        """
        Cython signature: void setStringDataArrays(libcpp_vector[StringDataArray] sda)
        Sets the additional string data arrays to store e.g. meta data
        """
        ...
    
    def unify(self, in_0: SpectrumSettings ) -> None:
        """
        Cython signature: void unify(SpectrumSettings)
        """
        ...
    
    def getType(self) -> int:
        """
        Cython signature: int getType()
        Returns the spectrum type (centroided (PEAKS) or profile data (RAW))
        """
        ...
    
    def setType(self, in_0: int ) -> None:
        """
        Cython signature: void setType(SpectrumType)
        Sets the spectrum type
        """
        ...
    
    def getNativeID(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getNativeID()
        Returns the native identifier for the spectrum, used by the acquisition software
        """
        ...
    
    def setNativeID(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setNativeID(String)
        Sets the native identifier for the spectrum, used by the acquisition software
        """
        ...
    
    def getComment(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getComment()
        Returns the free-text comment
        """
        ...
    
    def setComment(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setComment(String)
        Sets the free-text comment
        """
        ...
    
    def getInstrumentSettings(self) -> InstrumentSettings:
        """
        Cython signature: InstrumentSettings getInstrumentSettings()
        Returns a const reference to the instrument settings of the current spectrum
        """
        ...
    
    def setInstrumentSettings(self, in_0: InstrumentSettings ) -> None:
        """
        Cython signature: void setInstrumentSettings(InstrumentSettings)
        Sets the instrument settings of the current spectrum
        """
        ...
    
    def getAcquisitionInfo(self) -> AcquisitionInfo:
        """
        Cython signature: AcquisitionInfo getAcquisitionInfo()
        Returns a const reference to the acquisition info
        """
        ...
    
    def setAcquisitionInfo(self, in_0: AcquisitionInfo ) -> None:
        """
        Cython signature: void setAcquisitionInfo(AcquisitionInfo)
        Sets the acquisition info
        """
        ...
    
    def getSourceFile(self) -> SourceFile:
        """
        Cython signature: SourceFile getSourceFile()
        Returns a const reference to the source file
        """
        ...
    
    def setSourceFile(self, in_0: SourceFile ) -> None:
        """
        Cython signature: void setSourceFile(SourceFile)
        Sets the source file
        """
        ...
    
    def getPrecursors(self) -> List[Precursor]:
        """
        Cython signature: libcpp_vector[Precursor] getPrecursors()
        Returns a const reference to the precursors
        """
        ...
    
    def setPrecursors(self, in_0: List[Precursor] ) -> None:
        """
        Cython signature: void setPrecursors(libcpp_vector[Precursor])
        Sets the precursors
        """
        ...
    
    def getProducts(self) -> List[Product]:
        """
        Cython signature: libcpp_vector[Product] getProducts()
        Returns a const reference to the products
        """
        ...
    
    def setProducts(self, in_0: List[Product] ) -> None:
        """
        Cython signature: void setProducts(libcpp_vector[Product])
        Sets the products
        """
        ...
    
    def getPeptideIdentifications(self) -> List[PeptideIdentification]:
        """
        Cython signature: libcpp_vector[PeptideIdentification] getPeptideIdentifications()
        Returns a const reference to the PeptideIdentification vector
        """
        ...
    
    def setPeptideIdentifications(self, in_0: List[PeptideIdentification] ) -> None:
        """
        Cython signature: void setPeptideIdentifications(libcpp_vector[PeptideIdentification])
        Sets the PeptideIdentification vector
        """
        ...
    
    def getDataProcessing(self) -> List[DataProcessing]:
        """
        Cython signature: libcpp_vector[shared_ptr[DataProcessing]] getDataProcessing()
        """
        ...
    
    def setDataProcessing(self, in_0: List[DataProcessing] ) -> None:
        """
        Cython signature: void setDataProcessing(libcpp_vector[shared_ptr[DataProcessing]])
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def getMinMZ(self) -> float:
        """
        Cython signature: double getMinMZ()
        Returns the minimum m/z
        """
        ...
    
    def getMaxMZ(self) -> float:
        """
        Cython signature: double getMaxMZ()
        Returns the maximum m/z
        """
        ...
    
    def getMinIntensity(self) -> float:
        """
        Cython signature: double getMinIntensity()
        Returns the minimum intensity
        """
        ...
    
    def getMaxIntensity(self) -> float:
        """
        Cython signature: double getMaxIntensity()
        Returns the maximum intensity
        """
        ...
    
    def clearRanges(self) -> None:
        """
        Cython signature: void clearRanges()
        Resets all range dimensions as empty
        """
        ...
    
    def __richcmp__(self, other: MSSpectrum, op: int) -> Any:
        ...
    
    def __iter__(self) -> Peak1D:
       ... 


class MetaboTargetedAssay:
    """
    Cython implementation of _MetaboTargetedAssay

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MetaboTargetedAssay.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MetaboTargetedAssay()
        This class provides methods for the extraction of targeted assays for metabolomics
        """
        ...
    
    @overload
    def __init__(self, in_0: MetaboTargetedAssay ) -> None:
        """
        Cython signature: void MetaboTargetedAssay(MetaboTargetedAssay &)
        """
        ...
    
    def extractMetaboTargetedAssay(self, spectra: MSExperiment , feature_ms2_index: FeatureMapping_FeatureToMs2Indices , precursor_rt_tol: float , precursor_mz_distance: float , cosine_sim_threshold: float , transition_threshold: float , min_fragment_mz: float , max_fragment_mz: float , method_consensus_spectrum: bool , exclude_ms2_precursor: bool , file_counter: int ) -> List[MetaboTargetedAssay]:
        """
        Cython signature: libcpp_vector[MetaboTargetedAssay] extractMetaboTargetedAssay(MSExperiment & spectra, FeatureMapping_FeatureToMs2Indices & feature_ms2_index, double & precursor_rt_tol, double & precursor_mz_distance, double & cosine_sim_threshold, double & transition_threshold, double & min_fragment_mz, double & max_fragment_mz, bool & method_consensus_spectrum, bool & exclude_ms2_precursor, unsigned int & file_counter)
        Extract a vector of MetaboTargetedAssays without using fragment annotation
        
        
        :param spectra: Input of MSExperiment with spectra information
        :param feature_ms2_spectra_map: FeatureMapping class with associated MS2 spectra
        :param precursor_rt_tol: Retention time tolerance of the precursor
        :param precursor_mz_distance: Max m/z distance of the precursor entries of two spectra to be merged
        :param cosine_sim_threshold: Cosine similarty threshold for the usage of SpectraMerger
        :param transition_threshold: Intensity threshold for MS2 peak used in MetaboTargetedAssay
        :param min_fragment_mz: Minimum m/z a fragment ion has to have to be considered as a transition
        :param max_fragment_mz: Maximum m/z a fragment ion has to have to be considered as a transition
        :param method_consensus_spectrum: Boolean to use consensus spectrum method
        :param exclude_ms2_precursor: Boolean to exclude MS2 precursor from MetaboTargetedAssay
        :return: Vector of MetaboTargetedAssay
        """
        ...
    
    def extractMetaboTargetedAssayFragmentAnnotation(self, v_cmp_spec: List[MetaboTargetedAssay_CompoundTargetDecoyPair] , transition_threshold: float , min_fragment_mz: float , max_fragment_mz: float , use_exact_mass: bool , exclude_ms2_precursor: bool ) -> List[MetaboTargetedAssay]:
        """
        Cython signature: libcpp_vector[MetaboTargetedAssay] extractMetaboTargetedAssayFragmentAnnotation(libcpp_vector[MetaboTargetedAssay_CompoundTargetDecoyPair] & v_cmp_spec, double & transition_threshold, double & min_fragment_mz, double & max_fragment_mz, bool & use_exact_mass, bool & exclude_ms2_precursor)
        Extract a vector of MetaboTargetedAssays using fragment
        
        
        :param v_cmp_spec: Vector of CompoundInfo with associated fragment annotated MSspectrum
        :param transition_threshold: Intensity threshold for MS2 peak used in MetaboTargetedAssay
        :param min_fragment_mz: Minimum m/z a fragment ion has to have to be considered as a transition
        :param max_fragment_mz: Maximum m/z a fragment ion has to have to be considered as a transition
        :param use_exact_mass: Boolean if exact mass should be used as peak mass for annotated fragments
        :param exclude_ms2_precursor: Boolean to exclude MS2 precursor from MetaboTargetedAssay
        :param file_counter: Count if multiple files are used.
        :return: Vector of MetaboTargetedAssay
        """
        ...
    
    def pairCompoundWithAnnotatedTDSpectraPairs(self, v_cmpinfo: List[SiriusMSFile_CompoundInfo] , annotated_spectra: List[SiriusFragmentAnnotation_SiriusTargetDecoySpectra] ) -> List[MetaboTargetedAssay_CompoundTargetDecoyPair]:
        """
        Cython signature: libcpp_vector[MetaboTargetedAssay_CompoundTargetDecoyPair] pairCompoundWithAnnotatedTDSpectraPairs(libcpp_vector[SiriusMSFile_CompoundInfo] & v_cmpinfo, libcpp_vector[SiriusFragmentAnnotation_SiriusTargetDecoySpectra] & annotated_spectra)
        Pair compound information (SiriusMSFile) with the annotated target and decoy spectrum from SIRIUS/Passatutto based on the m_id (unique identifier composed of description_filepath_native_id_k introduced in the SiriusMSConverter)
        
        
        :param v_cmpinfo: Vector of SiriusMSFile::CompoundInfo
        :param annotated_spectra: Vector of SiriusTargetDecoySpectra
        :return: Vector of MetaboTargetedAssay::CompoundTargetDecoyPair
        """
        ... 


class MetaboTargetedAssay_CompoundTargetDecoyPair:
    """
    Cython implementation of _MetaboTargetedAssay_CompoundTargetDecoyPair

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MetaboTargetedAssay_CompoundTargetDecoyPair.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MetaboTargetedAssay_CompoundTargetDecoyPair()
        """
        ...
    
    @overload
    def __init__(self, in_0: MetaboTargetedAssay_CompoundTargetDecoyPair ) -> None:
        """
        Cython signature: void MetaboTargetedAssay_CompoundTargetDecoyPair(MetaboTargetedAssay_CompoundTargetDecoyPair &)
        """
        ... 


class MetaboliteSpectralMatching:
    """
    Cython implementation of _MetaboliteSpectralMatching

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MetaboliteSpectralMatching.html>`_
      -- Inherits from ['ProgressLogger', 'DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MetaboliteSpectralMatching()
        """
        ...
    
    @overload
    def __init__(self, in_0: MetaboliteSpectralMatching ) -> None:
        """
        Cython signature: void MetaboliteSpectralMatching(MetaboliteSpectralMatching &)
        """
        ...
    
    def run(self, exp: MSExperiment , speclib: MSExperiment , mz_tab: MzTab , out_spectra: String ) -> None:
        """
        Cython signature: void run(MSExperiment & exp, MSExperiment & speclib, MzTab & mz_tab, String & out_spectra)
        """
        ...
    
    def setLogType(self, in_0: int ) -> None:
        """
        Cython signature: void setLogType(LogType)
        Sets the progress log that should be used. The default type is NONE!
        """
        ...
    
    def getLogType(self) -> int:
        """
        Cython signature: LogType getLogType()
        Returns the type of progress log being used
        """
        ...
    
    def startProgress(self, begin: int , end: int , label: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void startProgress(ptrdiff_t begin, ptrdiff_t end, String label)
        """
        ...
    
    def setProgress(self, value: int ) -> None:
        """
        Cython signature: void setProgress(ptrdiff_t value)
        Sets the current progress
        """
        ...
    
    def endProgress(self) -> None:
        """
        Cython signature: void endProgress()
        Ends the progress display
        """
        ...
    
    def nextProgress(self) -> None:
        """
        Cython signature: void nextProgress()
        Increment progress by 1 (according to range begin-end)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ...
    
    computeHyperScore: __static_MetaboliteSpectralMatching_computeHyperScore 


class MultiplexDeltaMasses:
    """
    Cython implementation of _MultiplexDeltaMasses

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MultiplexDeltaMasses.html>`_

    Data structure for mass shift pattern
    
    Groups of labelled peptides appear with characteristic mass shifts
    
    For example, for an Arg6 labeled SILAC peptide pair we expect to see
    mass shifts of 0 and 6 Da. Or as second example, for a
    peptide pair of a dimethyl labelled sample with a single lysine
    we will see mass shifts of 56 Da and 64 Da.
    28 Da (N-term) + 28 Da (K) and 34 Da (N-term) + 34 Da (K)
    for light and heavy partners respectively
    
    The data structure stores the mass shifts and corresponding labels
    for a group of matching peptide features
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MultiplexDeltaMasses()
        """
        ...
    
    @overload
    def __init__(self, in_0: MultiplexDeltaMasses ) -> None:
        """
        Cython signature: void MultiplexDeltaMasses(MultiplexDeltaMasses &)
        """
        ...
    
    @overload
    def __init__(self, dm: List[MultiplexDeltaMasses_DeltaMass] ) -> None:
        """
        Cython signature: void MultiplexDeltaMasses(libcpp_vector[MultiplexDeltaMasses_DeltaMass] & dm)
        """
        ...
    
    def getDeltaMasses(self) -> List[MultiplexDeltaMasses_DeltaMass]:
        """
        Cython signature: libcpp_vector[MultiplexDeltaMasses_DeltaMass] getDeltaMasses()
        """
        ... 


class MultiplexDeltaMassesGenerator:
    """
    Cython implementation of _MultiplexDeltaMassesGenerator

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MultiplexDeltaMassesGenerator.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void MultiplexDeltaMassesGenerator()
        """
        ...
    
    @overload
    def __init__(self, in_0: MultiplexDeltaMassesGenerator ) -> None:
        """
        Cython signature: void MultiplexDeltaMassesGenerator(MultiplexDeltaMassesGenerator &)
        """
        ...
    
    @overload
    def __init__(self, labels: Union[bytes, str, String] , missed_cleavages: int , label_mass_shift: Dict[Union[bytes, str, String], float] ) -> None:
        """
        Cython signature: void MultiplexDeltaMassesGenerator(String labels, int missed_cleavages, libcpp_map[String,double] label_mass_shift)
        """
        ...
    
    def generateKnockoutDeltaMasses(self) -> None:
        """
        Cython signature: void generateKnockoutDeltaMasses()
        """
        ...
    
    def getDeltaMassesList(self) -> List[MultiplexDeltaMasses]:
        """
        Cython signature: libcpp_vector[MultiplexDeltaMasses] getDeltaMassesList()
        """
        ...
    
    def getLabelShort(self, label: Union[bytes, str, String] ) -> Union[bytes, str, String]:
        """
        Cython signature: String getLabelShort(String label)
        """
        ...
    
    def getLabelLong(self, label: Union[bytes, str, String] ) -> Union[bytes, str, String]:
        """
        Cython signature: String getLabelLong(String label)
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ... 


class MultiplexDeltaMassesGenerator_Label:
    """
    Cython implementation of _MultiplexDeltaMassesGenerator_Label

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MultiplexDeltaMassesGenerator_Label.html>`_
    """
    
    short_name: Union[bytes, str, String]
    
    long_name: Union[bytes, str, String]
    
    description: Union[bytes, str, String]
    
    delta_mass: float
    
    def __init__(self, sn: Union[bytes, str, String] , ln: Union[bytes, str, String] , d: Union[bytes, str, String] , dm: float ) -> None:
        """
        Cython signature: void MultiplexDeltaMassesGenerator_Label(String sn, String ln, String d, double dm)
        """
        ... 


class MultiplexDeltaMasses_DeltaMass:
    """
    Cython implementation of _MultiplexDeltaMasses_DeltaMass

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1MultiplexDeltaMasses_DeltaMass.html>`_
    """
    
    delta_mass: float
    
    @overload
    def __init__(self, dm: float , l: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void MultiplexDeltaMasses_DeltaMass(double dm, String l)
        """
        ...
    
    @overload
    def __init__(self, in_0: MultiplexDeltaMasses_DeltaMass ) -> None:
        """
        Cython signature: void MultiplexDeltaMasses_DeltaMass(MultiplexDeltaMasses_DeltaMass &)
        """
        ... 


class NumpressConfig:
    """
    Cython implementation of _NumpressConfig

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1NumpressConfig.html>`_
    """
    
    numpressFixedPoint: float
    
    numpressErrorTolerance: float
    
    np_compression: int
    
    estimate_fixed_point: bool
    
    linear_fp_mass_acc: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void NumpressConfig()
        """
        ...
    
    @overload
    def __init__(self, in_0: NumpressConfig ) -> None:
        """
        Cython signature: void NumpressConfig(NumpressConfig &)
        """
        ...
    
    def setCompression(self, compression: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCompression(const String & compression)
        """
        ... 


class OPXLSpectrumProcessingAlgorithms:
    """
    Cython implementation of _OPXLSpectrumProcessingAlgorithms

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1OPXLSpectrumProcessingAlgorithms.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OPXLSpectrumProcessingAlgorithms()
        """
        ...
    
    @overload
    def __init__(self, in_0: OPXLSpectrumProcessingAlgorithms ) -> None:
        """
        Cython signature: void OPXLSpectrumProcessingAlgorithms(OPXLSpectrumProcessingAlgorithms &)
        """
        ...
    
    def mergeAnnotatedSpectra(self, first_spectrum: MSSpectrum , second_spectrum: MSSpectrum ) -> MSSpectrum:
        """
        Cython signature: MSSpectrum mergeAnnotatedSpectra(MSSpectrum & first_spectrum, MSSpectrum & second_spectrum)
        """
        ...
    
    def preprocessSpectra(self, exp: MSExperiment , fragment_mass_tolerance: float , fragment_mass_tolerance_unit_ppm: bool , peptide_min_size: int , min_precursor_charge: int , max_precursor_charge: int , deisotope: bool , labeled: bool ) -> MSExperiment:
        """
        Cython signature: MSExperiment preprocessSpectra(MSExperiment & exp, double fragment_mass_tolerance, bool fragment_mass_tolerance_unit_ppm, size_t peptide_min_size, int min_precursor_charge, int max_precursor_charge, bool deisotope, bool labeled)
        """
        ...
    
    def getSpectrumAlignmentFastCharge(self, alignment: List[List[int, int]] , fragment_mass_tolerance: float , fragment_mass_tolerance_unit_ppm: bool , theo_spectrum: MSSpectrum , exp_spectrum: MSSpectrum , theo_charges: IntegerDataArray , exp_charges: IntegerDataArray , ppm_error_array: FloatDataArray , intensity_cutoff: float ) -> None:
        """
        Cython signature: void getSpectrumAlignmentFastCharge(libcpp_vector[libcpp_pair[size_t,size_t]] & alignment, double fragment_mass_tolerance, bool fragment_mass_tolerance_unit_ppm, const MSSpectrum & theo_spectrum, const MSSpectrum & exp_spectrum, const IntegerDataArray & theo_charges, const IntegerDataArray & exp_charges, FloatDataArray & ppm_error_array, double intensity_cutoff)
        """
        ...
    
    def getSpectrumAlignmentSimple(self, alignment: List[List[int, int]] , fragment_mass_tolerance: float , fragment_mass_tolerance_unit_ppm: bool , theo_spectrum: List[SimplePeak] , exp_spectrum: MSSpectrum , exp_charges: IntegerDataArray ) -> None:
        """
        Cython signature: void getSpectrumAlignmentSimple(libcpp_vector[libcpp_pair[size_t,size_t]] & alignment, double fragment_mass_tolerance, bool fragment_mass_tolerance_unit_ppm, const libcpp_vector[SimplePeak] & theo_spectrum, const MSSpectrum & exp_spectrum, const IntegerDataArray & exp_charges)
        """
        ... 


class OSW_ChromExtractParams:
    """
    Cython implementation of _OSW_ChromExtractParams

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1OSW_ChromExtractParams.html>`_
    """
    
    min_upper_edge_dist: float
    
    mz_extraction_window: float
    
    ppm: bool
    
    extraction_function: bytes
    
    rt_extraction_window: float
    
    extra_rt_extract: float
    
    im_extraction_window: float
    
    def __init__(self, in_0: OSW_ChromExtractParams ) -> None:
        """
        Cython signature: void OSW_ChromExtractParams(OSW_ChromExtractParams &)
        """
        ... 


class OpenPepXLLFAlgorithm:
    """
    Cython implementation of _OpenPepXLLFAlgorithm

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1OpenPepXLLFAlgorithm.html>`_
      -- Inherits from ['DefaultParamHandler']
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void OpenPepXLLFAlgorithm()
        """
        ...
    
    @overload
    def __init__(self, in_0: OpenPepXLLFAlgorithm ) -> None:
        """
        Cython signature: void OpenPepXLLFAlgorithm(OpenPepXLLFAlgorithm &)
        """
        ...
    
    def run(self, unprocessed_spectra: MSExperiment , fasta_db: List[FASTAEntry] , protein_ids: List[ProteinIdentification] , peptide_ids: List[PeptideIdentification] , all_top_csms: List[List[CrossLinkSpectrumMatch]] , spectra: MSExperiment ) -> int:
        """
        Cython signature: OpenPepXLLFAlgorithm_ExitCodes run(MSExperiment & unprocessed_spectra, libcpp_vector[FASTAEntry] & fasta_db, libcpp_vector[ProteinIdentification] & protein_ids, libcpp_vector[PeptideIdentification] & peptide_ids, libcpp_vector[libcpp_vector[CrossLinkSpectrumMatch]] & all_top_csms, MSExperiment & spectra)
        Performs the main function of this class, the search for cross-linked peptides
        
        
        :param unprocessed_spectra: The input PeakMap of experimental spectra
        :param fasta_db: The protein database containing targets and decoys
        :param protein_ids: A result vector containing search settings. Should contain one PeptideIdentification
        :param peptide_ids: A result vector containing cross-link spectrum matches as PeptideIdentifications and PeptideHits. Should be empty
        :param all_top_csms: A result vector containing cross-link spectrum matches as CrossLinkSpectrumMatches. Should be empty. This is only necessary for writing out xQuest type spectrum files
        :param spectra: A result vector containing the input spectra after preprocessing and filtering. Should be empty. This is only necessary for writing out xQuest type spectrum files
        """
        ...
    
    def getSubsections(self) -> List[bytes]:
        """
        Cython signature: libcpp_vector[String] getSubsections()
        """
        ...
    
    def setParameters(self, param: Param ) -> None:
        """
        Cython signature: void setParameters(Param & param)
        Sets the parameters
        """
        ...
    
    def getParameters(self) -> Param:
        """
        Cython signature: Param getParameters()
        Returns the parameters
        """
        ...
    
    def getDefaults(self) -> Param:
        """
        Cython signature: Param getDefaults()
        Returns the default parameters
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(const String &)
        Sets the name
        """
        ...
    OpenPepXLLFAlgorithm_ExitCodes : __OpenPepXLLFAlgorithm_ExitCodes 


class ParamEntry:
    """
    Cython implementation of _ParamEntry

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Param_1_1ParamEntry.html>`_
    """
    
    name: bytes
    
    description: bytes
    
    value: Union[int, float, bytes, str, List[int], List[float], List[bytes]]
    
    tags: Set[bytes]
    
    valid_strings: List[bytes]
    
    max_float: float
    
    min_float: float
    
    max_int: int
    
    min_int: int
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ParamEntry()
        """
        ...
    
    @overload
    def __init__(self, in_0: ParamEntry ) -> None:
        """
        Cython signature: void ParamEntry(ParamEntry &)
        """
        ...
    
    @overload
    def __init__(self, n: bytes , v: Union[int, float, bytes, str, List[int], List[float], List[bytes]] , d: bytes , t: List[bytes] ) -> None:
        """
        Cython signature: void ParamEntry(libcpp_string n, ParamValue v, libcpp_string d, libcpp_vector[libcpp_string] t)
        """
        ...
    
    @overload
    def __init__(self, n: bytes , v: Union[int, float, bytes, str, List[int], List[float], List[bytes]] , d: bytes ) -> None:
        """
        Cython signature: void ParamEntry(libcpp_string n, ParamValue v, libcpp_string d)
        """
        ...
    
    def __richcmp__(self, other: ParamEntry, op: int) -> Any:
        ... 


class ProtXMLFile:
    """
    Cython implementation of _ProtXMLFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ProtXMLFile.html>`_

    Used to load (storing not supported, yet) ProtXML files
    
    This class is used to load (storing not supported, yet) documents that implement
    the schema of ProtXML files
    """
    
    def __init__(self) -> None:
        """
        Cython signature: void ProtXMLFile()
        """
        ...
    
    def load(self, filename: Union[bytes, str, String] , protein_ids: ProteinIdentification , peptide_ids: PeptideIdentification ) -> None:
        """
        Cython signature: void load(String filename, ProteinIdentification & protein_ids, PeptideIdentification & peptide_ids)
        Loads the identifications of an ProtXML file without identifier
        
        The information is read in and the information is stored in the
        corresponding variables
        
        :raises:
          Exception: FileNotFound is thrown if the file could not be found
        :raises:
          Exception: ParseError is thrown if an error occurs during parsing
        """
        ...
    
    def store(self, filename: Union[bytes, str, String] , protein_ids: ProteinIdentification , peptide_ids: PeptideIdentification , document_id: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void store(String filename, ProteinIdentification & protein_ids, PeptideIdentification & peptide_ids, String document_id)
        """
        ... 


class RNaseDB:
    """
    Cython implementation of _RNaseDB

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1RNaseDB.html>`_
    """
    
    def getEnzyme(self, name: Union[bytes, str, String] ) -> DigestionEnzymeRNA:
        """
        Cython signature: const DigestionEnzymeRNA * getEnzyme(const String & name)
        """
        ...
    
    def getEnzymeByRegEx(self, cleavage_regex: Union[bytes, str, String] ) -> DigestionEnzymeRNA:
        """
        Cython signature: const DigestionEnzymeRNA * getEnzymeByRegEx(const String & cleavage_regex)
        """
        ...
    
    def getAllNames(self, all_names: List[bytes] ) -> None:
        """
        Cython signature: void getAllNames(libcpp_vector[String] & all_names)
        """
        ...
    
    def hasEnzyme(self, name: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool hasEnzyme(const String & name)
        """
        ... 


class ScanWindow:
    """
    Cython implementation of _ScanWindow

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1ScanWindow.html>`_
      -- Inherits from ['MetaInfoInterface']
    """
    
    begin: float
    
    end: float
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void ScanWindow()
        """
        ...
    
    @overload
    def __init__(self, in_0: ScanWindow ) -> None:
        """
        Cython signature: void ScanWindow(ScanWindow &)
        """
        ...
    
    def isMetaEmpty(self) -> bool:
        """
        Cython signature: bool isMetaEmpty()
        Returns if the MetaInfo is empty
        """
        ...
    
    def clearMetaInfo(self) -> None:
        """
        Cython signature: void clearMetaInfo()
        Removes all meta values
        """
        ...
    
    def metaRegistry(self) -> MetaInfoRegistry:
        """
        Cython signature: MetaInfoRegistry metaRegistry()
        Returns a reference to the MetaInfoRegistry
        """
        ...
    
    def getKeys(self, keys: List[bytes] ) -> None:
        """
        Cython signature: void getKeys(libcpp_vector[String] & keys)
        Fills the given vector with a list of all keys for which a value is set
        """
        ...
    
    def getMetaValue(self, in_0: Union[bytes, str, String] ) -> Union[int, float, bytes, str, List[int], List[float], List[bytes]]:
        """
        Cython signature: DataValue getMetaValue(String)
        Returns the value corresponding to a string, or
        """
        ...
    
    def setMetaValue(self, in_0: Union[bytes, str, String] , in_1: Union[int, float, bytes, str, List[int], List[float], List[bytes]] ) -> None:
        """
        Cython signature: void setMetaValue(String, DataValue)
        Sets the DataValue corresponding to a name
        """
        ...
    
    def metaValueExists(self, in_0: Union[bytes, str, String] ) -> bool:
        """
        Cython signature: bool metaValueExists(String)
        Returns whether an entry with the given name exists
        """
        ...
    
    def removeMetaValue(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void removeMetaValue(String)
        Removes the DataValue corresponding to `name` if it exists
        """
        ...
    
    def __richcmp__(self, other: ScanWindow, op: int) -> Any:
        ... 


class SequestInfile:
    """
    Cython implementation of _SequestInfile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SequestInfile.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SequestInfile()
        Sequest input file adapter
        """
        ...
    
    @overload
    def __init__(self, in_0: SequestInfile ) -> None:
        """
        Cython signature: void SequestInfile(SequestInfile &)
        """
        ...
    
    def store(self, filename: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void store(const String & filename)
        Stores the experiment data in a Sequest input file that can be used as input for Sequest shell execution
        
        :param filename: the name of the file in which the infile is stored into
        """
        ...
    
    def getEnzymeInfoAsString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getEnzymeInfoAsString()
        Returns the enzyme list as a string
        """
        ...
    
    def getDatabase(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getDatabase()
        Returns the used database
        """
        ...
    
    def setDatabase(self, database: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setDatabase(const String & database)
        Sets the used database
        """
        ...
    
    def getNeutralLossesForIons(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getNeutralLossesForIons()
        Returns whether neutral losses are considered for the a-, b- and y-ions
        """
        ...
    
    def setNeutralLossesForIons(self, neutral_losses_for_ions: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setNeutralLossesForIons(const String & neutral_losses_for_ions)
        Sets whether neutral losses are considered for the a-, b- and y-ions
        """
        ...
    
    def getIonSeriesWeights(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getIonSeriesWeights()
        Returns the weights for the a-, b-, c-, d-, v-, w-, x-, y- and z-ion series
        """
        ...
    
    def setIonSeriesWeights(self, ion_series_weights: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setIonSeriesWeights(const String & ion_series_weights)
        Sets the weights for the a-, b-, c-, d-, v-, w-, x-, y- and z-ion series
        """
        ...
    
    def getPartialSequence(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getPartialSequence()
        Returns the partial sequences (space delimited) that have to occur in the theoretical spectra
        """
        ...
    
    def setPartialSequence(self, partial_sequence: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setPartialSequence(const String & partial_sequence)
        Sets the partial sequences (space delimited) that have to occur in the theoretical spectra
        """
        ...
    
    def getSequenceHeaderFilter(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getSequenceHeaderFilter()
        Returns the sequences (space delimited) that have to occur, or be absent (preceded by a tilde) in the header of a protein to be considered
        """
        ...
    
    def setSequenceHeaderFilter(self, sequence_header_filter: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setSequenceHeaderFilter(const String & sequence_header_filter)
        Sets the sequences (space delimited) that have to occur, or be absent (preceded by a tilde) in the header of a protein to be considered
        """
        ...
    
    def getProteinMassFilter(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getProteinMassFilter()
        Returns the protein mass filter (either min and max mass, or mass and tolerance value in percent)
        """
        ...
    
    def setProteinMassFilter(self, protein_mass_filter: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setProteinMassFilter(const String & protein_mass_filter)
        Sets the protein mass filter (either min and max mass, or mass and tolerance value in percent)
        """
        ...
    
    def getPeakMassTolerance(self) -> float:
        """
        Cython signature: float getPeakMassTolerance()
        Returns the peak mass tolerance
        """
        ...
    
    def setPeakMassTolerance(self, peak_mass_tolerance: float ) -> None:
        """
        Cython signature: void setPeakMassTolerance(float peak_mass_tolerance)
        Sets the peak mass tolerance
        """
        ...
    
    def getPrecursorMassTolerance(self) -> float:
        """
        Cython signature: float getPrecursorMassTolerance()
        Returns the precursor mass tolerance
        """
        ...
    
    def setPrecursorMassTolerance(self, precursor_mass_tolerance: float ) -> None:
        """
        Cython signature: void setPrecursorMassTolerance(float precursor_mass_tolerance)
        Sets the precursor mass tolerance
        """
        ...
    
    def getMatchPeakTolerance(self) -> float:
        """
        Cython signature: float getMatchPeakTolerance()
        Returns the match peak tolerance
        """
        ...
    
    def setMatchPeakTolerance(self, match_peak_tolerance: float ) -> None:
        """
        Cython signature: void setMatchPeakTolerance(float match_peak_tolerance)
        Sets the match peak tolerance
        """
        ...
    
    def getIonCutoffPercentage(self) -> float:
        """
        Cython signature: float getIonCutoffPercentage()
        Returns the the cutoff of the ratio matching theoretical peaks/theoretical peaks
        """
        ...
    
    def setIonCutoffPercentage(self, ion_cutoff_percentage: float ) -> None:
        """
        Cython signature: void setIonCutoffPercentage(float ion_cutoff_percentage)
        Sets the ion cutoff of the ratio matching theoretical peaks/theoretical peaks
        """
        ...
    
    def getPeptideMassUnit(self) -> int:
        """
        Cython signature: size_t getPeptideMassUnit()
        Returns the peptide mass unit
        """
        ...
    
    def setPeptideMassUnit(self, peptide_mass_unit: int ) -> None:
        """
        Cython signature: void setPeptideMassUnit(size_t peptide_mass_unit)
        Sets the peptide mass unit
        """
        ...
    
    def getOutputLines(self) -> int:
        """
        Cython signature: size_t getOutputLines()
        Returns the number of peptides to be displayed
        """
        ...
    
    def setOutputLines(self, output_lines: int ) -> None:
        """
        Cython signature: void setOutputLines(size_t output_lines)
        Sets the number of peptides to be displayed
        """
        ...
    
    def getEnzymeNumber(self) -> int:
        """
        Cython signature: size_t getEnzymeNumber()
        Returns the enzyme used for cleavage (by means of the number from a list of enzymes)
        """
        ...
    
    def getEnzymeName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getEnzymeName()
        Returns the enzyme used for cleavage
        """
        ...
    
    def setEnzyme(self, enzyme_name: Union[bytes, str, String] ) -> int:
        """
        Cython signature: size_t setEnzyme(String enzyme_name)
        Sets the enzyme used for cleavage (by means of the number from a list of enzymes)
        """
        ...
    
    def getMaxAAPerModPerPeptide(self) -> int:
        """
        Cython signature: size_t getMaxAAPerModPerPeptide()
        Returns the maximum number of amino acids containing the same modification in a peptide
        """
        ...
    
    def setMaxAAPerModPerPeptide(self, max_aa_per_mod_per_peptide: int ) -> None:
        """
        Cython signature: void setMaxAAPerModPerPeptide(size_t max_aa_per_mod_per_peptide)
        Sets the maximum number of amino acids containing the same modification in a peptide
        """
        ...
    
    def getMaxModsPerPeptide(self) -> int:
        """
        Cython signature: size_t getMaxModsPerPeptide()
        Returns the maximum number of modifications that are allowed in a peptide
        """
        ...
    
    def setMaxModsPerPeptide(self, max_mods_per_peptide: int ) -> None:
        """
        Cython signature: void setMaxModsPerPeptide(size_t max_mods_per_peptide)
        Sets the maximum number of modifications that are allowed in a peptide
        """
        ...
    
    def getNucleotideReadingFrame(self) -> int:
        """
        Cython signature: size_t getNucleotideReadingFrame()
        Returns the nucleotide reading frame
        """
        ...
    
    def setNucleotideReadingFrame(self, nucleotide_reading_frame: int ) -> None:
        """
        Cython signature: void setNucleotideReadingFrame(size_t nucleotide_reading_frame)
        Sets the nucleotide reading frame
        """
        ...
    
    def getMaxInternalCleavageSites(self) -> int:
        """
        Cython signature: size_t getMaxInternalCleavageSites()
        Returns the maximum number of internal cleavage sites
        """
        ...
    
    def setMaxInternalCleavageSites(self, max_internal_cleavage_sites: int ) -> None:
        """
        Cython signature: void setMaxInternalCleavageSites(size_t max_internal_cleavage_sites)
        Sets the maximum number of internal cleavage sites
        """
        ...
    
    def getMatchPeakCount(self) -> int:
        """
        Cython signature: size_t getMatchPeakCount()
        Returns the number of top abundant peaks to match with theoretical ones
        """
        ...
    
    def setMatchPeakCount(self, match_peak_count: int ) -> None:
        """
        Cython signature: void setMatchPeakCount(size_t match_peak_count)
        Sets the number of top abundant peaks to with theoretical ones
        """
        ...
    
    def getMatchPeakAllowedError(self) -> int:
        """
        Cython signature: size_t getMatchPeakAllowedError()
        Returns the number of top abundant peaks that are allowed not to match with a theoretical peak
        """
        ...
    
    def setMatchPeakAllowedError(self, match_peak_allowed_error: int ) -> None:
        """
        Cython signature: void setMatchPeakAllowedError(size_t match_peak_allowed_error)
        Sets the number of top abundant peaks that are allowed not to match with a theoretical peak
        """
        ...
    
    def getShowFragmentIons(self) -> bool:
        """
        Cython signature: bool getShowFragmentIons()
        Returns whether fragment ions shall be displayed
        """
        ...
    
    def setShowFragmentIons(self, show_fragments: bool ) -> None:
        """
        Cython signature: void setShowFragmentIons(bool show_fragments)
        Sets whether fragment ions shall be displayed
        """
        ...
    
    def getPrintDuplicateReferences(self) -> bool:
        """
        Cython signature: bool getPrintDuplicateReferences()
        Returns whether all proteins containing a found peptide should be displayed
        """
        ...
    
    def setPrintDuplicateReferences(self, print_duplicate_references: bool ) -> None:
        """
        Cython signature: void setPrintDuplicateReferences(bool print_duplicate_references)
        Sets whether all proteins containing a found peptide should be displayed
        """
        ...
    
    def getRemovePrecursorNearPeaks(self) -> bool:
        """
        Cython signature: bool getRemovePrecursorNearPeaks()
        Returns whether peaks near (15 amu) the precursor peak are removed
        """
        ...
    
    def setRemovePrecursorNearPeaks(self, remove_precursor_near_peaks: bool ) -> None:
        """
        Cython signature: void setRemovePrecursorNearPeaks(bool remove_precursor_near_peaks)
        Sets whether peaks near (15 amu) the precursor peak are removed
        """
        ...
    
    def getMassTypeParent(self) -> bool:
        """
        Cython signature: bool getMassTypeParent()
        Returns the mass type of the parent (0 - monoisotopic, 1 - average mass)
        """
        ...
    
    def setMassTypeParent(self, mass_type_parent: bool ) -> None:
        """
        Cython signature: void setMassTypeParent(bool mass_type_parent)
        Sets the mass type of the parent (0 - monoisotopic, 1 - average mass)
        """
        ...
    
    def getMassTypeFragment(self) -> bool:
        """
        Cython signature: bool getMassTypeFragment()
        Returns the mass type of the fragments (0 - monoisotopic, 1 - average mass)
        """
        ...
    
    def setMassTypeFragment(self, mass_type_fragment: bool ) -> None:
        """
        Cython signature: void setMassTypeFragment(bool mass_type_fragment)
        Sets the mass type of the fragments (0 - monoisotopic, 1 - average mass)
        """
        ...
    
    def getNormalizeXcorr(self) -> bool:
        """
        Cython signature: bool getNormalizeXcorr()
        Returns whether normalized xcorr values are displayed
        """
        ...
    
    def setNormalizeXcorr(self, normalize_xcorr: bool ) -> None:
        """
        Cython signature: void setNormalizeXcorr(bool normalize_xcorr)
        Sets whether normalized xcorr values are displayed
        """
        ...
    
    def getResiduesInUpperCase(self) -> bool:
        """
        Cython signature: bool getResiduesInUpperCase()
        Returns whether residues are in upper case
        """
        ...
    
    def setResiduesInUpperCase(self, residues_in_upper_case: bool ) -> None:
        """
        Cython signature: void setResiduesInUpperCase(bool residues_in_upper_case)
        Sets whether residues are in upper case
        """
        ...
    
    def addEnzymeInfo(self, enzyme_info: List[bytes] ) -> None:
        """
        Cython signature: void addEnzymeInfo(libcpp_vector[String] & enzyme_info)
        Adds an enzyme to the list and sets is as used
        """
        ...
    
    def handlePTMs(self, modification_line: Union[bytes, str, String] , modifications_filename: Union[bytes, str, String] , monoisotopic: bool ) -> None:
        """
        Cython signature: void handlePTMs(const String & modification_line, const String & modifications_filename, bool monoisotopic)
        """
        ...
    
    def __richcmp__(self, other: SequestInfile, op: int) -> Any:
        ... 


class SignalToNoiseEstimatorMedian:
    """
    Cython implementation of _SignalToNoiseEstimatorMedian[_MSSpectrum]

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SignalToNoiseEstimatorMedian[_MSSpectrum].html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SignalToNoiseEstimatorMedian()
        """
        ...
    
    @overload
    def __init__(self, in_0: SignalToNoiseEstimatorMedian ) -> None:
        """
        Cython signature: void SignalToNoiseEstimatorMedian(SignalToNoiseEstimatorMedian &)
        """
        ...
    
    def init(self, spectrum: MSSpectrum ) -> None:
        """
        Cython signature: void init(MSSpectrum & spectrum)
        """
        ...
    
    def getSignalToNoise(self, index: int ) -> float:
        """
        Cython signature: double getSignalToNoise(size_t index)
        """
        ...
    
    def getSparseWindowPercent(self) -> float:
        """
        Cython signature: double getSparseWindowPercent()
        """
        ...
    
    def getHistogramRightmostPercent(self) -> float:
        """
        Cython signature: double getHistogramRightmostPercent()
        """
        ...
    IntensityThresholdCalculation : __IntensityThresholdCalculation 


class Software:
    """
    Cython implementation of _Software

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1Software.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void Software()
        """
        ...
    
    @overload
    def __init__(self, in_0: Software ) -> None:
        """
        Cython signature: void Software(Software &)
        """
        ...
    
    def getName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getName()
        Returns the name of the software
        """
        ...
    
    def getVersion(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getVersion()
        Returns the software version
        """
        ...
    
    def setName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setName(String)
        Sets the name of the software
        """
        ...
    
    def setVersion(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setVersion(String)
        Sets the software version
        """
        ... 


class SpectralMatch:
    """
    Cython implementation of _SpectralMatch

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SpectralMatch.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SpectralMatch()
        """
        ...
    
    @overload
    def __init__(self, in_0: SpectralMatch ) -> None:
        """
        Cython signature: void SpectralMatch(SpectralMatch &)
        """
        ...
    
    def getObservedPrecursorMass(self) -> float:
        """
        Cython signature: double getObservedPrecursorMass()
        """
        ...
    
    def setObservedPrecursorMass(self, in_0: float ) -> None:
        """
        Cython signature: void setObservedPrecursorMass(double)
        """
        ...
    
    def getObservedPrecursorRT(self) -> float:
        """
        Cython signature: double getObservedPrecursorRT()
        """
        ...
    
    def setObservedPrecursorRT(self, in_0: float ) -> None:
        """
        Cython signature: void setObservedPrecursorRT(double)
        """
        ...
    
    def getFoundPrecursorMass(self) -> float:
        """
        Cython signature: double getFoundPrecursorMass()
        """
        ...
    
    def setFoundPrecursorMass(self, in_0: float ) -> None:
        """
        Cython signature: void setFoundPrecursorMass(double)
        """
        ...
    
    def getFoundPrecursorCharge(self) -> int:
        """
        Cython signature: int getFoundPrecursorCharge()
        """
        ...
    
    def setFoundPrecursorCharge(self, in_0: int ) -> None:
        """
        Cython signature: void setFoundPrecursorCharge(int)
        """
        ...
    
    def getMatchingScore(self) -> float:
        """
        Cython signature: double getMatchingScore()
        """
        ...
    
    def setMatchingScore(self, in_0: float ) -> None:
        """
        Cython signature: void setMatchingScore(double)
        """
        ...
    
    def getObservedSpectrumIndex(self) -> int:
        """
        Cython signature: size_t getObservedSpectrumIndex()
        """
        ...
    
    def setObservedSpectrumIndex(self, in_0: int ) -> None:
        """
        Cython signature: void setObservedSpectrumIndex(size_t)
        """
        ...
    
    def getMatchingSpectrumIndex(self) -> int:
        """
        Cython signature: size_t getMatchingSpectrumIndex()
        """
        ...
    
    def setMatchingSpectrumIndex(self, in_0: int ) -> None:
        """
        Cython signature: void setMatchingSpectrumIndex(size_t)
        """
        ...
    
    def getPrimaryIdentifier(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getPrimaryIdentifier()
        """
        ...
    
    def setPrimaryIdentifier(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setPrimaryIdentifier(String)
        """
        ...
    
    def getSecondaryIdentifier(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getSecondaryIdentifier()
        """
        ...
    
    def setSecondaryIdentifier(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setSecondaryIdentifier(String)
        """
        ...
    
    def getCommonName(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getCommonName()
        """
        ...
    
    def setCommonName(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setCommonName(String)
        """
        ...
    
    def getSumFormula(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getSumFormula()
        """
        ...
    
    def setSumFormula(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setSumFormula(String)
        """
        ...
    
    def getInchiString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getInchiString()
        """
        ...
    
    def setInchiString(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setInchiString(String)
        """
        ...
    
    def getSMILESString(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getSMILESString()
        """
        ...
    
    def setSMILESString(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setSMILESString(String)
        """
        ...
    
    def getPrecursorAdduct(self) -> Union[bytes, str, String]:
        """
        Cython signature: String getPrecursorAdduct()
        """
        ...
    
    def setPrecursorAdduct(self, in_0: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setPrecursorAdduct(String)
        """
        ... 


class SpectrumHelper:
    """
    Cython implementation of _SpectrumHelper

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/class_1_1SpectrumHelper.html>`_
    """
    
    removePeaks: __static_SpectrumHelper_removePeaks
    
    removePeaks: __static_SpectrumHelper_removePeaks
    
    subtractMinimumIntensity: __static_SpectrumHelper_subtractMinimumIntensity
    
    subtractMinimumIntensity: __static_SpectrumHelper_subtractMinimumIntensity 


class SpectrumMetaData:
    """
    Cython implementation of _SpectrumMetaData

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SpectrumMetaData.html>`_
    """
    
    rt: float
    
    precursor_rt: float
    
    precursor_mz: float
    
    precursor_charge: int
    
    ms_level: int
    
    scan_number: int
    
    native_id: Union[bytes, str, String]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SpectrumMetaData()
        """
        ...
    
    @overload
    def __init__(self, in_0: SpectrumMetaData ) -> None:
        """
        Cython signature: void SpectrumMetaData(SpectrumMetaData &)
        """
        ... 


class SpectrumMetaDataLookup:
    """
    Cython implementation of _SpectrumMetaDataLookup

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1SpectrumMetaDataLookup.html>`_
      -- Inherits from ['SpectrumLookup']
    """
    
    def __init__(self) -> None:
        """
        Cython signature: void SpectrumMetaDataLookup()
        """
        ...
    
    @overload
    def readSpectra(self, spectra: MSExperiment , scan_regexp: Union[bytes, str, String] , get_precursor_rt: bool ) -> None:
        """
        Cython signature: void readSpectra(MSExperiment spectra, String scan_regexp, bool get_precursor_rt)
        Read spectra and store their meta data
        
        :param SpectrumContainer: Spectrum container class, must support `size` and `operator[]`
        :param spectra: Container of spectra
        :param scan_regexp: Regular expression for matching scan numbers in spectrum native IDs (must contain the named group "?<SCAN>")
        :param get_precursor_rt: Assign precursor retention times? (This relies on all precursor spectra being present and in the right order.)
        """
        ...
    
    @overload
    def readSpectra(self, spectra: MSExperiment , scan_regexp: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void readSpectra(MSExperiment spectra, String scan_regexp)
        Read and index spectra for later look-up
        
        :param spectra: Container of spectra
        :param scan_regexp: Regular expression for matching scan numbers in spectrum native IDs (must contain the named group "?<SCAN>". For example, "scan=(?<SCAN>\\d+)").
        """
        ...
    
    @overload
    def getSpectrumMetaData(self, index: int , meta: SpectrumMetaData ) -> None:
        """
        Cython signature: void getSpectrumMetaData(size_t index, SpectrumMetaData & meta)
        Look up meta data of a spectrum
        
        :param index: Index of the spectrum
        :param meta: Meta data output
        """
        ...
    
    @overload
    def getSpectrumMetaData(self, spectrum_ref: Union[bytes, str, String] , meta: SpectrumMetaData ) -> None:
        """
        Cython signature: void getSpectrumMetaData(String spectrum_ref, SpectrumMetaData & meta)
        Extract meta data from a spectrum
        
        :param spectrum: Spectrum input
        :param meta: Meta data output
        :param scan_regexp: Regular expression for extracting scan number from spectrum native ID
        :param precursor_rts: RTs of potential precursor spectra of different MS levels
        """
        ...
    
    @overload
    def getSpectrumMetaData(self, spectrum_ref: Union[bytes, str, String] , meta: SpectrumMetaData , flags: bytes ) -> None:
        """
        Cython signature: void getSpectrumMetaData(String spectrum_ref, SpectrumMetaData & meta, unsigned char flags)
        Extract meta data via a spectrum reference
        
        :param spectrum_ref: Spectrum reference to parse
        :param metadata: Meta data output
        :param flags: What meta data to extract
        """
        ...
    
    def setSpectraDataRef(self, spectra_data: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void setSpectraDataRef(const String & spectra_data)
        """
        ...
    
    def empty(self) -> bool:
        """
        Cython signature: bool empty()
        Check if any spectra were set
        """
        ...
    
    def findByRT(self, rt: float ) -> int:
        """
        Cython signature: size_t findByRT(double rt)
        Look up spectrum by retention time (RT)
        
        :param rt: Retention time to look up
        :returns: Index of the spectrum that matched
        """
        ...
    
    def findByNativeID(self, native_id: Union[bytes, str, String] ) -> int:
        """
        Cython signature: size_t findByNativeID(String native_id)
        Look up spectrum by native ID
        
        :param native_id: Native ID to look up
        :returns: Index of the spectrum that matched
        """
        ...
    
    def findByIndex(self, index: int , count_from_one: bool ) -> int:
        """
        Cython signature: size_t findByIndex(size_t index, bool count_from_one)
        Look up spectrum by index (position in the vector of spectra)
        
        :param index: Index to look up
        :param count_from_one: Do indexes start counting at one (default zero)?
        :returns: Index of the spectrum that matched
        """
        ...
    
    def findByScanNumber(self, scan_number: int ) -> int:
        """
        Cython signature: size_t findByScanNumber(size_t scan_number)
        Look up spectrum by scan number (extracted from the native ID)
        
        :param scan_number: Scan number to look up
        :returns: Index of the spectrum that matched
        """
        ...
    
    def findByReference(self, spectrum_ref: Union[bytes, str, String] ) -> int:
        """
        Cython signature: size_t findByReference(String spectrum_ref)
        Look up spectrum by reference
        
        :param spectrum_ref: Spectrum reference to parse
        :returns: Index of the spectrum that matched
        """
        ...
    
    def addReferenceFormat(self, regexp: Union[bytes, str, String] ) -> None:
        """
        Cython signature: void addReferenceFormat(String regexp)
        Register a possible format for a spectrum reference
        
        :param regexp: Regular expression defining the format
        """
        ...
    
    def extractScanNumber(self, native_id: Union[bytes, str, String] , native_id_type_accession: Union[bytes, str, String] ) -> int:
        """
        Cython signature: int extractScanNumber(const String & native_id, const String & native_id_type_accession)
        """
        ...
    
    addMissingIMToPeptideIDs: __static_SpectrumMetaDataLookup_addMissingIMToPeptideIDs
    
    addMissingRTsToPeptideIDs: __static_SpectrumMetaDataLookup_addMissingRTsToPeptideIDs
    
    addMissingSpectrumReferences: __static_SpectrumMetaDataLookup_addMissingSpectrumReferences
    
    getSpectrumMetaData: __static_SpectrumMetaDataLookup_getSpectrumMetaData 


class SwathMap:
    """
    Cython implementation of _SwathMap

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenSwath_1_1SwathMap.html>`_
    """
    
    lower: float
    
    upper: float
    
    center: float
    
    ms1: bool
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void SwathMap()
        Data structure to hold one SWATH map with information about upper / lower isolation window and whether the map is MS1 or MS2
        """
        ...
    
    @overload
    def __init__(self, in_0: SwathMap ) -> None:
        """
        Cython signature: void SwathMap(SwathMap &)
        """
        ...
    
    @overload
    def __init__(self, mz_start: float , mz_end: float , mz_center: float , is_ms1: bool ) -> None:
        """
        Cython signature: void SwathMap(double mz_start, double mz_end, double mz_center, bool is_ms1)
        """
        ... 


class TransitionPQPFile:
    """
    Cython implementation of _TransitionPQPFile

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS_1_1TransitionPQPFile.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void TransitionPQPFile()
        """
        ...
    
    @overload
    def __init__(self, in_0: TransitionPQPFile ) -> None:
        """
        Cython signature: void TransitionPQPFile(TransitionPQPFile &)
        """
        ...
    
    def convertTargetedExperimentToPQP(self, filename: bytes , targeted_exp: TargetedExperiment ) -> None:
        """
        Cython signature: void convertTargetedExperimentToPQP(char * filename, TargetedExperiment & targeted_exp)
        Write out a targeted experiment (TraML structure) into a PQP file
        
        :param filename: The output file
        :param targeted_exp: The targeted experiment
        """
        ...
    
    @overload
    def convertPQPToTargetedExperiment(self, filename: bytes , targeted_exp: TargetedExperiment , legacy_traml_id: bool ) -> None:
        """
        Cython signature: void convertPQPToTargetedExperiment(char * filename, TargetedExperiment & targeted_exp, bool legacy_traml_id)
        Read in a PQP file and construct a targeted experiment (TraML structure)
        
        :param filename: The input file
        :param targeted_exp: The output targeted experiment
        :param legacy_traml_id: Should legacy TraML IDs be used (boolean)?
        """
        ...
    
    @overload
    def convertPQPToTargetedExperiment(self, filename: bytes , targeted_exp: LightTargetedExperiment , legacy_traml_id: bool ) -> None:
        """
        Cython signature: void convertPQPToTargetedExperiment(char * filename, LightTargetedExperiment & targeted_exp, bool legacy_traml_id)
        Read in a PQP file and construct a targeted experiment (Light transition structure)
        
        :param filename: The input file
        :param targeted_exp: The output targeted experiment
        :param legacy_traml_id: Should legacy TraML IDs be used (boolean)?
        """
        ...
    
    def convertTargetedExperimentToTSV(self, filename: bytes , targeted_exp: TargetedExperiment ) -> None:
        """
        Cython signature: void convertTargetedExperimentToTSV(char * filename, TargetedExperiment & targeted_exp)
        """
        ...
    
    @overload
    def convertTSVToTargetedExperiment(self, filename: bytes , filetype: int , targeted_exp: TargetedExperiment ) -> None:
        """
        Cython signature: void convertTSVToTargetedExperiment(char * filename, FileType filetype, TargetedExperiment & targeted_exp)
        """
        ...
    
    @overload
    def convertTSVToTargetedExperiment(self, filename: bytes , filetype: int , targeted_exp: LightTargetedExperiment ) -> None:
        """
        Cython signature: void convertTSVToTargetedExperiment(char * filename, FileType filetype, LightTargetedExperiment & targeted_exp)
        """
        ...
    
    def validateTargetedExperiment(self, targeted_exp: TargetedExperiment ) -> None:
        """
        Cython signature: void validateTargetedExperiment(TargetedExperiment targeted_exp)
        """
        ... 


class _Interfaces_BinaryDataArray:
    """
    Cython implementation of _BinaryDataArray

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Interfaces_1_1BinaryDataArray.html>`_
    """
    
    data: List[float]
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void _Interfaces_BinaryDataArray()
        """
        ...
    
    @overload
    def __init__(self, in_0: _Interfaces_BinaryDataArray ) -> None:
        """
        Cython signature: void _Interfaces_BinaryDataArray(_Interfaces_BinaryDataArray &)
        """
        ... 


class _Interfaces_Chromatogram:
    """
    Cython implementation of _Chromatogram

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Interfaces_1_1Chromatogram.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void _Interfaces_Chromatogram()
        """
        ...
    
    @overload
    def __init__(self, in_0: _Interfaces_Chromatogram ) -> None:
        """
        Cython signature: void _Interfaces_Chromatogram(_Interfaces_Chromatogram &)
        """
        ... 


class _Interfaces_Spectrum:
    """
    Cython implementation of _Spectrum

    Original C++ documentation is available `here <http://www.openms.de/current_doxygen/html/classOpenMS::Interfaces_1_1Spectrum.html>`_
    """
    
    @overload
    def __init__(self, ) -> None:
        """
        Cython signature: void _Interfaces_Spectrum()
        """
        ...
    
    @overload
    def __init__(self, in_0: _Interfaces_Spectrum ) -> None:
        """
        Cython signature: void _Interfaces_Spectrum(_Interfaces_Spectrum &)
        """
        ... 


class BoundaryCondition:
    None
    BC_ZERO_ENDPOINTS : int
    BC_ZERO_FIRST : int
    BC_ZERO_SECOND : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __ByteOrder:
    None
    BYTEORDER_BIGENDIAN : int
    BYTEORDER_LITTLEENDIAN : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __IntensityThresholdCalculation:
    None
    MANUAL : int
    AUTOMAXBYSTDEV : int
    AUTOMAXBYPERCENT : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __NumpressCompression:
    None
    NONE : int
    LINEAR : int
    PIC : int
    SLOF : int
    SIZE_OF_NUMPRESSCOMPRESSION : int

    def getMapping(self) -> Dict[int, str]:
       ... 


class __OpenPepXLLFAlgorithm_ExitCodes:
    None
    EXECUTION_OK : int
    ILLEGAL_PARAMETERS : int
    UNEXPECTED_RESULT : int
    INCOMPATIBLE_INPUT_DATA : int

    def getMapping(self) -> Dict[int, str]:
       ... 

