# SPDX-FileCopyrightText: 2009-2022 the scikit-image team
# SPDX-FileCopyrightText: Copyright (c) 2024-2025, NVIDIA CORPORATION. All rights reserved.
# SPDX-License-Identifier: Apache-2.0 AND BSD-3-Clause

# Explicitly setting `__all__` is necessary for type inference engines
# to know which symbols are exported. See
# https://peps.python.org/pep-0484/#stub-files

__all__ = [
    "adapted_rand_error",
    "variation_of_information",
    "contingency_table",
    "mean_squared_error",
    "normalized_mutual_information",
    "normalized_root_mse",
    "peak_signal_noise_ratio",
    "structural_similarity",
]

from ._adapted_rand_error import adapted_rand_error
from ._contingency_table import contingency_table
from ._structural_similarity import structural_similarity
from ._variation_of_information import variation_of_information
from .simple_metrics import (
    mean_squared_error,
    normalized_mutual_information,
    normalized_root_mse,
    peak_signal_noise_ratio,
)
