# SPDX-FileCopyrightText: 2009-2022 the scikit-image team
# SPDX-FileCopyrightText: Copyright (c) 2024-2025, NVIDIA CORPORATION. All rights reserved.
# SPDX-License-Identifier: Apache-2.0 AND BSD-3-Clause

# Explicitly setting `__all__` is necessary for type inference engines
# to know which symbols are exported. See
# https://peps.python.org/pep-0484/#stub-files

__all__ = [
    "regionprops",
    "regionprops_table",
    "perimeter",
    "perimeter_crofton",
    "euler_number",
    "approximate_polygon",
    "subdivide_polygon",
    "block_reduce",
    "centroid",
    "moments",
    "moments_central",
    "moments_coords",
    "moments_coords_central",
    "moments_normalized",
    "moments_hu",
    "inertia_tensor",
    "inertia_tensor_eigvals",
    "profile_line",
    "label",
    "shannon_entropy",
    "blur_effect",
    "pearson_corr_coeff",
    "manders_coloc_coeff",
    "manders_overlap_coeff",
    "intersection_coeff",
]

from ._blur_effect import blur_effect
from ._colocalization import (
    intersection_coeff,
    manders_coloc_coeff,
    manders_overlap_coeff,
    pearson_corr_coeff,
)
from ._label import label
from ._moments import (
    centroid,
    inertia_tensor,
    inertia_tensor_eigvals,
    moments,
    moments_central,
    moments_coords,
    moments_coords_central,
    moments_hu,
    moments_normalized,
)
from ._polygon import approximate_polygon, subdivide_polygon
from ._regionprops import (
    euler_number,
    perimeter,
    perimeter_crofton,
    regionprops,
    regionprops_table,
)
from .block import block_reduce
from .entropy import shannon_entropy
from .profile import profile_line
