/*
 * Copyright (c) 2021, NVIDIA CORPORATION.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef CUCIM_BASE64_H
#define CUCIM_BASE64_H

#include "cucim/macros/defines.h"

namespace cucim::codec::base64
{
EXPORT_VISIBLE bool encode(const char* src, int src_count, char** out_dst, int* out_count);
EXPORT_VISIBLE bool decode(const char* src, int src_count, char** out_dst, int* out_count);
}
#endif // CUCIM_BASE64_H
