
set(CTEST_SCRIPT_DIRECTORY ".")
set(CMAKE_INSTALL_PREFIX "./../../../")
add_test(generate_resource_spec ./generate_ctest_json "./resource_spec.json")
execute_process(COMMAND ./generate_ctest_json --cwd COMMAND_ERROR_IS_FATAL ANY OUTPUT_VARIABLE _cwd)
set_tests_properties(generate_resource_spec PROPERTIES
  FIXTURES_SETUP resource_spec
  GENERATED_RESOURCE_SPEC_FILE "${_cwd}/resource_spec.json"
)



add_test([=[SG_DBSCAN_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_DBSCAN_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_DBSCAN_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_DBSCAN_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_SHAP_KERNEL_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_SHAP_KERNEL_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_SHAP_KERNEL_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_SHAP_KERNEL_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_HOST_BUFFER_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_HOST_BUFFER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_HOST_BUFFER_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_HOST_BUFFER_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_DEVICE_BUFFER_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_DEVICE_BUFFER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_DEVICE_BUFFER_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_DEVICE_BUFFER_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_FOREST_TRAVERSAL_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_FOREST_TRAVERSAL_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_FOREST_TRAVERSAL_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_FOREST_TRAVERSAL_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_TREELITE_TRAVERSAL_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_TREELITE_TRAVERSAL_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_TREELITE_TRAVERSAL_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_TREELITE_TRAVERSAL_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_TREELITE_IMPORTER_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_TREELITE_IMPORTER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_TREELITE_IMPORTER_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_TREELITE_IMPORTER_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_OLS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_OLS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_OLS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_OLS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_RIDGE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_RIDGE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_RIDGE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_RIDGE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_GENETIC_NODE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_GENETIC_NODE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_GENETIC_NODE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_GENETIC_NODE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_GENETIC_PARAM_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_GENETIC_PARAM_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_GENETIC_PARAM_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_GENETIC_PARAM_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_HDBSCAN_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_HDBSCAN_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_HDBSCAN_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_HDBSCAN_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_HOLTWINTERS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_HOLTWINTERS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_HOLTWINTERS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_HOLTWINTERS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_KNN_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_KNN_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_KNN_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_KNN_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_LINKAGE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_LINKAGE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_LINKAGE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_LINKAGE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_TRUSTWORTHINESS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_TRUSTWORTHINESS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_TRUSTWORTHINESS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_TRUSTWORTHINESS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_PCA_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_PCA_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_PCA_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_PCA_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_RF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_RF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_RF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_RF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[SG_CD_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_CD_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_CD_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_CD_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_LARS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_LARS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_LARS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_LARS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_QUASI_NEWTON]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_QUASI_NEWTON -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_QUASI_NEWTON]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_QUASI_NEWTON]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_SGD_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_SGD_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_SGD_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_SGD_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_SVC_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_SVC_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_SVC_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_SVC_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)
set_tests_properties([=[SG_SVC_TEST]=] PROPERTIES RUN_SERIAL ON)

add_test([=[SG_TSNE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_TSNE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_TSNE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_TSNE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_TSVD_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_TSVD_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_TSVD_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_TSVD_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_UMAP_PARAMETRIZABLE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_UMAP_PARAMETRIZABLE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_UMAP_PARAMETRIZABLE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_UMAP_PARAMETRIZABLE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[SG_HANDLE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/libcuml/SG_HANDLE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SG_HANDLE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SG_HANDLE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

