/*
 * Copyright (c) 2020-2022, NVIDIA CORPORATION.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <math.h>

/**
 * @addtogroup cuspatial_constants
 * @{
 */

namespace cuspatial {

constexpr double DEGREE_TO_RADIAN = M_PI / 180.0;
constexpr double RADIAN_TO_DEGREE = 180.0 / M_PI;
constexpr double CIRCLE_DEGREES   = 360.0;

constexpr double EARTH_RADIUS_KM                = 6371.0;
constexpr double EARTH_CIRCUMFERENCE_EQUATOR_KM = 40000.0;
constexpr double EARTH_CIRCUMFERENCE_KM_PER_DEGREE =
  EARTH_CIRCUMFERENCE_EQUATOR_KM / CIRCLE_DEGREES;

}  // namespace cuspatial

/**
 * @} // end of doxygen group
 */
