#=============================================================================
# SPDX-FileCopyrightText: Copyright (c) 2026, NVIDIA CORPORATION.
# SPDX-License-Identifier: Apache-2.0
#=============================================================================

#[=======================================================================[

Generated bs_thread_pool-config module

Result Variables
^^^^^^^^^^^^^^^^

This module will set the following variables::

  BS_THREAD_POOL_FOUND
  BS_THREAD_POOL_VERSION
  BS_THREAD_POOL_VERSION_MAJOR
  BS_THREAD_POOL_VERSION_MINOR

#]=======================================================================]


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

cmake_minimum_required(VERSION 3.30.4)

set(rapids_global_languages )
foreach(lang IN LISTS rapids_global_languages)
  include("${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-${lang}-language.cmake")
endforeach()
unset(rapids_global_languages)

include("${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-dependencies.cmake" OPTIONAL)
include("${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-targets.cmake" OPTIONAL)

if()
  set(bs_thread_pool_comp_names )
  # find dependencies before creating targets that use them
  # this way if a dependency can't be found we fail
  foreach(comp IN LISTS bs_thread_pool_FIND_COMPONENTS)
    if(${comp} IN_LIST bs_thread_pool_comp_names)
      file(GLOB bs_thread_pool_component_dep_files LIST_DIRECTORIES FALSE
           "${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-${comp}*-dependencies.cmake")
      foreach(f IN LISTS  bs_thread_pool_component_dep_files)
        include("${f}")
      endforeach()
    endif()
  endforeach()

  foreach(comp IN LISTS bs_thread_pool_FIND_COMPONENTS)
    if(${comp} IN_LIST bs_thread_pool_comp_names)
      file(GLOB bs_thread_pool_component_target_files LIST_DIRECTORIES FALSE
           "${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-${comp}*-targets.cmake")
      foreach(f IN LISTS  bs_thread_pool_component_target_files)
        include("${f}")
      endforeach()
      set(bs_thread_pool_${comp}_FOUND TRUE)
    endif()
  endforeach()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/bs_thread_pool-config-version.cmake" OPTIONAL)

# Set our version variables
set(BS_THREAD_POOL_VERSION_MAJOR 4)
set(BS_THREAD_POOL_VERSION_MINOR 1)
set(BS_THREAD_POOL_VERSION_PATCH 0)
set(BS_THREAD_POOL_VERSION 4.1.0)


set(rapids_global_targets thread_pool)
set(rapids_namespaced_global_targets thread_pool)
if((NOT "BS::" STREQUAL "") AND rapids_namespaced_global_targets)
  list(TRANSFORM rapids_namespaced_global_targets PREPEND "BS::")
endif()

foreach(target IN LISTS rapids_namespaced_global_targets)
  if(TARGET ${target})
    get_target_property(_is_imported ${target} IMPORTED)
    get_target_property(_already_global ${target} IMPORTED_GLOBAL)
    if(_is_imported AND NOT _already_global)
      set_target_properties(${target} PROPERTIES IMPORTED_GLOBAL TRUE)
    endif()
  endif()
endforeach()

# For backwards compat
if("rapids_config_install" STREQUAL "rapids_config_build")
  foreach(target IN LISTS rapids_global_targets)
    if(TARGET ${target})
      get_target_property(_is_imported ${target} IMPORTED)
      get_target_property(_already_global ${target} IMPORTED_GLOBAL)
      if(_is_imported AND NOT _already_global)
        set_target_properties(${target} PROPERTIES IMPORTED_GLOBAL TRUE)
      endif()
      if(NOT TARGET BS::${target})
        add_library(BS::${target} ALIAS ${target})
      endif()
    endif()
  endforeach()
endif()

unset(rapids_comp_names)
unset(rapids_comp_unique_ids)
unset(rapids_global_targets)
unset(rapids_namespaced_global_targets)

check_required_components(bs_thread_pool)

set(${CMAKE_FIND_PACKAGE_NAME}_CONFIG "${CMAKE_CURRENT_LIST_FILE}")

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(${CMAKE_FIND_PACKAGE_NAME} CONFIG_MODE)


