
set(CTEST_SCRIPT_DIRECTORY ".")
set(CMAKE_INSTALL_PREFIX "./../../../")
add_test(generate_resource_spec ./generate_ctest_json "./resource_spec.json")
execute_process(COMMAND ./generate_ctest_json --cwd COMMAND_ERROR_IS_FATAL ANY OUTPUT_VARIABLE _cwd)
set_tests_properties(generate_resource_spec PROPERTIES
  FIXTURES_SETUP resource_spec
  GENERATED_RESOURCE_SPEC_FILE "${_cwd}/resource_spec.json"
)



add_test([=[BASIC_IO_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/tests/libkvikio/BASIC_IO_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[BASIC_IO_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[BASIC_IO_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[DEFAULTS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/tests/libkvikio/DEFAULTS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEFAULTS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEFAULTS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[ERROR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/tests/libkvikio/ERROR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ERROR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ERROR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[REMOTE_HANDLE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/tests/libkvikio/REMOTE_HANDLE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[REMOTE_HANDLE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[REMOTE_HANDLE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

