
set(CTEST_SCRIPT_DIRECTORY ".")
set(CMAKE_INSTALL_PREFIX "./../../../")
add_test(generate_resource_spec ./generate_ctest_json "./resource_spec.json")
execute_process(COMMAND ./generate_ctest_json --cwd COMMAND_ERROR_IS_FATAL ANY OUTPUT_VARIABLE _cwd)
set_tests_properties(generate_resource_spec PROPERTIES
  FIXTURES_SETUP resource_spec
  GENERATED_RESOURCE_SPEC_FILE "${_cwd}/resource_spec.json"
)



add_test([=[CUDA_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[CUDA_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[CUDA_ASYNC_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[CUDA_ASYNC_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[MANAGED_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/MANAGED_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[MANAGED_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[MANAGED_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[MANAGED_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/MANAGED_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[MANAGED_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[MANAGED_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:15)

add_test([=[POOL_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POOL_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POOL_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POOL_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[POOL_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POOL_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POOL_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POOL_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[ARENA_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ARENA_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ARENA_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ARENA_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[ARENA_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ARENA_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ARENA_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ARENA_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[BINNING_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/BINNING_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[BINNING_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[BINNING_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[BINNING_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/BINNING_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[BINNING_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[BINNING_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[SYSTEM_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/SYSTEM_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SYSTEM_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SYSTEM_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[SYSTEM_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/SYSTEM_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SYSTEM_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SYSTEM_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_POOL_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_POOL_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_POOL_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_POOL_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_POOL_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_POOL_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_POOL_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_POOL_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[FIXED_SIZE_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/FIXED_SIZE_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[FIXED_SIZE_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[FIXED_SIZE_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[FIXED_SIZE_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/FIXED_SIZE_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[FIXED_SIZE_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[FIXED_SIZE_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEFAULT_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEFAULT_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEFAULT_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEFAULT_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEFAULT_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEFAULT_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEFAULT_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEFAULT_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_MEMORY_RESOURCE_VIEW_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_MEMORY_RESOURCE_VIEW_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_MEMORY_RESOURCE_VIEW_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_MEMORY_RESOURCE_VIEW_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_MEMORY_RESOURCE_VIEW_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_MEMORY_RESOURCE_VIEW_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_MEMORY_RESOURCE_VIEW_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_MEMORY_RESOURCE_VIEW_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ADAPTOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ADAPTOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ADAPTOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ADAPTOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ADAPTOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ADAPTOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[POOL_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POOL_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POOL_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POOL_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[POOL_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POOL_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POOL_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POOL_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[HWDECOMPRESS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/HWDECOMPRESS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[HWDECOMPRESS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[HWDECOMPRESS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[HWDECOMPRESS_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/HWDECOMPRESS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[HWDECOMPRESS_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[HWDECOMPRESS_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CUDA_ASYNC_MR_STATIC_CUDART_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_STATIC_CUDART_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_STATIC_CUDART_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_STATIC_CUDART_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[CUDA_ASYNC_MR_STATIC_CUDART_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_STATIC_CUDART_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_STATIC_CUDART_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_STATIC_CUDART_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[CUDA_ASYNC_MR_SHARED_CUDART_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_SHARED_CUDART_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_SHARED_CUDART_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_SHARED_CUDART_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[CUDA_ASYNC_MR_SHARED_CUDART_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MR_SHARED_CUDART_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MR_SHARED_CUDART_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MR_SHARED_CUDART_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[CUDA_ASYNC_MANAGED_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MANAGED_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MANAGED_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MANAGED_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CUDA_ASYNC_MANAGED_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_ASYNC_MANAGED_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_ASYNC_MANAGED_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_ASYNC_MANAGED_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[THRUST_ALLOCATOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/THRUST_ALLOCATOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[THRUST_ALLOCATOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[THRUST_ALLOCATOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[THRUST_ALLOCATOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/THRUST_ALLOCATOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[THRUST_ALLOCATOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[THRUST_ALLOCATOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[POLYMORPHIC_ALLOCATOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POLYMORPHIC_ALLOCATOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POLYMORPHIC_ALLOCATOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POLYMORPHIC_ALLOCATOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[POLYMORPHIC_ALLOCATOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/POLYMORPHIC_ALLOCATOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[POLYMORPHIC_ALLOCATOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[POLYMORPHIC_ALLOCATOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[STREAM_ADAPTOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/STREAM_ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[STREAM_ADAPTOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[STREAM_ADAPTOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[STREAM_ADAPTOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/STREAM_ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[STREAM_ADAPTOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[STREAM_ADAPTOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[STATISTICS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/STATISTICS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[STATISTICS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[STATISTICS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[STATISTICS_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/STATISTICS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[STATISTICS_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[STATISTICS_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[TRACKING_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/TRACKING_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[TRACKING_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[TRACKING_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[TRACKING_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/TRACKING_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[TRACKING_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[TRACKING_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[FAILURE_CALLBACK_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/FAILURE_CALLBACK_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[FAILURE_CALLBACK_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[FAILURE_CALLBACK_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[FAILURE_CALLBACK_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/FAILURE_CALLBACK_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[FAILURE_CALLBACK_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[FAILURE_CALLBACK_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PREFETCH_ADAPTOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PREFETCH_ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PREFETCH_ADAPTOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PREFETCH_ADAPTOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PREFETCH_ADAPTOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PREFETCH_ADAPTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PREFETCH_ADAPTOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PREFETCH_ADAPTOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ALIGNED_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ALIGNED_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ALIGNED_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ALIGNED_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ALIGNED_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ALIGNED_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ALIGNED_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ALIGNED_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[LIMITING_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/LIMITING_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[LIMITING_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[LIMITING_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[LIMITING_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/LIMITING_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[LIMITING_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[LIMITING_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[HOST_MR_REF_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/HOST_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[HOST_MR_REF_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[HOST_MR_REF_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[HOST_MR_REF_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/HOST_MR_REF_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[HOST_MR_REF_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[HOST_MR_REF_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_HOST_POOL_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_HOST_POOL_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_HOST_POOL_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_HOST_POOL_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PINNED_HOST_POOL_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PINNED_HOST_POOL_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PINNED_HOST_POOL_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PINNED_HOST_POOL_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CUDA_STREAM_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_STREAM_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_STREAM_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_STREAM_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CUDA_STREAM_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CUDA_STREAM_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CUDA_STREAM_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CUDA_STREAM_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_BUFFER_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_BUFFER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_BUFFER_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_BUFFER_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_BUFFER_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_BUFFER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_BUFFER_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_BUFFER_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_SCALAR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_SCALAR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_SCALAR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_SCALAR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_SCALAR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_SCALAR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_SCALAR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_SCALAR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[DEVICE_UVECTOR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_UVECTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_UVECTOR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_UVECTOR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[DEVICE_UVECTOR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/DEVICE_UVECTOR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[DEVICE_UVECTOR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[DEVICE_UVECTOR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:60)

add_test([=[PREFETCH_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PREFETCH_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PREFETCH_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PREFETCH_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[PREFETCH_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/PREFETCH_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[PREFETCH_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[PREFETCH_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[LOGGER_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/LOGGER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[LOGGER_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[LOGGER_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[LOGGER_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/LOGGER_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[LOGGER_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[LOGGER_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ARENA_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ARENA_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ARENA_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ARENA_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[ARENA_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ARENA_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ARENA_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ARENA_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[BINNING_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/BINNING_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[BINNING_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[BINNING_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[BINNING_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/BINNING_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[BINNING_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[BINNING_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CALLBACK_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CALLBACK_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CALLBACK_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CALLBACK_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CALLBACK_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CALLBACK_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CALLBACK_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CALLBACK_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[SYSTEM_MR_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/SYSTEM_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SYSTEM_MR_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SYSTEM_MR_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[SYSTEM_MR_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/SYSTEM_MR_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[SYSTEM_MR_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[SYSTEM_MR_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:100)

add_test([=[CONTAINER_MULTIDEVICE_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CONTAINER_MULTIDEVICE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CONTAINER_MULTIDEVICE_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CONTAINER_MULTIDEVICE_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[CONTAINER_MULTIDEVICE_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/CONTAINER_MULTIDEVICE_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[CONTAINER_MULTIDEVICE_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[CONTAINER_MULTIDEVICE_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ERROR_MACROS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ERROR_MACROS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ERROR_MACROS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ERROR_MACROS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[ERROR_MACROS_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/ERROR_MACROS_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[ERROR_MACROS_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[ERROR_MACROS_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[RESOURCE_REF_CONVERSION_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/RESOURCE_REF_CONVERSION_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[RESOURCE_REF_CONVERSION_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[RESOURCE_REF_CONVERSION_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

add_test([=[RESOURCE_REF_CONVERSION_PTDS_TEST]=] "cmake" -Dcommand_to_run=${CMAKE_INSTALL_PREFIX}/bin/gtests/librmm/RESOURCE_REF_CONVERSION_TEST -Dcommand_args= -P=./run_gpu_test.cmake)
set_tests_properties([=[RESOURCE_REF_CONVERSION_PTDS_TEST]=] PROPERTIES FIXTURES_REQUIRED resource_spec)
set_tests_properties([=[RESOURCE_REF_CONVERSION_PTDS_TEST]=] PROPERTIES RESOURCE_GROUPS 1,gpus:5)

