# Copyright (c) 2023-2024, NVIDIA CORPORATION.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from networkx.exception import *

from _nx_cugraph._version import __git_commit__, __version__
from _nx_cugraph import _check_networkx_version

_nxver: tuple[int, int] | tuple[int, int, int] = _check_networkx_version()

from . import utils

from . import classes
from .classes import *

from . import convert
from .convert import *

from . import convert_matrix
from .convert_matrix import *

from . import relabel
from .relabel import *

from . import generators
from .generators import *

from . import algorithms
from .algorithms import *

from .interface import BackendInterface

BackendInterface.Graph = classes.Graph
BackendInterface.DiGraph = classes.DiGraph
BackendInterface.MultiGraph = classes.MultiGraph
BackendInterface.MultiDiGraph = classes.MultiDiGraph
del BackendInterface
