# Copyright (c) 2024, NVIDIA CORPORATION.
import io
import os
from collections.abc import Mapping
from enum import IntEnum
from typing import Any, Literal, TypeAlias, overload

from pylibcudf.column import Column
from pylibcudf.io.datasource import Datasource
from pylibcudf.table import Table

class JSONRecoveryMode(IntEnum):
    FAIL = ...
    RECOVER_WITH_NULL = ...

class CompressionType(IntEnum):
    NONE = ...
    AUTO = ...
    SNAPPY = ...
    GZIP = ...
    BZIP2 = ...
    BROTLI = ...
    ZIP = ...
    XZ = ...
    ZLIB = ...
    LZ4 = ...
    LZO = ...
    ZSTD = ...

class ColumnEncoding(IntEnum):
    USE_DEFAULT = ...
    DICTIONARY = ...
    PLAIN = ...
    DELTA_BINARY_PACKED = ...
    DELTA_LENGTH_BYTE_ARRAY = ...
    DELTA_BYTE_ARRAY = ...
    BYTE_STREAM_SPLIT = ...
    DIRECT = ...
    DIRECT_V2 = ...
    DICTIONARY_V2 = ...

class DictionaryPolicy(IntEnum):
    NEVER = ...
    ADAPTIVE = ...
    ALWAYS = ...

class StatisticsFreq(IntEnum):
    STATISTICS_NONE = ...
    STATISTICS_ROWGROUP = ...
    STATISTICS_PAGE = ...
    STATISTICS_COLUMN = ...

class QuoteStyle(IntEnum):
    MINIMAL = ...
    ALL = ...
    NONNUMERIC = ...
    NONE = ...

ColumnNameSpec: TypeAlias = tuple[str, list[ColumnNameSpec]]
ChildNameSpec: TypeAlias = Mapping[str, ChildNameSpec]

class TableWithMetadata:
    tbl: Table
    def __init__(
        self, tbl: Table, column_names: list[ColumnNameSpec]
    ) -> None: ...
    @property
    def columns(self) -> list[Column]: ...
    @overload
    def column_names(self, include_children: Literal[False]) -> list[str]: ...
    @overload
    def column_names(
        self, include_children: Literal[True]
    ) -> list[ColumnNameSpec]: ...
    @overload
    def column_names(
        self, include_children: bool = False
    ) -> list[str] | list[ColumnNameSpec]: ...
    @property
    def child_names(self) -> ChildNameSpec: ...
    @property
    def per_file_user_data(self) -> list[Mapping[str, str]]: ...

class SourceInfo:
    def __init__(
        self, sources: list[str] | list[os.PathLike[Any]] | list[Datasource]
    ) -> None: ...

class SinkInfo:
    def __init__(
        self,
        sinks: list[os.PathLike[Any]]
        | list[io.StringIO]
        | list[io.BytesIO]
        | list[io.TextIOBase]
        | list[str],
    ) -> None: ...
