# Copyright (c) 2024, NVIDIA CORPORATION.

from enum import IntEnum

from pylibcudf.column import Column
from pylibcudf.scalar import Scalar

class StringCharacterTypes(IntEnum):
    DECIMAL = ...
    NUMERIC = ...
    DIGIT = ...
    ALPHA = ...
    SPACE = ...
    UPPER = ...
    LOWER = ...
    ALPHANUM = ...
    CASE_TYPES = ...
    ALL_TYPES = ...

def all_characters_of_type(
    source_strings: Column,
    types: StringCharacterTypes,
    verify_types: StringCharacterTypes,
) -> Column: ...
def filter_characters_of_type(
    source_strings: Column,
    types_to_remove: StringCharacterTypes,
    replacement: Scalar,
    types_to_keep: StringCharacterTypes,
) -> Column: ...
